<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\User;
use App\UserAsset;
use App\Candidate;
use App\SoftSkills;
use App\CandidateSkills;
use App\CandidateSkillsets;
use App\CandidateOperationalSkills;
use App\CandidateSoftSkills;
use App\CandidateExperiences;
use App\CandidateEducations;
use App\Activity;
use App\Association;
use App\CandidateNotecs;
use App\Country;
use App\CandidateDetails;
use Auth;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Position;
use Bican\Roles\Models\Jobtype;
use Bican\Roles\Models\Requirement;
use Bican\Roles\Models\Role;
use Hash;
use Input;
use Validator;
use GuzzleHttp\Client;
use App\VendorCandidateNotes;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use DB;
use Illuminate\Pagination\LengthAwarePaginator; //pagination based on length
use App\Company;
use App\Models\SkillblockResume;

class CandidateController extends Controller
{

    public function candidate_profile_pdf_export(Request $request){
        dd($request->all());
    }

    public function getIndex()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id){ $authId=$user->parent_id; }
            else {$authId=$user->id;}
        $candidates = Candidate::where('vendor_id',$authId)->where('is_privatearea',1)
                            ->with('skill')
                            ->with('first_association')
                            ->orderBy('updated_at', 'desc')
                            ->get();
        foreach ($candidates as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $numbers = ['encrypted_canId'=>$encrypted];
            $candidate['numbers'] = $numbers;
            $candidate['notes'] = VendorCandidateNotes::select('note_description')->where('candidate_id', $candidate['id'])->first();
        }

        foreach ($candidates as $key => $all_associations) {
            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;
            foreach ($all_associations['first_association'] as $key => $value) {
                if($value['candidate_status'] != null) {
                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }
                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach
            if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;
        }  // outer foreach
        return response()->success(compact('candidates'));
    }
   public function postSkillmatch(Request $request){
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        //conditional counting of extracted skills
        if((count($reqtags) > 0) && (count($reqtags) < 11)){

            //create schema [only temporary table based on session]
            Schema::create('temp_skills', function(Blueprint $table){
                $table->increments('id');
                $table->string('temp_skill_name');
                $table->timestamps();
                $table->temporary();
            });
            //iterate the extracted skills
            foreach($reqtags as $rqtagsKey =>$rqtagsValue)
            {

                //store the extracted skills into temp table
                DB::table('temp_skills')->insert(
                    ['temp_skill_name' => $rqtagsValue['text']]
                );

            }
            //get all data from temp table
            $skilldata = DB::table('temp_skills')->get();
            //get all skill names from temp table
            $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

            //condition to implement search functionality
            if((count($skilldata2) > 0) && (count($skilldata2) < 11))
            {
                /*$getCWSKD = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->where('is_alive',1)
                    ->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%')
                    ->get();*/
                $getCWSKD = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->where('is_alive',1)
                    ->where(function ($query) use ($skilldata2) {
                        for($i = 0; $i < count($skilldata2); $i++) {
                            $query->orWhere('skill_set', 'LIKE' , '%' . $skilldata2[$i] . '%');
                        }
                    })
                    //->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
                    ->get();

                $getCWSKD = (array) $getCWSKD;

                $matched = 1;
                foreach($getCWSKD as $array_key)
                {

                        $canarrayskill = $array_key->skill_set;
                        $skillarraycan = explode(', ',$canarrayskill);
                        $skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
                        //print_r($skillnames);
                        $perc = 100/count($skilldata2);
                        //print_r($perc);
                        //if all 5 skills matched
                        /*if(count($skillnames) == 0)
                        {
                            $final = 100;
                            $matched = $final;

                        }
                        else */if(count($skillnames) == 1)
                        {
                            //1 skill given and 1 skill not matched
                            /*if(count($skilldata2) == 1)
                            {
                                $final = $perc*0;
                                $matched = $final;

                            }//2 skills given 1 skill not matched
                            else */if(count($skilldata2) == 2)
                            {
                                $final = $perc*1;
                                $matched = $final;


                            }
                            else if(count($skilldata2) == 3)
                            {
                                $final = $perc*2;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 4)
                            {
                                $final = $perc*3;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 5)
                            {
                                $final = $perc*4;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $final = $perc*5;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $final = $perc*6;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $final = $perc*7;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $final = $perc*8;
                                $matched = $final;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $final = $perc*9;
                                $matched = $final;

                            }
                            else{
                                //
                            }

                        }
                        else if(count($skillnames) == 2)
                        {
                            //2 skills given 2 skills not matched
                            /*if(count($skilldata2) == 2)
                            {
                                $final = $perc*0;
                                $matched = $final;

                            }
                            else */if(count($skilldata2) == 3)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 4)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 5)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*6;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*7;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*8;

                            }
                            else{
                                //
                            }

                        }
                        else if(count($skillnames) == 3)
                        {
                            /*if(count($skilldata2) == 3)
                            {
                                $matched = $perc*0;

                            }
                            else */if(count($skilldata2) == 4)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 5)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*6;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*7;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 4)
                        {
                            /*if(count($skilldata2) == 4)
                            {
                                $matched = $perc*0;

                            }
                            else */if(count($skilldata2) == 5)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*6;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 5)
                        {
                            /*if(count($skilldata2) == 5)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 6)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*5;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 6)
                        {
                            /*if(count($skilldata2) == 6)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 7)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*2;//0%

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*3;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*4;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        else if(count($skillnames) == 7)
                        {
                            /*if(count($skilldata2) == 7)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 8)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*2;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*3;//0%

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 8)
                        {
                            /*if(count($skilldata2) == 8)
                            {
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 9)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*2;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        else if(count($skillnames) == 9)
                        {
                            /*if(count($skilldata2) == 9)
                            {
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 10)
                            {
                                $matched = $perc*1;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        /*else if(count($skillnames) == 10)
                        {
                            if(count($skilldata2) == 10)
                            {
                                $matched = $perc*0;//0%
                            }
                        }

                        else{
                            //
                        }*/
                    $array_key->percentage_calculator = $matched;
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
                    $numbers = ['encrypted_canId'=>$encrypted];
                    $array_key->numbers = $numbers;

                }
                $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
                $itemCollection = collect($getCWSKD);
                $perPage = 100;
                $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
                $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
                $paginatedItems->setPath($request->url());
                 //changed from 'freecvs' to 'paginatedItems'
                $skillmatchingdata2 = $paginatedItems->items();
        return json_encode($paginatedItems);
                //return response()->success(compact('getCWSKD'));

            }
            else{
                //search operation is failed if count if greater than 10
                //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

            }
            Schema::drop('temp_skills');

        }
        else{
            //will not process if skills count is greater than 10
            //$errorstore = 'Sorry cannot accept more than 10 skills!';

        }
    }
     public function postSkillmatchf(Request $request){
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        $authuser = Auth::user();

        if ($authuser->parent_id)
            $authId = $authuser->parent_id;
        else
            $authId = $authuser->id;

        //conditional counting of extracted skills
        if((count($reqtags) > 0) && (count($reqtags) < 11)){

            //create schema [only temporary table based on session]
            Schema::create('temp_skills', function(Blueprint $table){
                $table->increments('id');
                $table->string('temp_skill_name');
                $table->timestamps();
                $table->temporary();
            });
            //iterate the extracted skills
            foreach($reqtags as $rqtagsKey =>$rqtagsValue)
            {

                //store the extracted skills into temp table
                DB::table('temp_skills')->insert(
                    ['temp_skill_name' => $rqtagsValue['text']]
                );

            }
            //get all data from temp table
            $skilldata = DB::table('temp_skills')->get();
            //get all skill names from temp table
            $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

            //condition to implement search functionality
            if((count($skilldata2) > 0) && (count($skilldata2) < 11))
            {
                $getCWSKD = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'candidates.path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->join('users', 'users.id', '=', 'candidates.vendor_id')
                    ->where('vendor_id', '=', $authId)
                    ->where('is_privatearea',0)
                    ->where(function ($query) use ($skilldata2) {
                        for($i = 0; $i < count($skilldata2); $i++) {
                            $query->orWhere('skill_set', 'LIKE' , '%' . $skilldata2[$i] . '%');
                        }
                    })
                    ->get();
            $association=Association::whereNotBetween('candidate_status', array(9, 28))
                                        ->select('candidate_id')
                                        ->get();
            $associationid=array();
            foreach ($association as $key => $value) {
                array_push($associationid, $value['candidate_id']);
            }
            $getCWSKD =Candidate::whereIn('candidates.id',$associationid)
                                ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                                ->whereRaw("DATE_FORMAT(candidates.created_at,
                                    '%Y-%m-%d %h:%i:%s') <= DATE_FORMAT
                                    (( CURDATE()-INTERVAL 90 DAY ),
                                    '%Y-%m-%d %h:%i:%s')")
                                ->where(function ($query) use ($skilldata2) {
                                    $whereCond = '';
                                    for($i = 0; $i < count($skilldata2); $i++) {
                                        $whereCond .= 'LOWER(skill_set) like "% '.strtolower($skilldata2[$i]).'%" OR ';
                                    }
                                    $whereCond = substr($whereCond, 0, strlen($whereCond)-4);
                                    $query->whereRaw($whereCond);
                                })
                                ->get();

                $matched = 1;
                foreach($getCWSKD as $array_key)
                {

                        $canarrayskill = $array_key->skill_set;
                        $skillarraycan = explode(', ',$canarrayskill);
                        $skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
                        $perc = 100/count($skilldata2);
                       if(count($skillnames) !=0){
                            $final = $perc*(count($skilldata2)-count($skillnames));
                            $matched = $final;
                        }else{
                            $matched = 100;
                        }
                    $array_key->percentage_calculator = $matched;
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
                    $numbers = ['encrypted_canId'=>$encrypted];
                    $array_key->numbers = $numbers;

                }
                $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
                $itemCollection = collect($getCWSKD);
                $perPage = 100;
                $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
                $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
                $paginatedItems->setPath($request->url());
                 //changed from 'freecvs' to 'paginatedItems'
                $skillmatchingdata2 = $paginatedItems->items();
        return json_encode($paginatedItems);
                //return response()->success(compact('getCWSKD'));

            }
            else{
                //search operation is failed if count if greater than 10
                //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

            }
            Schema::drop('temp_skills');

        }
        else{
            //will not process if skills count is greater than 10
            //$errorstore = 'Sorry cannot accept more than 10 skills!';

        }
    }


    //Skill Matching Updated Code:


     public function postSkillmatches_old(Request $request)
     {
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        foreach($reqtags as $rqtagsKey =>$rqtagsValue)
        {
            $skills[] = $rqtagsValue['text'];
            //$skillData = $rqtagsValue['text']. ',';
        }
        //condition to implement search functionality
        if((count($skills) > 0) && (count($skills) < 11))
        {
            /*$getCWSKD = DB::table('candidates')
                ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                ->where('is_alive',1)
                ->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%')
                ->get();*/
            $getCWSKD = DB::table('candidates')
                ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                ->where('is_privatearea',0)
                ->where(function ($query) use ($skills) {
                    for($i = 0; $i < count($skills); $i++) {
                        $query->orWhere('skill_set', 'LIKE' , '%' . $skills[$i] . '%');
                    }
                })
                //->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
                ->get();

            $getCWSKD = (array) $getCWSKD;

//echo '<pre>'; print_r($getCWSKD); echo '</pre>'; die;

            $matched = 1;

            $perc = 100/count($skills);

            $candidateSkills = array();
            foreach($getCWSKD as $array_key)
            {
                $skillarraycan = explode(', ',$array_key->skill_set);
                $skillnames = array_udiff($skills, $skillarraycan, 'strcasecmp');
//echo count($skills).'===='.count($skillnames); echo '--------';
                //$candidateSkills[] = explode(', ', $array_key->skill_set);
                //$skillnames[] = array_udiff($skills, $candidateSkills,'strcasecmp');

                /*$candidateSkills[] = explode(', ', $array_key->skill_set);
                $skillnames = array_udiff($skills, $candidateSkills,'strcasecmp');*/

                //if(in_array($array_key->skill_set, $skills))
                //if($skillnames == 1 || $skillnames == 2 || )
                //{

                if(count($skillnames) == 1)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 2)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 3)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 4)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 5)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 6)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 7)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 8)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 9)
                    $matched = $perc * (count($skills) - 1);
                elseif(count($skillnames) == 10)
                    $matched = $perc * (count($skills) - 1);
                else
                    $matched = 10;

                /*    if((count($skills) - count($skillnames)) != 0)
                        $matched = $perc * ( (count($skills) - count($skillnames)) - 1);
                    else
                        $matched = 10;*/
                    //echo $matched.'=====';
                //}

                $array_key->percentage_calculator = round($matched);
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
                $numbers = ['encrypted_canId'=>$encrypted];
                $array_key->numbers = $numbers;
            }
            //print_r($skillnames); echo '======';

            $currentPage = LengthAwarePaginator::resolveCurrentPage();
            //Replace collect() method content with your own method
            $itemCollection = collect($getCWSKD);
            $perPage = 100;
            $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
            $paginatedItems = new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
            $paginatedItems->setPath($request->url());
             //changed from 'freecvs' to 'paginatedItems'
            $skillmatchingdata2 = $paginatedItems->items();
            return json_encode($paginatedItems);
        }
        //die;
    }

public function postSkillmatches_changed(Request $request){
            $authuser = Auth::user();

            //get requiredTags as an Array
            $reqtags = Input::get('requiredTags');

            //conditional counting of extracted skills
            if((count($reqtags) > 0) && (count($reqtags) < 11)){

            //create schema [only temporary table based on session]
            Schema::create('temp_skills', function(Blueprint $table){
            $table->increments('id');
            $table->string('temp_skill_name');
            $table->timestamps();
            $table->temporary();
            });
            //iterate the extracted skills
            foreach($reqtags as $rqtagsKey =>$rqtagsValue)
            {

            //store the extracted skills into temp table
            DB::table('temp_skills')->insert(
            ['temp_skill_name' => $rqtagsValue['text']]
            );

            }
            //get all data from temp table
            $skilldata = DB::table('temp_skills')->get();
            //get all skill names from temp table
            $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

            //condition to implement search functionality
            if((count($skilldata2) > 0) && (count($skilldata2) < 11))
            {
            /*$getCWSKD = DB::table('candidates')
            ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
            ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
            ->where('is_alive',1)
            ->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%')
            ->get();*/
            $getCWSKD = DB::table('candidates')
            ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'candidates.path', 'skill_set')
            ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
            ->join('users', 'users.id', '=', 'candidates.vendor_id')
            ->whereIn('role_id', array(6,9))
            ->whereRaw('users.id ='.$authuser->id)
            ->where('is_privatearea',0)
            ->where(function ($query) use ($skilldata2) {
            for($i = 0; $i < count($skilldata2); $i++) {
            //$query->orWhere('LOWER(skill_set)', 'LIKE' , '%' . strtolower($skilldata2[$i]) . '%');
            $query->orWhereRaw("LOWER(`skill_set`) LIKE '%".trim(strtolower($skilldata2[$i]))."%'");
            }
            })
            //->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
            ->limit(25)
            ->get();

            /*echo DB::table('candidates')
            ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
            ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
            ->where('is_privatearea',0)
            ->where(function ($query) use ($skilldata2) {
            for($i = 0; $i < count($skilldata2); $i++) {
            //$query->orWhere('LOWER(skill_set)', 'LIKE' , '%' . strtolower($skilldata2[$i]) . '%');
            $query->orWhereRaw('LOWER(`skill_set`) LIKE ? ',[trim(strtolower($skilldata2[$i])).'%']);
            }
            })
            //->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
            ->limit(25)
            ->toSql();*/

            $getCWSKD = (array) $getCWSKD;

            $matched = 1;
            foreach($getCWSKD as $array_key)
            {

            $matched = 1;

            $canarrayskill = $array_key->skill_set;
            $skillarraycan = explode(', ',$canarrayskill);

            /*foreach($skillarraycan_1 as $skillarraycan1)
            $skillarraycan[] = trim($skillarraycan1);*/

            //$skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
            $skillnames = array_diff($skilldata2, $skillarraycan);

            //print_r($skillnames);
            $perc = 100/count($skilldata2);
            //echo $perc .'-----'. count($skillnames).'==='.count($skilldata2).'++++++++++';
            //if all 5 skills matched
            /*if(count($skillnames) == 0)
            {
            $final = 100;
            $matched = $final;

            }
            else */if(count($skillnames) == 1)
            { //echo 'Count Of Skills: '.count($skilldata2).'-----';
            //1 skill given and 1 skill not matched
            if(count($skilldata2) == 1)
            {
            $matched = $perc*1;
            }//2 skills given 1 skill not matched
            else if(count($skilldata2) == 2)
            {
            $matched = $perc*1;
            }
            else if(count($skilldata2) == 3)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 4)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 5)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 6)
            {
            $matched = $perc*5;
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*6;
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*7;
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*8;
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*9;
            }
            else{
            //
            }

            }
            else if(count($skillnames) == 2)
            {
            //2 skills given 2 skills not matched
            if(count($skilldata2) == 2)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 3)
            {
            $matched = $perc*1;
            }
            else if(count($skilldata2) == 4)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 5)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 6)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*5;
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*6;
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*7;
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*8;
            }
            else{
            //
            }
            }
            else if(count($skillnames) == 3)
            {
            if(count($skilldata2) == 3)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 4)
            {
            $matched = $perc*1;
            }
            else if(count($skilldata2) == 5)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 6)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*5;
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*6;
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*7;
            }
            else
            {
            //
            }

            }
            else if(count($skillnames) == 4)
            {
            if(count($skilldata2) == 4)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 5)
            {
            $matched = $perc*1;
            }
            else if(count($skilldata2) == 6)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*5;
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*6;
            }
            else
            {
            //
            }
            }
            else if(count($skillnames) == 5)
            {
            if(count($skilldata2) == 5)
            {
            //no skills matched
            $matched = $perc*5;//0%
            }
            else if(count($skilldata2) == 6)
            {
            $matched = $perc*1;
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*2;
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*3;
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*4;
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*5;
            }
            else
            {
            //
            }

            }
            else if(count($skillnames) == 6)
            {
            if(count($skilldata2) == 6)
            {
            //no skills matched
            $matched = $perc*16.1;//0%
            }
            else if(count($skilldata2) == 7)
            {
            $matched = $perc*1;//0%
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*2;//0%
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*3;//0%
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*4;//0%
            }
            else
            {
            //
            }
            }
            else if(count($skillnames) == 7)
            {
            if(count($skilldata2) == 7)
            {
            //no skills matched
            $matched = $perc*14.2;//0%
            }
            else if(count($skilldata2) == 8)
            {
            $matched = $perc*1;//0%
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*2;//0%
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*3;//0%
            }
            else
            {
            //
            }

            }
            else if(count($skillnames) == 8)
            {
            if(count($skilldata2) == 8)
            {
            $matched = $perc*12.5;//0%
            }
            else if(count($skilldata2) == 9)
            {
            $matched = $perc*1;//0%
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*2;//0%
            }
            else
            {
            //
            }
            }
            else if(count($skillnames) == 9)
            {
            if(count($skilldata2) == 9)
            {
            $matched = $perc*11;//0%
            }
            else if(count($skilldata2) == 10)
            {
            $matched = $perc*1;//0%
            }
            else
            {
            //
            }
            }
            else if(count($skillnames) == 10)
            {
            if(count($skilldata2) == 10)
            {
            $matched = $perc*10;//0%
            }
            }

            else{
            //
            }
            //echo $matched;
            $array_key->percentage_calculator = $matched;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
            $numbers = ['encrypted_canId'=>$encrypted];
            $array_key->numbers = $numbers;

            //echo $perc .'-----'. count($skillnames).'==='.count($skilldata2).'++++++++++'.$matched.'*********';

            //print_r($skillnames);

            }
            $currentPage = LengthAwarePaginator::resolveCurrentPage();

            //Replace collect() method content with your own method
            $itemCollection = collect($getCWSKD);

            //echo '<pre>'; print_r($itemCollection); echo '</pre>'; die;

            $perPage = 100;
            $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
            $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
            $paginatedItems->setPath($request->url());
            //changed from 'freecvs' to 'paginatedItems'
            $skillmatchingdata2 = $paginatedItems->items();
            return json_encode($paginatedItems);
            //return response()->success(compact('getCWSKD'));

            }
            else{
            //search operation is failed if count if greater than 10
            //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

            }
            Schema::drop('temp_skills');

            }
            else{
            //will not process if skills count is greater than 10
            //$errorstore = 'Sorry cannot accept more than 10 skills!';

            }
}

public function postSkillmatches(Request $request){
    $authuser = Auth::user();
    //get requiredTags as an Array
    $reqtags = Input::get('requiredTags');
    //conditional counting of extracted skills
    if((count($reqtags) > 0) && (count($reqtags) < 11)){
    //create schema [only temporary table based on session]
    Schema::create('temp_skills', function(Blueprint $table){
    $table->increments('id');
    $table->string('temp_skill_name');
    $table->timestamps();
    $table->temporary();
    });
    //iterate the extracted skills
    foreach($reqtags as $rqtagsKey =>$rqtagsValue)
    {
        //store the extracted skills into temp table
        DB::table('temp_skills')->insert(
        ['temp_skill_name' => $rqtagsValue['text']]
        );
    }
    //$vendorusers = User::select('id','parent_id')->where('parent_id', $authuser->id)->where('role_id', 9)->orderBy('first_name', 'asc')->get();
    //$vendorusers->id;
    //print_r($vendorusers[0]['id']); exit;
    //get all data from temp table
    $skilldata = DB::table('temp_skills')->get();
    //get all skill names from temp table
    $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');
    //condition to implement search functionality
    if((count($skilldata2) > 0) && (count($skilldata2) < 11))
    {
        $getCWSKD = DB::table('candidates')
        ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set','vendor_id','is_privatearea','vendor_user_id')
        ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
        //->join('users', 'users.parent_id', '=', 'candidates.vendor_user_id')
        //->where('vendor_id', '=', $authuser->id)
        ->where('is_privatearea',0)
        ->where('vendor_id',$authuser->id)
        //->where('vendor_user_id',100250)

        // ->where(function ($query) use ($skilldata2) {
        //     for($i = 0; $i < count($skilldata2); $i++) {
        //     $query->orWhere('skill_set', 'LIKE' , '%' . $skilldata2[$i] . '%');
        //     }
        // })
        ->get();
        $getCWSKD = (array) $getCWSKD;
        $matched = 1;
        foreach($getCWSKD as $array_key)
        {
            $canarrayskill = $array_key->skill_set;
            $skillarraycan = explode(', ',$canarrayskill);
            $skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
            $perc = 100/count($skilldata2);
            if(count($skillnames) !=0){

                   $final = $perc*(count($skilldata2)-count($skillnames));
                   $matched = $final;
            }else{
                $matched = 100;
            }

            $array_key->percentage_calculator = $matched;
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
            $numbers = ['encrypted_canId'=>$encrypted];
            $array_key->numbers = $numbers;
            $array_key->skils_block = SkillblockResume::where('candidate_id',$array_key->id )->whereNotIn('found_id', [3,2])->get();

        }
        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
        $itemCollection = collect($getCWSKD);
        $perPage = 100;
        $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
        $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
        $paginatedItems->setPath($request->url());
        //changed from 'freecvs' to 'paginatedItems'
        $skillmatchingdata2 = $paginatedItems->items();
        return json_encode($paginatedItems);
        //return response()->success(compact('getCWSKD'));

    }else{
    }
    Schema::drop('temp_skills');

    }
    else{}
}//Skill Matching Updated Code:
 //Skill Matching Updated Code:
    public function postSkillmatches_old_1(Request $request){
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        //conditional counting of extracted skills
        if((count($reqtags) > 0) && (count($reqtags) < 11)){

            //create schema [only temporary table based on session]
            Schema::create('temp_skills', function(Blueprint $table){
                $table->increments('id');
                $table->string('temp_skill_name');
                $table->timestamps();
                $table->temporary();
            });
            //iterate the extracted skills
            foreach($reqtags as $rqtagsKey =>$rqtagsValue)
            {

                //store the extracted skills into temp table
                DB::table('temp_skills')->insert(
                    ['temp_skill_name' => $rqtagsValue['text']]
                );

            }
            //get all data from temp table
            $skilldata = DB::table('temp_skills')->get();
            //get all skill names from temp table
            $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

            //condition to implement search functionality
            if((count($skilldata2) > 0) && (count($skilldata2) < 11))
            {
                /*$getCWSKD = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->where('is_alive',1)
                    ->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%')
                    ->get();*/
                $getCWSKD = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->where('is_privatearea',0)
                    ->where(function ($query) use ($skilldata2) {
                        for($i = 0; $i < count($skilldata2); $i++) {
                            $query->orWhere('skill_set', 'LIKE' , '%' . $skilldata2[$i] . '%');
                        }
                    })
                    //->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
                    ->get();

                $getCWSKD = (array) $getCWSKD;

                $matched = 1;
                foreach($getCWSKD as $array_key)
                {

                        $canarrayskill = $array_key->skill_set;
                        $skillarraycan = explode(', ',$canarrayskill);
                        $skillnames = array_udiff($skilldata2,$skillarraycan,'strcmp');
                        //print_r($skillnames);
                        $perc = 100/count($skilldata2);
                        //print_r($perc);
                        //if all 5 skills matched
                        /*if(count($skillnames) == 0)
                        {
                            $final = 100;
                            $matched = $final;

                        }
                        else */if(count($skillnames) == 1)
                        {   //echo 'Count Of Skills: '.count($skilldata2).'-----';
                            //1 skill given and 1 skill not matched
                            /*if(count($skilldata2) == 1)
                            {
                                $final = $perc*0;
                                $matched = $final;

                            }//2 skills given 1 skill not matched
                            else */if(count($skilldata2) == 2)
                            {
                                $matched = $perc*1;
                            }
                            else if(count($skilldata2) == 3)
                            {
                                $matched = $perc*2;
                            }
                            else if(count($skilldata2) == 4)
                            {
                                $matched = $perc*3;
                            }
                            else if(count($skilldata2) == 5)
                            {
                                $matched = $perc*4;
                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*5;
                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*6;
                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*7;
                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*8;
                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*9;
                            }
                            else{
                                //
                            }

                        }
                        else if(count($skillnames) == 2)
                        {
                            //2 skills given 2 skills not matched
                            /*if(count($skilldata2) == 2)
                            {
                                $final = $perc*0;
                                $matched = $final;

                            }
                            else */if(count($skilldata2) == 3)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 4)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 5)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*6;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*7;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*8;

                            }
                            else{
                                //
                            }

                        }
                        else if(count($skillnames) == 3)
                        {
                            /*if(count($skilldata2) == 3)
                            {
                                $matched = $perc*0;

                            }
                            else */if(count($skilldata2) == 4)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 5)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*6;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*7;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 4)
                        {
                            /*if(count($skilldata2) == 4)
                            {
                                $matched = $perc*0;

                            }
                            else */if(count($skilldata2) == 5)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 6)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*5;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*6;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 5)
                        {
                            /*if(count($skilldata2) == 5)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 6)
                            {
                                $matched = $perc*1;

                            }
                            else if(count($skilldata2) == 7)
                            {
                                $matched = $perc*2;

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*3;

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*4;

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*5;

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 6)
                        {
                            /*if(count($skilldata2) == 6)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 7)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 8)
                            {
                                $matched = $perc*2;//0%

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*3;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*4;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        else if(count($skillnames) == 7)
                        {
                            /*if(count($skilldata2) == 7)
                            {
                                //no skills matched
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 8)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 9)
                            {
                                $matched = $perc*2;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*3;//0%

                            }
                            else
                            {
                                //
                            }

                        }
                        else if(count($skillnames) == 8)
                        {
                            /*if(count($skilldata2) == 8)
                            {
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 9)
                            {
                                $matched = $perc*1;//0%

                            }
                            else if(count($skilldata2) == 10)
                            {
                                $matched = $perc*2;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        else if(count($skillnames) == 9)
                        {
                            /*if(count($skilldata2) == 9)
                            {
                                $matched = $perc*0;//0%

                            }
                            else */if(count($skilldata2) == 10)
                            {
                                $matched = $perc*1;//0%

                            }
                            else
                            {
                                //
                            }
                        }
                        /*else if(count($skillnames) == 10)
                        {
                            if(count($skilldata2) == 10)
                            {
                                $matched = $perc*0;//0%
                            }
                        }

                        else{
                            //
                        }*/
                //echo $matched;
                    $array_key->percentage_calculator = $matched;
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
                    $numbers = ['encrypted_canId'=>$encrypted];
                    $array_key->numbers = $numbers;

                }
                $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
                $itemCollection = collect($getCWSKD);
                $perPage = 100;
                $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
                $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
                $paginatedItems->setPath($request->url());
                 //changed from 'freecvs' to 'paginatedItems'
                $skillmatchingdata2 = $paginatedItems->items();
        return json_encode($paginatedItems);
                //return response()->success(compact('getCWSKD'));

            }
            else{
                //search operation is failed if count if greater than 10
                //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

            }
            Schema::drop('temp_skills');

        }
        else{
            //will not process if skills count is greater than 10
            //$errorstore = 'Sorry cannot accept more than 10 skills!';

        }
    }

public function postSkillmatching(Request $request){
        //$freecvs = Candidate::with('skill')->where('is_alive',1)->get();
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        //conditional counting of extracted skills
        if((count($reqtags) > 0) && (count($reqtags) < 11)){

        //create schema [only temporary table based on session]
        Schema::create('temp_skills', function(Blueprint $table){
        $table->increments('id');
        $table->string('temp_skill_name');
        $table->timestamps();
        $table->temporary();
        });
        //iterate the extracted skills
        foreach($reqtags as $rqtagsKey =>$rqtagsValue)
        {

        //store the extracted skills into temp table
        DB::table('temp_skills')->insert(
        ['temp_skill_name' => $rqtagsValue['text']]
        );

        }
        //get all data from temp table
        $skilldata = DB::table('temp_skills')->get();
        //get all skill names from temp table
        $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

        //condition to implement search functionality
        if((count($skilldata2) > 0) && (count($skilldata2) < 11))
        {

        //get candidate with skill data
        /*$getCWSKD = Candidate::with('skill')
        ->where('is_alive',1)
        ->whereHas('skill', function($qk) use($skilldata2)
        {
        $qk->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
        })->get();*/

        // Lakahman commneted below code and added new query statements to get required columns on 17-09-2019
            /*
            $getCWSKD = Candidate::with('skill')
                        ->where('is_alive',1)
                        ->get();
                        //print_r($getCWSKD);
            */

            $getCWSKD = DB::table('candidates')
                ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                ->where('is_alive',1)
                ->get();

        $getCWSKD = (array) $getCWSKD;

        foreach($getCWSKD as $array_key)
        {

        $canarrayskill = $array_key->skill_set;
        $skillarraycan = explode(', ',$canarrayskill);
        $skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
        $perc = 100/count($skilldata2);
        //if all 5 skills matched
        if(count($skillnames) == 0)
        {


        $final = 100;
        $matched = $final;


        }
        else if(count($skillnames) == 1)
        {
        //1 skill given and 1 skill not matched
        if(count($skilldata2) == 1)
        {
        $final = $perc*0;
        $matched = $final;

        }//2 skills given 1 skill not matched
        else if(count($skilldata2) == 2)
        {
        $final = $perc*1;
        $matched = $final;


        }
        else if(count($skilldata2) == 3)
        {
        $final = $perc*2;
        $matched = $final;

        }
        else if(count($skilldata2) == 4)
        {
        $final = $perc*3;
        $matched = $final;

        }
        else if(count($skilldata2) == 5)
        {
        $final = $perc*4;
        $matched = $final;

        }
        else if(count($skilldata2) == 6)
        {
        $final = $perc*5;
        $matched = $final;

        }
        else if(count($skilldata2) == 7)
        {
        $final = $perc*6;
        $matched = $final;

        }
        else if(count($skilldata2) == 8)
        {
        $final = $perc*7;
        $matched = $final;

        }
        else if(count($skilldata2) == 9)
        {
        $final = $perc*8;
        $matched = $final;

        }
        else if(count($skilldata2) == 10)
        {
        $final = $perc*9;
        $matched = $final;

        }
        else{
        //
        }

        }
        else if(count($skillnames) == 2)
        {
        //2 skills given 2 skills not matched
        if(count($skilldata2) == 2)
        {
        $final = $perc*0;
        $matched = $final;

        }
        else if(count($skilldata2) == 3)
        {
        $matched = $perc*1;

        }
        else if(count($skilldata2) == 4)
        {
        $matched = $perc*2;

        }
        else if(count($skilldata2) == 5)
        {
        $matched = $perc*3;

        }
        else if(count($skilldata2) == 6)
        {
        $matched = $perc*4;

        }
        else if(count($skilldata2) == 7)
        {
        $matched = $perc*5;

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*6;

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*7;

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*8;

        }
        else{
        //
        }

        }
        else if(count($skillnames) == 3)
        {
        if(count($skilldata2) == 3)
        {
        $matched = $perc*0;

        }
        else if(count($skilldata2) == 4)
        {
        $matched = $perc*1;

        }
        else if(count($skilldata2) == 5)
        {
        $matched = $perc*2;

        }
        else if(count($skilldata2) == 6)
        {
        $matched = $perc*3;

        }
        else if(count($skilldata2) == 7)
        {
        $matched = $perc*4;

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*5;

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*6;

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*7;

        }
        else
        {
        //
        }

        }
        else if(count($skillnames) == 4)
        {
        if(count($skilldata2) == 4)
        {
        $matched = $perc*0;

        }
        else if(count($skilldata2) == 5)
        {
        $matched = $perc*1;

        }
        else if(count($skilldata2) == 6)
        {
        $matched = $perc*2;

        }
        else if(count($skilldata2) == 7)
        {
        $matched = $perc*3;

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*4;

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*5;

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*6;

        }
        else
        {
        //
        }

        }
        else if(count($skillnames) == 5)
        {
        if(count($skilldata2) == 5)
        {
        //no skills matched
        $matched = $perc*0;//0%

        }
        else if(count($skilldata2) == 6)
        {
        $matched = $perc*1;

        }
        else if(count($skilldata2) == 7)
        {
        $matched = $perc*2;

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*3;

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*4;

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*5;

        }
        else
        {
        //
        }

        }
        else if(count($skillnames) == 6)
        {
        if(count($skilldata2) == 6)
        {
        //no skills matched
        $matched = $perc*0;//0%

        }
        else if(count($skilldata2) == 7)
        {
        $matched = $perc*1;//0%

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*2;//0%

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*3;//0%

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*4;//0%

        }
        else
        {
        //
        }
        }
        else if(count($skillnames) == 7)
        {
        if(count($skilldata2) == 7)
        {
        //no skills matched
        $matched = $perc*0;//0%

        }
        else if(count($skilldata2) == 8)
        {
        $matched = $perc*1;//0%

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*2;//0%

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*3;//0%

        }
        else
        {
        //
        }

        }
        else if(count($skillnames) == 8)
        {
        if(count($skilldata2) == 8)
        {
        $matched = $perc*0;//0%

        }
        else if(count($skilldata2) == 9)
        {
        $matched = $perc*1;//0%

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*2;//0%

        }
        else
        {
        //
        }
        }
        else if(count($skillnames) == 9)
        {
        if(count($skilldata2) == 9)
        {
        $matched = $perc*0;//0%

        }
        else if(count($skilldata2) == 10)
        {
        $matched = $perc*1;//0%

        }
        else
        {
        //
        }
        }
        else if(count($skillnames) == 10)
        {
        if(count($skilldata2) == 10)
        {
        $matched = $perc*0;//0%
        }
        }

        else{
        //
        }


        //$array_key['index_found_at'] = $resultinfo;
        $array_key->percentage_calculator = $matched;
        $timestamp = 129346161081;
        $randomKey = '-';
        $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
        $numbers = ['encrypted_canId'=>$encrypted];
        $array_key->numbers = $numbers;

        }
         $currentPage = LengthAwarePaginator::resolveCurrentPage();
                //Replace collect() method content with your own method
                $itemCollection = collect($getCWSKD);
                $perPage = 100;
                $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
                $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
                $paginatedItems->setPath($request->url());
                 //changed from 'freecvs' to 'paginatedItems'
                $skillmatchingdata = $paginatedItems->items();
                return json_encode($paginatedItems);
        //return response()->success(compact('getCWSKD'));
        }
        else{
        //search operation is failed if count if greater than 10
        //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

        }
        Schema::drop('temp_skills');

        }
        else{
        //will not process if skills count is greater than 10
        //$errorstore = 'Sorry cannot accept more than 10 skills!';

        }
}
public function postSkillmatchingf(Request $request){
        //$freecvs = Candidate::with('skill')->where('is_alive',1)->get();
        //get requiredTags as an Array
        $reqtags = Input::get('requiredTags');

        //conditional counting of extracted skills
        if((count($reqtags) > 0) && (count($reqtags) < 11)){

        //create schema [only temporary table based on session]
        Schema::create('temp_skills', function(Blueprint $table){
        $table->increments('id');
        $table->string('temp_skill_name');
        $table->timestamps();
        $table->temporary();
        });
        //iterate the extracted skills
        foreach($reqtags as $rqtagsKey =>$rqtagsValue)
        {

        //store the extracted skills into temp table
        DB::table('temp_skills')->insert(
        ['temp_skill_name' => $rqtagsValue['text']]
        );

        }
        //get all data from temp table
        $skilldata = DB::table('temp_skills')->get();
        //get all skill names from temp table
        $skilldata2 = DB::table('temp_skills')->select('temp_skill_name')->lists('temp_skill_name');

        //condition to implement search functionality
        if((count($skilldata2) > 0) && (count($skilldata2) < 11))
        {

        //get candidate with skill data
        /*$getCWSKD = Candidate::with('skill')
        ->where('is_alive',1)
        ->whereHas('skill', function($qk) use($skilldata2)
        {
        $qk->where('skill_set', 'LIKE' , '%' . $skilldata2[0] . '%');
        })->get();*/

        // Lakahman commneted below code and added new query statements to get required columns on 17-09-2019
            /*
            $getCWSKD = Candidate::with('skill')
                        ->where('is_alive',1)
                        ->get();
                        //print_r($getCWSKD);
            */
            $association=Association::whereNotBetween('candidate_status', array(9, 28))
                                        ->select('candidate_id')
                                        ->get();
            $associationid=array();
            foreach ($association as $key => $value) {
                array_push($associationid, $value['candidate_id']);
            }
            $getCWSKD =Candidate::whereIn('candidates.id',$associationid)
                                ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                                ->get();

        /*$getCWSKD = (array) $getCWSKD;

        $getCWSKD=$getCWSKD['items'];

        print_r($getCWSKD);exit;*/

        foreach($getCWSKD as $array_key)
        {

        $canarrayskill = $array_key->skill_set;
        $skillarraycan = explode(', ',$canarrayskill);
        $skillnames = array_udiff($skilldata2,$skillarraycan,'strcasecmp');
        $perc = 100/count($skilldata2);
        //if all 5 skills matched
         if(count($skillnames) !=0){

                   $final = $perc*(count($skilldata2)-count($skillnames));
                   $matched = $final;
            }else{
                $matched = 100;
            }


        //$array_key['index_found_at'] = $resultinfo;
        $array_key->percentage_calculator = $matched;
        $timestamp = 129346161081;
        $randomKey = '-';
        $encrypted = base64_encode($timestamp . $randomKey . $array_key->id);
        $numbers = ['encrypted_canId'=>$encrypted];
        $array_key->numbers = $numbers;
        $array_key->skils_block = SkillblockResume::where('candidate_id',$array_key->id )->whereNotIn('found_id', [3,2])->get();

        }
         $currentPage = LengthAwarePaginator::resolveCurrentPage();
                //Replace collect() method content with your own method
                $itemCollection = collect($getCWSKD);
                $perPage = 100;
                $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
                $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
                $paginatedItems->setPath($request->url());
                 //changed from 'freecvs' to 'paginatedItems'
                $skillmatchingdata = $paginatedItems->items();
                return json_encode($paginatedItems);
        //return response()->success(compact('getCWSKD'));
        }
        else{
        //search operation is failed if count if greater than 10
        //$cannotDoSearchOp = 'Sorry you cannot do Search Now!';

        }
        Schema::drop('temp_skills');

        }
        else{
        //will not process if skills count is greater than 10
        //$errorstore = 'Sorry cannot accept more than 10 skills!';

        }
}
    public function postVendorcandidateupdate()
    {
        $authuser = Auth::user();
        $present_salary = Input::get('present_salary');
        $email = Input::get('email');
        $phone = Input::get('phone');
        $expected_salary = Input::get('expected_salary');
        $present_location = Input::get('present_location');
        $buy_out = Input::get('buyout');
        $current_notice = Input::get('currentnotice');
        $aadhar_no = Input::get('aadharno');
        $country_code = Input::get('country_code');
        $mobile = Input::get('mobile');
        $gender = Input::get('gender');
        $currency = Input::get('currency');

        //$pan_cardno = Input::get('pan_cardno');

        //$passport_no = Input::get('passport_no');

        //print_r($aadhar_no);

        //$relocate_locations= Input::get('relocate_locations');

        $citys = Input::get('relocate_locations');
        $relocate_locations1 = array();
        foreach($citys as $job_cities)
            {
               array_push($relocate_locations1, $job_cities['name']);
            }
        $relocate_locations = implode(",",$relocate_locations1);
        $notice_period = Input::get('notice_period');
        $note_description = Input::get('note_description');
        $candidate_id = Input::get('candidateId');
        $job_id = Input::get('jobID');
        $vendor_notes_data = new VendorCandidateNotes();
        $vendor_notes_data->present_salary = $present_salary;
        $vendor_notes_data->expected_salary = $expected_salary;
        $vendor_notes_data->note_description = $note_description;
        $vendor_notes_data->present_location = $present_location[0]['name'];
        $vendor_notes_data->relocate_locations = $relocate_locations;
        $vendor_notes_data->notice_period = $notice_period[0];
        $vendor_notes_data->candidate_id = $candidate_id;
        $vendor_notes_data->job_id = $job_id;
        $vendor_notes_data->save();
        $preferred_location = Input::get('preferred_location');
        $preferred_country = Input::get('preferred_country');
        $present_country = Input::get('present_country');
        $nationality = Input::get('nationality');
        $work_autherization = Input::get('work_autherization');
        $qualification = Input::get('qualification');
        $id = Input::get('candidateId');
        $operational_skills = Input::get('operational_skills');
        $total_experience_in_year = Input::get('experience');
        $full_name = Input::get('full_name');
        $companyemail = Input::get('companyemail');
        $pref_data = array();
            if(count($preferred_location)){
                foreach ($preferred_location as $qual) {
                     $pref_data[] = $qual['name'];
                }
            }
        $pref_data = implode(",",$pref_data);
        $qualification_data = array();
            if(count($qualification)){
                foreach ($qualification as $qual) {
                     $qualification_data[] = $qual['qualification'];
                }
            }
        $qualification_data = implode(",",$qualification_data);
        $candidateData = [
            'preferred_location' => $pref_data,
            'qualification' => $qualification_data,
            'total_experience_in_year' => $total_experience_in_year,
            'full_name' => $full_name,
            'email' => $email,
            'phone' => $phone,
            'mobile' =>$mobile,
            'city'=>$present_location[0]['name'],
            'buyout' => $buy_out,
            'currentservingnotice' => $current_notice,
            'unique_id' => $aadhar_no,
            'preferred_country' => $preferred_country,
            'present_country' => $present_country,
            'nationality' => $nationality,
            'work_autherization' => $work_autherization,
            'country_code' => $country_code,
			'is_privatearea'=>1,
            'current_salary' => $present_salary,
            'expected_salary' => $expected_salary,
            'gender' => $gender,
            'currency' => $currency
             //'pan_no' => $pan_cardno,
             //'passport_no' => $passport_no,
        ];
        $affectedRows = Candidate::where('id', '=', $id)->update($candidateData);
        $candidate_details = [
                'current_working_email' => $companyemail,
        ];

        $affectedRows = CandidateDetails::where('candidate_id', '=', $id)->update($candidate_details);
        $operationalSkillsData = [
            'operational_skills' => $operational_skills,
        ];
         $affectedRows = CandidateOperationalSkills::where('candidate_id', '=', $id)->update($operationalSkillsData);
        return response()->success($id);
    }
     public function postCheckaadharvalidity()

        {
            $aadhar = Input::get('aadharno');
            $jobid = Input::get('jobID');
            $can_data = Candidate::where('unique_id',$aadhar)->get(['id']);
           // print_r($can_data[0]['id']);exit;
            if(count($can_data) > 0){
                $candidatejobcount = Association::where('job_id',$jobid)
                                    ->where('candidate_id',$can_data[0]['id'])
                ->get();
                return count($candidatejobcount);
            }else{
                return 0;
            }

        }
 public function getCandidatedata($id)
    {   $authuser = Auth::user();
        $candidatedata = Candidate::where('id', $id)
                                    ->with('candidate_operational_skill')
                                    ->get();

    $data = array_filter(explode(",",$candidatedata[0]['candidate_operational_skill'][0]['operational_skills']));
    $data = array_unique($data);
    $candidatedata[0]['candidate_operational_skill'][0]['operational_skills'] = implode(",",$data);
    if($candidatedata[0])
    {
        if($candidatedata[0]['country_code']){
            $short_country = Country::where('ISD_code',str_replace('+', '', $candidatedata[0]['country_code']))->get();
            $candidatedata[0]['country_code_id'] = $short_country[0]['country_code'];
        }
        else{
             $candidatedata[0]['country_code_id'] = 'IN';
        }
    }
    else
    {
        $candidatedata[0]['country_code_id'] = 'IN';
    }
        return response()->success($candidatedata);
    }


public function postCandidatenote(){

    $user = Auth::user();
    $note = Input::get('note');
    $id = Input::get('candidate_id');
    $candidate = [
            'note' =>$note,
            ];
     $affectedRows = Candidate::where('id', '=', intval($id))->update($candidate);
     $updateCurrentUsercontext = Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated Note.',
        ]);
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));
    return response()->success('success');
}
    public function postCandidatenotes(){

        $user = Auth::user();
        $note = Input::get('note');
        $id = Input::get('candidate_id');
         //$affectedRows = CandidateNotes::where('id', '=', intval($id));
        //print_r($id);exit;
        $candidateactivity = new CandidateNotecs();
        $candidateactivity->note = $note;
        $candidateactivity->candidate_id = $id;
        $candidateactivity->save();
         /*$updateCurrentUsercontext = Activity::create([
                    'person_id' => $user->id,
                    'name' => 'Updated Note.',
            ]);*/
            //$createrowResponse = response()->success(compact('createrow'));
        return response()->success('success');
    }
    public function postCandidatesummary(){
        $user = Auth::user();
        $note = Input::get('note');
        $id = Input::get('candidate_id');
        // $candidateactivity = new  Candidate();
        $candidateData = [
            'edit_summary' => $note,
        ];
        $candidate = Candidate::where('id',$id)
                              ->update($candidateData);
        return response()->success('success');
    }
     public function postCandidateembedded(){
        $user = Auth::user();
        $id = Input::get('candidate_id');
        // $candidateactivity = new  Candidate();
        
        $candidateembedded = Candidate::select('loomembeded')->where('id',$id)
                              ->get();
        return response()->success(compact('candidateembedded'));
    }
    public function postCandidatesloom(){
        $user = Auth::user();
        $note = Input::get('loomembeded');
        $id = Input::get('candidate_id');
        $candidateData = [
            'loomembeded' => $note,
        ];
        $candidate = Candidate::where('id',$id)
                              ->update($candidateData);
        return response()->success('success');
    }
     public function postCandidatesloomget(){

        $id = Input::get('candidate_id');
        $candidatesloomget = CandidateDetails::where('candidate_id',$id)->get();

        return response()->success(compact('candidatesloomget'));
    }
    public function postCandidatenoteupdate(){
        $user = Auth::user();
        $note = Input::get('note');
        $id = Input::get('candidate_id');
        // $candidateactivity = new  Candidate();
        $candidateData = [
            'note_description' => $note,
            'updated_at'=> date('Y-m-d H:i:s')
        ];
        $candidate = VendorCandidateNotes::where('candidate_id',$id)
                              ->update($candidateData);
        return response()->success('success');
    }
    public function getCandidatenoteget($id){
        $user = Auth::user();
        $candidate = VendorCandidateNotes::where('candidate_id',$id)
                              ->get();

        $empCompanyID = Company::select('timezone')->where('id',$user->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
//echo $empTimezone.'empTimezone';
        foreach ($candidate as $notes) {

            $created_date = date('Y-m-d-H-i-s', strtotime($notes['created_at']));
            $created_at = explode('-', $created_date);

            $date = new \DateTime($notes['created_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $notes['created_at'] = $date->format('Y-m-d H:i:s');

            $created_date = date('Y-m-d-H-i-s', strtotime($notes['updated_at']));
            $created_at = explode('-', $created_date);

            $date = new \DateTime($notes['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $notes['updated_at'] = $date->format('Y-m-d H:i:s');
        }
        return response()->success($candidate);
    }
public function postCandidatesnotec(){

    $user = Auth::user();
    $id = Input::get('candidate_id');
    $candidateNotes = CandidateNotecs::where('candidate_id', '=', intval($id))->orderBy('updated_at','DESC')->get();
    $empCompanyID = Company::select('timezone')->where('id',$user->company_id)->get();
    $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

    foreach ($candidateNotes as $candidateNote) {

        $created_date = date('Y-m-d-H-i-s', strtotime($candidateNote['updated_at']));
        $created_at = explode('-', $created_date);

        $date = new \DateTime($candidateNote['updated_at'], new \DateTimeZone('UTC'));
        $date->format('Y-m-d H:i:s');

        $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
        $candidateNote['updated_at'] = $date->format('Y-m-d H:i:s');

        $candidateNote['timezone'] = $empTimezone[0]['GMT_offset'];
    }
    return response()->success(compact('candidateNotes'));
}

   /* public function getFreecvs(Request $request)
    {

        $freecvs = Candidate::with('skill')->where('is_alive',1)->orderBy('created_at','DESC')->get(['full_name','id','current_location','path','resume_file_name']);
        foreach ($freecvs as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
            $numbers = ['encrypted_canId'=>$encrypted];
            $job['numbers'] = $numbers;
        }

        return response()->success(compact('freecvs'));
    }*/
    public function getFreecvs(Request $request)
    {
//        $freecvs = Candidate::with('skill')->where('is_alive',1)->orderBy('created_at','DESC')->get();

        /*$freecvs = Candidate::select('full_name', 'current_location', 'preferred_location')->with(array('skill'=>function($query){$query->select('candidate_skillsets.id', 'candidate_skillsets.skill_set as skill_set', 'candidate_skillsets.candidate_id');}))->where('is_alive',1)->orderBy('created_at','DESC')->get();*/

        /*$freecvs = Candidate::with(array('skill'=>function($query){$query->select('skill_set');}))->select('full_name', 'current_location', 'preferred_location')->where('is_alive',1)->orderBy('created_at','DESC')->get();*/

        $freecvs = DB::table('candidates')
                    ->select('candidates.id', 'full_name', 'current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')
                    ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                    ->where('is_alive',1)
                    ->orderBy('candidates.created_at','DESC')
                    ->get();

        foreach ($freecvs as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job->id);
            $numbers = ['encrypted_canId'=>$encrypted];
            $job->numbers = $numbers;
        }
        /*
        ** Adding Custom Pagination to FreeCVS
        */

        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
        $itemCollection = collect($freecvs);
        $perPage = 50;
        $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
        $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
        $paginatedItems->setPath($request->url());
         //changed from 'freecvs' to 'paginatedItems'
        $freecvsdata = $paginatedItems->items(); //we can call Paginated Items Data using this Method in Angular too....o
        //echo '<pre>'; print_r($freecvsdata); die;
        //echo '<pre>'; print_r($paginatedItems); die;
        //return response()->success(compact('paginatedItems','freecvsdata'));
        return json_encode($paginatedItems);//()->('paginatedItems','freecvsdata');


        //return view('freecvs', ['data' => $freecvsdata]);
    }
     public function getCandfreecvs(Request $request)
    {
         //-----------------------------for string remove between special charecter --------------
                        // $string = "abc@ g m  a il .com";
                        // $try = preg_replace('/ [a-zA-Z]\w*/', '', $string);
                        //   print_r($try );die();

        //----------------------------------------------------------------------------------------
        $association=Association::whereNotBetween('candidate_status', array(9, 28))
                                    ->select('candidate_id')
                                    ->get();
        $associationid=array();
        foreach ($association as $key => $value) {
            array_push($associationid, $value['candidate_id']);
        }


        $candidate=Candidate::whereIn('candidates.id',$associationid)
                                ->select( 'candidates.id','email', 'full_name','current_location', 'preferred_location', 'resume_file_name', 'path', 'skill_set')->groupBy('email')
                                ->join('candidate_skillsets', 'candidate_skillsets.candidate_id', '=', 'candidates.id')
                                ->whereRaw("DATE_FORMAT(candidates.created_at, '%Y-%m-%d %h:%i:%s') <= DATE_FORMAT(( CURDATE()-INTERVAL 180 DAY ), '%Y-%m-%d %h:%i:%s')")
                                ->get();
        foreach ($candidate as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $job->id);
            $numbers = ['encrypted_canId'=>$encrypted];
            $job->numbers = $numbers;
            $job->skils_block = SkillblockResume::where('candidate_id',$job->id )->whereNotIn('found_id', [3,2])->get();
        }
        $currentPage = LengthAwarePaginator::resolveCurrentPage();
        //Replace collect() method content with your own method
        $itemCollection = collect($candidate);
        $perPage = 50;
        $currentPageItems = $itemCollection->slice(($currentPage * $perPage) - $perPage, $perPage)->all();
        $paginatedItems= new LengthAwarePaginator($currentPageItems , count($itemCollection), $perPage);
        $paginatedItems->setPath($request->url());
         //changed from 'freecvs' to 'paginatedItems'
        $freecvsdata = $paginatedItems->items(); //we can call Paginated Items Data using this Method in Angular too....o
        //echo '<pre>'; print_r($freecvsdata); die;
        //echo '<pre>'; print_r($paginatedItems); die;
        //return response()->success(compact('paginatedItems','freecvsdata'));
        return json_encode($paginatedItems);
    }

    public function getFilesnew()
    {
        return response()->success('success');
    }

    /*public function getVendorFileUploadCount(Request $request)
    {
        $vendorfileuploadcount = Candidate::where('asset_id')->count();
    }*/
    // postresume
    public function postUserassets()//
    {
        $asset_create_respose = null;
        $user = null;
        if ( Input::hasFile('file') )
            {
                $user = Auth::user();
                $files = Input::file('file');
                $note = Input::get('note');

                    if(count($files) == 1){
                        $file_name = $files[0]->getClientOriginalName();
                        $file_type = $files[0]->getmimeType();
                         $vendoruserData = [
                         'is_privatearea'=>0
                         ];
                        $canskills = UserAsset::where('file_name',$file_name)->get();
                        $affectedRows = UserAsset::where('file_name',$file_name)->update($vendoruserData);

                        $path = base_path()."/public/user_assets/".$user->id;
                        $destinationPath = 'user_assets/'.$user->id;
                        $url = "/user_assets/".$user->id;
                        $files[0]->move($destinationPath, $files[0]->getClientOriginalName());

                        //Insert assets record
                          $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $user->id,
                            'is_privatearea' => 1,
                            'note'=>$note
                        ]);

                        $asset_create_respose =  response()->success(compact('assets_create'));
                    } else {

                        foreach ($files as $file) {
                            $file_name = $file->getClientOriginalName();
                            $file_type = $file->getmimeType();
                            $path = base_path()."/public/user_assets/".$user->id;
                            $destinationPath = 'user_assets/'.$user->id;
                            $url = "/user_assets/".$user->id;
                            $file->move($destinationPath, $file->getClientOriginalName());

                            //Insert assets record
                              $assets_create = UserAsset::create([
                                'file_name' => $file_name,
                                'file_type' => $file_type,
                                'path' => $path,
                                'url' => $url,
                                'user_id' => $user->id,
                                'is_privatearea' => 1,
                                'note'=>$note
                            ]);
                            $asset_create_respose =  response()->success(compact('assets_create'));
                        }//foreach

                    } // else

                //Insert Successfull resume posting activity record
                $candidateResumePostIn = Activity::create([
                        'person_id' => $user->id,
                        'name' => 'Saved Uploaded resumes in private drive.',
                ]);
                $candidateResumePostInResponse =  response()->success(compact('candidateResumePostIn'));
                return $asset_create_respose;
            } //If

    } // cvpostresume
    public function postMovecandidate()
    {
        $candidateId = Input::get('candidateId');
        $fileData = ['is_privatearea' => 1];
        $affectedRows = Candidate::where('id', '=', intval($candidateId))->update($fileData);
        return response()->success('success');
    } // postresume
    public function postStatuschange()
    {
        $candidateId = Input::get('candidateId');
        $status = Input::get('status');
        $date = date_create();
        $created_date= date_format($date, 'Y-m-d H:i:s');
        $fileData = ['created_at' => $created_date,'is_active_private' => $status];
        $affectedRows = Candidate::where('id', '=', intval($candidateId))->update($fileData);
        return response()->success('success');
    } // postresume
    public function postResume()
    {
        $asset_create_respose = null;
        $user = null;
        if ( Input::hasFile('file') )
            {
                $user = Auth::user();
                $files = Input::file('file');
                $note = Input::get('note');
                    if(count($files) == 1){
                        $file_name = $files->getClientOriginalName();
                        $file_type = $files->getmimeType();
                        $path = base_path()."/public/user_assets/".$user->id;
                        $destinationPath = 'user_assets/'.$user->id;
                        $url = "/user_assets/".$user->id;
                        $files->move($destinationPath, $files->getClientOriginalName());
                        //Insert assets record
                          $assets_create = UserAsset::create([
                            'file_name' => $file_name,
                            'file_type' => $file_type,
                            'path' => $path,
                            'url' => $url,
                            'user_id' => $user->id,
                            'note'=>$note
                        ]);
                        $asset_create_respose =  response()->success(compact('assets_create'));
                    } else {

                        foreach ($files as $file) {
                            $file_name = $file->getClientOriginalName();
                            $file_type = $file->getmimeType();
                            $path = base_path()."/public/user_assets/".$user->id;
                            $destinationPath = 'user_assets/'.$user->id;
                            $url = "/user_assets/".$user->id;
                            $file->move($destinationPath, $file->getClientOriginalName());

                            //Insert assets record
                              $assets_create = UserAsset::create([
                                'file_name' => $file_name,
                                'file_type' => $file_type,
                                'path' => $path,
                                'url' => $url,
                                'user_id' => $user->id,
                                'note'=>$note
                            ]);
                            $asset_create_respose =  response()->success(compact('assets_create'));
                        }//foreach
                    } // else

                //Insert Successfull resume posting activity record
                $candidateResumePostIn = Activity::create([
                        'person_id' => $user->id,
                        'name' => 'Saved Uploaded resumes in private drive.',
                ]);
                $candidateResumePostInResponse =  response()->success(compact('candidateResumePostIn'));
                return $asset_create_respose;
            } //If

    } // postresume

    public function deleteUpdatefile($id)
    {
       /* $fileData = ['is_alive' => 0];*/
        $affectedRows = Candidate::where('id', '=', intval($id))->delete();
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}
        $updatefile = Activity::create(['vendor_id' => $authId,'name' => 'Updated File.']);
        if($authuser->parent_id) {
            $updatefile=Activity::create(['vendor_id' => $authId,'name' => 'Updated File.']);
        }
      return response()->success('success');
    }

    public function deleteUpdatefreecvs($id)
    {
        $fileData = [
            'is_alive' => 0
        ];
        $affectedRows = Candidate::where('id', '=', intval($id))->update($fileData);
        $authuser = Auth::user();
        //Insert Successfull file update activity record
        $updatefreecvs = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Updated File.',
        ]);
        //$updateFreecvsResponse =  response()->success(compact('updatefreecvs'));

      return response()->success('success');
    }

    /*public function getFiles()
    {
        $authuser=Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}

        $files=Candidate::where('vendor_id',$authId)->where('is_privatearea',0)->where('is_alive',1)
                            ->with('skill')
                            ->with('first_association')
                            ->orderBy('id', 'DESC')
                            ->get();
        foreach ($files as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
            $numbers = ['encrypted_canId'=>$encrypted_canId];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('files'));
    }*/

    public function getFiles()
    {
        $authuser=Auth::user();
        $authId=null;
        if($authuser->parent_id) {
            $authId=$authuser->parent_id;
            $files=Candidate::where('vendor_user_id',$authuser->id)
                        ->where('is_privatearea',0)
                        ->where('is_alive',1)
                        ->with('skill')
                        ->with('vendoruser')
                        ->with('first_association')
                        /*->orderBy('id', 'DESC')*/
                        ->orderBy('created_at','DESC')
                        /*->limit(100)*/
                        ->get();
        } else {
            $authId=$authuser->id;
            $files=Candidate::where('vendor_id',$authId)
                        ->where('is_privatearea',0)
                        ->where('is_alive',1)
                        ->with('skill')
                        ->with('vendor')
                        ->with('vendoruser')
                        ->with('first_association')
                        /*->orderBy('id', 'DESC')*/
                        ->orderBy('created_at','DESC')
                        /*->limit(100)*/
                        ->get();
        }

        foreach ($files as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
            $numbers = ['encrypted_canId'=>$encrypted_canId];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('files'));
    }

    public function getFilesuccess()
    {
        $authuser=Auth::user();
        return response()->success(compact('filesuccess'));
    }

    public function getCandidateshortlistedphone()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}

        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedphone = Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();
        foreach ($candidateshortlistedphone as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $numbers = ['encrypted_canId'=>$encrypted];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedphone as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
               if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedphone'));
    }

    public function getCandidateshortlistedf2f()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();

        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedf2f=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateshortlistedf2f as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $numbers = ['encrypted_canId'=>$encrypted];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedf2f as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedf2f'));
    }

    public function getCandidateshortlistedfinal()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedfinal=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateshortlistedfinal as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedfinal as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedfinal'));
    }

    public function getCandidateshortlistedwalkin()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedwalkin=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();
        foreach ($candidateshortlistedwalkin as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedwalkin as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedwalkin'));
    }

    public function getCandidateshortlistedskype()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedskype=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateshortlistedskype as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedskype as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedskype'));
    }

    public function getCandidateshortlisteddirect()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlisteddirect=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateshortlisteddirect as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlisteddirect as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }

                } //candidate_status

            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlisteddirect'));
    }

    public function getCandidateshortlistedheld()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',24)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateshortlistedheld=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateshortlistedheld as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateshortlistedheld as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;

        }  // outer foreach
        return response()->success(compact('candidateshortlistedheld'));
    }


    public function getCandidateselected()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[27,28])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidateselected=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidateselected as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidateselected as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;
        }  // outer foreach
        return response()->success(compact('candidateselected'));
    }


    public function getCandidatedirectjoin()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[28])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidatedirectjoin=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidatedirectjoin as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidatedirectjoin as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;
        }  // outer foreach
        return response()->success(compact('candidatedirectjoin'));
    }

    public function getCandidaterejectedaftershortlisted()
    {
        $user = Auth::user();
        $authId=null;
        if($user->parent_id) {$authId=$user->parent_id;}
        else {$authId=$user->id;}
        $association_candidates=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[30])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->get();
        $association_ids=array();
        foreach ($association_candidates as $key => $value) {
            array_push($association_ids, $value['candidate_id']);
        }

        $candidaterejectedaftershortlisted=Candidate::whereIn('id',$association_ids)
                                ->with('skill')
                                ->with('first_association')
                                ->get();

        foreach ($candidaterejectedaftershortlisted as $candidate) {
            $timestamp = 129310611081;
            $randomKey = '-';
            $encrypted = base64_encode($timestamp . $randomKey . $candidate['id']);
            $encrypted_statusid = base64_encode($timestamp . $randomKey . $candidate['candidate_status']);
            $numbers = ['encrypted_canId'=>$encrypted, 'encrypted_canStatus'=>$encrypted_statusid];
            $candidate['numbers'] = $numbers;
        }

        foreach ($candidaterejectedaftershortlisted as $key => $all_associations) {

            $star_1 = $star_2 =  $star_3 = $star_4 = $star_5 = $jobs_count = $shortlisted = $interviewed = $final_interview = $selected = 0;

            foreach ($all_associations['first_association'] as $key => $value) {

                if($value['candidate_status'] != null) {

                    $jobs_count++;
                    if($value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 31 || $value['candidate_status'] == 19) {
                        $star_1++;
                    } else if( $value['candidate_status'] == 21 || $value['candidate_status'] == 22 || $value['candidate_status'] == 23) {
                        $star_2++;
                    } else if($value['candidate_status'] == 20) {
                        $star_3++;
                    } else if($value['candidate_status'] == 27) {
                        $star_4++;
                    } else if($value['candidate_status'] == 28) {
                        $star_5++;
                    }

                    //Shorlisted
                    if( $value['candidate_status'] == 17 || $value['candidate_status'] == 18 || $value['candidate_status'] == 22 || $value['candidate_status'] == 31 ) {
                        $shortlisted++;
                    }
                    //Interviewed
                    if ( $value['status']['parent_id'] == 5 ) {
                        $interviewed++;
                    }
                    //Final interview
                    if ( $value['candidate_status'] == 20 ) {
                        $final_interview++;
                    }
                    //Selected
                    if ( $value['candidate_status'] == 27 || $value['candidate_status'] == 28 ) {
                        $selected++;
                    }
                } //candidate_status
            } // inner foreach

            if($jobs_count) {
                if($jobs_count) {
                if($star_5){
                    $all_associations['rating'] = 5;
                } else if ($star_4) {
                    $all_associations['rating'] = 4;
                } else if ($star_3) {
                    $all_associations['rating'] = 3;
                } else if ($star_2) {
                    $all_associations['rating'] = 2;
                } else if ($star_1) {
                    $all_associations['rating'] = 1;
                }
            } else {$all_associations['rating'] = 0;}
            } else {$all_associations['rating'] = 0;}
            $all_associations['shotlisted'] = $shortlisted;
            $all_associations['interviewed'] = $interviewed;
            $all_associations['final_interview'] = $final_interview;
            $all_associations['selected'] = $selected;
        }  // outer foreach
        return response()->success(compact('candidaterejectedaftershortlisted'));
    }
    

    public function getCandidatecount() {
        $authuser = Auth::user();
        $authId = $authuser->id;
        $candidates_srt_telephone = Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',17)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();

        $candidates_srt_f2f = Association::where('vendor_id',$authId)

                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',18)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
        
        $candidates_srt_final=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',20)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
                                    
        $candidates_walkin=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',21)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
                            
        $candidates_skype=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',22)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();      
        $candidates_direct=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',23)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();  
        $candidates_held=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->where('candidate_status',24)
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
        $candidates_selected=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[27,28])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();

        $candidates_direct_join=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[28])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
        $candidates_rejected_after_shorlisted=Association::where('vendor_id',$authId)
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereIn('candidate_status',[30])
                                    ->whereNotNull('accountmanager_id')
                                    ->select('candidate_id')
                                    ->count();
                                    
        $numbers = ['candidates_srt_telephone'=>$candidates_srt_telephone, 'candidates_srt_f2f'=>$candidates_srt_f2f, 'candidates_srt_final'=>$candidates_srt_final, 'candidates_walkin'=>$candidates_walkin, 'candidates_skype'=>$candidates_skype, 'candidates_direct'=>$candidates_direct, 'candidates_held'=>$candidates_held, 'candidates_selected'=>$candidates_selected, 'candidates_direct_join'=>$candidates_direct_join, 'candidates_rejected_after_shorlisted'=>$candidates_rejected_after_shorlisted];
        
        return response()->success(compact('numbers'));
    }
    public function postCandidatejson() {

            $job_id = Input::get('job_id');

            $josnInfo = DB::select("select * from candidate_json where job_id='".$job_id."' AND flag='0' ");
            $noofprofile = count($josnInfo);
        
            if(count($josnInfo)>0) {
            foreach($josnInfo as $key => $value) {

            $value->json = unserialize(base64_decode($value->json));
            }
            }
            return response()->success(compact('josnInfo','noofprofile'));
}

public function postCandidatemaskflag()
{
    $candidate_id = Input::get('candidate_id');
    $mask = Input::get('Mask');
    $candidateflag =DB::update("update  candidates  set mask='".$mask."' where id='".$candidate_id."'");

    return response()->success('success');

}

    

}
