<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\User;
use App\Activity;
use Auth;
use Input;
use DB;
use DateTime;
use DateInterval;
use date_add;
use date_interval_create_from_date_string;
use App\Association;
use App\Industry;
use App\Company; 
use App\Country;
use App\VendorUserJob;
use App\CandidatePoints;
use App\JobOrders;
use App\Http\Controllers\RchilliController;
use App\Models\SkillblockResume;
use App\Candidate;
use Session;
use App\AiCompetencySe;

class KanbanViewController extends Controller
{
    public function postCandidateviews() {
		$job_id = Input::get('job_id');
		$candidate_id = Input::get('candidate_id');
		$candInfo = DB::table('associations as a')
					->select('c.id as candidate_id','a.job_id','c.first_name','vcn.present_location', 'a.candidate_status','a.created_at')
					->leftjoin('candidates as c', 'c.id', '=', 'a.candidate_id')
					->leftjoin('vendor_candidate_notes as vcn', 'vcn.candidate_id', '=', 'a.candidate_id')
					->whereIn('candidate_status',[19,5,9,10,11,12,13,14,15,16,17,18,20,21,22,23,24,25,27,28,29,30,31,2,1])
					->where('a.job_id', $job_id)
					->groupBy('a.candidate_id')
					->get();

		$duplicateArr = array();
		$shortlistedArr = array();
		$rejectedArr = array();
		$receivedArr = array();
		
		if(is_array($candInfo) && count($candInfo)>0) {
			foreach($candInfo as $key => $value) {
				$candExp = DB::select("select * from candidates where id='".$value->candidate_id."'");
				/*if($candExp == null)
				{
					$candExpe = 0;
				}
				else{
					$candExpe = $candExp[0]->total_experience_in_year;
				}*/
				$created_at = $value->created_at;
				$current_date = date('Y-m-d h:i:s');
				$d1 = new DateTime($created_at);
				$d2 = new DateTime($current_date);
				$interval = $d2->diff($d1);
				
				$years = $interval->format('%y');
				$month = $interval->format('%m');
				if($years!=0) {
					$expinMonth = ($years * 12) + $month;
				} else {
					$expinMonth = $month;
				}
				$candExpe = $candExp[0]->total_experience_in_year;
				
				$city_name = explode("/", $value->present_location);

				$colorsInfo = DB::table("candidatefit as cf")
					->join("kanban_color as kc", 'kc.job_id', '=', 'cf.job_id')
					->where('cf.job_id', $job_id)->where('cf.candidate_id', $value->candidate_id)
					->get();
				$color="";
				if(is_array($colorsInfo) && count($colorsInfo)>0) {
					if($colorsInfo[0]->fit==1) {
						if(!empty($colorsInfo[0]->perfect_fit)) {
							$color = $colorsInfo[0]->perfect_fit;
						} else {
							$color = "#61bd4f";
						}
					}
					if($colorsInfo[0]->fit==2) {
						if(!empty($colorsInfo[0]->good_fit)) {
							$color = $colorsInfo[0]->good_fit;
						} else {
							$color = "#ffce19";
						}
					}
					if($colorsInfo[0]->fit==3) {
						if(!empty($colorsInfo[0]->may_fit)) {
							$color = $colorsInfo[0]->may_fit;
						} else {
							$color = "#69e6db";
						}
					}
				}
				//print_r($colorsInfo);exit;
				$fit="";
				//$fitcolor="";
				$statuscolorsInfo = DB::table("candidatefit as cf")
					->join("kanban_color as kc", 'kc.job_id', '=', 'cf.job_id')
					->where('cf.job_id', $job_id)
					->get();
				
				$statuscolor = "";
				if(isset($colorsInfo[0]->fit)) {
					 $fit = $colorsInfo[0]->fit;
					}
				if($value->candidate_status==2) {
					$status = "Rejected";
					if(isset($statuscolorsInfo[0]->reject)) {
					 $statuscolor = $statuscolorsInfo[0]->reject;
					}else{
					  $statuscolor = "#eb5e71";	
					}
				
					$rejectedArr[] = array('experience'=>$candExpe,
											'name' =>$value->first_name,
											'present_location' =>$city_name[0],
											'candidate_status'=>$status,
											'duration'=>$expinMonth,
											'can_id'=>$value->candidate_id,
											'fit'=>$fit,
											'fitcolor' =>$color,
											'statuscolor' =>$statuscolor
											);
				}
				if($value->candidate_status==1) {
					$status = "Duplicate";
					if(isset($statuscolorsInfo[0]->duplicate)) {
					 $statuscolor = $statuscolorsInfo[0]->duplicate;
					}else{
					  $statuscolor = "#c47370";	
					}
					$duplicateArr[] = array('experience'=>$candExpe,
											'name' =>$value->first_name,
											'present_location' =>$city_name[0],
											'candidate_status'=>$status,
											'duration'=>$expinMonth,
											'can_id'=>$value->candidate_id,
											'fit'=>$fit,
											'fitcolor' =>$color,
											'statuscolor' =>$statuscolor
											);
				}
				
				if(in_array($value->candidate_status,[5,9,10,11,12,13,14,15,16,17,18,20,21,22,23,24,25,27,28,29,30,31])) {
					$status = "Shortlisted";
					if(isset($statuscolorsInfo[0]->shortlist)) {
					 $statuscolor = $statuscolorsInfo[0]->shortlist;
					}else{
					  $statuscolor = "#fb9c0a";	
					}
					$shortlistedArr[] = array('experience'=>$candExpe,
											'name' =>$value->first_name,
											'present_location' =>$city_name[0],
											'candidate_status'=>$status,
											'duration'=>$expinMonth,
											'can_id'=>$value->candidate_id,
											'fit'=>$fit,
											'fitcolor' =>$color,
											'statuscolor' =>$statuscolor
											);
				}
				if($value->candidate_status==19) {
					$status = "Received";
					if(isset($statuscolorsInfo[0]->received)) {
					 $statuscolor = $statuscolorsInfo[0]->received;
					}else{
					  $statuscolor = "#01bfff";	
					}
					$receivedArr[] = array('experience'=>$candExpe,
											'name' =>$value->first_name,
											'present_location' =>$city_name[0],
											'candidate_status'=>$status,
											'duration'=>$expinMonth,
											'can_id'=>$value->candidate_id,
											'fit'=>$fit,
											'fitcolor' =>$color,
											'statuscolor' =>$statuscolor
											);
				}
			}

			if(is_array($receivedArr) ){
				$kanbanData['received'] = $receivedArr;
				$kanbanData['Received'] = count($receivedArr);
			}
			if(is_array($shortlistedArr) ){
				$kanbanData['shortlisted'] = $shortlistedArr;
				$kanbanData['Shortlisted'] = count($shortlistedArr);
			}
			if(is_array($rejectedArr) ){
				$kanbanData['rejected'] = $rejectedArr;
				$kanbanData['Rejected'] = count($rejectedArr);
			}
			if(is_array($duplicateArr) ){
				$kanbanData['duplicate'] = $duplicateArr;
				$kanbanData['Duplicate'] = count($duplicateArr);
			}
			if(is_array($duplicateArr) && count($duplicateArr)>0){
				$kanbanData[] = $duplicateArr;
			}
			
		}
		$colorInfo = DB::select("select * from kanban_color where job_id='$job_id'");
		$kanbanData['colorInfo'] = $colorInfo;
		 return response()->success(compact('kanbanData'));
	}
	public function postCandidatestatusupdate(Request $req) {
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		$candidate_status = Input::get('candidate_status');
		// if($candidate_status ==1){
		// 		$statusIds=19;
		// }else if($candidate_status ==4){
		// 		$statusIds=5;
		// }else if($candidate_status ==5){
		// 		$statusIds=1;
		// }else if($candidate_status ==7){
		// 		$statusIds=2;
		// }
		// $statusIds = DB::select("select id from statuses where name='".$candidate_status."'");
		DB::table("associations")
			->where('candidate_id',$candidate_id)
			->update(array('candidate_status'=>$candidate_status));
		$date = date("Y-m-d h:i:s");
		/*DB::insert("insert into kanban_activity set job_id='".$job_id."', candidate_id='".$candidate_id."', status='".$candidate_status."', created_at='".$date."', updated_at='".$date."'");
		$success ="Candidate status updated successfully.";*/
		 $candidate = Candidate::where('id', $candidate_id)->with('vendorcandidatenotes','status','candidate_operational_skill')->with(['experiences' => function($query){
                                    return $query;
                                }])
                                ->first();
        $candidate['candidate_details'] = DB::table('candidate_details')->where('candidate_id', $candidate_id)->first();	
        $candidate['CandidatePoints'] = DB::table('candidate_points')->where('candidate_id', $candidate_id)->first();	
        $Rchilcntl = new RchilliController();
       $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate_id);

        $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate_id);


        $candidate['talentmoning']= $candidateTalentMine;
        $candidate['candidateSpectrum']= $candidateSpectrum;
         $skils_block = SkillblockResume::where('candidate_id', $candidate_id)->whereNotIn('found_id', [3,2])->get();

          $candidate['skils_block'] = $skils_block;
 
         
			$candidateSkillblock = DB::table('skillblock_resume')->where('candidate_id', $candidate_id)->get();
            
			$candidate['candidateskillblocks'] = $candidateSkillblock;
			$timestamp = 129310611081;
            $randomKey = '-';
            $candidate['encrypted'] = base64_encode($timestamp . $randomKey . $candidate_id);
            //$req->session()->flash('success', 'candidate moved successfully.');
		return response()->success(compact('candidate'));
	}
	public function getInterviewkanbanrounds() {
		$job_id = Input::get('job_id');
		$interviewRounds = DB::table('interview_customized')
						->where('job_id', $job_id)
						->get();
		
		if(is_array($interviewRounds) && count($interviewRounds)>0) {
			foreach($interviewRounds as $ky =>$intround) {
			
				$interview_rounds = $intround->interview_round_name;
				
				$candInfo = DB::table('associations as a')
							->select('c.id as candidate_id','c.first_name','vcn.present_location', 'a.candidate_status','a.created_at')
							->join('candidates as c', 'c.id', '=', 'a.candidate_id')
							->join('vendor_candidate_notes as vcn', 'vcn.candidate_id', '=', 'a.candidate_id')
							->whereIn('candidate_status',[2,24,27])
							->where('a.job_id', $job_id)
							->groupBy('a.candidate_id')
							->get();
				
				$selectedArr = array();
				$holdArr = array();
				$rejectedArr = array();
				
				if(is_array($candInfo) && count($candInfo)>0) {
					foreach($candInfo as $key => $value) {
						$candExp = DB::select("select * from candidate_experiences where candidate_id='".$value->candidate_id."'");
						
						$created_at = $value->created_at;
						$current_date = date('Y-m-d h:i:s'); 
						$d1 = new DateTime($created_at);
						$d2 = new DateTime($current_date);
						$interval = $d2->diff($d1);
						
						$years = $interval->format('%y');
						$month = $interval->format('%m');
						if($years!=0) {
							$expinMonth = ($years * 12) + $month;
						} else {
							$expinMonth = $month;
						}
						
						if($value->candidate_status==2) {
							$rejectedArr[] = array('experience'=>$candExp[0]->total_experienceIn_months,
													'name' =>$value->first_name,
													'present_location' =>$value->present_location,
													'candidate_status'=>'Rejected',
													'duration'=>$expinMonth
													);
						}
						if($value->candidate_status==24) {
							$holdArr[] = array('experience'=>$candExp[0]->total_experienceIn_months,
													'name' =>$value->first_name,
													'present_location' =>$value->present_location,
													'candidate_status'=>'Hold',
													'duration'=>$expinMonth
													);
						}
						if($value->candidate_status==27) {
							$selectedArr[] = array('experience'=>$candExp[0]->total_experienceIn_months,
													'name' =>$value->first_name,
													'present_location' =>$value->present_location,
													'candidate_status'=>'Selected',
													'duration'=>$expinMonth
													);
						}
					}
					if(is_array($selectedArr) && count($selectedArr)>0){
						$kanbanData[] = array('interview_round'=>$interview_rounds, 'selected'=>$selectedArr);
					}
					if(is_array($holdArr) && count($holdArr)>0){
						$kanbanData[] = array('interview_round'=>$interview_rounds, 'selected'=>$holdArr);
					}
					if(is_array($rejectedArr) && count($rejectedArr)>0){
						$kanbanData[] = array('interview_round'=>$interview_rounds, 'selected'=>$rejectedArr);
					}		
				}
				$kanbanDataView[] = $kanbanData;
			}
		}
		return response()->success(compact('kanbanDataView'));
	}
	public function postInterviewroundnames() {
		$job_id = Input::get('job_id');
		
		$interviewRounds = DB::table('interview_customized')
					->where('job_id', $job_id)
					->get();
	
		return response()->success(compact('interviewRounds'));
	}
	public function postInterviewupdatetitle() {
		$id = Input::get('id');
		$round_name = Input::get('round_name');
		
		DB::table("interview_customized")
			->where('id',$id)
			->update(array('interview_round_name'=>$round_name));
			
		$success ="Interview title updated successfully.";
		return response()->success(compact('success'));
	}
	public function postKanbanactivitylog() {
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		
		$activityInfo = DB::select("select * from kanban_activity where job_id='".$job_id."' and candidate_id='".$candidate_id."'");
		return response()->success(compact('activityInfo'));
	}
	public function postFitupdate() {
		$candidate_id = Input::get('candidate_id');
		$job_id = Input::get('job_id');
		$fit_id = Input::get('fitchange');
		
		DB::insert("Insert into candidatefit set candidate_id='".$candidate_id."', job_id='".$job_id."', fit='".$fit_id."' ");
		$success = "Candidate information added successfully.";
		return response()->success(compact('success'));
	}
	
	public function postColorupdate() {
		$job_id = Input::get('job_id');
		$color = Input::get('color');
		$statuscolor = Input::get('statuscolor');

		$colorInfo = DB::select("select * from kanban_color where job_id='".$job_id."'");
		$valid = count($colorInfo);
		//echo $valid;exit;
		if ($valid == 0) {
			
			DB::insert("insert into  kanban_color  set job_id='".$job_id."', ".$statuscolor."='".$color."'");
			$kanbancolor="succesfulluy inserted";
		}
		else{

			DB::update("update  kanban_color  set ".$statuscolor."='".$color."' where job_id='".$job_id."'");
			$kanbancolor="succesfulluy inserted";
		}
		
		return response()->success(compact('kanbancolor'));
	}

	public function postColorupdateget() {
		$job_id = Input::get('job_id');
		$getcolor = DB::select("select * from kanban_color where job_id='".$job_id."'");
		return response()->success(compact('getcolor'));
	}
			public function postCandidatepopup(Request $req) {
		$candidate_id = Input::get('candidate_id');
		
		 $candidate = Candidate::where('id', $candidate_id)->with('vendorcandidatenotes','status','candidate_operational_skill')->with(['experiences' => function($query){
                                    return $query;
                                }])
                                ->first();
        $candidate['candidate_details'] = DB::table('candidate_details')->where('candidate_id', $candidate_id)->first();	
        $candidate['CandidatePoints'] = DB::table('candidate_points')->where('candidate_id', $candidate_id)->first();	
        $Rchilcntl = new RchilliController();
       $candidateTalentMine = $Rchilcntl->getCandidateTalentMine($candidate_id);
       $candidateSpectrum = $Rchilcntl->getCandidateSpectrum($candidate_id);
       $candidate['talentmoning']= $candidateTalentMine;
       $candidate['candidateSpectrum']= $candidateSpectrum;
       $skils_block = SkillblockResume::where('candidate_id', $candidate_id)->whereNotIn('found_id', [3,2])->get();
       $candidate['skils_block'] = $skils_block;
       $candidateSkillblock = DB::table('skillblock_resume')->where('candidate_id', $candidate_id)->get();
            
			$candidate['candidateskillblocks'] = $candidateSkillblock;
			$timestamp = 129310611081;
            $randomKey = '-';
            $candidate['encrypted'] = base64_encode($timestamp . $randomKey . $candidate_id);
		return response()->success(compact('candidate'));
	}
}
