<?php
namespace App\Http\Controllers;

use App\User;
use Auth;
use App\JobOrders;
use App\JobType;
use App\Association;
use App\Status;
use App\Activity;
use App\Country;
use App\City;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Illuminate\Http\Request;
use Input;
use Validator;
use DB;
use App\Quotation;

class StatusController extends Controller
{
    public function getIndex()
    {
        $status = Status::all();
        return response()->success(compact('status'));
    }
 
    public function postStatus() 
    {
        $status = Status::create([
            'name' => Input::get('name'),
            'description' => Input::get('description'),
            'parent_id' => Input::get('parent_id'),
            'role_id' => Input::get('role_id'),
            'user_id' => Input::get('user_id'),
            'status_type' => Input::get('status_type'),
            'funny_icon' => Input::get('funny_icon'),
            
        ]);
        $authuser = Auth::user();
        //Insert Successfull status create activity record
        $newStatus = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new status.',
        ]);
        $newStatusResponse =  response()->success(compact('newStatus'));
        return response()->success(compact('status'));
    }

    public function getStatus($id)
    {
        $Status = Status::find($id);
        return response()->success($role);
    }

    public function getVendorstatuses($jobId)
    {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;} 
        else {$authId=$authuser->id;}
        $vendorstatuses=Status::where('status_type','sourcing_action')
                                ->where('user_id',NULL)
                                ->get();
        $vacancies=JobOrders::where('id',intval($jobId))->first()->vacancies;
        $accountmanager_id=Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        foreach ($vendorstatuses as $status) {
            $vendorstattimeline = null;
            if($vacancies) {
            $vendorstattimeline=Activity::where('vendor_id',$authId)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->where('activity_by',$authId)
                        ->where('status_id',$status['id'])
                        ->where('is_vendor_sourcing_activity',1)
                        ->get();
                if(count($vendorstattimeline)>=$vacancies) { $status['showlimit']=false; }
                else { $status['showlimit']=true; }
                if( ($status['id']==32 || $status['id']==33) && (count($vendorstattimeline) >= 1) ) { $status['showlimit']=false; } 
            }
        } //foreach
        return response()->success(compact('vendorstatuses'));
    }

   public function getVendorcurrentstatus($jobId)
    {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;} 
        else {$authId=$authuser->id;}
        $accountmanager_id = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $vendorcurrentstatus=Activity::where('vendor_id',$authuser->id)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->where('activity_by',$authuser->id)
                        ->whereNotNull('status_id')
                        ->with('sourcingStatus')
                        ->where('is_vendor_sourcing_activity',1)
                        ->orderBy('created_at', 'DESC')
                        ->orderBy('status_id', 'DESC')->first();
        return response()->success(compact('vendorcurrentstatus'));
    }

    public function postAmvendorcurrentstatus()
    {
        $authuser = Auth::user();
        $jobId = Input::get('joborderId');
        $vendor_id = Input::get('vendorId');

        $amvendorcurrentstatus=Activity::where('vendor_id',$vendor_id)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$authuser->id)
                        ->where('activity_by',$vendor_id)
                        ->whereNotNull('status_id')
                        ->with('sourcingStatus')
                        ->where('is_vendor_sourcing_activity',1)
                        ->orderBy('created_at', 'DESC')->first();
        $job=JobOrders::where('id',intval($jobId))->first();
        $amvendorcurrentstatus['job'] = $job;
        return response()->success(compact('amvendorcurrentstatus'));
    }

    public function postEnableemployer()
    {
        $authuser = Auth::user();
        $jobId = Input::get('joborderId');

        $job = ['can_see_vendor_activity' => 1];
        $enableemployer = JobOrders::where('id',$jobId)->update($job);

        return response()->success(compact('enableemployer'));
    }

    public function getVendorstattimeline($jobId)
    {
        $authuser = Auth::user();
        $authId=null;
        if ($authuser->parent_id) {$authId=$authuser->parent_id;}
        else {$authId=$authuser->id;}

        $accountmanager_id = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        if ($authuser->parent_id) :
            $vendorstattimeline=Activity::where('vendor_id',$authId)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('vendor_user_id',$authuser->id)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->where('activity_by',$authId)
                        ->whereNotNull('status_id')
                        ->where('is_vendor_sourcing_activity',1)
                        ->with('activityuser.role','status','candidate')
                        ->with('job')
                        ->with('sourcingStatus')
                        ->get();
        else :
            $vendorstattimeline=Activity::where('vendor_id',$authId)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$accountmanager_id)
                        ->whereNull('vendor_user_id')
                        ->where('activity_by',$authId)
                        ->whereNotNull('status_id')
                        ->where('is_vendor_sourcing_activity',1)
                        ->with('activityuser.role','status','candidate')
                        ->with('job')
                        ->with('sourcingStatus')
                        ->get();
        endif;
        return response()->success(compact('vendorstattimeline'));
    }

    public function getCheckifsourcingfinished($jobId)
    {
        $authuser = Auth::user();
        $accountmanager_id = Association::where('vendor_id',$authuser->id)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        $checkifsourcingfinished = null;
        $count10 = null;
        for ($i=32; $i <= 41 ; $i++) { 
            $checkifsourcingfinished1 = 0;
            $checkifsourcingfinished1 = Activity::where('vendor_id',$authuser->id)
                            ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('activity_by',$authuser->id)
                            ->where('status_id',intval($i))
                            ->where('is_vendor_sourcing_activity',1)
                            ->get();

            if(count($checkifsourcingfinished1)) { $count10++; }
        }//for

        $checkifsourcingfinished = Activity::where('vendor_id',$authuser->id)
                            ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('activity_by',$authuser->id)
                            ->whereNotNull('status_id')
                            ->where('is_vendor_sourcing_activity',1)
                            ->first();

        if( $count10 >= 10 ) { $checkifsourcingfinished[0]['isfinished'] = true; }
        else { $checkifsourcingfinished[0]['isfinished'] = false; }

        return response()->success(compact('checkifsourcingfinished'));
    }

    public function postFinishpendingvsa()
    {
        $authuser = Auth::user();
        $authId=null;
        $jobId = Input::get('jobs');
        $empId=JobOrders::where('id',$jobId)->first()->user_id;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
            else{$authId=$authuser->id;}

        $accountmanager_id = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;
        //print_r($accountmanager_id);exit;
        $finishpendingvsa = null;
        for ($i=32; $i <= 41 ; $i++) { 
            $checkifsourcingfinished1 = 0;
            $checkifsourcingfinished1 = Activity::where('vendor_id',$authId)
                            ->where('employer_id',$empId)
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            ->where('accountmanager_id',$accountmanager_id)
                            ->where('activity_by',$authId)
                            ->where('status_id',intval($i))
                            ->where('is_vendor_sourcing_activity',1)
                            ->count();
            //print_r($checkifsourcingfinished1);exit;
            if($checkifsourcingfinished1==0) {
                $finishpendingVSA = new Activity();
                $finishpendingVSA->name = "Vendor changed sourcing action";
                $finishpendingVSA->admin_id = 1;
                $finishpendingVSA->accountmanager_id = $accountmanager_id;
                $finishpendingVSA->employer_id =$empId;
                $finishpendingVSA->job_id = intval($jobId);
                $finishpendingVSA->status_id = $i;
                $finishpendingVSA->vendor_id = $authId;
                $finishpendingVSA->activity_by = $authId;
                $finishpendingVSA->is_vendor_sourcing_activity = 1;
                $finishpendingVSA->save(); 
                if($authuser->parent_id){
                    $finishpendingVSA = new Activity();
                    $finishpendingVSA->name = "Vendor changed sourcing action";
                    $finishpendingVSA->admin_id = 1;
                    $finishpendingVSA->accountmanager_id=$accountmanager_id;
                    $finishpendingVSA->employer_id =$empId;
                    $finishpendingVSA->job_id = intval($jobId);
                    $finishpendingVSA->status_id = $i;
                    $finishpendingVSA->vendor_id = $authId;
                    $finishpendingVSA->vendor_user_id=$authuser->id;
                    $finishpendingVSA->activity_by = $authuser->id;
                    $finishpendingVSA->is_vendor_sourcing_activity = 1;
                    $finishpendingVSA->save();
                }
            } //if
        }//for
        return response()->success(compact('finishpendingvsa'));
    }

    public function postAmvendorstattimeline()
    {
        $authuser = Auth::user();

        $jobId = Input::get('joborderId');
        $vendor_id = Input::get('vendorId');

        $amvendorstattimeline = Activity::where('vendor_id',$vendor_id)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        ->where('accountmanager_id',$authuser->id)
                        ->where('activity_by',$vendor_id)
                        ->whereNotNull('status_id')
                        ->where('is_vendor_sourcing_activity',1)
                        ->with('activityuser.role','status','candidate')
                        ->with('job')
                        ->with('sourcingStatus')
                        ->get();

        return response()->success(compact('amvendorstattimeline'));
    } 

    public function postAmallvendorstattimeline()
    {
        $authuser=Auth::user();
        $jobId=Input::get('joborderId');
        $vendor_ids=Input::get('vendorIds');
        $sourcingFlag = 0;
        $submitted_profiles = 0;
        $is_vendor_pending = 0;
        $amallvendorstattimeline=null;
        $number=str_replace("+91","",Input::get('can_id'));
        $number=str_replace("91-","",Input::get('can_id'));
        $number=str_replace("-","",$number);
        $city = \App\City::where('id',$authuser->city_id)->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
        $receipientno = $countryCode.$number;
        $vacancies = JobOrders::where('id',intval($jobId))->first()->vacancies;
        $empCompanyID = \App\Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();
        foreach ($vendor_ids as $key => $value) {
            $result = null;
            $sourcingFlag = 0;
            $submitted_profiles = 0;
            $is_vendor_pending = 0;

            $result=Activity::where('vendor_id',$value)
                        ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                        ->where('admin_id',1)
                        ->where('job_id',intval($jobId))
                        //->where('accountmanager_id',$authuser->id)
                        ->where('is_vendor_sourcing_activity',1)
                        ->whereNull('vendor_user_id')
                        ->with('activityuser.role','status')
                        ->with('job','vendor')
                        ->with('sourcingStatus')
                        ->get();

            $is_vendor_pending = Association::where('vendor_id',intval($value))
                            //->where('accountmanager_id',$authuser->id)
                            ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                            ->where('job_id',intval($jobId))
                            ->where('admin_id',1)
                            ->where('job_status',4)
                            ->where('is_removed',0)
                            ->where('status_updated_by',$authuser->id)
                            ->whereNull('candidate_id')
                            ->whereNull('candidate_status')
                            ->count();                              
            if(count($result) >= 10) {
                //Get No. of submitted profiles

                $submitted_profiles = Association::where('vendor_id',$value)
                            //->where('accountmanager_id',$authuser->id)
                            ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                            ->where('job_id',intval($jobId))
                            ->where('admin_id',1)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->count();

                if($submitted_profiles) {
                    if($vacancies==$submitted_profiles){$sourcingFlag=2;}
                    else if($vacancies>$submitted_profiles) {$sourcingFlag=3; }
                } else { $sourcingFlag = 0; }

            } else if (count($result) < 10) { 
                $submitted_profiles = Association::where('vendor_id',$value)
                            //->where('accountmanager_id',$authuser->id)
                            ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                            ->where('job_id',intval($jobId))
                            ->where('admin_id',1)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->count();
                $sourcingFlag = 1; }

            foreach ($result as $single_activity) {
                $single_activity['submitted_profiles'] = $submitted_profiles;
                $single_activity['sourcingFlag'] = $sourcingFlag;
                $single_activity['country_code'] = "+".$countryCode.$number;
                $single_activity['is_vendor_pending'] = $is_vendor_pending;
                $date = new \DateTime($single_activity['created_at'], new \DateTimeZone('UTC'));
                $date->format('Y-m-d H:i:s');
                $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                $single_activity['created_at'] = $date->format('Y-m-d H:i:s');
                $single_activity['timezone'] = $empTimezone[0]['GMT_offset'];
                $single_activity['timezoneName'] = $empTimezone[0]['timezone'];

            }//$result
            if(count($result) > 0){$amallvendorstattimeline[$key] = $result;}
            
        } //vendor_ids
        return response()->success(compact('amallvendorstattimeline'));
    }    

    public function postEmpallvendorstattimeline()
    {
        $authuser=Auth::user();
        $jobId=Input::get('joborderId');
        $vendor_ids=Input::get('vendorIds');
        $sourcingFlag = 0;
        $submitted_profiles = 0;
        $is_vendor_pending = 0;
        $empallvendorstattimeline=null;
        $authId = null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;}
            else {$authId=$authuser->id;}
        $accountmanager_id=Association::where('vendor_id',$authId)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNull('vendor_user_id')
                                        ->where('job_id',$jobId)
                                        ->whereNull('candidate_id')
                                        ->first()['accountmanager_id'];
		
         $candidates = Association::where('job_id',$jobId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('employer_id')
                            ->whereNotNull('vendor_id')
                            ->whereNull('vendor_user_id')
                            ->with(array('Status','Candidate'))
                            ->get();

        $city = \App\City::where('id',$authuser->city_id)->get();
                if(count($city) > 0) {
                    $country = Country::where('id',$city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }                               
        $vacancies = JobOrders::where('id',intval($jobId))->first()->vacancies;


         $empCompanyID = \App\Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = \App\Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

        $associationsIds = array();
        foreach($candidates as $candidate) {

            if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $authId) ) {
                array_push($associationsIds, $candidate->id);
            }
            else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $authId) ) {
                array_push($associationsIds, $candidate->id);
            }

            /*echo '<pre>'; print_r(date_format($candidate['candidate']['updated_at'], 'Y-m-d H:i:s')); echo '</pre>';*/
//echo $empTimezone[0]['timezone_1'].'---';
            $date = new \DateTime($candidate->candidate->updated_at, new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone']));
            $candidate->candidate->updated_at = $date->format('Y-m-d H:i:s');
            $candidate->candidate->timezoneName = $empTimezone[0]['timezone'];

            //$candidate->timezone = $empTimezone[0]['GMT_offset'];
        }
       // echo '<pre>';print_r(new \DateTime($candidate->candidate->updated_at, new \DateTimeZone('UTC')));exit();

        $candidatenotes = \App\VendorCandidateNotes::where('job_id', $jobId)
                                ->where('candidate_id', $accountmanager_id['candidate_id'])
                                ->select('note_description')->get();

            $job['vendorcandidatenotes'] = $candidatenotes;

            $date = new \DateTime($accountmanager_id['updated_at'], new \DateTimeZone('UTC'));
            $date->format('Y-m-d H:i:s');

            $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
            $job['updated_at'] = $date->format('Y-m-d H:i:s');

            $job['timezone'] = $empTimezone[0]['GMT_offset'];



        foreach ($vendor_ids as $key => $value) {
            $result = null;
            $sourcingFlag = 0;
            $submitted_profiles = 0;
            $is_vendor_pending = 0;
            $timezone = $job['timezone']; 
            $result=Activity::where('vendor_id',$value)
                            ->where('employer_id',$authId)
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            //->where('accountmanager_id',$accountmanager_id)
                            ->where('is_vendor_sourcing_activity',1)
                            ->with('activityuser.role','status')
                            ->with('job','vendor')
                            ->with('sourcingStatus')
                            ->get();
            $is_vendor_pending = Association::where('vendor_id',intval($value))
                            //->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$authId)
                            ->where('job_id',intval($jobId))
                            ->where('admin_id',1)
                            ->where('job_status',4)
                            ->where('is_removed',0)
                            //->where('status_updated_by',$accountmanager_id)
                            ->whereNull('candidate_id')
                            ->whereNull('candidate_status')
                            ->count();   


            if(count($result) >= 10) {
                //Get No. of submitted profiles
                $submitted_profiles = Association::where('vendor_id',$value)
                            //->where('accountmanager_id',$accountmanager_id)
                            ->where('employer_id',$authId)
                            ->where('job_id',intval($jobId))
                            ->where('admin_id',1)
                            ->whereNotNull('candidate_id')
                            ->whereNotNull('candidate_status')
                            ->count();
                if($submitted_profiles) {
                    if($vacancies==$submitted_profiles){$sourcingFlag=2;}
                    else if($vacancies>$submitted_profiles) {$sourcingFlag=3; }
                } else { $sourcingFlag = 0; }
            } else if (count($result) < 10) { $sourcingFlag = 1; }
            foreach ($result as $single_activity) {
                $single_activity['submitted_profiles'] = $submitted_profiles;
                $single_activity['sourcingFlag'] = $sourcingFlag;
                $single_activity['country_code'] = "+".$countryCode;
                $single_activity['is_vendor_pending'] = $is_vendor_pending; 
                $single_activity['timezone'] = $timezone;
            }//$result
            if(count($result) > 0){$empallvendorstattimeline[$key] = $result;}
        } //vendor_ids
        return response()->success(compact('empallvendorstattimeline'));
    }       

    public function postEmpvendorstattimeline()
    {
        $authuser = Auth::user();
        $jobId = Input::get('joborderId');
        $vendor_id = Input::get('vendorId');
        $cansee = JobOrders::where('id',$jobId)->first()->can_see_vendor_activity;
        if($cansee){
            $empvendorstattimeline = Activity::where('vendor_id',$vendor_id)
                            ->whereNotNull('accountmanager_id')
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            ->where('employer_id',$authuser->id)
                            ->where('activity_by',$vendor_id)
                            ->whereNotNull('status_id')
                            ->where('is_vendor_sourcing_activity',1)
                            ->with('activityuser.role','status','candidate')
                            ->with('job')
                            ->with('sourcingStatus')
                            ->get();
        } else { return response()->error("You are ristricted to see sourcing activity."); }

        return response()->success(compact('empvendorstattimeline'));
    }

    public function postEmpvendorcurrentstatus()
    {
        $authuser = Auth::user();
        $jobId = Input::get('joborderId');
        $vendor_id = Input::get('vendorId');
        $job = JobOrders::where('id',$jobId)->first();
        if($job->can_see_vendor_activity) {
            $empvendorcurrentstatus=Activity::where('vendor_id',$vendor_id)
                            ->whereNotNull('accountmanager_id')
                            ->where('admin_id',1)
                            ->where('job_id',intval($jobId))
                            ->where('employer_id',$authuser->id)
                            ->where('activity_by',$vendor_id)
                            ->whereNotNull('status_id')
                            ->with('sourcingStatus')
                            ->where('is_vendor_sourcing_activity',1)
                            ->orderBy('created_at', 'DESC')->first();
            $empvendorcurrentstatus['job'] = $job;
        }  else { return response()->error("You are ristricted to see sourcing activity."); }
        return response()->success(compact('empvendorcurrentstatus'));
    } 
    
    public function deleteStatus($id)
    {
        Status::destroy($id);
         $authuser = Auth::user();
        //Insert Successfull status delete activity record
        $deleteStatus = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted an existing status.',
        ]);
        $deleteStatusResponse =  response()->success(compact('deleteStatus'));
        return response()->success('success');
    }

    public function getStatusShow($id)
    {
        $Status = Status::find($id);
        return response()->success($Status);
    }
      public function putStatusShow()
    {
        $StatusForm = Input::get('data');
        $StatusData = [
            'name' => $StatusForm['name'],
            'description' => $StatusForm['description'],
        ];

        $affectedRows = Status::where('id', '=', intval($StatusForm['id']))->update($StatusData);
        $Status = Status::find($StatusForm['id']);

        $authuser = Auth::user();
        //Insert Successfull status update activity record
        $updateStatus = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Updated an existing status.',
        ]);
        $updateStatusResponse =  response()->success(compact('updateStatus'));

      return response()->success('success');
    }

    public function postNewvendorstatus() 
    {
        $authuser = Auth::user();
        $authId=null;
        if($authuser->parent_id) {$authId=$authuser->parent_id;} 
        else {$authId=$authuser->id;}        
        $jobId = Input::get('job_id');
        $vendorstate = Input::get('vendorstate');
        $accountmanager_id = Association::where('vendor_id',$authId)
                            ->whereNotNull('accountmanager_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->where('job_id',$jobId)
                            ->whereNull('candidate_id')
                            ->first()->accountmanager_id;

     if ( $vendorstate >= 32 && $vendorstate <= 39 ) {
            $vendorstatus = new Activity();
            $vendorstatus->name = "Vendor changed sourcing action";
            $vendorstatus->admin_id = 1;
            $vendorstatus->accountmanager_id = $accountmanager_id;
            $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
            $vendorstatus->job_id = intval($jobId);
            $vendorstatus->status_id = intval($vendorstate);
            $vendorstatus->vendor_id = $authId;
            $vendorstatus->activity_by = $authId;
            $vendorstatus->is_vendor_sourcing_activity = 1;
            $vendorstatus->save();  
                if($authuser->parent_id){
                    $vendorstatus = new Activity();
                    $vendorstatus->name = "Vendor changed sourcing action";
                    $vendorstatus->admin_id = 1;
                    $vendorstatus->accountmanager_id = $accountmanager_id;
                    $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
                    $vendorstatus->job_id = intval($jobId);
                    $vendorstatus->status_id = intval($vendorstate);
                    $vendorstatus->vendor_id = $authId;
                    $vendorstatus->vendor_user_id = $authuser->id;
                    $vendorstatus->activity_by = $authId;
                    $vendorstatus->is_vendor_sourcing_activity = 1;
                    $vendorstatus->save();  
                }
        } else if ( ($vendorstate >= 40) ) {
            for($index = 2; $index <= 8; $index++ ) {
                $exist = Activity::where('vendor_id',$authId)
                                    ->where('employer_id',JobOrders::where('id',$jobId)->first()->user_id)
                                    ->where('admin_id',1)
                                    ->where('job_id',intval($jobId))
                                    ->where('accountmanager_id',$accountmanager_id)
                                    ->where('activity_by',$authId)
                                    ->where('status_id',intval($index) + 30)
                                    ->where('is_vendor_sourcing_activity',1)
                                    ->with('activityuser.role','status','candidate')
                                    ->with('job')
                                    ->with('sourcingStatus')
                                    ->count();
                if(!$exist) {
                    $vendorstatus = new Activity();
                    $vendorstatus->name = "Vendor changed sourcing action";
                    $vendorstatus->admin_id = 1;
                    $vendorstatus->accountmanager_id = $accountmanager_id;
                    $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
                    $vendorstatus->job_id = intval($jobId);
                    $vendorstatus->status_id = intval($index) + 30;
                    $vendorstatus->vendor_id = $authId;
                    $vendorstatus->activity_by = $authId;
                    $vendorstatus->is_vendor_sourcing_activity = 1;
                    $vendorstatus->save();
                    if($authuser->parent_id){
                        $vendorstatus = new Activity();
                        $vendorstatus->name = "Vendor changed sourcing action";
                        $vendorstatus->admin_id = 1;
                        $vendorstatus->accountmanager_id = $accountmanager_id;
                        $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
                        $vendorstatus->job_id = intval($jobId);
                        $vendorstatus->status_id = intval($index) + 30;
                        $vendorstatus->vendor_id = $authId;
                        $vendorstatus->vendor_user_id = $authuser->id;
                        $vendorstatus->activity_by = $authId;
                        $vendorstatus->is_vendor_sourcing_activity = 1;
                        $vendorstatus->save();
                    }
                } 
            } //for
                $vendorstatus = new Activity();
                $vendorstatus->name = "Vendor changed sourcing action";
                $vendorstatus->admin_id = 1;
                $vendorstatus->accountmanager_id = $accountmanager_id;
                $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
                $vendorstatus->job_id = intval($jobId);
                $vendorstatus->status_id = intval($vendorstate);
                $vendorstatus->vendor_id = $authId;
                $vendorstatus->activity_by = $authId;
                $vendorstatus->is_vendor_sourcing_activity = 1;
                $vendorstatus->save();
                
                if($authuser->parent_id){
                    $vendorstatus = new Activity();
                    $vendorstatus->name = "Vendor changed sourcing action";
                    $vendorstatus->admin_id = 1;
                    $vendorstatus->accountmanager_id = $accountmanager_id;
                    $vendorstatus->employer_id =JobOrders::where('id',$jobId)->first()->user_id;
                    $vendorstatus->job_id = intval($jobId);
                    $vendorstatus->status_id = intval($vendorstate);
                    $vendorstatus->vendor_id = $authId;
                    $vendorstatus->is_vendor_sourcing_activity = 1;
                    $vendorstatus->activity_by = $authId;
                    $vendorstatus->is_vendor_sourcing_activity = 1;
                    $vendorstatus->save();
                }
        }//elseif
        return response()->success(compact('vendorstatus'));
    }
     
}