<?php

namespace App\Http\Controllers;

use App\User;
use App\Activity;
use Auth;
use Bican\Roles\Models\Permission;
use Bican\Roles\Models\Role;
use Hash;
use Mail;
use Illuminate\Http\Request;
use Input;
use Validator; 
use App\Company;
use App\UserAssociation;
use App\Association;
use App\VendorActivities;
use App\Country; 
use App\City;
use App\Subscription;
use App\EmployerUserJobs;
use App\VendorUserSetting;
use App\VendorUserJobs;
use App\JobOrders;
use GuzzleHttp\Client;
use App\Candidate;
use DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use DateTime;
use DateInterval;
use App\Pricing;
use App\Models\SkillblockResume;
use Session;


class UserController extends Controller
{
    /**
     * Get user current context.
     *
     * @return JSON
     */
    public function getProfiledata()
    {
        $user = Auth::user();
        if($user->role_id == 5) {
            $associations = Association::where('employer_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
                /*$short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
                $assigned_user['country_code_id'] = $short_country[0]['country_code'];*/
            } else {$assigned_user = array(); }
        }

        if($user->role_id == 8) {
            $associations = Association::where('employer_user_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
               /*  $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
                $assigned_user['country_code_id'] = $short_country[0]['country_code'];*/
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 6) {
            $associations = Association::where('vendor_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
                /* $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
                $assigned_user['country_code_id'] = $short_country[0]['country_code'];*/
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 9) {
            $associations = Association::where('vendor_user_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
                 /*$short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
                $assigned_user['country_code_id'] = $short_country[0]['country_code'];*/
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 10) {
            $associations = Association::where('accountmanager_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->admin_id;
                $assigned_user = User::find($assigned_user_id);
               /* $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
                $assigned_user['country_code_id'] = $short_country[0]['country_code'];*/
            } else {
                $assigned_user = array();
            }
        }
       
        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
        $user['country_code_id'] = $short_country[0]['country_code'];
        return response()->success($user);
    }
      public function getPasswordprofiledata()
    {
        $user = Auth::user();
        if($user->role_id == 5) {
            $associations = Association::where('employer_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 8) {
            $associations = Association::where('employer_user_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 6) {
            $associations = Association::where('vendor_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 9) {
            $associations = Association::where('vendor_user_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        }

        if($user->role_id == 10) {
            $associations = Association::where('accountmanager_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')->with('company')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->admin_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        }

        return response()->success($user);
    }
    public function getCurrentuser()
    {
        $user = Auth::user();
        $currentuser = User::where('id',$user->id)->get();
        return response()->success(compact('currentuser'));

    }
    public function getMe()
    {
        $user = Auth::user();


switch ($user->role_id) {
    case '5':
        $associations = Association::where('employer_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
            $settings=null;
        break;
    case '6':
       $associations = Association::where('vendor_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
            $settings=null;
        break;
    case '8':
       $associations = Association::where('employer_user_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
            $settings=null;
        break;
    case '9':
        $associations = Association::where('vendor_user_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($user->parent_id){
                $settings = VendorUserSetting::where('vendor_user_id',$user->id)->first();
            } else {$settings = null;}                          
            
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
        break;
    case '10':
       $associations = Association::where('accountmanager_id',$user->id)
                            ->whereNull('employer_id')
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('employer_user_id')
                            ->whereNull('vendor_user_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->admin_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
            $settings = null;
        break;
        case '1':
        $associations = Association::where('employer_id',$user->id)
                            ->whereNull('vendor_id')
                            ->whereNull('job_id')
                            ->whereNull('candidate_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('accountmanager_id')
                            ->first();
            if($associations) {
                $assigned_user_id = $associations->accountmanager_id;
                $assigned_user = User::find($assigned_user_id);
            } else {
                $assigned_user = array();
            }
            $settings=null;
        break;
  
    
}

        
        $default_country = Country::where('is_enabled',1)->first();
        return response()->success(compact('user','assigned_user','default_country','settings'));
    }
    /**
     * Update user current context.
     *
     * @return JSON success message
     */
    public function putMe(Request $request)
    {
        $user = Auth::user();

        $this->validate($request, [
            'data.name' => 'required|min:3',
            'data.email' => 'required|email|unique:users,email,'.$user->id,
        ]);

        $userForm = app('request')
                    ->only(
                        'data.current_password',
                        'data.new_password',
                        'data.new_password_confirmation',
                        'data.first_name',
                        'data.last_name',
                        'data.email'
                    );

        $userForm = $userForm['data'];
        $user->first_name = $userForm['first_name'];
        $user->last_name = $userForm['last_name'];
        $user->email = $userForm['email'];

        if ($request->has('data.current_password')) {
            Validator::extend('hashmatch', function ($attribute, $value, $parameters) {
                return Hash::check($value, Auth::user()->password);
            });

            $rules = [
                'data.current_password' => 'required|hashmatch:data.current_password',
                'data.new_password' => 'required|min:8|confirmed',
                'data.new_password_confirmation' => 'required|min:8',
            ];

            $payload = app('request')->only('data.current_password', 'data.new_password', 'data.new_password_confirmation');

            $messages = [
                'hashmatch' => 'Invalid Password',
            ];

            $validator = app('validator')->make($payload, $rules, $messages);

            if ($validator->fails()) {
                return response()->error($validator->errors());
            } else {
                $user->password = Hash::make($userForm['new_password']);
            }
        }

        $user->save();

        //Insert Successfull current user context update activity record
        $updateCurrentUsercontext = Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated current user context.',
        ]);
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));

        return response()->success('success');
    }

     public function putUsercompany(Request $request)
    {	//$this->postDeleteVendor();exit;
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data'
                    );
      
        $company = [
            'name' => $userForm['data']['usercompany']['name'],
            'address_line_1' => $userForm['data']['usercompany']['address_line_1'],
            'postal_code' => $userForm['data']['usercompany']['postal_code'],
            'city_id' => $userForm['data']['usercompany']['city_id'],
            'telephone' => $userForm['data']['usercompany']['telephone'],
            'timezone' => $userForm['data']['usercompany']['timezone'][0]['id'],
        ];
       
        $affectedRows = Company::where('id', '=', intval($userForm['data']['usercompany']['id']))->update($company);

 //Insert Successfull current user context update activity record
        $updateCurrentUsercontext = Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated Company Details.',
        ]);
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));

        return response()->success('success');
    }

  public function putProfiledata(Request $request)
    {
        $user = Auth::user();
        $this->validate($request, [
            'data.first_name' => 'required|min:3',
            'data.email' => 'required|email|unique:users,email,'.$user->id,
        ]);
        $userForm = app('request')->only(
                        'data.first_name',
                        'data.last_name',
                        'data.email',
                        'data.mobile',
                        'data.oldEmail',
                        'data.country_code',
                        'data.current_password',
                        'data.new_password',
                        'data.new_password_confirmation',
						'data.otp'
                    );
       
        $userForm = $userForm['data'];
		$otp = Session::get('otp');
		
		if($otp!= $userForm['otp']) {
			return "Otp didn't match";
		}

        //check if email being updated.
        if($userForm['oldEmail']!=$userForm['email']){
            $email = $userForm['email'];
            $verificationCode = str_random(20);
            $user->email_verification_code = $verificationCode;
            $user->email_verified =0;
            $user->email = $userForm['email'];
            Mail::send('emails.email_activate', ['email' => $email, 'token' => $verificationCode,'text' => 'Activate new email.'], function ($m) use($email) {
             $m->to($email, 'Activate new email.')->subject('Activate new email.');
            });
        }
       
        $user->first_name = $userForm['first_name'];
        $user->last_name = $userForm['last_name'];
        $user->mobile = $userForm['mobile'];
        $user->country_code = $userForm['country_code'];
        $user->password = Hash::make($userForm['new_password']);
         
        $user->save();
        //Insert Successfull current user context update activity record
        
        if($user->parent_id) {
            $updateCurrentUsercontext = Activity::create([
                'vendor_id' => $user->parent_id,
                'name' => 'Updated current user context.',
            ]);
            $updateCurrentUsercontext = Activity::create([
                'vendor_id' => $user->parent_id,
                'vendor_user_id' => $user->id,
                'name' => 'Updated current user context.',
            ]);
        } else {
            $updateCurrentUsercontext = Activity::create([
                'vendor_id' => $user->id,
                'name' => 'Updated current user context.',
            ]);
        }
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));
        return response()->success('success');
    }


    public function putPasswordprofiledata(Request $request)
    {
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data.current_password',
                        'data.new_password',
                        'data.new_password_confirmation',
						'data.otp'
                    );
        $userForm = $userForm['data'];
		
		$sessinInfo = DB::select("select * from users_session where user_id='".$user->id."'");
		
		if($sessinInfo[0]->session_id != $userForm['otp']) {
			
			 return response()->error('Otp did not matched.');
		}
		
        if ($request->has('data.current_password')) {
            Validator::extend('hashmatch', function ($attribute, $value, $parameters) {
                return Hash::check($value, Auth::user()->password);
            });
            $rules = [
                'data.current_password' => 'required|hashmatch:data.current_password|',
                'data.new_password' => 'required|min:8|confirmed|different:data.current_password',
                'data.new_password_confirmation' => 'required|min:8',
            ];
            $payload = app('request')->only('data.current_password', 'data.new_password', 'data.new_password_confirmation');
            $messages = [
                'new_password' => 'Current password and new password cannot be same. Please try again',
            ];
            $validator = app('validator')->make($payload, $rules, $messages);
            if ($validator->fails()) {
                return response()->error($validator->errors());
            } else {
                $user->password = Hash::make($userForm['new_password']);
            }
        }
        $user->save();
        if($user->parent_id){
            $updateCurrentUsercontext=Activity::create([
                    'vendor_id' => $user->parent_id,
                    'name' => 'Updated current user Password.',
            ]);
            $updateCurrentUsercontext=Activity::create([
                    'vendor_id' => $user->parent_id,
                    'vendor_user_id' => $user->id,
                    'name' => 'Updated current user Password.',
            ]);
        }
        else{
            $updateCurrentUsercontext=Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated current user Password.',
            ]);
        }
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));
		
        return response()->success('success');
    }
    /**
     * Get all users.
     *
     * @return JSON
     */
    public function getIndex()
    {
        $users = User::all();
        return response()->success(compact('users'));
    }

    /**
     * Get user details referenced by id.
     *
     * @param int User ID
     *
     * @return JSON
     */
    public function getShow($id)
    {
        $user = User::find($id);
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();
        return response()->success($user);
    }
     public function postMobiledata(Request $request)
    {
        $email=$request->email;
        $mobile= $request->mobile;
        $mobileD=User::where('mobile',$mobile)->count();
        $emailD=User::where('email',$email)->count();
      
         $numbers = ['mobile'=>$mobileD,'email'=>$emailD];
                $mobiledata['numbers'] = $numbers;

        return response()->success($mobiledata);
    }

    public function getEmployerdata($id)
    {
        $user = User::find($id);
        $authuser = Auth::user();
        $accountmanagerId = Association::where('employer_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->first();
        $user['accountmanager_id']=$accountmanagerId;
        $company= Company::where('id',$user->company_id)->get();
        $city = City::where('id',$company[0]['city_id'])->get();
        $country = Country::where('id',$city[0]->country_id)->get();
        $countryid = $country[0]['id'];
        $user['countryid']=$countryid;
        $user['city_id']=$city; 
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();

        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
        $user['country_code_id'] = $short_country[0]['country_code'];
        return response()->success($user);
    }
      public function getEmployeramdata($id)
    {
        $user = User::find($id);
        $authuser = Auth::user();
        $accountmanagerId = Association::where('employer_id',$id)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->first();
                                       
        $user['accountmanager_id']=$accountmanagerId;
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();
        return response()->success($user);
    }

    public function putEmployerdata(Request $request)
    {
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data.id',
                        'data.first_name',
                        'data.last_name',
                        'data.email',
                        'data.companyData',
                        'data.accountmanager_id',
                        'data.job_type',
                        'data.is_global',
                        'data.country_code'
                    );
        $userForm = $userForm['data'];
        $user->id = $userForm['id'];
        $user->first_name = $userForm['first_name'];
        $user->last_name = $userForm['last_name'];
        $user->email = $userForm['email'];
        $user->is_global = $userForm['is_global'];
        $company = [
            'name' => $userForm['companyData']['name'],
            'address_line_1' => $userForm['companyData']['address_line_1'],
            'postal_code' => $userForm['companyData']['postal_code'],
            'city_id' => $userForm['companyData']['city_id'][0]['id'],
            'telephone' => $userForm['companyData']['telephone'],
            'company_website' => $userForm['companyData']['company_website'],
            'company_size' => $userForm['companyData']['company_size'],
            'company_type' => $userForm['companyData']['company_type'],
            'company_annual_revenue' => $userForm['companyData']['company_annual_revenue'],
            'company_description' => $userForm['companyData']['company_description'],
            'company_tags' => $userForm['companyData']['company_tags'],
            'company_social_media_links' => $userForm['companyData']['company_social_media_links'],
            'company_technology_details' => $userForm['companyData']['company_technology_details']
        ];
        if($userForm['is_global']) $userForm['is_global'] = 1;
        else $userForm['is_global'] = 0;
        $userData = [
            'first_name' => $userForm['first_name'],
            'last_name' => $userForm['last_name'],
            'email' => $userForm['email'],
            'is_global' => $userForm['is_global']
        ];

        $amAssociation = ['accountmanager_id' => $userForm['accountmanager_id']['accountmanager_id']];
        $affectedRowsUser = Association::where('employer_id', '=', intval($userForm['id']))
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->update($amAssociation);
       
        $affectedRows = Company::where('id', '=', intval($userForm['companyData']['id']))->update($company);
        $affectedRowsUser = User::where('id', '=', intval($userForm['id']))->update($userData);
        //Insert Successfull current user context update activity record
        $updateCurrentUsercontext = Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated Employer context.',
        ]);
        // by mukesh
        $country_code = (int) $userForm['country_code'];
        $country = Country::select('id', 'currency')->where('ISD_code', $country_code)->get();
        $contries = json_decode($country);
        
        $pringData = DB::table('pricings')->where('emp_id',$userForm['id'])->where('country_id',$contries[0]->id)->get();
        
        if(count($pringData)==0) {
            
            $countryPrice = DB::table('country_pricing')
                                ->select('id', 'country_slap1','country_slap2','country_slap3', 'country_slap4', 'country_slap5', 'country_slap6')
                                ->where('country_currency', $contries[0]->currency)->take(1)->get();
            $count_id = $countryPrice[0]->id;
            unset($countryPrice[0]->id);
            unset($countryPrice[0]->country_slap1);
            $countryPrice = array_values((array) $countryPrice[0]);
            
            $countryPricePercents = DB::table('country_pricing_percent')
                                    ->select('country_slap2','country_slap2','country_slap3','country_slap4','country_slap5','country_slap6')
                                    ->where('country_id', $count_id)->get();
            $countryPricePercents = array_values((array) $countryPricePercents[0]);
            for($i=0; $i<count($countryPricePercents); $i++) {
                $prices = explode("-", $countryPrice[$i]);
                $price = new Pricing();
                $price->country_id = $contries[0]->id;
                $price->default_country = $contries[0]->id;
                $price->type_of_emp = 'Permanent';
                $price->starting_range = $prices[0];
                $price->ending_range = $prices[1];
                $price->price = $countryPricePercents[$i];
                $price->price_type = 'percentage';
                $price->emp_id = $user->id;
                $price->save();
            }
            $countryPrice = DB::table('country_pricing')
                                ->select('country_slap1','contract_percent')
                                ->where('country_currency', $contries[0]->currency)->take(1)->get();
                                
            $priceCon = new Pricing();
            $priceCon->country_id = $contries[0]->id;
            $priceCon->type_of_emp = 'Contract To Hire';
            $priceCon->default_country = $contries[0]->id;
            $priceCon->flat_rate = $countryPrice[0]->country_slap1;
            $priceCon->price = $countryPrice[0]->contract_percent;
            $priceCon->price_type = 'percentage';
            $priceCon->emp_id = $user->id;
            $priceCon->save();
        
            
            $cnPricePercents = DB::table('country_pricing_percent')
                                    ->select('country_slap1')
                                    ->where('country_id', $count_id)->get();
            $priceFlat = new Pricing();
            $priceFlat->country_id = $contries[0]->id;
            $priceFlat->type_of_emp = 'Flat Rate';
            $priceFlat->default_country = $contries[0]->id;
            $priceFlat->flat_rate = $countryPrice[0]->country_slap1;
            $priceFlat->price = $cnPricePercents[0]->country_slap1;
            $priceFlat->price_type = 'percentage';
            $priceFlat->emp_id = $user->id;
            $priceFlat->save();
        }
        
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));
        return response()->success('success');
    }
  public function putEmployeramdata(Request $request)
    {
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data.id',
                        'data.first_name',
                        'data.last_name',
                        'data.email',
                        'data.companyData',
                        'data.accountmanager_id',
                        'data.job_type',
                        'data.is_global'
                    );
        $userForm = $userForm['data'];
        $user->id = $userForm['id'];
        $user->first_name = $userForm['first_name'];
        $user->last_name = $userForm['last_name'];
        $user->email = $userForm['email'];
        $user->is_global = $userForm['is_global'];
        
        $amAssociation = ['accountmanager_id' => $userForm['accountmanager_id']['accountmanager_id']];
        $affectedRowsUser = Association::where('employer_id', '=', intval($userForm['id']))
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->update($amAssociation);
        //Insert Successfull current user context update activity record
        $updateCurrentUsercontext = Activity::create([
                'person_id' => $user->id,
                'name' => 'Updated Employer Account Manager.',
        ]);
        $updateCurrentUsercontextResponse = response()->success(compact('updateCurrentUsercontext'));
        return response()->success('success');
    }
    public function getVendordata($id)
    {
        $user = User::find($id);

        $accountmanagerIds = Association::where('vendor_id',$id)
                                        ->where('is_removed',0)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->groupBy('accountmanager_id')
                                        ->lists('accountmanager_id');

        $user['accountmanager_id']=$accountmanagerIds;
        $city = City::where('id',$user->city_id)->get();
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryid = $country[0]['id'];
        $user['countryid']=$countryid;

        $user['city_id']=$city;
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();
        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
        $user['country_code_id'] = $short_country[0]['country_code'];
        return response()->success($user);
    }
     public function getVendoramdata($id)
    {
        $user = User::find($id);

        $accountmanagerIds = Association::where('vendor_id',$id)
                                        ->where('is_removed',0)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('admin_id')
                                        ->groupBy('accountmanager_id')
                                        ->lists('accountmanager_id');

        $user['accountmanager_id']=$accountmanagerIds;
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();
        return response()->success($user);
    }
    // by mukesh
    public function putVendordata(Request $request)
    {   
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data.id',
                        'data.first_name',
                        'data.last_name',
                        'data.email',
                        'data.companyData',
                        'data.accountmanager_id',
                        'data.payroll',
                        'data.vendor_code',
                        'data.cityPin',
                        'data.vendor_type',
                        'data.vendor_price_percent'
                    );
        
        $userForm = $userForm['data'];
        $user->id = $userForm['id'];
        $user->first_name = $userForm['first_name'];
        $user->last_name = $userForm['last_name'];
        $user->email = $userForm['email'];
        $company = [
            'name' => $userForm['companyData']['name'],
            'address_line_1' => $userForm['companyData']['address_line_1'],
            'postal_code' => $userForm['companyData']['postal_code'],
            'city_id' => $userForm['cityPin'][0]['id'],
            'telephone' => $userForm['companyData']['telephone'],
        ];
        $userData = [
            'first_name' => $userForm['first_name'],
            'last_name' => $userForm['last_name'],
            'email' => $userForm['email'],
            'payroll' => $userForm['payroll'],
            'vendor_code' => $userForm['vendor_code'],
            'vendor_type' => $userForm['vendor_type'],
            'vendor_price_percent' => $userForm['vendor_price_percent'],
        ];
        
        if( count($userForm['accountmanager_id']) ):
            foreach($userForm['accountmanager_id'] as $am):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->vendor_id = $userForm['id'];
                $userassociation->accountmanager_id = $am;
                $userassociation->status_updated_by = 1;
                $userassociation->save();
            endforeach;
        endif;

        $affectedRows=Company::where('id', '=', intval($userForm['companyData']['id']))->update($company);
        $affectedRowsUser=User::where('id', '=', intval($userForm['id']))->update($userData);
        //Insert Successfull current user context update activity record
        $vendorUpdate = new Activity();
        $vendorUpdate->name = "Updated vendor user data.";
        $vendorUpdate->admin_id = 1;
        $vendorUpdate->activity_by = 1;
        $vendorUpdate->save();
        
        // my Mukesh
        $vendor_id = $userForm['id'];
        $users = User::where('id', $vendor_id)->select('vendor_price_percent','user_type')->get();
        
        if($users[0]->user_type==1)  {
            $vendor_price_percent = 50;
            $account_manager_percent = 50;
        } else {
            $vendor_price_percent = $users[0]->vendor_price_percent;
            $account_manager_percent = 100 - $vendor_price_percent;
        }
        $jobInfo = DB::table("associations as a")
                  ->select('a.job_id', 'vpr.permanent_price', 'vpr.contract_price', 'vpr.flat_rate')
                  ->join('vendor_pricing_revenue as vpr', 'vpr.job_id', '=', 'a.job_id')
                  ->where('a.vendor_id', $vendor_id)
                  ->get();
                  
        if(is_array($jobInfo) && count($jobInfo)>0) {
            
            foreach($jobInfo as $key =>$info) {
                if(!empty($info->flat_rate)) {
                    
                    $vendor_price = ($info->flat_rate * $vendor_price_percent)/100;
                    $accountm_price = ($info->flat_rate * $account_manager_percent)/100;
                } else if(!empty($info->contract_price)) {
                    
                    $vendor_price = ($info->contract_price * $vendor_price_percent)/100;
                    $accountm_price = ($info->contract_price * $account_manager_percent)/100;
                }  else if(!empty($info->permanent_price)) {
                    
                    $vendor_price = ($info->permanent_price * $vendor_price_percent)/100;
                    $accountm_price = ($info->permanent_price * $account_manager_percent)/100;
                } 
                $created_at = date('Y-m-d h:i:s');
                $vendorAccInfo = DB::select("select * from vendor_accountmanager_share where job_id='".$info->job_id."' and vendor_id='".$vendor_id."'");
                
                if(is_array($vendorAccInfo) && count($vendorAccInfo)>0) {
                    DB::table('vendor_accountmanager_share')
                        ->where('id', $vendorAccInfo[0]->id)
                        ->update([
                            'vendor_price' => $vendor_price,
                            'account_manager_price' => $accountm_price
                        ]);
                } else {
                    DB::insert("insert into vendor_accountmanager_share set vendor_id='".$vendor_id."', job_id='".$info->job_id."', vendor_price='".$vendor_price."', account_manager_price='".$accountm_price."', created_at='".$created_at."', updated_at='".$created_at."'");
                }
            }
        }
        // end Mukesh
        $updateCurrentUsercontextResponse=response()->success(compact('updateCurrentUsercontext'));
        return response()->success('success');
    }
 public function putVendoramdata(Request $request)
    {
        $user = Auth::user();
        $userForm = app('request')->only(
                        'data.id',
                        'data.first_name',
                        'data.last_name',
                        'data.email',
                        'data.companyData',
                        'data.accountmanager_id',
                        'data.payroll',
                        'data.vendor_code',
                        'data.cityPin'
                    );
        $userForm = $userForm['data'];
        
        if( count($userForm['accountmanager_id']) ):
            foreach($userForm['accountmanager_id'] as $am):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->vendor_id = $userForm['id'];
                $userassociation->accountmanager_id = $am;
                $userassociation->status_updated_by = 1;
                $userassociation->save();
            endforeach;
        endif;

        $vendorUpdate = new Activity();
        $vendorUpdate->name = "Account Managers hasbeen Updated.";
        $vendorUpdate->admin_id = 1;
        $vendorUpdate->activity_by = 1;
        $vendorUpdate->save();

        $updateCurrentUsercontextResponse=response()->success(compact('updateCurrentUsercontext'));
        return response()->success('success');
    }
    public function getAccountmanager($id)
    {
        $user = User::find($id);
        $user['role'] = $user
                        ->roles()
                        ->select(['slug', 'roles.id', 'roles.name'])
                        ->get();
        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
        $user['country_code_id'] = $short_country[0]['country_code'];
        return response()->success($user);

    }
    public function getCompany($id)
    {
        $company = Company::find($id);
        $city = City::where('id',$company->city_id)->get();
        return response()->success($company);
    }
    public function getCompanyn($id)
    {
        $company = Company::find($id);
        $city = City::where('id',$company->city_id)->get();
        $country_en = city::where('id',$company->city_id)->get();
        $company['city_id']=$country_en;
        return response()->success($company);
    }
    public function getUsercompany()
    {
        $user = Auth::user();
		
        $usercompany = Company::find($user->company_id);
        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
		
        $usercompany['country_code'] = $short_country[0]['country_code'];
        $usercompany['timezone']=Country::where('id',$usercompany['timezone'])->get();
        $usercompany['timezone'][0]['name']= $usercompany['timezone'][0]->timezone.' ('.$usercompany['timezone'][0]->GMT_offset.')';
        return response()->success(compact('usercompany'));
    }

    public function getCompanydetails($id)
    {
        $userdetails = User::find($id);

         $companydetails = Company::find($userdetails['company_id']);
        
        return response()->success($companydetails);
    }
    public function getVendoruserShow($id)
    {
        $user=User::find($id);
        $settings=VendorUserSetting::where('vendor_user_id',intval($id))->first();
        $user['settings']=$settings;
        $short_country = Country::where('ISD_code',str_replace('+', '', $user->country_code))->get();
        $user['country_code_id'] = $short_country[0]['country_code'];
        return response()->success($user);
    }
     public function putVendoruserShow()
    {

        $authuser = Auth::user();
        $vendoruserForm = Input::get('data');
        $vendoruserData = [
            'first_name' => $vendoruserForm['first_name'],
            'last_name' => $vendoruserForm['last_name'],
            'mobile' => $vendoruserForm['mobile'],
            'email' => $vendoruserForm['email'],
            'country_code' => $vendoruserForm['country_code'],
        ];

        $vendoruserSettings = [
            'auto_mode_keywords'=>$vendoruserForm['settings']['auto_mode_keywords'],
            'priority'=>$vendoruserForm['settings']['priority'],
            'direct_submission_to_am'=>$vendoruserForm['settings']['direct_submission_to_am'],
            'upload_cv_to_private_area'=>$vendoruserForm['settings']['upload_cv_to_private_area'],
            'search_in_free_cvs'=>$vendoruserForm['settings']['search_in_free_cvs'],
            'activate_vsa'=>$vendoruserForm['settings']['activate_vsa'],
            'candidate_area_access'=>$vendoruserForm['settings']['candidate_area_access'],
            'auto_assign_job'=>$vendoruserForm['settings']['auto_assign_job'],
            'max_jobs'=>$vendoruserForm['settings']['max_jobs']
        ];

        $affectedRows = User::where('id', '=', intval($vendoruserForm['id']))->update($vendoruserData);

        $settingsUpdate = VendorUserSetting::where('vendor_user_id', intval($vendoruserForm['settings']['vendor_user_id']))->update($vendoruserSettings);

        $vendoruser = User::find($vendoruserForm['id']);
        $updateUserPermissions = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Vendor user details are updated.',
        ]);
        return response()->success($vendoruser);
    }

    /**
     * Update user data.
     *
     * @return JSON success message
     */
    public function putShow(Request $request)
    {
        $userForm = array_dot(
            app('request')->only(
                'data.first_name',
                'data.last_name',
                'data.email',
                'data.id'
            )
        );

        $userId = intval($userForm['data.id']);

        $user = User::find($userId);

        $this->validate($request, [
            'data.id' => 'required|integer',
            'data.first_name' => 'required|min:3',
            'data.last_name' => 'required|min:1',
            'data.email' => 'required|email|unique:users,email,'.$user->id,
        ]);

        $userData = [
            'first_name' => $userForm['data.first_name'],
            'last_name' => $userForm['data.last_name'],
            'email' => $userForm['data.email'],
        ];

        $affectedRows = User::where('id', '=', $userId)->update($userData);

        $user->detachAllRoles();

        foreach (Input::get('data.role') as $setRole) {
            $user->attachRole($setRole);
        }

        //Insert Successfull current user update activity record
        $updateCurrentUser = Activity::create([
                'person_id' => $user->id,
                'name' => 'Current user information is updated.',
        ]);
        $updateCurrentUserResponse =  response()->success(compact('updateCurrentUser'));

        return response()->success('success');
    }

    /**
     * Delete User Data.
     *
     * @return JSON success message
     */
    public function deleteUser($id)
    {
        // $user = User::find($id);
        // $user->delete();
        return response()->success('success');
    }

    /**
     * Get all user roles.
     *
     * @return JSON
     */
    public function getRoles()
    {
        $roles = Role::all();

        return response()->success(compact('roles'));
    }

    public function getRoleid()
    {
        $authuser = Auth::user();
        $roleid = User::where('id',$authuser->id)->get(['role_id']) ;
        return response()->success(compact('roleid'));
    }

    /**
     * Get role details referenced by id.
     *
     * @param int Role ID
     *
     * @return JSON
     */
    public function getRolesShow($id)
    {
        $role = Role::find($id);

        $role['permissions'] = $role
                        ->permissions()
                        ->select(['permissions.name', 'permissions.id'])
                        ->get();

        return response()->success($role);
    }

    /**
     * Update role data and assign permission.
     *
     * @return JSON success message
     */
    public function putRolesShow()
    {
        $roleForm = Input::get('data');
        $roleData = [
            'name' => $roleForm['name'],
            'slug' => $roleForm['slug'],
            'description' => $roleForm['description'],
        ];

        $roleForm['slug'] = str_slug($roleForm['slug'], '.');
        $affectedRows = Role::where('id', '=', intval($roleForm['id']))->update($roleData);
        $role = Role::find($roleForm['id']);

        $role->detachAllPermissions();

        foreach (Input::get('data.permissions') as $setPermission) {
            $role->attachPermission($setPermission);
        }

        $authuser = Auth::user();
    //Insert Successfull current user permissions update activity record
        $updateUserPermissions = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Current user permissions are updated.',
        ]);
        $updateCurrentUserPermissionsResponse =  response()->success(compact('updateUserPermissions'));

        return response()->success('success');
    }

    /**
     * Create new user role.
     *
     * @return JSON
     */
    public function postRoles()
    {
        $role = Role::create([
            'name' => Input::get('role'),
            'slug' => str_slug(Input::get('slug'), '.'),
            'description' => Input::get('description'),
        ]);

        $authuser = Auth::user();
        //Insert Successfull new user role create activity record
        $newUserRole = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new user role.',
        ]);
        $newUserRoleResponse =  response()->success(compact('newUserRole'));

        return response()->success(compact('role'));
    }

    /**
     * Delete user role referenced by id.
     *
     * @param int Role ID
     *
     * @return JSON
     */
    public function deleteRoles($id)
    {
        Role::destroy($id);
        $authuser = Auth::user();
        //Insert Successfull user role delete activity record
        $deleteUserRole = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted user role.',
        ]);
        $deleteUserRoleResponse = response()->success(compact('deleteUserRole'));
        return response()->success('success');
    }
      public function deleteProfiledata($id)
    {
        $authuser = Auth::user();
        $vendoruserData = [
            'path' => '',
            'file_name' => ''
        ];
        $affectedRows = User::where('id', '=', intval($authuser->id))->update($vendoruserData);
        
        return response()->success('success');
    }

    public function deleteAmuserremove($id)
    {
        Association::destroy($id);
        $authuser = Auth::user();
        //Insert Successfull user role delete activity record

        $deleteAMUser = new Activity();
        $deleteAMUser->name = "Deleted account manager user";
        $deleteAMUser->admin_id = 1;
        $deleteAMUser->activity_by = $authuser->id;
        $deleteAMUser->save();

        $deleteUserRoleResponse = response()->success(compact('deleteAMUser'));
        return response()->success('success');
    }

    public function deleteVendoram($id)
    {
        $authuser = Auth::user();
         $data = [
            'is_removed' => 1,
            'status_updated_by' => 1
        ];

        $amupdate = Association::where('accountmanager_id',$id)
                        ->where('is_removed',0)
                        ->where('admin_id',1)
                        ->whereNull('job_id')
                        ->whereNull('employer_id')
                        ->whereNull('employer_user_id')
                        ->whereNull('vendor_user_id')
                        ->whereNull('candidate_id')
                        ->update($data);

        //Insert Successfull removed am activity record
        $AMUser = new Activity();
        $AMUser->name = "Removed account manager";
        $AMUser->admin_id = 1;
        $AMUser->activity_by = $authuser->id;
        $AMUser->save();

        $deleteUserRoleResponse = response()->success(compact('AMUser'));
        return response()->success('success');
    }

    /**
     * Get all system permissions.
     *
     * @return JSON
     */
    public function getPermissions()
    {
        $permissions = Permission::all();

        return response()->success(compact('permissions'));
    }

    /**
     * Create new system permission.
     *
     * @return JSON
     */
    public function postPermissions()
    {
        $permission = Permission::create([
            'name' => Input::get('name'),
            'slug' => str_slug(Input::get('slug'), '.'),
            'description' => Input::get('description'),
        ]);

        $authuser = Auth::user();
        //Insert Successfull new system persmission activity record
        $newSystemPermission = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new system permission.',
        ]);
        $newSystemPermissionResponse = response()->success(compact('newSystemPermission'));

        return response()->success(compact('permission'));
    }

    /**
     * Get system permission referenced by id.
     *
     * @param int Permission ID
     *
     * @return JSON
     */
    public function getPermissionsShow($id) 
    {
        $permission = Permission::find($id);

        return response()->success($permission);
    }

    /**
     * Update system permission.
     *
     * @return JSON
     */
    public function putPermissionsShow()
    {
        $permissionForm = Input::get('data');
        $permissionForm['slug'] = str_slug($permissionForm['slug'], '.');
        $affectedRows = Permission::where('id', '=', intval($permissionForm['id']))->update($permissionForm);

        $authuser = Auth::user();
        //Insert Successfull system persmission update activity record
        $updateSystemPermission = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Updated system permission.',
        ]);
        $updateSystemPermissionResponse = response()->success(compact('updateSystemPermission'));

        return response()->success($permissionForm);
    }

    /**
     * Delete system permission referenced by id.
     *
     * @param int Permission ID
     *
     * @return JSON
     */
    public function deletePermissions($id)
    {
        Permission::destroy($id);

        $authuser = Auth::user();
        //Insert Successfull system persmission delete activity record
        $deleteSystemPermission = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Deleted system permission.',
        ]);
        $deleteSystemPermissionResponse = response()->success(compact('deleteSystemPermission'));

        return response()->success('success');
    }

    /**
     * Create new employer.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegisteremployer(Request $request)
    {   
       $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'company' => 'required',
            'address' => 'required',
            'telephone' => 'required',
            'postal_code' => 'required',
            'city' => 'required',
            'aManager' => 'required',
            'jobtype' => 'required',
            'is_global' => 'required',
            'country_code' => 'required',

        ]);

        $authuser = Auth::user();

        $company = new Company();
        $company->name = trim($request->company);
        $company->telephone = trim($request->telephone);
        $company->address_line_1 = trim($request->address);
        $company->postal_code = trim($request->postal_code);
        $company->city_id = trim($request->city);
        $company->country_code = trim($request->country_code);
		$company->company_email = trim($request->company_email);
		$company->company_website = trim($request->company_website);
		$company->company_size = trim($request->company_size);
		$company->company_type = trim($request->company_type);
		$company->company_annual_revenue = trim($request->company_annual_revenue);
		$company->timeZone = $request->timezone[0]['id'];
		$company->company_description = trim($request->company_description);
		$company->company_tags = trim($request->company_tags);
		$company->company_social_media_links = trim($request->company_social_media_links);
		$company->company_technology_details = trim($request->company_technology_details);
        $company->save();

        $verificationCode = str_random(20);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->job_type = $request->jobtype;
        $user->email_verified=0;
        $user->company_id=$company->id;
        $user->role_id=5;
        $user->is_global=$request->is_global;
        $user->city_id = trim($request->city);
        $user->user_type=$request->user_type;
        $user->save();
        
        // by mukesh
        $country_code = (int) $request->country_code;
        $country = Country::select('id', 'currency')->where('ISD_code', $country_code)->get();
        $contries = json_decode($country);
        
        $countryPrice = DB::table('country_pricing')
                            ->select('id', 'country_slap1','country_slap2','country_slap3', 'country_slap4', 'country_slap5', 'country_slap6')
                            ->where('country_currency', $contries[0]->currency)->take(1)->get();
        $count_id = $countryPrice[0]->id;
        unset($countryPrice[0]->id);
        unset($countryPrice[0]->country_slap1);
        $countryPrice = array_values((array) $countryPrice[0]);
        
        $countryPricePercents = DB::table('country_pricing_percent')
                                ->select('country_slap2','country_slap2','country_slap3','country_slap4','country_slap5','country_slap6')
                                ->where('country_id', $count_id)->get();
        $countryPricePercents = array_values((array) $countryPricePercents[0]);
        for($i=0; $i<count($countryPricePercents); $i++) {
            $prices = explode("-", $countryPrice[$i]);
            $price = new Pricing();
            $price->country_id = $contries[0]->id;
            $price->default_country = $contries[0]->id;
            $price->type_of_emp = 'Permanent';
            $price->starting_range = $prices[0];
            $price->ending_range = $prices[1];
            $price->price = $countryPricePercents[$i];
            $price->price_type = 'percentage';
            $price->emp_id = $user->id;
            $price->save();
        }
        $countryPrice = DB::table('country_pricing')
                            ->select('country_slap1','contract_percent')
                            ->where('country_currency', $contries[0]->currency)->take(1)->get();
                            
        $priceCon = new Pricing();
        $priceCon->country_id = $contries[0]->id;
        $priceCon->type_of_emp = 'Contract To Hire';
        $priceCon->default_country = $contries[0]->id;
        $priceCon->flat_rate = $countryPrice[0]->country_slap1;
        $priceCon->price = $countryPrice[0]->contract_percent;
        $priceCon->price_type = 'percentage';
        $priceCon->emp_id = $user->id;
        $priceCon->save();
    
        
        $cnPricePercents = DB::table('country_pricing_percent')
                                ->select('country_slap1')
                                ->where('country_id', $count_id)->get();
        $priceFlat = new Pricing();
        $priceFlat->country_id = $contries[0]->id;
        $priceFlat->type_of_emp = 'Flat Rate';
        $priceFlat->default_country = $contries[0]->id;
        $priceFlat->flat_rate = $countryPrice[0]->country_slap1;
        $priceFlat->price = $cnPricePercents[0]->country_slap1;
        $priceFlat->price_type = 'percentage';
        $priceFlat->emp_id = $user->id;
        $priceFlat->save();
    
        
        $roles = array(2,5,8);
        foreach ($roles as $setRole) { $user->attachRole($setRole); } 

        $userassociation = new Association();
        $userassociation->admin_id = $authuser->id;
        $userassociation->employer_id = $user->id;
        $userassociation->accountmanager_id = trim($request->aManager);
        $userassociation->status_updated_by = 1;
        $userassociation->save();
        
        $fullName = $user->first_name.$user->last_name;
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' =>$fullName, 'token' => $verificationCode, 'name' => $user->first_name,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('Welcome to Hirextra.com! Just Relax..we do Everything!');
         });
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "Hirextra";
        $msgtxt = "Thanks for Joining Hirextra. Please check your email";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $createNewEmployer = new Activity();
        $createNewEmployer->name = "Created new employer.";
        $createNewEmployer->admin_id = 1;
        $createNewEmployer->company_id = $company->id;
        $createNewEmployer->activity_by = 1;
        $createNewEmployer->save();
        $createNewEmployerResponse = response()->success(compact('createNewEmployer'));
        return response()->success(compact('user'));
    }

    /**
     * Create new vendor.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegistervendor(Request $request)
    {   
        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'company' => 'required',
            'address' => 'required',
            'telephone' => 'required',
            'postal_code' => 'required',
            'vendor_code' => 'required',
            'city' => 'required',
            'payroll' => 'required',
            'aManager' => 'required',
            'country_code' => 'required'
        ]);

        $authuser = Auth::user();
        $company = new Company(); 
        $company->name = trim($request->company);
        $company->telephone = trim($request->telephone);
        $company->address_line_1 = trim($request->address);
        $company->postal_code = trim($request->postal_code);
        $company->city_id = trim($request->city);
        $company->country_code = trim($request->country_code);
        $company->save();

        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->vendor_code = trim($request->vendor_code);
        $user->payroll = $request->payroll;
        $user->email_verified = 0;
        $user->company_id = $company->id;
        $user->vendor_type = $request->vendor_type;
        if($request->vendor_type==3) {
            $user->role_id = 15;
        } else {
            $user->role_id = 6;
        }
        $user->vendor_price_percent = $request->vendor_price_percent;
        $user->city_id = trim($request->city);
        $user->save();
        
        $roles = array(2,6,9);
        foreach ($roles as $setRole) {
            $user->attachRole($setRole);
        }

        foreach ($request->aManager as $key => $value) {
            $userassociation = new Association();
            $userassociation->admin_id = $authuser->id;
            $userassociation->vendor_id = $user->id;
            $userassociation->accountmanager_id = trim($value['id']);
            $userassociation->status_updated_by = 1;
            $userassociation->save();
        }
        $fullName = $user->first_name.$user->last_name;

        $country = Country::where('is_enabled',1)->first();
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' => $fullName, 'token' => $verificationCode, 'name' => $user->first_name,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('Welcome to Hirextra.com! Three cheers to our Partnership!');
         });

        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for Joining Hirextra. Please check your email";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
       
       //Insert Successfull new vendor create activity record
        $createNewVendor = Activity::create([
                'person_id' => $authuser->id,
                'company_id' => $company->id,
                'name' => 'Created new vendor.',
        ]);
        $createNewVendorResponse = response()->success(compact('createNewVendor'));
        return response()->success(compact('user'));
    }
     public function postRegistervendordashboard()
    {
        $duration = [
            'accountmanager_id' => Input::get('aManager')
        ];
           
        $affectedRows = Activity::where('person_id', '=', intval(Input::get('personId')))->update($duration);
        return response()->success("Created success");
    }


    /**
     * Create new account manager.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegisteram(Request $request)
    {
        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'country_code' => 'required'
        ]);

        $authuser = Auth::user();

        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = 10;
        $user->save();

        $userassociation = new Association();
        $userassociation->admin_id = $authuser->id;
        $userassociation->accountmanager_id = $user->id;
        $userassociation->save();

        $roles = array(2,10);
        foreach ($roles as $setRole) {
            $user->attachRole($setRole);
        }

        if($request->employers):
            $employers = $request->employers;
            foreach($employers as $emp):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->employer_id = $emp['id'];
                $userassociation->accountmanager_id = $user->id;
                $userassociation->save();                
            endforeach;
        endif;

        if($request->vendors):
            $vendors = $request->vendors;
            foreach($vendors as $vendor):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->vendor_id = $vendor['id'];
                $userassociation->accountmanager_id = $user->id;
                $userassociation->save();                
            endforeach;
        endif;

       $country = Country::where('is_enabled',1)->first();
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
 Mail::send('emails.reset_link', ['email' => $user->email, 'token' => $verificationCode, 'name' => $user->first_name,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('Make sure you\'ve done it! Create Password for Hirextra.com.');
         });
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for Joining Hirextra. Please check your email";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
       
        //Insert Successfull new account manager create activity record
        $createNewAm = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new account manager.',
        ]);
        $createNewAmResponse = response()->success(compact('createNewAm'));

        return response()->success(compact('user'));
    }

    public function putAccountmanager()
    {
       
        $userForm = Input::get('data');

        $userData = [
                    'first_name' => $userForm['first_name'],
                    'last_name' => $userForm['last_name'],
                    'mobile' => $userForm['mobile'],
                    'email' => $userForm['email'],
                    'country_code' => $userForm['country_code'],
                    ];
         $affectedRows = user::where('id', '=', intval($userForm['id']))->update($userData);
    
        if(isset($userForm['employers'])):
             $employers=$userForm['employers'];
            foreach($employers as $emp):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->employer_id = $emp['id'];
                $userassociation->accountmanager_id = $userForm['id'];
                $userassociation->save();                
            endforeach;
        endif;

        if(isset($userForm['vendors'])):
            $vendors = $userForm['vendors'];
            foreach($vendors as $vendor):
                $userassociation = new Association();
                $userassociation->admin_id = 1;
                $userassociation->vendor_id = $vendor['id'];
                $userassociation->accountmanager_id = $userForm['id'];
                $userassociation->save();                
            endforeach;
        endif;

        //Insert Successfull new account manager create activity record
        $createNewAm = Activity::create([
                'person_id' => $userForm['id'],
                'name' => 'Updated User.',
        ]);
        $createNewAmResponse = response()->success(compact('createNewAm'));

        return response()->success(compact('userForm'));
    }

    /**
     * Create new customer support users.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegistercustomersupportuser(Request $request)
    {

        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'company' => 'required',
            'address' => 'required',
            'telephone' => 'required',
            'postal_code' => 'required',
            'city' => 'required',
            'country_code' => 'required'
        ]);

        $authuser = Auth::user();

        $company = new Company();
        $company->name = trim($request->company);
        $company->telephone = trim($request->telephone);
        $company->address_line_1 = trim($request->address);
        $company->postal_code = trim($request->postal_code);
        $company->city_id = $request->city;
        $company->save();

        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $company->id;
        $user->role_id = 7;
        $user->save();

        $roles = array(2,7);
        foreach ($roles as $setRole) {
            $user->attachRole($setRole);
        }

        $userassociation = new Association();
        $userassociation->admin_id = $authuser->id;
        $userassociation->customersupportuser_id = $user->id;
        $userassociation->save();
        
        $fullName = $user->first_name.$user->last_name;
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' =>  $fullName, 'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        $createNewCustomersupportuser = Activity::create([
                'person_id' => $authuser->id,
                'company_id' => $company->id,
                'name' => 'Created new customer support user.',
        ]);
        
        $createNewCustomersupportuserResponse = response()->success(compact('createNewCustomersupportuser'));

        return response()->success(compact('user'));
    }
    /**
     * Create new employer team member.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegisteremployeruser(Request $request)
    {
        $this->validate($request,[
            'first_name' => 'required|min:3',
            'last_name' => 'required|min:1',
            'email' => 'required|email|unique:users',
            'mobile' => 'required|numeric|unique:users',
            'country_code' => 'required'
             ]);
        $authuser = Auth::user();
        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = 8;
        $user->parent_id = $authuser->id;
        $user->save();
        $roles = array(2,8);
        foreach ($roles as $setRole) {$user->attachRole($setRole);}
        $userassociation = new Association();
        $userassociation->admin_id = 1;
        $userassociation->employer_user_id = $user->id;
        $userassociation->employer_id = $authuser->id;
        $userassociation->save();
        $fullName = $user->first_name.$user->last_name;
        //Insert Successfull new employer team member create activity record
        $createNewEmployerTm = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new employer team member.',
        ]);
        $createNewEmployerTmResponse = response()->success(compact('createNewEmployerTm'));

        Mail::send('emails.reset_link', ['email' => $user->email,  'name' =>  $fullName, 'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('user'));
    }

    public function postRegisterprocessuser(Request $request)
    {
        $this->validate($request, [
            'process_role'     =>  'required',
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'country_code' => 'required',
        ]);

        $authuser = Auth::user();

        $verificationCode = str_random(40);
        $user = new User();
        $user->role_id = trim($request->process_role);
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = $request->process_role;
        $user->parent_id = $authuser->id;
        $user->save();

        $roles = array(2, $request->process_role);
        foreach ($roles as $setRole) {
            $user->attachRole(2, $setRole);
        }

        $userassociation = new Association();
        $userassociation->admin_id = 1;
        $userassociation->process_id = $authuser->id;
        $userassociation->save();
        $fullName = $authuser->first_name.$authuser->last_name;
        //Insert Successfull new employer team member create activity record
        $createNewProcessTm = Activity::create([
                'process_user_id' => $authuser->id,
                'name' => 'Created new Process User team member.',
        ]);
        $createNewProcessTmResponse = response()->success(compact('createNewProcessTm'));
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' => $fullName, 'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        $number = $authuser->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('user'));
    }

    public function postRegisterprocesslead(Request $request)
    {
        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
        ]);

        $authuser = Auth::user();

        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = 11;
        $user->parent_id = $authuser->id;
        $user->save();

        $roles = array(11);
        foreach ($roles as $setRole) {
            $user->attachRole($setRole);
        }

        $userassociation = new Association();
        $userassociation->admin_id = 1;
        $userassociation->employer_user_id = $user->id;
        $userassociation->employer_id = $authuser->id;
        $userassociation->save();

       
         $fullName = $user->first_name.$user->last_name;
        
        //Insert Successfull new employer team member create activity record
        $createNewEmployerTm = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new Process Lead team member.',
        ]);
        $createNewEmployerTmResponse = response()->success(compact('createNewEmployerTm'));
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' =>$fullName, 'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('user'));
    }

    public function postRegisterprocessexecutive(Request $request)
    {
        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
        ]);

        $authuser = Auth::user();

        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = 12;
        $user->parent_id = $authuser->id;
        $user->save();

        $roles = array(12);
        foreach ($roles as $setRole) {
            $user->attachRole($setRole);
        }

        $userassociation = new Association();
        $userassociation->admin_id = 1;
        $userassociation->employer_user_id = $user->id;
        $userassociation->employer_id = $authuser->id;
        $userassociation->save();

       
         $fullName = $user->first_name.$user->last_name;
        
        //Insert Successfull new employer team member create activity record
        $createNewEmployerTm = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new Process Executive team member.',
        ]);
        $createNewProcessTmResponse = response()->success(compact('createNewEmployerTm'));
        Mail::send('emails.reset_link', ['email' => $user->email, 'name' =>$fullName, 'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success(compact('user'));
    }

    /**
     * Create new vendor team member.
     *
     * @param Instance Request instance
     *
     * @return JSON user details and auth credentials
     */
    public function postRegistervendoruser(Request $request)
    {
        $this->validate($request, [
            'first_name'       => 'required|min:3',
            'last_name'       => 'required|min:1',
            'email'      => 'required|email|unique:users',
            'mobile'      => 'required|numeric|unique:users',
            'country_code'      => 'required',
        ]);
        $authuser = Auth::user();
        $verificationCode = str_random(40);
        $user = new User();
        $user->first_name = trim($request->first_name);
        $user->last_name = trim($request->last_name);
        $user->mobile = trim($request->mobile);
        $user->country_code = trim($request->country_code);
        $user->email = trim(strtolower($request->email));
        $user->password = bcrypt('password');
        $user->email_verification_code = $verificationCode;
        $user->email_verified = 0;
        $user->company_id = $authuser->company_id;
        $user->role_id = 9;
        $user->parent_id = $authuser->id;
        $user->save();
        
        $settings = new VendorUserSetting();
        $settings->vendor_user_id=$user->id;
        $settings->direct_submission_to_am=trim($request->direct_submission_to_am);
        $settings->upload_cv_to_private_area=trim($request->upload_cv_to_private_area);
        $settings->search_in_free_cvs=trim($request->search_in_free_cvs);
        $settings->activate_vsa=trim($request->activate_vsa);
        $settings->candidate_area_access=trim($request->candidate_area_access);
        $settings->min_jobs=trim($request->min_jobs);
        $settings->max_jobs=trim($request->max_jobs);
        $settings->auto_assign_job=trim($request->auto_assign_job);
        $settings->auto_mode_keywords=trim($request->auto_mode_keywords);
        $settings->priority=trim($request->priority);
        $settings->save();

        $roles = array(2,6,9);
        foreach ($roles as $setRole) { $user->attachRole($setRole); }
        $userassociation = new Association();
        $userassociation->admin_id = 1;
        $userassociation->vendor_user_id = $user->id;
        $userassociation->vendor_id = $authuser->id;
        $userassociation->save();
        $fullName = $user->first_name.$user->last_name;
        //Insert Successfull new vendor team member create activity record
        $createNewVendorTm = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new vendor team member.',
        ]);
        $createNewVendorTmResponse = response()->success(compact('createNewVendorTm'));
            Mail::send('emails.reset_link', ['email' => $user->email, 'name' =>$fullName,'token' => $verificationCode,'text' => 'You are invited to HireXtra.com.'], function ($m) use($user) {
             $m->to($user->email, 'You are invited to HireXtra.com.')->subject('You are invited to HireXtra.com.');
         });
        $city = City::where('id',$authuser->city_id)->get();
        if(count($city) > 0) {
            $country = Country::where('id',$city[0]->country_id)->get();
            $countryCode = $country[0]->ISD_code;   
        } else {          
            $countryCode = 91;        
        }
        $number = $user->mobile;
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number; 
        $originator = "HRXTRA";
        $msgtxt = "Thanks for choosing Hirextra. Please check your email.";
        curl_setopt($ch,CURLOPT_URL,  "http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
       //Insert Successfull new vendor create activity record
        $createNewVendor = Activity::create([
                'person_id' => $authuser->id,
                'name' => 'Created new vendor team.',
        ]);
        $createNewVendorResponse = response()->success(compact('createNewVendor'));
        return response()->success(compact('user'));
    }
 
    /**
     * Get all employers.
     *
     * @return JSON
     */
    public function getEmployers()
    {
        $employers = User::where('role_id', 5)->whereNull("parent_id")->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('employers'));
    }

    public function getUserroles()
    {
        $userroles = User::whereIn('role_id', array(5,6))->whereNull("parent_id")->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('userroles'));
    }

    public function getSurveycount()
    {
        $surveycount = User::where('processSurveyApprove', 1)->get();
        return response()->success(compact('surveycount'));
    }

    public function getProcessusers()
    {
        $processusers = User::whereIn('role_id', array(11,12))->orderBy('first_name', 'asc')->with('company')->get();
        
        return response()->success(compact('processusers'));
    }

    /**
     * Get all employers.
     *
     * @return JSON
     */
    public function getEmployersforam()
    {
        $useremployers = Association::whereNotNull('accountmanager_id')
                                    ->whereNull('job_id')
                                    ->whereNull('vendor_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')->with('employer')
                                    ->get();
       $employer_ids = array();
        foreach ($useremployers as $employers) {
            $employer_ids[] = $employers->employer_id;
        }
        $employersforam = User::where('role_id', 5)->whereNotIn('id',$employer_ids)->whereNull("parent_id")->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('employersforam'));
    }

    public function getCountry()
    {
        $country = Country::where('is_enabled',1)->get();
        return response()->success(compact('country'));
    }    
    /**
     * Get all vendors.
     *
     * @return JSON
     */
    public function getVendors()
    {
        $vendors = User::where('role_id', 6)->whereNull('parent_id')->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('vendors'));
    }
     
      public function getSubscribedatas()
    {
        $subscribedatas = DB::table('subscription')->whereNotNull('id')->orderBy('id', 'asc')->get();
        return response()->success(compact('subscribedatas'));
    }
    /**
     * Get all vendors.
     *
     * @return JSON
     */
    public function getVendorsforam()
    {
        $vendorsforam = User::where('role_id', 6)
                            ->whereNull('parent_id')
                            ->orderBy('first_name', 'asc')
                            ->with('company')
                            ->get();
        return response()->success(compact('vendorsforam'));
    }

    /**
     * Get all account managers.
     *
     * @return JSON
     */
    public function getAccountmanagers()
    {
        $accountmanagers = User::where('role_id', 10)->orderBy('first_name', 'asc')->with('company')->get();

          $amjobids = array();

        foreach($accountmanagers as $am) {
            
            $amjobids=Association::where('accountmanager_id', $am->id)
                                ->whereNotNull('job_id')
                                ->whereNotNull('employer_id')
                                ->groupBy('job_id')
                                ->lists('job_id');
            $submittedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();
                                
            $rejectedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[2,1])
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $selectedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[27,28])
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count(); 
            $shorlistedProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',array(5,17,18,20,22,23,24,25,26))
                                ->whereNotNull('employer_id')
                                ->whereNotNull('vendor_id')
                                ->count(); 
            $totalProfiles=Association::whereIn('job_id',$amjobids)
                                ->where('accountmanager_id',$am->id)
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->whereNotNull('employer_id')
                                ->groupby('job_id','candidate_id')
                                ->count();
            $jobsrejectedbyam = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',2)
                                ->count();                                  
            $inactivejobs = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',7)
                                ->count();
            $jobsaccepted = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',3)
                                ->count();
            $jobspending = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',4)
                                ->count();
            $jobsclosed = JobOrders::whereIn('id',$amjobids)
                                ->where('status',6)->where('is_talentpool',0)
                                ->count();                                 
            $jobsheld = JobOrders::whereIn('id',$amjobids)
                                ->whereNotNull('user_id')->where('is_talentpool',0)
                                ->where('status',24)
                                ->count();
            $empuserNumber=array('totalJobs' => count($amjobids), 'closedJobs' => $jobsclosed,  'rejectedJobs' => $jobsrejectedbyam, 'inactiveJobs' => $inactivejobs ,'jobsaccepted' =>$jobsaccepted , 'jobspending' => $jobspending, 'heldjobs' => $jobsheld , 'submittedProfiles' => $submittedProfiles, 'rejectedProfiles' => $rejectedProfiles ,'selectedProfiles' => $selectedProfiles ,'shorlistedProfiles' => $shorlistedProfiles);
            $am['empuserNumber'] = $empuserNumber;
        }

        return response()->success(compact('accountmanagers'));
    }

    /**
     * Get all employers.
     *
     * @return JSON
     */
    public function getCustomersupportusers()
    {
        $customersupportusers = User::where('role_id', 7)->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('customersupportusers'));
    }

    /**
     * Get all employer users.
     *
     * @return JSON
     */
    public function getEmployerusers()
    {
        $authuser = Auth::user();
        $employerusers=User::where('role_id', 8)->where('parent_id',$authuser->id)->orderBy('first_name', 'asc')->with('company')->get();
        foreach($employerusers as $emp){
            $empjobids=EmployerUserJobs::where('employer_id', $emp->parent_id)
                                ->where('employer_user_id', $emp->id)
                                ->lists('job_id');
            $submittedProfiles=Association::whereIn('job_id',$empjobids)
                                ->where('employer_id',$emp->parent_id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('candidate_status')
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $rejectedProfiles=Association::whereIn('job_id',$empjobids)
                                ->where('employer_id',$emp->parent_id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[2,1])
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->count();
            $selectedProfiles=Association::whereIn('job_id',$empjobids)
                                ->where('employer_id',$emp->parent_id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',[27,28])
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->count(); 
            $shorlistedProfiles=Association::whereIn('job_id',$empjobids)
                                ->where('employer_id',$emp->parent_id)
                                ->whereNotNull('candidate_id')
                                ->whereIn('candidate_status',array(5,17,18,20,22,23,24,25,26))
                                ->whereNotNull('accountmanager_id')
                                ->whereNotNull('vendor_id')
                                ->count(); 
            $totalProfiles=Association::whereIn('job_id',$empjobids)
                                ->where('employer_id',$emp->parent_id)
                                ->whereNull('employer_user_id')
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->groupby('job_id','candidate_id')
                                ->count();
            $jobsrejectedbyam = JobOrders::whereIn('id',$empjobids)
                                ->where('user_id',$emp->parent_id)->where('is_talentpool',0)
                                ->where('status',2)
                                ->count();                                   
            $inactivejobs = JobOrders::whereIn('id',$empjobids)
                                ->where('user_id',$emp->parent_id)->where('is_talentpool',0)
                                ->where('status',7)
                                ->count();
            $jobsaccepted = JobOrders::whereIn('id',$empjobids)
                                ->where('user_id',$emp->parent_id)->where('is_talentpool',0)
                                ->where('status',3)
                                ->count();
            $jobspending = JobOrders::whereIn('id',$empjobids)->where('is_talentpool',0)
                                ->where('user_id',$emp->parent_id)
                                ->where('status',4)
                                ->count();
            $jobsclosed = JobOrders::whereIn('id',$empjobids)->where('is_talentpool',0)
                                ->where('user_id',$emp->parent_id)
                                ->where('status',6)
                                ->count();                                 
            $jobsheld = JobOrders::whereIn('id',$empjobids)->where('is_talentpool',0)
                                ->where('user_id',$emp->parent_id)
                                ->where('status',24)
                                ->count();
            $empuserNumber=array('totalJobs' => count($empjobids), 'closedJobs' => $jobsclosed,  'rejectedJobs' => $jobsrejectedbyam, 'inactiveJobs' => $inactivejobs ,'jobsaccepted' =>$jobsaccepted , 'jobspending' => $jobspending, 'heldjobs' => $jobsheld , 'submittedProfiles' => $submittedProfiles, 'rejectedProfiles' => $rejectedProfiles ,'selectedProfiles' => $selectedProfiles ,'shorlistedProfiles' => $shorlistedProfiles);
            $emp['empuserNumber'] = $empuserNumber;
        }
        return response()->success(compact('employerusers'));
    }

    /**
     * Get all vendor users.
     *
     * @return JSON
     */

    /**
     * Get all custom support users.
     *
     * @return JSON
     */
    public function getVendorusers()
    {
        $authuser = Auth::user();

        if($authuser->parent_id){
            $vendorusers = User::where('parent_id', $authuser->parent_id)->where('role_id', 9)->orderBy('first_name', 'asc') ->with('company')->get();
            
        } else {
            $vendorusers = User::where('parent_id', $authuser->id)->where('role_id', 9)->orderBy('first_name', 'asc') ->with('company')->get(); 
        }
        return response()->success(compact('vendorusers'));
    }


    public function getVendorusersprivatearea() {
        $authuser = Auth::user();

        $empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
        $empTimezone = Country::select('id', 'timezone', 'GMT_offset', 'timezone_1')->where('id',$empCompanyID[0]->timezone)->get();

            $vendorusersprivatearea = User::select('*')
                                            ->whereRaw('(parent_id = '. $authuser->id.' OR id = '. $authuser->id.')')
                                            ->whereIn('role_id', array(6,9)) 
                                            ->orderBy('first_name', 'asc') 
                                            ->get();
                    foreach ($vendorusersprivatearea as $key ) {
                        $key['candidateData'] = candidate::select('full_name','updated_at','vendor_id','vendor_user_id','updated_at')->where('vendor_id',$key['id'])->orderBy('updated_at','desc')->groupBy('email')
                                        ->first();
                    }
            foreach($vendorusersprivatearea as $vupaKey => $vupaValue) {
                $vupaValue['vendorfileuploadcount'] = Candidate::select('id')
                                                    ->where('vendor_user_id', $vupaValue['id'])
                                                    ->where('is_privatearea', 0)->DISTINCT()
                                                    ->count('email');
            }
         
            foreach($vendorusersprivatearea as $vupaKey => $vupaValue) {
                $vendorCandidatesData = null;
                $vendorCandidatesCount = Candidate::select('id')
                                                ->whereRaw('(vendor_id = '. $vupaValue['id'] .' AND vendor_user_id = 0)') 
                                                ->where('is_privatearea', 0)->DISTINCT() 
                                                ->count('email');

                if($vendorCandidatesCount == 0) {
                    $vendorCandidatesCount = Candidate::select('id')
                                                ->whereRaw('(vendor_user_id = '. $vupaValue['id'] .' AND vendor_user_id != 0)') 
                                                ->where('is_privatearea', 0)->DISTINCT() 
                                                ->count('email');
                }

                $vupaValue['vendorfileuploadcount'] = $vendorCandidatesCount;   
                 $vupaValue['timezone'] = $empTimezone[0]['GMT_offset'];            
            }
                $vupaValue['timezone'] = $empTimezone[0]['GMT_offset'];

        return response()->success(compact('vendorusersprivatearea'));
    }

    public function getVendorusersprivateareadata($id) {
        $authuser = Auth::user();
        if ($authuser->parent_id) {
                $vendorusersprivateareadata = Candidate::where('vendor_user_id', $id)
                                                    ->where('is_privatearea', 0)
                                                    ->with('skill')
                                                    ->with('vendor')
                                                    ->with('vendoruser')
                                                    //->with('SkillblockResume')
                                                    ->get();
                foreach ($vendorusersprivateareadata as $job) {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['encrypted_canId'=>$encrypted_canId];
                    $job['numbers'] = $numbers;
                }
        } else {
                $vendorCandidatesData = null;
                $vendorCandidatesCount = Candidate::select('id')
                                                ->whereRaw('(vendor_id = '. $id .' AND vendor_user_id = 0)') 
                                                ->where('is_privatearea', 0) 
                                                ->where('is_alive', 1) 
                                                ->count();
				
                if($vendorCandidatesCount > 0) {
                    $vendorusersprivateareadata = Candidate::whereRaw('(vendor_id = '. $id .' AND vendor_user_id = 0)')
                                                ->where('is_privatearea', 0)
												->where('is_alive', 1) 
												->groupBy('email')
                                                ->with('skill', 'vendor', 'vendoruser')
                                                //->with('SkillblockResume')
                                                ->get();
                } else if($vendorCandidatesCount == 0) {
                    $vendorusersprivateareadata = Candidate::whereRaw('(vendor_user_id = '. $id .' AND vendor_user_id != 0)')
                                                    ->where('is_privatearea', 0)
                                                    ->where('is_alive', 1)
													->groupBy('email')
                                                    ->with('skill', 'vendor', 'vendoruser')
                                                    //->with('SkillblockResume')
                                                    ->get();
					
                }
				
				$empCompanyID = Company::select('timezone')->where('id',$authuser->company_id)->get();
                $empTimezone = Country::select('id', 'timezone', 'GMT_offset')->where('id',$empCompanyID[0]->timezone)->get();

//echo '<pre>'; print_r($vendorusersprivateareadata); echo '</pre>';

                foreach ($vendorusersprivateareadata as $job) {
					$parsing_date =date('d-m-Y h:i:s', strtotime($job->parsing_date));
					$actual_date = new DateTime($parsing_date);
					$currectDate = new DateTime(date('d-m-Y h:i:s'));
					$dateDiff = $currectDate->diff($actual_date);
					$diffDays = $dateDiff->format('%d');
					$job['date_diffence'] =  $diffDays;
					$job['updated_at'] =  $job->updated_at;
                    $date = new \DateTime($job['updated_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');

                    $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                    $job['updated_at'] = $date->format('Y-m-d H:i:s');


                    $date = new \DateTime($job['created_at'], new \DateTimeZone('UTC'));
                    $date->format('Y-m-d H:i:s');

                    $date->setTimezone(new \DateTimeZone($empTimezone[0]['timezone'])); 
                    $job['created_at'] = $date->format('Y-m-d H:i:s');

                    $job['created_at'] = $job['created_at'];

                    $job['timezone'] = $empTimezone[0]['GMT_offset'];

                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
                    $numbers = ['encrypted_canId'=>$encrypted_canId];
                    $job['numbers'] = $numbers;
                    $job['skils_block'] = SkillblockResume::where('candidate_id',$job->id )->whereNotIn('found_id', [3,2])->get();
                }
        }
        return response()->success(compact('vendorusersprivateareadata'));
    }


         public function postVupafilterbyskilllocation(Request $request)
        {
            $authuser = Auth::user();
            $skillFilterTags = Input::get('requiredTags');
            $locationFilter = Input::get('location');
            $locationFilter1 = preg_split("#/#",$locationFilter);
            if((count($skillFilterTags) > 0) && (count($skillFilterTags) > 0))
            {
            Schema::create('temp_skills_filter', function(Blueprint $table){
            $table->increments('id');
            $table->string('temp_skill_filter_name');
            $table->timestamps();
            $table->temporary();
            });
            Schema::create('temp_location_filter', function(Blueprint $table){
            $table->increments('id');
            $table->string('temp_location_filter_name');
            $table->timestamps();
            $table->temporary();
            });
            foreach($skillFilterTags as $skFTKey =>$skFTValue)
            { 
            DB::table('temp_skills_filter')->insert(
            ['temp_skill_filter_name' => $skFTValue['text']]
            );
            }
            DB::table('temp_location_filter')->insert(['temp_location_filter_name' => $locationFilter1[0]]);
            $skillfilterdata = DB::table('temp_skills_filter')->select('temp_skill_filter_name')->lists('temp_skill_filter_name');
            $locationfilterdata = DB::table('temp_location_filter')->select('temp_location_filter_name')->lists('temp_location_filter_name');

            if((count($skillfilterdata) > 0 && count($skillfilterdata) > 0))
            {

            $vupawskf = User::select('id', 'first_name', 'role_id')->whereRaw('(parent_id = '. $authuser->id.' OR id = '. $authuser->id.')')->whereIn('role_id', array(6,9))->orderBy('first_name', 'asc') ->with('company')->get();

            foreach($vupawskf as $vupawskfKey => $vupawskfValue) {

            $vendorCandidatesData = null;
            $vendorCandidatesCount = Candidate::select('id')
            ->whereRaw('(vendor_id = '. $vupawskfValue['id'] .' AND vendor_user_id = 0)') 
            ->where('is_privatearea', 0) 
            ->count();

            if($vendorCandidatesCount > 0) {
            $vupaUploadCountWSKLD = Candidate::whereRaw('(vendor_id = '.$vupawskfValue['id'].' AND vendor_user_id = 0)')
            ->where('is_privatearea', 0)
            ->with('skill', 'vendor', 'vendoruser')
            ->whereHas('skill', function($bk) use($skillfilterdata)
            {
            foreach($skillfilterdata as $skillname)
            $bk->orWhere('skill_set', 'LIKE', '%' .$skillname.'%');
            })
            ->where('current_location', 'REGEXP', '^'.$locationfilterdata[0].'')
            ->get();
            } else if($vendorCandidatesCount == 0) {
            $vupaUploadCountWSKLD = Candidate::whereRaw('(vendor_user_id = '.$vupawskfValue['id'].' AND vendor_user_id != 0)')
            ->where('is_privatearea', 0)
            ->with('skill', 'vendor', 'vendoruser')
            ->whereHas('skill', function($bk) use($skillfilterdata)
            {
            foreach($skillfilterdata as $skillname)
            $bk->orWhere('skill_set', 'LIKE', '%' .$skillname.'%');
            })
            ->where('current_location', 'REGEXP', '^'.$locationfilterdata[0].'')
            ->get();
            }

            $vupacount = $vupaUploadCountWSKLD->count();

            $vupawskfValue['vendorfileuploadcount'] = $vupacount;
            $vupawskfValue['vendorfileuploaddata'] = $vupaUploadCountWSKLD;
            //$filterData = $vupawskfValue['vendorfileuploaddata'];
            foreach ($vupawskfValue['vendorfileuploaddata'] as $job) {
            $timestamp = 129346161081;
            $randomKey = '-';
            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
            $numbers = ['encrypted_canId'=>$encrypted_canId];
            $job['numbers'] = $numbers;

            }
            }

            return response()->success(compact('vupawskf'));

            }
            Schema::drop('temp_skills_filter');
            Schema::drop('temp_location_filter'); 

            } 
    }


    public function postVupafilterbyskillwoutlocation(Request $request)
    {
        $authuser = Auth::user();
        $skillFilterTags = Input::get('requiredTags');
        $locationFilter = Input::get('location');
        /*
        ** splitted location(city/state/country) to get 
        ** only "city/current location" name for our operation*/
        $locationFilter1 = preg_split("#/#",$locationFilter);
        if((count($skillFilterTags) > 0) && (count($skillFilterTags) < 11) && (count($locationFilter) > 0))
        {
            //create schema [only temporary table based on session]
            //temp table for Skills Filter
            Schema::create('temp_skills_filter', function(Blueprint $table){
                    $table->increments('id');
                    $table->string('temp_skill_filter_name');
                    $table->timestamps();
                    $table->temporary();
                });
            //temp table for Location Filter
            Schema::create('temp_location_filter', function(Blueprint $table){
                $table->increments('id');
                $table->string('temp_location_filter_name');
                $table->timestamps();
                $table->temporary();
            });
            //iterate the extracted skills and store in temp table
            foreach($skillFilterTags as $skFTKey =>$skFTValue)
            {   
                //store the extracted skills into temp table
                DB::table('temp_skills_filter')->insert(
                   ['temp_skill_filter_name' => $skFTValue['text']]
                    );
            }
            //store the location into temp table
            DB::table('temp_location_filter')->insert(['temp_location_filter_name' => $locationFilter1[0]]);
            $skillfilterdata = DB::table('temp_skills_filter')->select('temp_skill_filter_name')->lists('temp_skill_filter_name');
            $locationfilterdata = DB::table('temp_location_filter')->select('temp_location_filter_name')->lists('temp_location_filter_name');
            //checking count of temp skill filter & location filter names
            if((count($skillfilterdata) > 0) && (count($skillfilterdata) < 11) && (count($locationfilterdata) > 0))
            {  //if true, enters into this block
                if($authuser->parent_id)
                {
                    $vupawskfa = User::where('parent_id', $authuser->parent_id)->where('role_id', 9)->orderBy('first_name', 'asc') ->with('company')->get();
                    foreach($vupawskfa as $vupawskfaKey => $vupawskfaValue)
                    {
                        $vupaUploadCountWSKLD = Candidate::with('skill')
                            ->where('is_privatearea',0)
                            ->where('vendor_user_id',$vupawskfaValue['id'])
                            ->select('*')
                            ->whereHas('skill', function($bk) use($skillfilterdata,$locationfilterdata)
                            {
                                $bk->where('skill_set', 'LIKE', '%' .$skillfilterdata[0].'%');
                                //$bk->orWhere('current_location', 'REGEXP', '^'.$locationfilterdata[0].'');
                            })
                            ->whereNull('current_location', 'REGEXP', '^'.$locationfilterdata[0].'')
                            ->with('vendor')
                            ->with('vendoruser')
                            ->get();
                        $vupacount = $vupaUploadCountWSKLD->count();
                        $vupawskfaValue['vendorfileuploadcount'] = $vupacount;    
                        $vupawskfaValue['vendorfileuploaddata'] = $vupaUploadCountWSKLD;
                        //$filterData = $vupawskfValue['vendorfileuploaddata'];
                        foreach ($vupawskfaValue['vendorfileuploaddata'] as $job) {
                            $timestamp = 129346161081;
                            $randomKey = '-';
                            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
                            $numbers = ['encrypted_canId'=>$encrypted_canId];
                            $job['numbers'] = $numbers;
                        }
                    }
                }
                else
                {
                    $vupawskfa = User::where('parent_id', $authuser->id)->where('role_id', 9)->orderBy('first_name', 'asc') ->with('company')->get();
                    foreach($vupawskfa as $vupawskfaKey => $vupawskfaValue)
                    {
                        $vupaUploadCountWSKLD = Candidate::with('skill')
                            ->where('is_privatearea',0)
                            ->where('vendor_user_id',$vupawskfaValue['id'])
                            ->select('*')
                            ->whereHas('skill', function($bk) use($skillfilterdata,$locationfilterdata)
                            {
                                $bk->where('skill_set', 'LIKE', '%' .$skillfilterdata[0].'%');
                                //$bk->orWhere('current_location', 'REGEXP', '^'.$locationfilterdata[0].'');
                            })
                            ->whereNull('current_location', 'REGEXP', '^'.$locationfilterdata[0].'')
                            ->get();
                        $vupacount = $vupaUploadCountWSKLD->count();
                        $vupawskfaValue['vendorfileuploadcount'] = $vupacount;    
                        $vupawskfaValue['vendorfileuploaddata'] = $vupaUploadCountWSKLD;
                        //$filterData = $vupawskfValue['vendorfileuploaddata'];
                        foreach ($vupawskfaValue['vendorfileuploaddata'] as $job) {
                            $timestamp = 129346161081;
                            $randomKey = '-';
                            $encrypted_canId = base64_encode($timestamp . $randomKey . $job['id']);
                            $numbers = ['encrypted_canId'=>$encrypted_canId];
                            $job['numbers'] = $numbers;
                        }
                        //print_r($vupaUploadCountWSKLD);
                        //return response()->success(compact('vupaUploadCountWSKLD'));
                        //$mydata = $vupawskfaValue['vendorfileuploaddata'];
                        
                    } 
                }
                
                return response()->success(compact('vupawskfa')); 
            }
            Schema::drop('temp_skills_filter');
            Schema::drop('temp_location_filter');    

        }    
    }

    /**
     * Get all custom support users.
     *
     * @return JSON
     */
    public function getCustomersupport()
    {
        $customersupport = User::where('role_id', 7)->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('customersupport'));
    }

    /**
     * Get am vendors.
     *
     * @return JSON
     */
    public function getAmassignedvendors($jobId)
    {
        $authuser = Auth::user();
        $AssignedClients=Association::where('accountmanager_id', $authuser->id)
                                ->where('job_id', $jobId)
                                ->whereNotNull('vendor_id')
                                ->whereNull('vendor_user_id')
                                ->groupBy('vendor_id')
                                ->get();
        $vendorids = array();
        foreach($AssignedClients as $client){array_push($vendorids, $client->vendor_id);}
             $v_users=User::where('role_id',9)
                                ->get();
        $vendoruids = array();
        foreach($v_users as $vusers){array_push($vendoruids, $vusers->id);}
      
        $amassignedvendors=Association::where('accountmanager_id', $authuser->id)
                                ->whereNotIn('vendor_id', $vendorids)
                                ->whereNotIn('vendor_id', $vendoruids)
                                ->whereNull('vendor_user_id')
                                ->groupBy('vendor_id')
                                ->whereNotNull('vendor_id')
                                ->with('vendor')
                                ->get();
        return response()->success(compact('amassignedvendors'));
    }

    public function getEmployeralljobs($id)
    {
        $authuser = Auth::user();
        $date_data =new DateTime();
        $count_value = "P".$id."D";
        $date_data->sub(new DateInterval($count_value));
        $diff_date = $date_data->format('Y-m-d');
        
            $employeralljobs = JobOrders::where('user_id',$id)->where('is_talentpool',0)->with('employer')->with('employer.company')->with('job.JobType','job.status') ->whereHas('job',function($query){
                                        $query->where('status','<>',7);
                                    })->with('JobType')->with('Industry')->get();

            foreach ($employeralljobs as $job) {
                $amIdData = Association::where('job_id',$job['id'])
                                ->whereNotNull('accountmanager_id')
                                ->whereNull('candidate_id')
                                ->whereNull('vendor_id')
                                ->get(['accountmanager_id']);

                if(count($amIdData) >=1)
                {
                    $amId = Association::where('job_id',$job['id'])
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNull('candidate_id')
                                        ->whereNull('vendor_id')
                                        ->first()->accountmanager_id;
                
                    $candidates = Association::where('job_id',$job['id'])
                                        ->where('candidate_status', '<>', 19)
                                        ->whereNotNull('accountmanager_id')
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereNull('vendor_user_id')
                                        ->with(array('Status','Candidate'))
                                        ->get();

                    $associationsIds = array();
                    foreach($candidates as $candidate) {

                        //echo $candidate->candidate_status .'=='. $candidate->status_updated_by .'=='. $amId . '====';

                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        } 
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }


                    $activityes = Activity::where('activity_by',$amId)->where('job_id',$job['id'])->whereIn('candidate_status',array(1,2))->get();
                    $activityData = array();
                    foreach($activityes as $activityesdata) {
                        array_push($activityData, $activityesdata->candidate_id);    
                    }
                    $assingedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->with(array('Status','Candidate'))
                                                    ->count();
                    $rejectedids = Association::where('job_id',$job['id'])
                                    ->whereIn('candidate_status',array(1, 2, 30))
                                    ->where('employer_id',$id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->with(array('Status','Candidate'))
                                    ->get();

                    $associationsIds = array();
                    foreach($rejectedids as $candidate) {
                        if ( !($candidate->candidate_status == 2 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                        else if ( !($candidate->candidate_status == 1 && $candidate->status_updated_by == $amId) ) {
                            array_push($associationsIds, $candidate->id);    
                        }
                    }
                    $rejectedcandidates = Association::whereIn('id',$associationsIds)
                                                    ->whereNotIn('candidate_id',$activityData)
                                                    ->count();

                    $shortlistedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',array(5, 17, 18, 20, 22, 23, 24, 25, 26))
                                    ->where('employer_id',$id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $selectedcandidates = Association::where('job_id',$job['id'])->whereNotIn('candidate_id',$activityData)
                                    ->whereIn('candidate_status',[27, 28])
                                    ->where('employer_id',$id)
                                    ->whereNotNull('accountmanager_id')
                                    ->whereNotNull('candidate_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->count();
                    $offeredProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(27,28))
                                        ->count();
                    $interviwedProfiles=Association::where('job_id',$job['id'])
                                        ->where('employer_id',$id)
                                        ->whereNotNull('candidate_id')
                                        ->whereNotNull('vendor_id')
                                        ->whereIn('candidate_status',array(17,18,19,20,21,22,23,27,28,30))
                                        ->count();
                                   
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);

                    $numbers['encrypted_jobId'] = $encrypted;
                    $numbers['profilesReceived'] = $assingedcandidates;
                    $numbers['rejectedProfiles'] = $rejectedcandidates;
                    $numbers['shortlistedProfiles'] = $shortlistedcandidates;
                    $numbers['offeredProfiles'] = $offeredProfiles;
                    $numbers['holdProfiles'] = 0;
                    $numbers['interviwedProfiles'] = $interviwedProfiles;

                    $job['numbers'] = $numbers;
                }
                else
                {
                    $timestamp = 129346161081;
                    $randomKey = '-';
                    $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                    
                    $numbers['profilesReceived'] = 0;
                    $numbers['rejectedProfiles'] = 0;
                    $numbers['shortlistedProfiles'] = 0;
                    $numbers['offeredProfiles'] = 0;
                    $numbers['holdProfiles'] = 0;
                    $numbers['interviwedProfiles'] = 0;

                    $job['numbers'] = $numbers; 
                }
            } // foreach
       
        return response()->success(compact('employeralljobs'));
    }

    /**
     * Get all employers assigned to account manager.
     *
     * @return JSON
     */
    /*public function getEmployeralljobs_old($id)
    {
        $authuser = Auth::user();
        $employeralljobs = JobOrders::select('id')->where('user_id',$id)->where('is_talentpool',0)->with('employer')->with('employer.company')->with('job.JobType','job.status')->get();

        if (count($employeralljobs)>0) {
            foreach ($employeralljobs as $job){
                if($job->job->gdprmandatory){
                    $gdprJobId[] = $job->id;
                    $gdprAssoStatsRaw =  Association::whereIn('id',$gdprJobId)
                                ->where('accountmanager_id',$authuser->id)->where('gdpr_status',1)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->select('id',
                                    DB::raw('count(id) AS profilesReceived'),
                                    DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                                )
                                ->groupBy('id')
                                ->get();
//echo '<pre>'; print_r($gdprAssoStatsRaw); echo '</pre>';

                    foreach ($gdprAssoStatsRaw as $stats){   
                        $gdprAssoStats[$stats->id]=array(
                            "profilesReceived" => $stats->profilesReceived,
                            "rejectedProfiles" => $stats->rejectedProfiles,
                            "shortlistedProfiles" => $stats->shortlistedProfiles,
                            "offeredProfiles" => $stats->offeredProfiles,
                            "holdProfiles" => $stats->holdProfiles,
                            "interviwedProfiles" => $stats->interviwedProfiles
                        );   
                    }


                }else{
                    $nongdprJobId[] = $job->id;   
                     $nongdprAssoStatsRaw =  Association::whereIn('id',$nongdprJobId)
                                ->where('accountmanager_id',$authuser->id)
                                ->whereNotNull('candidate_id')
                                ->whereNotNull('vendor_id')
                                ->select('id',
                                    DB::raw('count(id) AS profilesReceived'),
                                    DB::raw('sum(CASE WHEN candidate_status in(1,2,30) THEN  1 ELSE 0 END) AS rejectedProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,24,25,26,27,28,31) THEN  1 ELSE 0 END) AS shortlistedProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(27,28) THEN  1 ELSE 0 END) AS offeredProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(24,26) THEN  1 ELSE 0 END) AS holdProfiles'),
                                    DB::raw('sum(CASE WHEN candidate_status in(17,18,19,20,21,22,23,27,28,30) THEN  1 ELSE 0 END) AS interviwedProfiles')
                                )
                                ->groupBy('id')
                                ->get();        
            foreach ($nongdprAssoStatsRaw as $stats){   
                $nongdprAssoStats[$stats->id]=array(
                    "profilesReceived" => $stats->profilesReceived,
                    "rejectedProfiles" => $stats->rejectedProfiles,
                    "shortlistedProfiles" => $stats->shortlistedProfiles,
                    "offeredProfiles" => $stats->offeredProfiles,
                    "holdProfiles" => $stats->holdProfiles,
                    "interviwedProfiles" => $stats->interviwedProfiles
                );                     
            }             
                }
            }
            foreach ($employeralljobs as $job){
                //echo 'foreach';
                $timestamp = 129346161081;
                $randomKey = '-';
                $encrypted = base64_encode($timestamp . $randomKey . $job['id']);
                $numbers['encrypted_jobId'] = $encrypted;
                $numbers['profilesReceived'] = 0;
                $numbers['rejectedProfiles'] = 0;
                $numbers['shortlistedProfiles'] = 0;
                $numbers['offeredProfiles'] = 0;
                $numbers['holdProfiles'] = 0;
                $numbers['interviwedProfiles'] = 0;

                if($job->job->gdprmandatory){
                    //echo 'IF';
                    if(!empty($gdprAssoStats[$job['id']])){
                        $numbers['profilesReceived'] = $gdprAssoStats[$job['id']]['profilesReceived'];
                        $numbers['rejectedProfiles'] = $gdprAssoStats[$job['id']]['rejectedProfiles'];
                        $numbers['shortlistedProfiles'] = $gdprAssoStats[$job['id']]['shortlistedProfiles'];
                        $numbers['offeredProfiles'] = $gdprAssoStats[$job['id']]['offeredProfiles'];
                        $numbers['holdProfiles'] = $gdprAssoStats[$job['id']]['holdProfiles'];
                        $numbers['interviwedProfiles'] = $gdprAssoStats[$job['id']]['interviwedProfiles'];
                    }
                }else{
                    //echo 'Else';
                    //print_r($nongdprAssoStats); echo '==============';
                    if(!empty($nongdprAssoStats[$job['id']])){
                        $numbers['profilesReceived'] = $nongdprAssoStats[$job['id']]['profilesReceived'];
                        $numbers['rejectedProfiles'] = $nongdprAssoStats[$job['id']]['rejectedProfiles'];
                        $numbers['shortlistedProfiles'] = $nongdprAssoStats[$job['id']]['shortlistedProfiles'];
                        $numbers['offeredProfiles'] = $nongdprAssoStats[$job['id']]['offeredProfiles'];
                        $numbers['holdProfiles'] = $nongdprAssoStats[$job['id']]['holdProfiles'];
                        $numbers['interviwedProfiles'] = $nongdprAssoStats[$job['id']]['interviwedProfiles'];
                    }                
                }
                $job['numbers'] = $numbers;
            }
        }
        
        return response()->success(compact('employeralljobs'));
    }*/

    public function getAmemployers()
    {
        $authuser = Auth::user();
        $amemployers = Association::select('employer_id')->where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('employer_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->with('employer.company')
                                    ->get();
         foreach ($amemployers as $job) {
            $id=$job['employer_id'];
            $empselectedcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',27)
                                        ->count();
            $empdirectjoincandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',28)
                                        ->count();
            $empphoneinterviewcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',17)
                                        ->count();
            $empshrtlistcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',18)
                                        ->count();
            $empfinalinterviewcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',20)
                                        ->count();
            $empwailkincandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',21)
                                        ->count();
            $empskypeinterviewcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',22)
                                        ->count();
            $empdirectinterviewcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',23)
                                        ->count();
            $empholdcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)->where('employer_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',24)
                                        ->count();
             $emprejectaftershortistcandidates = Association::select('id')->where('accountmanager_id',$authuser->id)
                            ->where('employer_id',$id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',2)
                            ->count();
             $jobs = JobOrders::select('id')->where('user_id',$id)->where('status', '!=', 7)->where('is_talentpool',0)->count();
            $numbers = ['empskypeinterviewcandidates'=>$empskypeinterviewcandidates, 'empdirectinterviewcandidates'=>$empdirectinterviewcandidates, 'empholdcandidates'=>$empholdcandidates,'empwailkincandidates'=>$empwailkincandidates,'empfinalinterviewcandidates'=>$empfinalinterviewcandidates,'empshrtlistcandidates'=>$empshrtlistcandidates,'empphoneinterviewcandidates'=>$empphoneinterviewcandidates,'empdirectjoincandidates'=>$empdirectjoincandidates,'empselectedcandidates'=>$empselectedcandidates,'emprejectaftershortistcandidates'=>$emprejectaftershortistcandidates,'jobs'=>$jobs];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amemployers'));
    }
    // public function getVendoruserstoassignjobs()
    // {
    //     $authuser = Auth::user();
    //     $a = User::where('parent_id', $authuser->id)->where('role_id', 9)->with('vendorusersettings')->orderBy('first_name', 'asc')->get();
    //     $i = array();
    //     foreach ($a as $k => $v) {
    //         $b=Association::where('vendor_user_id',intval($v->id))->where('vendor_id',intval($authuser->id))->whereNotNull('job_id')->groupBy('job_id')->count();
    //         if( $v->vendorusersettings != null && ($b < $v->vendorusersettings->max_jobs) ){array_push($i, $v->id);}
    //     }//foreach
    //      $vendoruserstoassignjobs = User::whereIn('id', $i)->orderBy('first_name','asc')->get();
    //     return response()->success(compact('vendoruserstoassignjobs'));
    // }
    public function getVendoruserstoassignjobs($jobId){
        $authuser = Auth::user();
        $a = User::where('parent_id', $authuser->id)->where('role_id', 9)->with('vendorusersettings')->orderBy('first_name', 'asc')->get()->toArray();
    $i = array();
    $activity = array();
    foreach ($a as $k => $v) {
         $i[] = $v['id'];
        $act = Activity::select('vendor_id','vendor_user_id','job_id','name')->where('vendor_user_id', $v['id'])->where('name','Job assigned to vendor user')->where('job_id',intval($jobId))->get()->toArray();
        if(is_array($act) && count($act)>0) {
        $activity[] = $act;
        }
    }
    
    if(is_array($activity) && count($activity)>0){
        
       foreach($activity as $activity_k => $activity_v){
           
                if (($key = array_search($activity_v[0]['vendor_user_id'], $i)) !== false) {
                                            unset($i[$key]);
                 $vendoruserstoassignjobs = User::whereIn('id', $i)->orderBy('first_name','asc')->get();
                }
        
        }
    }else{
             $vendoruserstoassignjobs = User::where('parent_id', $authuser->id)->where('role_id', 9)->with('vendorusersettings')->orderBy('first_name', 'asc')->get();

    }
    return response()->success(compact('vendoruserstoassignjobs'));

}

    // public function getVendoruserstoassignjobs($jobId)
    // {
    //     // echo 'testingss:::'.$jobId;exit;
    //     $authuser = Auth::user();
    //     $a = User::where('parent_id', $authuser->id)->where('role_id', 9)->with('vendorusersettings')->orderBy('first_name', 'asc')->get();
    //     $i = array();
    //     foreach ($a as $k => $v) {
    //         $b=Association::where('vendor_user_id',intval($v->id))->where('vendor_id',intval($authuser->id))->whereNotNull('job_id')->groupBy('job_id')->count();
    //         if( $v->vendorusersettings != null && ($b < $v->vendorusersettings->max_jobs) ){array_push($i, $v->id);}

    //         $activity_array = array();
    //         $activity = Activity::select('vendor_user_id','job_id')->where('vendor_id', intval($authuser->id))->where('job_id',intval($jobId))->get()->toArray();

    //         $n = 1;
    //         foreach($activity as $activity_k => $activity_v){
    //             if($activity_v['vendor_user_id'] != ''){
    //                 if (($key = array_search($activity_v['vendor_user_id'], $i)) !== false) {
    //                                     unset($i[$key]);
    //                     $vendoruserstoassignjobs = User::whereIn('id', $i)->orderBy('first_name','asc')->get();
    //                 }
    //             }            
    //         }
    //         // echo '<pre>'; print_r($activity_array);exit;
    //     }//foreach
    //     return response()->success(compact('vendoruserstoassignjobs'));
    // }

    /**
     * Get all vendors assigned to account manager.
     *
     * @return JSON
     */
    public function getAmvendors()  
    {
        $authuser = Auth::user();
        $amvendors = Association::where('accountmanager_id',$authuser->id)
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->with('vendor.company')
                                    ->get();

        foreach ($amvendors as $job) {
            $id=$job['vendor_id'];
            $empselectedcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',27)
                                        ->count();
            $empdirectjoincandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',28)
                                        ->count();
            $empphoneinterviewcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',17)
                                        ->count();
            $empshrtlistcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',18)
                                        ->count();
            $empfinalinterviewcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',20)
                                        ->count();
            $empwailkincandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',21)
                                        ->count();
            $empskypeinterviewcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',22)
                                        ->count();
            $empdirectinterviewcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',23)
                                        ->count();
            $empholdcandidates = Association::where('accountmanager_id',$authuser->id)->where('vendor_id',$id)
                                        ->whereNotNull('vendor_id')
                                        ->whereNotNull('employer_id')
                                        ->whereNull('vendor_user_id')
                                        ->whereNull('employer_user_id')
                                        ->whereNotNull('job_id')
                                        ->whereNotNull('candidate_id')
                                        ->where('candidate_status',24)
                                        ->count();
             $emprejectaftershortistcandidates = Association::where('accountmanager_id',$authuser->id)
                            ->where('vendor_id',$id)
                            ->whereNotNull('vendor_id')
                            ->whereNotNull('employer_id')
                            ->whereNull('vendor_user_id')
                            ->whereNull('employer_user_id')
                            ->whereNotNull('job_id')
                            ->whereNotNull('candidate_id')
                            ->where('candidate_status',30)
                            ->count();
             $jobs = JobOrders::where('user_id',$id)->where('is_talentpool',0)->count();
            $numbers = ['empskypeinterviewcandidates'=>$empskypeinterviewcandidates, 'empdirectinterviewcandidates'=>$empdirectinterviewcandidates, 'empholdcandidates'=>$empholdcandidates,'empwailkincandidates'=>$empwailkincandidates,'empfinalinterviewcandidates'=>$empfinalinterviewcandidates,'empshrtlistcandidates'=>$empshrtlistcandidates,'empphoneinterviewcandidates'=>$empphoneinterviewcandidates,'empdirectjoincandidates'=>$empdirectjoincandidates,'empselectedcandidates'=>$empselectedcandidates,'emprejectaftershortistcandidates'=>$emprejectaftershortistcandidates,'jobs'=>$jobs];
            $job['numbers'] = $numbers;
        }
        return response()->success(compact('amvendors'));
    }

    
     
     public function getAmvendorsdata($id)
    {
        $authuser = Auth::user();
        $assignedvendors = Association::where('accountmanager_id',$authuser->id)
                                    ->where('job_id',$id)
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')
                                    ->get();
        $vendors = array();
        foreach($assignedvendors as $vendor) { $vendors[] = $vendor->vendor_id; }
        $amvendorsdata = Association::where('accountmanager_id',$authuser->id)
                                    ->whereNotNull('vendor_id')
                                    ->where('is_removed',0)
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('job_id')
                                    ->whereNull('candidate_id')
                                    ->with('vendor.company')->whereNotIn('vendor_id',$vendors)
                                    ->get();
        foreach ($amvendorsdata as $vendor) {
            $completeDetails = $vendor->vendor['first_name'] .' , '. $vendor->vendor['email'] .' , '. $vendor->vendor->company['name'] ;
            $vendor['vendordetails'] = $completeDetails;
        } 
                               
        return response()->success(compact('amvendorsdata'));
    }

  public function getVendorsteamdata($id)
    {
        $authuser = Auth::user();

        $jobassignvendorsteam = VendorActivities::where('vendor_id',$authuser->id)->where('job_id',$id)
        ->whereNotNull('vendor_user_id')
        ->whereNotNull('job_id')
        ->whereNull('candidate_id')
        ->whereNull('candidate_status')
        ->with('vendoruserid')
        ->get();
         $vendors = array();
        foreach ($jobassignvendorsteam as $vendor) {
            $vendors [] = $vendor->vendor_user_id;
        }

        $vendorsteamdata = User::where('parent_id', $authuser->id)->whereNotIn('id',$vendors)->get();
        return response()->success(compact('vendorsteamdata'));
    }
 public function getUservendors($id)
    {
        $uservendors = Association::where('accountmanager_id',$id)
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')->whereNull('job_id')->with('vendor')->with('vendor.company')
                                    ->get();
       return response()->success(compact('uservendors'));
   }
    public function getUseremployers($id)
    {

        $useremployers = Association::where('accountmanager_id',$id)
                                    ->whereNull('job_id')
                                    ->whereNull('vendor_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')->with('employer')->with('employer.company')
                                    ->get();
       return response()->success(compact('useremployers'));
   }
    public function getEmployersremaining($id)
    {
         $useremployers = Association::select('employer_id')->whereNotNull('accountmanager_id')
                                    ->whereNull('job_id')
                                    ->whereNull('vendor_id')
                                    ->whereNotNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')->with('employer')
                                    ->get();
          $employers = array();
        foreach ($useremployers as $employer) {
            $employers [] = $employer->employer_id;
        }
        $employersremaining = User::where('role_id', 5)->whereNotIn('id',$employers)->orderBy('first_name', 'asc')->with('company')->get();

        return response()->success(compact('employersremaining'));
    }
    public function getVendorsremaining($id)
    {
         $uservendors = Association::select('vendor_id')->where('accountmanager_id',$id)
                                    ->whereNull('job_id')
                                    ->where('is_removed',0)
                                    ->whereNotNull('vendor_id')
                                    ->whereNull('employer_id')
                                    ->whereNull('employer_user_id')
                                    ->whereNull('vendor_user_id')
                                    ->whereNull('candidate_id')->with('employer')
                                    ->get();
                                  
        $vendors = array();
        foreach ($uservendors as $vendor) {
            $vendors [] = $vendor->vendor_id;
        }
        $vendorsremaining = User::where('role_id', 6)->whereNotIn('id',$vendors)->orderBy('first_name', 'asc')->with('company')->get();
        return response()->success(compact('vendorsremaining'));
    }

    public function getAmremaining($Vendorid)
    {
         $useram = Association::select('accountmanager_id')
                                ->where('vendor_id',$Vendorid)
                                ->where('is_removed',0)
                                ->whereNull('job_id')
                                ->whereNull('employer_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('candidate_id')
                                ->groupBy('accountmanager_id')
                                ->get();
        $ams = array();
        foreach ($useram as $am) {
            array_push($ams, $am->accountmanager_id);
        }
        $amremaining = User::where('role_id', 10)
                            ->whereNotIn('id',$ams)
                            ->orderBy('first_name', 'asc')
                            ->with('company')
                            ->get();
        return response()->success(compact('amremaining'));
    }

    public function getExistingam($Vendorid)
    {
         $useram = Association::where('vendor_id',$Vendorid)
                                ->where('is_removed',0)
                                ->whereNull('job_id')
                                ->whereNull('employer_id')
                                ->whereNull('employer_user_id')
                                ->whereNull('vendor_user_id')
                                ->whereNull('candidate_id')
                                ->groupBy('accountmanager_id')
                                ->get();
        $ams = array();
        foreach ($useram as $am) {
            array_push($ams, $am->accountmanager_id);
        }
        $existingam = User::where('role_id', 10)
                            ->whereIn('id',$ams)
                            ->orderBy('first_name', 'asc')
                            ->with('company')
                            ->get();
        return response()->success(compact('existingam'));
    }

    public function postSendotp()
   {
        $authuser = Auth::user();
        $otp =  Input::get('otp');
        $number = Input::get('newMobileNumber');
        $countryCode   = str_replace("+","",Input::get('country_code'));
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number;
        $originator = "HireXtra";
        $msgtxt = "OTP to update your mobile number is ". $otp . " .";
        curl_setopt($ch,CURLOPT_URL,"http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success('success');
    }
	public function postSendotpnew()
   {
        $authuser = Auth::user();
        $number = Input::get('newMobileNumber');
        $number  =str_replace("+91", "", $number);
        $city = \App\City::where('id', $authuser->city_id)->get();
                if (count($city) > 0) {
                    $country = Country::where('id', $city[0]->country_id)->get();
                    $countryCode = $country[0]->ISD_code;
                } else {
                    $countryCode = 91;
                }
		$otp = rand(0,100000);
		DB::delete("delete from users_session where user_id='".$authuser->id."'");
		DB::insert("insert into users_session set user_id='".$authuser->id."', session_id='".$otp."' ");
		
        $ch = curl_init();
        $user="kv@hirextra.com";
        $password="hirextra";
        $receipientno = $countryCode.$number;
        $originator = "HireXtra";
        $msgtxt = "OTP for your mobile number is ". $otp . " .";
        curl_setopt($ch,CURLOPT_URL,"http://app.mobivatebulksms.com/gateway/api/simple/MT?");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "USER_NAME=$user&PASSWORD=$password&ORIGINATOR=$originator&RECIPIENT=$receipientno&ROUTE=mglobal&MESSAGE_TEXT=$msgtxt");
        $buffer = curl_exec($ch);
        $httpcode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        return response()->success('success');
    }

    public function getChangejobtype($id)
    {
        $user = User::find($id);
        if($user->job_type==1){
            $userData = [
                'job_type' => 2
            ];
        }else{
           $userData = [
                'job_type' => 1
            ];
        }

        $affectedRows = User::where('id', '=', intval($id))->update($userData);
        $changejobtype = User::where('role_id', 5)->whereNull("parent_id")->orderBy('first_name', 'asc')->with('company')->get();
       
        return response()->success($changejobtype);
    }
    public function getLocation() {
        $authuser = Auth::User();
        $locations = array();
        if(!empty($authuser->id)) {
            $countriesInfo = DB::table('pricings')
                        ->select('country_id')
                        ->groupBy('country_id')
                        ->where('emp_id', $authuser->id)
                        ->get();
            
            if(is_array($countriesInfo) && count($countriesInfo)>0) {
                foreach($countriesInfo as $key => $value) {
                    $locations[] = $this->get_country_info($value->country_id);
                }
            } 
        } 
        return response()->success(compact('locations'));

	}
	public function get_country_info($country_id) {
		$countryInfo = Country::where('id',$country_id)->get();
		return $countryInfo[0];
	}  

        public function getContinents() {
        $authuser = Auth::User();
        $locations = array();
        if(!empty($authuser->id)) {
            $continents = DB::table('continents as c')->distinct('c.id')
                        ->select('c.id','c.continents_name')
                        ->join('countries as co','c.id','=','co.continents')
                        ->join('pricings as p', 'co.id', '=', 'p.country_id')
                        ->where('p.emp_id', $authuser->id)
                        ->get();
        } 
        return response()->success(compact('continents'));

    }

    public function getContinentsnew($id) {
        $authuser = Auth::User();
         if(!empty($authuser->id)) {
            $continentsnew = DB::table('countries as c')->distinct('c.id')
                        ->select('c.id','c.name','c.continents')
                        ->where('c.continents',$id)                        
                        ->join('pricings as p', 'c.id', '=', 'p.country_id')
                        ->where('p.emp_id', $authuser->id)
                        ->get();
            }
        return response()->success(compact('continentsnew'));

    }
  
	public function postCompanyinformation() {
		
		$email = Input::get('email');
        $getemail = explode("@", $email);
		$companyInfo = DB::select("select * from clear_bit_companies where domain like '%".$getemail[1]."%'");
        if($companyInfo != null){
            $findemail = 1; 
        }
        else{
            $findemail = 0; 
        }
		if(is_array($companyInfo) && count($companyInfo)==0) {
			$curl = \curl_init();
			\curl_setopt_array($curl, array(
				CURLOPT_URL => 'https://person-stream.clearbit.com/v2/combined/find?email=' . $email,
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => 'GET',
				CURLOPT_HTTPHEADER => array(
					'Authorization: Bearer ' . \Config::get('app.api_clearbit')
				),
			));
			$response = curl_exec($curl);
			curl_close($curl);
			$companyInfo = json_decode($response, true);

		}
		return response()->success(compact('companyInfo','findemail'));
		
	}
}
