<?php

namespace App\Http\Controllers\api;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\JobOrders;
use App\Transformers\v1\JobOrderTransformer; //using transformer now
use App\JobCitys;
use DB;
use App\Association;

//extend base controller but not a default one to use Helpers
class JobOrderController extends BaseController 
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //Get All Job Orders
        //return JobOrders::all();
        /*$getAJO = JobOrders::with('Industry')
                            ->with('company')
                            //->with('JobCitys')
                            ->with('employer')
                            //->where('is_private',0)
                            //->offset(0)
                            //->limit(10)
                            ->get();
*/
        //$getAJO = JobOrders::with('status')->with('JobType')->with('JobCitys.citys')->with('Industry')->with('Education.educations')->with('JobLanguages.languages')->with('user')->get();

        /*$getAJO = DB::table('job_orders')
                ->join('job_types', 'job_orders.job_type_id', '=', 'job_types.id')
                ->join('job_citys', 'job_orders.id', '=', 'job_citys.job_id')
                ->join('cities', 'job_citys.job_id', '=', 'cities.id')
                ->join('countries', 'cities.country_id', '=', 'countries.id')
                ->join('industries', 'job_orders.industry_id', '=', 'industries.id')
                //->join('education_associations', 'job_orders.education_id', '=', 'education_associations.id')
                //->join('job_languages', 'job_orders.language_id', '=', 'job_languages.id')
                ->join('users', 'job_orders.user_id', '=', 'users.id')
                ->join('companies', 'users.company_id', '=', 'companies.id')
                ->join('statuses', 'job_orders.status', '=', 'statuses.id')
                ->selectRaw('job_orders.name, job_orders.created_at, companies.name as company, cities.name as city, cities.city_state as state, countries.name as country, job_orders.salary as maxSalary, job_orders.salary_min as minSalary, job_orders.experience as experienceFrom, job_orders.experience_to as experienceTo, job_orders.salaryType, job_orders.vacancies, job_orders.description')
                //->selectRaw('job_orders.name, job_orders.created_at, job_orders.salary as maxSalary, job_orders.salary_min as minSalary, job_orders.experience as experienceFrom, job_orders.experience_to as experienceTo, job_orders.salaryType, job_orders.vacancies, job_orders.description')
                ->whereRaw('statuses.id = 3')
                ->groupby('job_orders.id')
                ->get();*/
        //echo '<pre>'; print_r($getAJO); die;


        $getAJO = DB::table('associations')
                    ->join('job_orders', 'job_orders.id', '=', 'associations.job_id')
                    ->join('users', 'job_orders.user_id', '=', 'users.id')
                    ->join('companies', 'users.company_id', '=', 'companies.id')
                    ->join('job_types', 'job_types.id', '=', 'job_orders.job_type_id')
                    ->join('job_citys', 'job_orders.id', '=', 'job_citys.job_id')
                    ->join('cities', 'job_citys.city_id', '=', 'cities.id')
                    ->join('countries', 'cities.country_id', '=', 'countries.id')
                    ->join('industries', 'job_orders.industry_id', '=', 'industries.id')
                    //->join('education_associations', 'job_orders.education_id', '=', 'education_associations.id')
                    ->join('statuses', 'job_orders.status', '=', 'statuses.id')
                    ->whereRaw('associations.candidate_id IS NULL')
                    ->whereRaw('employer_id IS NOT NULL')
                    ->whereRaw('vendor_user_id IS NULL')
                    ->whereRaw('associations.vendor_id IS NULL')
                    ->whereRaw('employer_user_id IS NULL')
                    ->whereRaw('statuses.id = 3')
                    ->where('job_orders.status', '!=', 7)
                    ->selectRaw('job_orders.name, DATE_FORMAT(job_orders.created_at, "%Y-%m-%d") as created_at, companies.name as company, cities.name as city, cities.city_state as state, countries.name as country, job_orders.salary as maxSalary, job_orders.salary_min as minSalary, job_orders.experience as experienceFrom, job_orders.experience_to as experienceTo, job_orders.salaryType, job_orders.vacancies, job_orders.description, job_orders.skills_preferred, job_orders.skills_required')
                    ->groupby('job_orders.id')
                    ->get();
        
        //echo '<pre>'; print_r($getAJO); die;

        if(count($getAJO) > 0) {
            $getXMLArray = array();
            foreach($getAJO as $k => $value) {
                //echo '<pre>'; print_r($value); echo '</pre>';
                //$getXMLArray[] = $value['attributes'];
                $getXMLArray[] = (array) $value;
            }

            //echo '<pre>'; print_r($getXMLArray); die;
            
            //creating object of SimpleXMLElement
            $xml_user_info = new \SimpleXMLElement("<?xml version=\"1.0\"?><job_info></job_info>");
            
            //function call to convert array to xml
            $this->array_to_xml($getXMLArray,$xml_user_info);
            
            //saving generated xml file
            $xml_file = $xml_user_info->asXML();
            //print_r($xml_file);
            
            //success and error message based on xml creation
            if(!$xml_file){
                echo 'XML file generation error.';
            } else {
                return $xml_file;
            }
        } else {
            return $this->sendError('Job Order not found.');
        }

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        $jobOrder = JobOrders::create([
            'USR_NoRole' => $request->get('noRole'),
            'USR_CompleteName' => $request->get('completeName'),
            'USR_UserName' => $request->get('name'),
            'USR_Password' => Hash::make($request->get('password')),
            'USR_BBlocked' => $request->get('isBlocked'),
            'USR_BAssociation' => $request->get('isAssociation'),
            'USR_NoPeriode' => $request->get('noPeriode'),
            'USR_NoEntite' => $request->get('noEntite'),
            'USR_CreateUser' => "jschneider",
            'USR_CreateTimestamp' => date("Y-m-d H:i:s"),
            'USR_UpdateUser' => "jschneider",
            'USR_UpdateTimestamp' => date("Y-m-d H:i:s"),
        ]);

        $token = JWTAuth::fromUser($user);

        $salaryType = $request->get('salaryType');
        $salaryMax = "";
        $salaryMin = "";
        if ($request->get('job_type') == "Permanent") {
            $salaryMax = $request->get('maxSalary');
            $salaryMin = $request->get('minSalary');
            if($salaryType=='per year')
            { 
                $salaryMax = $salaryMax * 1;
                $salaryMin = $salaryMin * 1;
            } 
            else if($salaryType=='per month') 
            {
                $salaryMax = $salaryMax * 12;
                $salaryMin = $salaryMin * 12;
            }
            else if($salaryType=='per week') 
            {
                $salaryMax = $salaryMax * 52;
                $salaryMin = $salaryMin * 52;
            }
            else if($salaryType=='per day') 
            {
                $salaryMax = $salaryMax * 365;
                $salaryMin = $salaryMin * 365;
            }
        }

        $JobOrders = JobOrders::create([
                    'name' => $request->get('name'),
                    'currency' => $request->get('currency'),
                    'salary' => $salaryMax,
                    'salary_min' => $salaryMin,
                    'billrate' => $request->get('billRate'),
                    'am_billRate' => $request->get('am_billRate'),
                    'vendor_billRate' => $request->get('vendor_billRate'),
                    'level' => $request->get('level'),
                    'salaryType' => $salaryType,
                    'experience' => $request->get('experience'),
                    'experience_to' => $request->get('experience_to'),
                    'vacancies' => $request->get('vacancies'),
                    'educationLevel' => '',
                    /*'experiencetype' => $request->get('experienceType'),*/
                    'language_id' => '',
                    'industry_id' => 0,
                    'deadline' => $request->get('deadline'),
                    'job_type_id' => $request->get('job_type_id'),
                    'user_id' => $authId,
                    'requirement_id' => 1,
                    'status' => 7,
                    'gdprmandatory' => 1,
                    'job_internal_code' => $request->get('internalCode'),
                    'description' => $request->get('description'),
                    'skills_preferred' => $request->get('preferredSkills'),
                    'skills_required' => $request->get('requiredSkills'),
                    'is_private' => $request->get('is_private'),
                    'joborder_number' => '',
                    'min_contract_term' => $request->get('min_contract_term'),
                    'max_contract_term' => $request->get('max_contract_term'),
                    'contract_term_type' => $request->get('contract_term_type'),
                    'is_talentpool' => $request->get('is_talentpool'),
                    'expectedjoingdate' => date('Y-m-d',strtotime($request->get('expectedjoingdate'))),
                    //'payment_mode' => $request->get('paymentMode'),
                    //'payment_terms' => $request->get('paymentTerms')
                ]);

        //$visibility
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //Storing Job Order

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request)
    {
        //Display Individual Job Order based on ID
        /*$getAJO = DB::table('associations')
                ->join('candidates', 'associations.candidate_id', '=', 'candidates.id')
                ->join('job_orders', 'associations.job_id', '=', 'job_orders.id')
                ->selectRaw('job_id, candidates.full_name, candidates.email, job_orders.currency, job_orders.salary, job_orders.salary_min, job_orders.experience, job_orders.experience_to, job_orders.salaryType, job_orders.vacancies, job_orders.description')
                ->whereRaw('job_orders.id = ?', [$request->get('id')])
                ->groupby('job_orders.id')
                ->get();*/

        $getAJO = DB::table('job_orders')
                ->join('job_types', 'job_orders.job_type_id', '=', 'job_types.id')
                ->join('job_citys', 'job_orders.id', '=', 'job_citys.job_id')
                ->join('cities', 'job_citys.job_id', '=', 'cities.id')
                ->join('countries', 'cities.country_id', '=', 'countries.id')
                ->join('industries', 'job_orders.industry_id', '=', 'industries.id')
                ->join('education_associations', 'job_orders.education_id', '=', 'education_associations.id')
                //->join('job_languages', 'job_orders.language_id', '=', 'job_languages.id')
                ->join('users', 'job_orders.user_id', '=', 'users.id')
                ->join('companies', 'users.company_id', '=', 'companies.id')
                ->join('statuses', 'job_orders.status', '=', 'statuses.id')
                ->selectRaw('job_orders.name, job_orders.created_at, companies.name as company, cities.name as city, cities.city_state as state, countries.name as country, job_orders.salary as maxSalary, job_orders.salary_min as minSalary, job_orders.experience as experienceFrom, job_orders.experience_to as experienceTo, job_orders.salaryType, job_orders.vacancies, job_orders.description')
                //->selectRaw('job_orders.name, job_orders.created_at, job_orders.salary as maxSalary, job_orders.salary_min as minSalary, job_orders.experience as experienceFrom, job_orders.experience_to as experienceTo, job_orders.salaryType, job_orders.vacancies, job_orders.description')
                ->whereRaw('statuses.id = 3')
                ->whereRaw('job_orders.id = ?', [$request->get('id')])
                ->groupby('job_orders.id')
                //->groupby('job_orders.id')
                ->get();

        if(count($getAJO) > 0) {
            $xml = $this->array2xml((array) $getAJO[0], false);
            return $xml;
        } else {
            return $this->sendError('Job Order not found.');
        }

        //echo '<pre>';
        //print_r($xml);

        //print_r($getAJO); 
        //die;
        
        /*$filePath = storage_path('../public/user_assets/100033/3Year_Resume_Format.doc');
        $c =  file_get_contents($filePath);
        file_put_contents('temp.txt',$c);
        $cc = file_get_contents('temp.txt');
        if(strlen($cc)=='0'){
            $cc = fopen("temp.txt","r");
        }
        $encoded = base64_encode($cc);
        unlink('temp.txt');*/

        if (count($getAJO) == 0) {
            return $this->sendError('Job Order not found.');
        }
        
        return $this->item($getAJO, new JobOrderTransformer);
    }

    /*function array2xml($array, $xml = false){

        if($xml === false){
            $xml = new \SimpleXMLElement('<result/>');
        }

        foreach($array as $key => $value){
            //echo $key . '---' . $value . '<br>';
            if($xml === false){
                $xml = new \SimpleXMLElement('<result/>');
            }
            if(is_array($value)){
                $clients = $xml->createElement("clients");
                $xml->appendChild($clients);

                foreach($value as $k => $val)
                {
                    if(is_array($val))
                        $this->array2xml(htmlspecialchars($val), $xml->addChild($k));
                    else
                       $xml->addChild($k, htmlspecialchars($val));
                }
            } else {
                $xml->addChild($key, htmlspecialchars($value));
            }
        }

        return $xml->asXML();
    }*/
    
    //function defination to convert array to xml
    function array_to_xml($array, &$xml_user_info) {
        foreach($array as $key => $value) {
            if(is_array($value)) {
                if(!is_numeric($key)){
                    $subnode = $xml_user_info->addChild("$key");
                    $this->array_to_xml($value, $subnode);
                }else{
                    $subnode = $xml_user_info->addChild("job");
                    $this->array_to_xml($value, $subnode);
                }
            }else {
                $xml_user_info->addChild("$key",htmlspecialchars("$value"));
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }


    public function sendError($error, $errorMessages = [], $code = 404)
    {
        $response = [
            'success' => false,
            'message' => $error,
        ];
        if(!empty($errorMessages)){
            $response[‘data’] = $errorMessages;
        }
        return response()->json($response, $code);
    }
}
