class AccountManagerListController{
constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state

    $rootScope.$broadcast('pageurl', this.$state.current.url);


    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
             return col.hidden ?
                 '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                      '<span class="dtr-title">'+
                          col.title+
                    '</span> '+
                    '<span class="dtr-data">'+
                        col.data+
                   '</span>'+
               '</li>' : 
               '';
           }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
    

    let Users = API.service('accountmanagers', API.all('users'))
    
    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
          DTColumnBuilder.newColumn(null).withTitle('Company').renderWith(empCompany),
          DTColumnBuilder.newColumn('mobile').withTitle('Mobile'),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" title="Edit" ui-sref="app.accountmanagersedit({userId: ${data.id}})">
                     <img src="/user_assets/assets/emp_dashboard/edit.svg" width="18" class="img-q">
                </a>
                &nbsp
                <a class="btn btn-xs" title="Activity" ui-sref="app.amactivity({userId: ${data.id}})" disabled>
                     <img src="/user_assets/assets/emp_dashboard/desktop.svg" width="18" class="img-q">
                </a>
                <!--<button class="btn btn-xs" ng-click="vm.delete(${data.id})">
                     <img src="/user_assets/assets/emp_dashboard/delete.svg" width="18" class="img-q">
                </button>-->`
    }

   let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`

    }
    let empCompany = (data) => {
          return ` ${data.company.name}`;         
      }
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  $onInit () {
    $(document).on('click', '.expandrow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr');
          var content = $(this).parent().parent().find('.expandedcontent').html();
          $('<tr><td colspan="5" style="background-color: #e8c1c1;">'+content+'</td></tr>').insertAfter(tr);
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });

        $(document).on('click', '.deleterow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr').next().remove();;
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });
  }
}

export const AccountManagerListComponent = {
    templateUrl: './views/app/components/account-manager-list/account-manager-list.component.html',
    controller: AccountManagerListController,
    controllerAs: 'vm',
    bindings: {}
}
