class AccountManagersAddController{
  constructor (API,$scope, $state, $stateParams, $rootScope) {
    'ngInject'

    this.$state = $state
    this.formSubmitted = false 
    this.API = API
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let Employers = API.service('employers', API.all('users'))
    Employers.getList()
      .then((response) => {
        let systemEmployers = []
        $scope.employerResponse = response.plain()
       $scope.masterEmployers=$scope.employerResponse;
    })

    let Vendors = API.service('vendorsforam', API.all('users'))
    Vendors.getList()
      .then((response) => {
        let systemVendors = []
        $scope.masterVendors = response.plain()
        // $scope.masterVendors=$scope.vendorResponse;
    })

  }

  register (isValid) {
    this.$state.go(this.$state.current, {}, { alerts: 'test' })
     let UserData = this.API.service('mobiledata', this.API.all('users'))
    UserData.post({
        'mobile': this.mobile,
        'email': this.email,
      })
   // UserData.one(this.mobile).get()
      .then((response) => {
      this.mobileNum=response.data.numbers.mobile;
      this.emailNum=response.data.numbers.email;
      if (isValid && (this.mobileNum == 0) && (this.emailNum == 0)) {
        let AM = this.API.service('registeram', this.API.all('users'))
        var country_code = $(".iti__selected-dial-code").html();
        var country_mobile = $('#phone').val();
        let $state = this.$state
        AM.post({
          'first_name': this.first_name,
          'last_name': this.last_name,
          'mobile': country_mobile,
          'email': this.email,
          'employers': this.employers,
          'vendors': this.vendors,
          'country_code' : country_code
        }).then(function () {
          let alert = { type: 'success', msg: 'Account manager has been added.' }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          
          if(response.data.errors.mobile && response.data.errors.email){
            let alert = { type: 'error', msg: response.data.errors.mobile[0] +','+ response.data.errors.email[0] }
            $state.go($state.current, { alerts: alert},{reload:true})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          }
          else if(response.data.errors.mobile){
            let alert = { type: 'error', msg: response.data.errors.mobile[0] }
            $state.go($state.current, { alerts: alert},{reload:true})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          }
          else if(response.data.errors.email){
            let alert = { type: 'error', msg: response.data.errors.email[0]}
            $state.go($state.current, { alerts: alert},{reload:true})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          }
      })
    } else {
      this.formSubmitted = true
    }
      })
  }

  $onInit () {
    $("#numberValid").keypress(function (e) {
     //if the letter is not digit then display error and don't type anything
     if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
               return false;
    }
   });
  }
}

export const AccountManagersAddComponent = {
    templateUrl: './views/app/components/account-managers-add/account-managers-add.component.html',
    controller: AccountManagersAddController,
    controllerAs: 'vm',
    bindings: {}
}
