class AccountManagersEditController{
  constructor (API, $state,$scope, $stateParams, $rootScope) {
    'ngInject'

    this.$state = $state
    this.formSubmitted = false
    this.API = API
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let userId = $stateParams.userId
    let UserData = API.service('accountmanager', API.all('users'))
    UserData.one(userId).get()
      .then((response) => {
        let userRole = []
        let userResponse = response.plain()
        angular.forEach(userResponse.data.role, function (value) {
          userRole.push(value.id)
        })
        response.data.role = userRole
        this.usereditdata = API.copy(response)
       $scope.country_code=this.usereditdata.data.country_code_id;
        var short_country_code = $scope.country_code;
        var countryCode = document.querySelector("#phone");
         window.intlTelInput(countryCode, {
          hiddenInput: "full_number",
          initialCountry: short_country_code,
            onlyCountries: ['GB', 'IN', 'US', 'DE', 'IT','FR','ES','NL','SE','PL','MT','GR','AT','PT','DK','CZ','HR','FI','BE','CY','HU','RO','IE','BG','LT','EE','SI','SK','LV','CHE'],
            separateDialCode: true,
          utilsScript: "/user_assets/css/utils.js?1562189064761",
        });
    });

    let vendorsAssigned = API.service('uservendors', API.all('users'))
    vendorsAssigned.one(userId).get()
      .then((response) => {
        $scope.uVendors=response.data;
        
    });

    let empAssigned = API.service('useremployers', API.all('users'))
    empAssigned.one(userId).get()
      .then((response) => {
        $scope.uEmp=response.data;
    });

    let Employers = API.service('employersremaining', API.all('users'))
    Employers.one(userId).get()
      .then((response) => {
        let systemEmployers = []
        let employerResponse = response.plain()
       $scope.masterEmployers=employerResponse.data.employersremaining;
    });

    let Vendors = API.service('vendorsremaining', API.all('users'))
    Vendors.one(userId).get()
      .then((response) => {
        let systemVendors = []
        let vendorResponse = response.plain()
        $scope.masterVendors=vendorResponse.data.vendorsremaining;
    });
  }
  
 save (isValid) {
   var country_code = $(".iti__selected-dial-code").html();
    if (isValid) {
      let $state = this.$state
      this.usereditdata.data.vendors=this.vendors;
      this.usereditdata.data.employers=this.employers;
      this.usereditdata.data.country_code=country_code;
      this.usereditdata.put()
        .then(() => {
          let alert = { type: 'success', msg: 'User has been updated.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

delete (Id) {

    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('amuserremove',Id).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Role has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }
  $onInit () {
    $(".numberValid").keypress(function (e) {
      if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
        return false;
      }
    });
  }
}

export const AccountManagersEditComponent = {
    templateUrl: './views/app/components/account-managers-edit/account-managers-edit.component.html',
    controller: AccountManagersEditController,
    controllerAs: 'vm',
    bindings: {}
};
