class ActivateEmailController{
   constructor (API, $state, $rootScope) {
    'ngInject'

    this.API = API
    this.$state = $state
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
     
      let data = {
        email: this.$state.params.email,
        email_verification_code: this.$state.params.token
      }

      this.API.all('auth/password/activate').post(data).then(() => {
        let alrtArr = []
        alrtArr = {type: 'success', msg: 'Your account has been activate, You may now login.'}
        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-success").hide() }, 10000);
      }, (res) => {
        let alrtArr = []
        angular.forEach(res.data.errors, function (value) {
          alrtArr = {type: 'error', msg: value[0]}
        })
        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      })
  }//constructor

  $onInit () {
    this.isValidToken = false
    this.verifyToken()
  }

  verifyToken () {
    let email = this.$state.params.email
    let token = this.$state.params.token
    this.API.all('auth/password').get('verify', {
    email, token}).then(() => {
      this.isValidToken = true
    }, () => {
      //this.$state.go('app.landing')
    })
  }
}

export const ActivateEmailComponent = {
    templateUrl: './views/app/components/activate-email/activate-email.component.html',
    controller: ActivateEmailController,
    controllerAs: 'vm',
    bindings: {}
};
