class AdminJobViewController{
    constructor ($scope, $stateParams, $state, API, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, AclService, ContextService, $filter, $rootScope, $interval, $timeout,$http) {
    'ngInject'
  
    this.$state = $state
    this.API = API
    this.$scope = $scope
    this.$uibModal = $uibModal
    this.$log = $log
    this.animationsEnabled = true
    this.formSubmitted = false
    this.alerts = []
    this.alerts1 = []
    $scope.unsortedTimeline = null
    $scope.myVar = false;
    $scope.myVar1 = true;
    $scope.disablesort = 0;
    $scope.diff = null
    $scope.Jobstat = null
    let jobView = this
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    $scope.numbers = [ 10, 25, 50, 100];
    $scope.selectednumber1 = "10";
    $scope.selectednumber2 = "10";
    $scope.selectednumber3 = "10";
    $scope.selectednumber4 = "10";
   /*  $("#myModalData").modal('show');*/

    $scope.toggle = function() {
        $scope.myVar = !$scope.myVar;
         $scope.myVar1 = !$scope.myVar1;
    };

    $scope.formatDate = function(date){
      return new Date(date)
    }
        
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    if ($stateParams.alerts1) {
      this.alerts1.push($stateParams.alerts1)
    }

    ContextService.me(function (data) {
      jobView.loggedInUserData = data
    })

    let getCountry = API.service('country', API.all('users'))
    getCountry.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.country = dataSet
      });
    
    let joborderId = $stateParams.joborderId;
    $scope.joborderId = $stateParams.joborderId;


$scope.saveVendor = function(jid,vendors){

     $state.go($state.current, {}, { alerts: 'test' })
        let assignJobs = API.service('assignvendorsview', API.all('joborders'))
        assignJobs.post({
          'vendors': vendors,
          'jobOrderId': jid
        }).then((response) =>  {
          let alert = { type: 'success', msg: 'Job assigned to vendors successfully.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    }

    function getDataDiff(startDate, endDate) {
        var time = endDate.getTime() - startDate.getTime();
         var hours = Math.abs(endDate.getTime() - startDate.getTime()) / 36e5;
        // var days = Math.floor(diff / (60 * 60 * 24 * 1000));
        // var hours = Math.floor(diff / (60 * 60 * 1000)) - (days * 24);
        // var minutes = Math.floor(diff / (60 * 1000)) - ((days * 24 * 60) + (hours * 60));
        // var seconds = Math.floor(diff / 1000) - ((days * 24 * 60 * 60) + (hours * 60 * 60) + (minutes * 60));
        //return { day: days, hour: hours, minute: minutes, second: seconds };

        return '' + Math.abs(hours.toPrecision(1)) + ' hrs';
      }

let Decript = API.service('decryption', API.all('joborders'))
  Decript.one(joborderId).get()
  .then((response) => {
    let jobid_split = response.data.decryption;
    let split_arr = jobid_split.split('-');
    joborderId = split_arr[1];

    let Jobtype = API.service('jjoborder-show', API.all('joborders'))
    Jobtype.one(joborderId).get()
      .then((response) => {
        this.joborder = API.copy(response)
        $scope.joborderData = this.joborder
        this.joborder.data.created_at = this.joborder.data.created_at.split(" ")[0];
        this.joborder.data.new_updated_at = new Date(this.joborder.data.new_updated_at.date).getTime();
        this.joborder.data.current_time = new Date(this.joborder.data.current_time.date).getTime();
        $scope.Jobstat = this.joborder.data.status.id

        if(this.joborder.data.skills_required) {
          let sReq=this.joborder.data.skills_required
          let visitorName = ", ";
          let myNewString = sReq.replace(/,/g, visitorName);
          this.joborder.data.skills_required=myNewString;  
        }
        
        if(this.joborder.data.skills_preferred) {
          let sPrepare=this.joborder.data.skills_preferred
          let preferredreplace = ", ";
          let modData = sPrepare.replace(/,/g, preferredreplace);
          this.joborder.data.skills_preferred=modData;
        }
        function guageInit () {
        var from = $scope.joborderData.data. experience;
       /*$('#experience').val() ? $('#experience').val() : 0;*/
        var to = $scope.joborderData.data.experience_to; /*$('#experience_to').val() ? $('#experience_to').val() : 0;*/
        if( (parseInt(to) == 0) || ( parseInt(to) < parseInt(from) ) ){ to = from;}
        var myConfig10 = {
            "graphid": 1,
            "type": "gauge",
            "scale-r": {"aperture": 180,"values": "0:30:2",
                "center": {"size": 6,"background-color": "#fff","border-color": "#58ab28"},
                "ring":{"size":6,"background-color":"#f04e7d"},
                "item":{"font-color":"#58ab28","font-family":"Georgia, serif","font-size":12,"font-weight":"bold","font-style":"normal","offset-r": 0,"angle":"auto"},        
                "markers": [
                    {"type": "area","range": [from, to],"offset-start": 0,"offset-end": 0,"background-color": "#58ab28","alpha": 1},
                    {"type":"line","range":[from],"line-color":"#f04e7d","line-width":4,"line-style":"solid","alpha":1},
                    {"type":"line","range":[to],"line-color":"#f04e7d","line-width":4,"line-style":"solid","alpha":1}
                ]//markers
            } //scale-r
        };
        setTimeout(function() { 
            zingchart.render({id: 'myChart',data: myConfig10,height: "100%",width: "100%"});
        }, 0);
    };

    guageInit();
    $('#exceedVal').hide();

    function expBlurEvent() {
        $('#exceedVal').hide();
        var from_val = $('#experience').val();
        var to_val = $('#experience_to').val();

        if( (from_val > 30) || (to_val > 30) ) {
            $('#exceedVal').show();
            $('#experience').val(0);
            $('#experience_to').val(0);
            return false;
        }

        zingchart.exec('myChart', 'destroy');
        guageInit();    
    };
       
      })
       let Assignvendors = API.service('jobassignvendors', API.all('joborders'))
       Assignvendors.one(joborderId).get()
      .then((response) => {
        $scope.vendornames=response.data.amassignvendors
      })

       let vendors = this.API.service('amvendorsdata', this.API.all('users'))
        vendors.one(joborderId).get()
      .then((response) => {
          let dataSet = response.plain()
          $scope.masterVendors=dataSet.data.amvendorsdata;
      })

      let Timeline = API.service('admintimeline', API.all('joborders'))
      Timeline.one(joborderId).getList()
        .then((response) => {
          let Dbtimeline = response.plain()
          let DbtimelineData = response.plain()
            angular.forEach(Dbtimeline, function(value, key) {
              let time = new Date(value.created_at).getTime()
              Dbtimeline[key]['formatted_date'] = time
              if(key == 0) {$scope.startTimestamp = time;}
              else if ((Dbtimeline.length -1) == key) {$scope.endTimestamp = time;} 
            });
          this.timeline = Dbtimeline
          $scope.unsortedTimeline = this.timeline
          $scope.diff = getDataDiff(new Date($scope.startTimestamp), new Date($scope.endTimestamp));
            /*  $("#myModalData").modal('hide');*/
      })

      let newTimeline = API.service('newadmintimeline', API.all('joborders'))
      newTimeline.one(joborderId).getList()
        .then((response) => {
          let Dbtimeline = response.plain()
          this.newTimeline = Dbtimeline
      })

      let estRevenue = API.service('jobadminestimaterevenue', API.all('joborders'))
      estRevenue.one(joborderId).getList()
        .then((response) => {
          if(response.length) {
            this.estimaterevenue = response.plain()
            this.revenue1 = this.estimaterevenue[0].est_revenue_1
            this.revenue2 = this.estimaterevenue[0].est_revenue_2
            this.revenue3 = this.estimaterevenue[0].est_revenue_3
             this.revenue4 = this.estimaterevenue[0].est_revenue_4;
            this.revenue5 = this.estimaterevenue[0].est_revenue_5;
            $scope.revenue1 = this.estimaterevenue[0].est_revenue_1
            $scope.revenue2 = this.estimaterevenue[0].est_revenue_2
            $scope.revenue3 = this.estimaterevenue[0].est_revenue_3
             $scope.revenue4 = this.estimaterevenue[0].est_revenue_4
            $scope.revenue5 = this.estimaterevenue[0].est_revenue_5
            $scope.revenue_slot = this.estimaterevenue[0].default_revenue
         
          }
      })

      let amassignedvendors = API.service('adminassignedvendorsnumbers', API.all('joborders'))
    amassignedvendors.one(joborderId).getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.vendorassigned = dataSet;
        
        this.dtOptions1 = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', true)
          .withOption('paging', false)
          .withOption('bInfo', false)
          .withOption('bFilter', false)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns1 = [
          DTColumnBuilder.newColumn('vendor_id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(amvendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Company').renderWith(amcompany_name),
          DTColumnBuilder.newColumn(null).withTitle('Submitted Profiles').renderWith(submitted),
          DTColumnBuilder.newColumn(null).withTitle('Shortlisted Profiles').renderWith(shortlisted),
          DTColumnBuilder.newColumn(null).withTitle('Rejected Profiles').renderWith(rejected),
         /* DTColumnBuilder.newColumn(null).withTitle('Revenue - Slot').renderWith(prevenue),*/
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(jstatus).withClass('text-center'),
          
        ]
        this.displayTable1 = true
      })

      let submitted = (data) => {
        return `${data.submitted}`
      }

      let shortlisted = (data) => {
        return `${data.shortlisted}`
      }

      let rejected = (data) => {
        return `${data.rejected}`
      }

      let jstatus = (data) => {
        if(data.job_status !== null){
          let statusClass = data.job_status.name.replace(/\s+/g, '-').toLowerCase();
          return `<span class="status-cell status-${statusClass}" >${data.job_status.name}</span>`;
        } else {
          return `<span></span>`;
        }
      }

      let amvendor_name = (data) => {
        return `${data.vendor.first_name} ${data.vendor.last_name}`
      }

      let amcompany_name = (data) => {
        return `${data.vendor.company.name}`
      }

      let prevenue = (data) => {
        let userdata = $scope.country
        let revSlot = $scope.revenue_slot
        let prevenue1 = $scope.revenue1
        let prevenue2 = $scope.revenue2
        let prevenue3 = $scope.revenue3

        if(revSlot == 3) {
          return `<i class="fa ${userdata[0].fa_icon_class}"></i> ${prevenue3} - Slot ${revSlot}`
        }
        if(revSlot == 2) {
          return `<i class="fa ${userdata[0].fa_icon_class}"></i> ${prevenue2} - Slot ${revSlot}`
        }
        if(revSlot == 1) {
          return `<i class="fa ${userdata[0].fa_icon_class}"></i> ${prevenue1} - Slot ${revSlot}`
        }
        if(revSlot == 0) {
          return `-`
        }
      }

    //get the assigned candidates list to this job   
    let amassignedcandidates = API.service('adminassignedpendingcandidates', API.all('joborders'))
    
    $scope.items = [ { name: "Accept", id: 31 }, { name: "Duplicate", id: 1 }, { name: "Reject", id: 2 } ]
    $scope.changeStatus = [ { name: "Change status", id: 'changeStatus' }, { name: "Reject", id: 'rejectShorlisted' } ]

    amassignedcandidates.one(joborderId).getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.allprofiles = dataSet;
        
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(job_profile),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(vendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Experience in years').renderWith(exp_years),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(summary),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status).withClass('text-center'),
        ]
        this.displayTable = true
      })

    let job_profile = (data) => {
      return `<a a ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${$scope.joborderId}'})" >${data.candidate.full_name}</a>`;
    } 

    let vendor_name = (data) => {
        return `${data.vendor.first_name} ${data.vendor.last_name}`
    } 

    let exp_years = (data) => {
        if(data.candidate.total_experience_in_year) {
          return `${data.candidate.total_experience_in_year}`
        } else {
          return `Fresher` 
        }
    } 
    let status = (data) => {
      let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
      if(this.joborder.data.status.id != 6){
        return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" data-toggle="modal" data-target="#view_details_modal" ng-mouseover="openTooltip()" title="${data.note}">${data.status.name} <i class="fa fa-comment"></i></span>`;
      } else {
        return `<span class="status-cell status-${statusClass}" >${data.status.name}</span>`;
      }
    }

   /* let summary = (data) => {
        return `${data.candidate.summary.length ==10 }`
    }*/ 
            let summary = (data) => {
            if(data.candidate.edit_summary){
              let string = data.candidate.edit_summary;
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>
               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate_notes.updated_at}(${data.timezone})</p></div>`
               }else{
              let string = data.candidate.summary;
              let ex_string=data.candidate.executive_summary
              string=  string.concat(ex_string)
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>

               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate.updated_at}(${data.timezone})</p></div>`
              }
            }
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      if(data.candidate_status == 19 && $scope.Jobstat != 6){
        return `<select ng-options="item.name for item in items" ng-click="vm.modalOpen(${data.candidate.id}, selected${data.candidate.id})" ng-model="selected${data.candidate.id}"><option value="" selected>Select</option></select>` ;
      } else {
        return `NA`
      }
    }

    $scope.profilesFilterIA=function(){ 
      
      let inactiveCandidates = API.service('admininactivecandidates', API.all('joborders'))

      inactiveCandidates.one(joborderId).getList()
      .then((response) => {
        let dataSet = {}
        dataSet = response.plain()
        $scope.pendingprofiles = dataSet;
        
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(job_profile),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(vendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Experience in years').renderWith(exp_years),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(summary),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status).withClass('text-center'),
        ]
        this.displayTable = true
      })

        let job_profile = (data) => {
          return `<a a ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${$scope.joborderId}' })" >${data.candidate.full_name}</a>`;
        } 

        let vendor_name = (data) => {
          return `${data.vendor.first_name} ${data.vendor.last_name}`
        } 

        let exp_years = (data) => {
            if(data.candidate.total_experience_in_year) {
              return `${data.candidate.total_experience_in_year}`
            } else {
              return `Fresher` 
            }
        } 
        let status = (data) => {
          let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
          //return `<span class="status-cell status-${statusClass}">${data.status.name}</span>`
          if(data.note && $scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" ng-mouseover="openTooltip()" data-toggle="modal" data-target="#view_details_modal" title="${data.note}" data-toggle="tooltip" data-placement="left">${data.status.name} <i class="fa fa-sticky-note"></i></span>`
          } else if($scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" data-toggle="modal" data-target="#view_details_modal">${data.status.name}</span>`
          } else if($scope.Jobstat == 6) {
            return `<span class="status-cell status-${statusClass}">${data.status.name}</span>`            
          }
        } 
       let summary = (data) => {
            if(data.candidate.edit_summary){
              let string = data.candidate.edit_summary;
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>
               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate_notes.updated_at}(${data.timezone})</p></div>`
               }else{
              let string = data.candidate.summary;
              let ex_string=data.candidate.executive_summary
              string=  string.concat(ex_string)
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>

               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate.updated_at}(${data.timezone})</p></div>`
              }
            }
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }

        let actionsHtml = (data) => {
          if(data.candidate_status == 19 && $scope.Jobstat != 6){
            return `<select ng-options="item.name for item in items" ng-click="vm.modalOpen(${data.candidate.id}, selected${data.candidate.id})" ng-model="selected${data.candidate.id}"><option value="" selected>Select</option></select>` ;
          } else {
            return `N/A`
          }
        }// actionHtml

    }

    $scope.profileFilterR=function(){ 
      
      let rejectedCandidates = API.service('adminrejectedcandidates', API.all('joborders'))

      rejectedCandidates.one(joborderId).getList()
      .then((response) => {
        let dataSet = {}
        dataSet = response.plain()
        $scope.rejectedprofiles = dataSet;
        
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(job_profile),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(vendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Experience in years').renderWith(exp_years),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(summary),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status).withClass('text-center'),
        ]
        this.displayTable = true
      })

        let job_profile = (data) => {
          return `<a a ui-sref="app.candidateprofile({candidateId: ${data.candidate.id}, JoborderId: ${joborderId} })" >${data.candidate.full_name}</a>`;
        } 

        let vendor_name = (data) => {
          return `${data.vendor.first_name} ${data.vendor.last_name}`
        }

        let exp_years = (data) => {
            if(data.candidate.total_experience_in_year) {
              return `${data.candidate.total_experience_in_year}`
            } else {
              return `Fresher` 
            }
        } 
        let status = (data) => {
          let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
          if(data.note && $scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" ng-mouseover="openTooltip()" data-toggle="modal" data-target="#view_details_modal" title="${data.note}" data-toggle="tooltip" data-placement="left">${data.status.name} <i class="fa fa-sticky-note"></i></span>`
          } else if( $scope.Jobstat != 6 ){
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" data-toggle="modal" data-target="#view_details_modal">${data.status.name}</span>`
          } else if($scope.Jobstat == 6) {
            return `<span class="status-cell status-${statusClass}">${data.status.name}</span>`            
          }
        } 
       let summary = (data) => {
            if(data.candidate.edit_summary){
              let string = data.candidate.edit_summary;
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>
               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate_notes.updated_at}(${data.timezone})</p></div>`
               }else{
              let string = data.candidate.summary;
              let ex_string=data.candidate.executive_summary
              string=  string.concat(ex_string)
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>

               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate.updated_at}(${data.timezone})</p></div>`
              }
            }
        let actionsHtml = (data) => {
            return `N/A`
        }
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }
    }

    $scope.profileFilterSrt=function(){ 
      
      let shortlistedCandidates = API.service('amshortlistedcandidates', API.all('jobsorders'))

      shortlistedCandidates.one(joborderId).getList()
      .then((response) => {

        let dataSet = {}
        dataSet = response.plain()
        $scope.shortlistedprofiles = dataSet;
        
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(job_profile),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(vendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Experience in years').renderWith(exp_years),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(summary),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status).withClass('text-center'),
        ]
        this.displayTable = true
      })

        let job_profile = (data) => {
          return `<a a ui-sref="app.candidateprofile({candidateId: ${data.numbers.encrypted_canId}, JoborderId: ${$scope.joborderId} })" >${data.candidate.full_name}</a>`;
        } 

        let vendor_name = (data) => {
          return `${data.vendor.first_name} ${data.vendor.last_name}`
        }

        let exp_years = (data) => {
            if(data.candidate.total_experience_in_year) {
              return `${data.candidate.total_experience_in_year}`
            } else {
              return `Fresher` 
            }
        } 
        let status = (data) => {
          let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
          if(data.note && $scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" ng-mouseover="openTooltip()" data-toggle="modal" data-target="#view_details_modal" title="${data.note}" data-toggle="tooltip" data-placement="left">${data.status.name} <i class="fa fa-sticky-note"></i></span>`
          } else if($scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="copyData(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})" data-toggle="modal" data-target="#view_details_modal">${data.status.name}</span>`
          } else if($scope.Jobstat == 6) {
            return `<span class="status-cell status-${statusClass}">${data.status.name}</span>`            
          }
        } 
       let summary = (data) => {
            if(data.candidate.edit_summary){
              let string = data.candidate.edit_summary;
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>
               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate_notes.updated_at}(${data.timezone})</p></div>`
               }else{
              let string = data.candidate.summary;
              let ex_string=data.candidate.executive_summary
              string=  string.concat(ex_string)
              let length = 300;
              var trimmedString = string.substring(0, length);
              var trimmedStrings =(string.replace(/'/g, " "))
              var trimmedStringshow =trimmedString;
              var matchedskills = '';
              var arrayLength = data.skils_block.length;
              if(arrayLength  >2){
                var clickmore ='Read More' ;
                }else{
                      var clickmore ='' ;
                }
                 for(var i=0; i < arrayLength; i++) {
                  matchedskills += `<span ng-mouseover="openTooltip()" title="" data-toggle="tooltip" data-placement="auto" data-original-title="${data.skils_block[i].skill_value}">
                  <span  class="salad">${data.skils_block[i].keyword}</span></span>`
                }
             
                return `${trimmedStringshow}${'...'}<button class="btn btn-primary btn-xs edit_sum" ng-if="${data.candidate_status} !='1' && ${data.candidate_status} !='2' && ${data.candidate_status} !='6' && ${data.candidate_status} !='30'" ng-click="vm.modalNote(${data.candidate_id},'${trimmedStrings}','${data.candidate.full_name}','${data.candidate.updated_at}','${data.timezone}')">Edit</button>

               <br><div class="readmorefor"><div class="restrictheight">`+matchedskills+`</div>
                <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span>
                <p style="font-size: 8px;float: right !important;color: #252525;position: absolute; right:10px; bottom:0px;margin: -9px !important;">Last Updated at:-  ${data.candidate.updated_at}(${data.timezone})</p></div>`
              }
            }
        let actionsHtml = (data) => {
            return `N/A`
        } 
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }

    }
})


      let allLanguages = this.API.service('languages', this.API.all('joborders'))
      allLanguages.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.masterLanguages=dataSet;
    }) 
      $scope.userData = null
      
      ContextService.me(function (data) {
        $scope.userData = data
      })

      $scope.close=function(id){
        //alert(id);
      }

     $scope.copyData=function(a_id,am_id,e_id,v_id,j_id,c_id){
          $scope.admin_id=a_id;
          $scope.accountmanager_id=am_id;
          $scope.employer_id=e_id;
          $scope.vendor_id=v_id;
          $scope.job_id=j_id;
          $scope.candidate_id=c_id;

        let ActivityData = API.service('activitydata', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':$scope.admin_id,
            'accountmanager_id':$scope.accountmanager_id,
            'employer_id':$scope.employer_id,
            'vendor_id':$scope.vendor_id,
            'job_id':$scope.job_id,
            'candidate_id':$scope.candidate_id,
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydata;
          });
     
    }

    $scope.updateStatus=function(){
      $scope.description=$('#description').val();
       $state.go($state.current, {}, { alerts: 'test' })
        let ActivityComment = API.service('activitycommentam', API.all('jobsorders'))
        ActivityComment.post({
            'name': $scope.description,
            'admin_id':$scope.admin_id,
            'accountmanager_id':$scope.accountmanager_id,
            'employer_id':$scope.employer_id,
            'vendor_id':$scope.vendor_id,
            'job_id':$scope.job_id,
            'candidate_id':$scope.candidate_id,
          }).then(function () {
             let ActivityData = API.service('activitydata', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':$scope.admin_id,
            'accountmanager_id':$scope.accountmanager_id,
            'employer_id':$scope.employer_id,
            'vendor_id':$scope.vendor_id,
            'job_id':$scope.job_id,
            'candidate_id':$scope.candidate_id,
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydata;
        $('#description').val('');
          });
          }, function (response) {
            let alert = { type: 'error', msg: 'Data not sent' }
            $state.go($state.current, { alerts: alert})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          })
    } 

    $scope.openTooltip = function() {
      $('[data-toggle="tooltip"]').tooltip();
    }

    $scope.acceptJob=function(id){
        $state.go($state.current, {}, { alerts1: 'test' })
        let vendorJobAlerts1 = API.service('amjobacceptuser-show', API.all('joborders'))
        vendorJobAlerts1.one(id).put()
        .then((response) => {
           let alert = { type: 'success', msg: 'Job has been Accepted.' }
          $state.go($state.current, { alerts1: alert},{reload:true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts1: alert},{reload:true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    }

    $scope.rejectJob=function(id){
      $state.go($state.current, {}, { alerts1: 'test' })
      let vendorJobAlerts1 = API.service('amjobrejectuser-show', API.all('joborders'))
      vendorJobAlerts1.one(id).put()
      .then((response) => {
      let dataSet = response.plain()
        let alert = { type: 'success', msg: 'Job has been Rejected.' }
        $state.go($state.current, { alerts1: alert},{reload:true})
        setTimeout(function(){ $(".alert-success").hide() }, 10000);
      }, (response) => {
        let alert = { type: 'error', msg: response.data.message }
        $state.go($state.current, { alerts1: alert},{reload:true})
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      })
    }

    $scope.reverseObject = function() { 
        $scope.disablesort = 1;
       let reveresedObj = $scope.unsortedTimeline.sort(function(a, b) {
        return b.id - a.id;
      });
       this.timeline = reveresedObj
    }

    $scope.currentVersion = function() {
        $scope.disablesort = 0;
        let reveresedObj = $scope.unsortedTimeline.sort(function(a, b) {
          return a.id - b.id;
        });
        this.timeline = reveresedObj
    }

    $scope.loadTimeline = function(e) {
      toggleOptions($(e.currentTarget).parent());
    }
      var nbOptions = 8;
      // show / hide the options
      var angleStart = -360;

      // jquery rotate animation
      function rotate(li,d) {
          $({d:angleStart}).animate({d:d}, {
              step: function(now) {
                  $(li)
                     .css({ transform: 'rotate('+now+'deg)' })
                     .find('label')
                        .css({ transform: 'rotate('+(-now)+'deg)' });
              }, duration: 0
          });
      }

      function toggleOptions(s) {
          $(s).toggleClass('open');
          var li = $(s).find('li');
          var deg = $(s).hasClass('half') ? 180/(li.length-1) : 360/li.length;
          for(var i=0; i<li.length; i++) {
              var d = $(s).hasClass('half') ? (i*deg)-90 : i*deg;
              $(s).hasClass('open') ? rotate(li[i],d) : rotate(li[i],angleStart);
          }
      }
      $timeout(function() {
          toggleOptions('.special');
      }, 10000);

} //constructor

  delete (joborderId) {
    let API = this.API
    let $state = this.$state
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('joborders').one('joborder', joborderId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'Job Order has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }


  modalOpen (CandidateId, selectedOption, candidateStatusId) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
    $scope.CandidateId = CandidateId
    $scope.selectedOption = selectedOption
    $scope.candidateStatusId = candidateStatusId
    $scope.reasonsSelected = 0
    $scope.reasonsSelectedAs = 0

    if($scope.selectedOption.id == 1) {$scope.modalTitle = 'Duplicate profile'}
    else if ($scope.selectedOption.id == 2) {$scope.modalTitle = 'Reasons to reject'}
    else if ($scope.selectedOption.id == 31) {$scope.modalTitle = 'Accepted'}
    else if ($scope.selectedOption.id == 'changeStatus') {$scope.modalTitle = 'Change Status'}
    else if ($scope.selectedOption.id == 'rejectShorlisted') {$scope.modalTitle = 'Reasons to reject'}
      

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        items: () => {
          return items
        },
        jobCandidateForm: function () {
            return $scope.jobCandidateForm;
        },
        canId: function () {
            return $scope.CandidateId;
        },
        selectedOption: function () {
            return $scope.selectedOption;
        },
        JobOrderId: function () {
            return $scope.joborderId;
        },
        modalTitle: function () {
            return $scope.modalTitle;
        },
        candidateStatusId: function() {
          return $scope.candidateStatusId;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }

  modalcontroller ($scope, $uibModalInstance, items, $state, API, jobCandidateForm, selectedOption, canId, JobOrderId, $filter, modalTitle, candidateStatusId) {
    'ngInject'

    this.items = items
    $scope.jobCandidateForm = jobCandidateForm
    $scope.canId = canId
    $scope.selectedOption = selectedOption
    $scope.modalTitle = modalTitle
    $scope.JobOrderId = JobOrderId
    $scope.candidateStatusId = candidateStatusId
    $scope.masterReasons = null
    $scope.masterrejectAS = null
    $scope.reasonsSelected = 0
    $scope.reasonIdStrings = null
    $scope.reasonsSelectedAs = 0
    $scope.reasonIdAsStrings = null
    $scope.f2fIds  = null
    $scope.phoneIds = null
    $scope.selected = null
    this.selectedshortlistedround = candidateStatusId

      //Get all the reasons to reject if employer wants to reject.
      if($scope.selectedOption.id == 2) { // rejected
        let rejectReasons = API.service('reasontoreject', API.all('joborders'))
        rejectReasons.getList()
          .then((response) => {
              $scope.masterReasons = response.plain()
          })
      } else if ($scope.selectedOption.id == 31 || $scope.selectedOption.id == 'changeStatus') {

        
      } else if($scope.selectedOption.id == 'rejectShorlisted') { // rejected after shortlisted
        let reasontorejectAs = API.service('reasontorejectas', API.all('joborders'))
        reasontorejectAs.getList()
          .then((response) => {
              $scope.masterrejectAS = response.plain()
          })
      }
    
    this.selectedReasons = function () {
        $scope.reasonsSelected = $filter('filter')($scope.masterReasons, {checked: true});
        $scope.reasonIdStrings = String($scope.reasonsSelected.map(function(a) {return a.id;}));
    }

    this.selectedReasonsAs = function () { 
        $scope.reasonsSelectedAs = $filter('filter')($scope.masterrejectAS, {checked: true});
        $scope.reasonsSelectedAsFalse = $filter('filter')($scope.masterrejectAS, {checked: false});

        $scope.reasonIdAsStrings = String($scope.reasonsSelectedAs.map(function(a) {
          if(a.id == 35){$scope.showTA = true;}
          return a.id;
        }));

        $scope.reasonIdAsStringsFalse = String($scope.reasonsSelectedAsFalse.map(function(a) {
          if(a.id == 35){$scope.showTA = false;}
        }));
    }

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item, $scope.selectedOption)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }

    this.save = (isValid) => {
      $state.go($state.current, {}, { alerts: 'test' }, {reload: true})

      if (isValid) {

      if($scope.selectedOption.id == 1){ // Duplicate
        let duplicateJob = API.service('amduplicatejob', API.all('joborders'))
        duplicateJob.post({
          'joborderId': $scope.JobOrderId,
          'note': this.duplicateTA,
          'dupcandId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Profile marked as duplicate.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }
      else if($scope.selectedOption.id == 31){ // Accepted
       
        let duplicateJob = API.service('acceptedprofile', API.all('joborders'))
        duplicateJob.post({
          'joborderId': $scope.JobOrderId,
          'note': this.acceptedTA,
          'dupcandId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Sent profile to employer.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }
      else if($scope.selectedOption.id == 2) { // rejected

        let reasonstoReject = API.service('amreasonstoreject', API.all('joborders'))
        reasonstoReject.post({
          'joborderId': $scope.JobOrderId,
          'reasonIds': $scope.reasonIdStrings,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Profile has been rejected.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }
      else if($scope.selectedOption.id == 31 || $scope.selectedOption.id == 'changeStatus') { // Shortlisted
         
        let shortlistedIds = API.service('shortlistedids', API.all('joborders'))
        shortlistedIds.post({
          'joborderId': $scope.JobOrderId,
          'shortlistIds': this.selectedshortlistedround,
          'shrtListNote': this.shrtListNote,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Candiadate has been shortlisted.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })
      }  

      else if($scope.selectedOption.id == 'rejectShorlisted') { // rejected

        let reasonstoReject = API.service('reasonstorejectas', API.all('joborders'))
        reasonstoReject.post({
          'joborderId': $scope.JobOrderId,
          'reasonIdsAs': $scope.reasonIdAsStrings,
          'note': this.rejectAsNote,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Sent reasons to reject candidate.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })
      }
      } else {
        this.formSubmitted = true
      }
    } //this.save
  }
  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  }
    $onInit(){
      this.duplicateTA = ''
      this.acceptedTA = ''
      this.selectedshortlistedround = ''
      this.shrtListNote = ''
      this.rejectAsNote = ''
    }
}

export const AdminJobViewComponent = {
    templateUrl: './views/app/components/admin-job-view/admin-job-view.component.html',
    controller: AdminJobViewController,
    controllerAs: 'vm',
    bindings: {}
};
