class AmAssignVendorsController{
    constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal 
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    this.alerts = []
 if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
  
   let Joborders = API.service('amassignvendors', API.all('joborders'));
     Joborders.getList()
      .then((response) => {
     
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
        DTColumnBuilder.newColumn('job_id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Experience').renderWith(actionExp),
        /*  DTColumnBuilder.newColumn('created_at').withTitle('Created Date'),*/
         DTColumnBuilder.newColumn(null).withTitle('Job Type').renderWith(actionJobtype).withClass('text-center'),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(actionStatus).withClass('text-center'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().withClass('text-center')
            .renderWith(actionsHtml)
        ]

        this.displayTable = true 
      })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionName = (data) => {
      return `
                <a ui-sref="app.amjobview({joborderId: '${data.numbers.encrypted_jobId}'})">
                   ${data.job_closed.name}
                </a>`
    }
   let actionJobtype = (data) => {
     if(data.job_closed.job_type != null) {
          if(data.job_closed.job_type_new != null){
          return `${data.job_closed.job_type_new}`
          }else{
            return `${data.job_closed.job_type.name}`
          }
        }
          return "";
    }
    let actionExp = (data) => {
       return `${data.job_closed.experience} Years in ${data.job_closed.name} `
    }
    let actionStatus = (data) => {
       let statusClass = data.job_closed.status.name.replace(/\s+/g, '-').toLowerCase();
       return `<span class="status-cell status-${statusClass}">${data.job_closed.status.name}</span>`
    }
   let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" title="View This Job" ui-sref="app.amjobview({joborderId: '${data.numbers.encrypted_jobId}'})">
                    <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>
                &nbsp
                <button class="btn btn-xs" title="Assign to" ng-click="vm.modalOpen(${data.job_id})">
                     <img src="/user_assets/assets/emp_dashboard/plus.svg" width="18" class="img-q">
                </button>`
    }
  }





  delete (joborderId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('joborders').one('joborder', joborderId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'Job Order has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  modalOpen (jobId) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    //let items = this.vendors
    let jobOrderId = jobId
    let API = this.API
    let $state = this.$state

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        // items: () => {
        //   return items
        // },
        jobOrderId: jobOrderId,
        vendorForm: function () {
            return $scope.vendorForm;
        }
      }
    })

    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }
  modalcontroller ($scope, $uibModalInstance, $state, API, vendorForm, jobOrderId) {
    'ngInject'

    //this.items = items
    this.jobOrderId = jobOrderId
    $scope.vendorForm = vendorForm
    // $scope.selected = {
    //   item: items[0]
    // }

    let vendors = API.service('amassignedvendors', API.all('users'))
    vendors.one(jobOrderId).getList()
       .then((response) => {
        this.items = response.plain()
    })


    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }

    this.save = (isValid) => {
      $('.assignBtn').hide();
      $state.go($state.current, {}, { alerts: 'test' })
      if (isValid) {
        let assignJobs = API.service('assignvendors', API.all('joborders'))
        
        assignJobs.post({
          'vendors': this.vendors,
          'jobOrderId': this.jobOrderId
        }).then((response) =>  {
         $uibModalInstance.dismiss('cancel')
          let alert = { type: 'success', msg: 'Job assigned to vendors successfully.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      } else {
        this.formSubmitted = true
      }
    }
  }
  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  }

  swalConfirm () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false
    }, () => {
      swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
    })
  }

  swalBasic () {
    swal("Here's a message!", "It's pretty, isn't it?")
  }

  swalSuccess () {
    swal('Good job!', 'You clicked the button!', 'success')
  }

  swalDecide () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, cancel plx!',
      closeOnConfirm: false,
      closeOnCancel: false
    }, (isConfirm) => {
      if (isConfirm) {
        swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
      } else {
        swal('Cancelled', 'Your imaginary file is safe :)', 'error')
      }
    })
  }

  swalImage () {
    swal({
      title: 'Sweet!',
      text: "Here's a custom image.",
      imageUrl: '/img/avatar5.png'
    })
  }

  swalHtmlMessage () {
    swal({
      title: 'HTML <small>Title</small>!',
      text: 'A custom <span style="color:#F8BB86">html<span> message.',
      html: true
    })
  }

  swalAutoClose () {
    swal({
      title: 'Auto close alert!',
      text: 'I will close in 2 seconds.',
      timer: 2000,
      showConfirmButton: false
    })
  }

  swalPrompt () {
    swal({
      title: 'An input!',
      text: 'Write something interesting:',
      type: 'input',
      showCancelButton: true,
      closeOnConfirm: false,
      animation: 'slide-from-top',
      inputPlaceholder: 'Write something'
    }, (inputValue) => {
      if (inputValue === false)
        return false
      if (inputValue === '') {
        swal.showInputError('You need to write something!')
        return false
      }
      swal('Nice!', 'You wrote: ' + inputValue, 'success')
    })
  }

  swalAjax () {
    let API = this.API

    swal({
      title: 'Ajax request example',
      text: 'Submit to run ajax request',
      type: 'info',
      showCancelButton: true,
      closeOnConfirm: false,
      showLoaderOnConfirm: true
    }, () => {
      let UserData = API.service('me', API.all('users'))

      UserData.one().get()
        .then((response) => {
          let userdata = response.plain()
          swal('Your Name is: ' + userdata.data.name)
        })
    })
  }

    $onInit(){
    }
}

export const AmAssignVendorsComponent = {
    templateUrl: './views/app/components/am-assign-vendors/am-assign-vendors.component.html',
    controller: AmAssignVendorsController,
    controllerAs: 'vm',
    bindings: {}
};
