class AmDashboardController{
  constructor ($scope, $state, AclService, ContextService, API, $compile, DTOptionsBuilder, DTColumnBuilder, $log, $http, $timeout, $interval, $rootScope, $stateParams) {
    'ngInject'
    $scope.labels = ['January', 'February', 'March', 'April', 'May', 'June', 'July']
    $scope.series = ['Series A', 'Series B']
    $scope.tab_value = 1000;
    $scope.data = [
      [65, 59, 80, 81, 56, 55, 40],
      [28, 48, 40, 19, 86, 27, 90]
    ]
      function renderer(api, rowIdx, columns) {
          var data = $.map( columns, function ( col, i ) {
                return col.hidden ?
                '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                    '<span class="dtr-title">'+
                        col.title+
                  '</span> '+
                  '<span class="dtr-data">'+
                      col.data+
                 '</span>'+
                '</li>' : 
             '';
           }).join('');
            var retVal =  data ?
               $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
                false;
                $scope.$digest();
          return retVal;
      }
    $scope.zone_name = new Date().toLocaleTimeString('en-us',{timeZoneName:'short'}).split(' ')[2];
    $scope.reschedule_association_id=null;
    $scope.selectedDateObj=null;
    $scope.reschedule_date=null;
    $scope.pieLabels = ['Download Sales', 'In-Store Sales', 'Mail-Order Sales']
    $scope.pieData = [300, 500, 100]
    $scope.calender_show = false;
    let dashboard = this
    this.API = API
    this.can = AclService.can
    this.$state = $state
    this.$log = $log
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {this.alerts.push($stateParams.alerts)}
    ContextService.me(function (data) {
      dashboard.userData = data
    })
    let hideValue=0;

    $scope.show_calendar = function(){
      $scope.calender_show = true;
    }

    $scope.changeDate = function (data) {
      $scope.reschedule_association_id=data.association_id;
      $scope.employer_id = data.employer_id;
      $scope.candidate_id = data.candidate_id;
      $scope.job_id = data.job_id;
    }

    $scope.onEventSelected = function (event) {
          swal({
            title: event.swal_title,
            text: event.popup_message,
            html: true
          })
    };

    /*let Deviationrequestget = API.service('alldeviationrequests', API.all('joborders'))
    Deviationrequestget.getList()
    .then((response) => {
      dashboard.deviationresponse = response.plain()
    })*/

    let aminterschedule = API.service('aminterschedule', API.all('joborders'))
    aminterschedule.getList()
      .then((response) => {
        let dataSet = response.plain()
        angular.forEach(dataSet, function(value, key) {
          if(value.interview_schedule_date) {
            var mmmmm=new Date(value.interview_schedule_date);
            var pppp=mmmmm.toLocaleString();
            let date_time=value.interview_schedule_date,
            slices = pppp.split(' '),
            date_from_string = slices[0],
            time_from_string = slices[1],
            apm = slices[2],
            date_string_split = date_from_string.split('/'),  
            ms = date_string_split[0],
            ds= date_string_split[1],
            ys = date_string_split[2].replace(",", ''),
            time_string_split=time_from_string.split(':'),
            hs = time_string_split[0].replace(/\b0+/g, ''),
            mins = time_string_split[1].replace(/\b0+/g, '');
            ms = ms-1;
            ds = ds;
           if(apm == "PM"){
              hs = 12+parseInt(hs);
              if(hs == 12){
                hs = 24
              } else if(hs == 24) {
                hs = 12
              }
            } else if(apm == "AM") {
              if(hs == 12){
                hs = 0
              } else if(hs == 24) {
                hs = 12
              }
            }else if(hs == 12 && apm == "AM"){
                hs=0;
            }
            let startTime = new Date(ys, ms, ds, hs, mins),
                endDate = new Date(ys, ms, ds, hs, mins, 59);
            dataSet[key]['startTime']=startTime;
            dataSet[key]['endTime']=endDate;
          }
        });
        $scope.eventSource = dataSet;
        setTimeout(function(){ 
          document.querySelectorAll('.calendar-event-inner').forEach(function (element, index) {
              element.title = element.innerHTML;
              let str = element.innerHTML;
              element.innerHTML = str.substr(0, 20) + "...";
          });
        }, 1000);        
    });

    this.myFunction1=function(){
       let talentpools_data = API.service('talentpoolsdata', API.all('dashboard'))
               talentpools_data.getList()
            .then((response) => {
              dashboard.amDashboardTalentpools = response.plain();
            let dataSet = response.plain()

            this.dtOptions = DTOptionsBuilder.newOptions()
              .withOption('data', dataSet)
              .withOption('createdRow', createdRow)
              .withOption('responsive', {details: {renderer: renderer}})
              .withOption('order', [0, 'desc'])
              .withDisplayLength(50)
              .withBootstrap()
              
            this.dtColumns = [
              DTColumnBuilder.newColumn(null).withTitle('Talentpool Code').notSortable()
                .renderWith(talentpool_code),
                DTColumnBuilder.newColumn(null).withTitle('Talentpool Name').notSortable()
                .renderWith(talentpool_name),
                DTColumnBuilder.newColumn(null).withTitle('Profile Name').notSortable()
                .renderWith(profile_name),
                 DTColumnBuilder.newColumn(null).withTitle('For Job').notSortable()
                .renderWith(job_name),
              DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
                .renderWith(actionsHtml)
            ]

            this.displayTable = true

          })
          let talentpool_name = (data) => {
            return `${data.talentpools.name}</a>`  
          }
          let talentpool_code = (data) => {
            return `${data.talentpools.talentpool_code}</a>`  
          }

          let profile_name = (data) => {
            return `${data.talentpools.resume_name}`  
          }
          let job_name = (data) => {
            return `${data.job.name}`  
          }
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }

        let actionsHtml = (data) => {
          return `<a class="btn btn-xs btn-success">
                        <i class="fa fa-check" title="Submit This Request to Vendor"></i>
                    </a>
                    <a class="btn btn-xs btn-warning">
                        <i class="fa fa-pause" title="Hold This Request to Vendor"></i>
                    </a>
                    <a class="btn btn-xs btn-danger">
                        <i class="fa fa-remove" aria-hidden="true" title="Cancel This Request"></i>
                    </a>
                    `
        }
      var p = document.getElementById("talentpoolsmetrics");
        var y = document.getElementsByClassName("talentpool");
        var z = document.getElementsByClassName("jobs-panel-content");
        if (p.style.display === "block") {
            p.style.display = "none";
            y[0].innerHTML = "Talentpool Requests ("+this.amDashboard.talentpoolreqs+")";
            z[0].style.display = "block";

        } else {
            p.style.display = "block";
            y[0].innerHTML = "Hide Talentpool Dashboard";
            z[0].style.display = "none";
        }
         let amDashboardTlntpoolnumbers = API.service('amtplnumbers', API.all('dashboard'))
        amDashboardTlntpoolnumbers.getList()
          .then((response) => {
            let dataSet = response.plain()
            dashboard.amTlntpoolnumbers=dataSet[0];
        })
    }
      $scope.showDiv=function() {
        var div = document.getElementById("newpost");
        if (div.style.display !== "none") {
            div.style.display = "none";
        }
        else {
           let amBellData = API.service('amnotifications', API.all('dashboard'))
               amBellData.getList()
          .then((response) => {
           let dataSet = response.plain()
            $scope.notificationsData=dataSet;
            dashboard.amDashboard=dataSet[0];
        })
            div.style.display = "block";
        }
      }

      $http({
          method: "get",
          url: '/api/dashboard/lastloginam',
          dataType: 'json',
          ignoreLoadingBar: true
          }).then(function successCallback(response){
            $scope.lastlogin = response.data.data.lastlogin[0].time[1].updated_at;
            $scope.timezone = response.data.data.lastlogin[0].timezone[0].GMT_offset;
    })

        let amDashboard = API.service('amnumbers', API.all('dashboard'))
        amDashboard.getList()
          .then((response) => {
            let dataSet = response.plain()
            dashboard.amDashboard=dataSet[0];
        })

        let amNotes = API.service('amactivitydata', API.all('dashboard'))
        amNotes.getList()
          .then((response) => {
            let dataSet = response.plain()
            dashboard.amNotes = dataSet
              angular.forEach(dashboard.amNotes, function(value, key) {
                let dDate = "\""+value.interview_schedule_date+"\"";
                if(value.interview_schedule_date){
                  value.interview_schedule_date = Date.parse(value.interview_schedule_date);
                var d = new Date(); // for now
                var hours = d.getHours();
                var minutes = d.getMinutes();
                var time = hours+':'+minutes;
                $scope.dateOpts = {
                  enableTime: true,
                  dateFormat: "d-m-Y h:i K",
                  position: "auto",
                  animate: true,
                  minDate: "today",
                  /*minTime: time,*/
                  closeOnSelect: true,
                  static: true,
                  time_24hr: false,
                  onChange: function(selectedDates, dateStr, instance) {
                    $scope.selectedDateObj=dateStr;
                  },
                  onOpen: [
                    function(selectedDates, dateStr, instance){
                      instance.setDate(instance.element.attributes[6].nodeValue);
                      instance.redraw();
                      var existingElem = angular.element(document.getElementsByClassName('flatpickr-button'));
                      existingElem.remove();
                      var newEl = angular.element('<div class="flatpickr-button"><button class="btn btn-default dateSubmit" ng-click="submitNewDate()" type="submit">Submit</button></div>');
                      var pageElement = angular.element(document.getElementsByClassName('flatpickr-calendar open'));
                      pageElement.append(newEl);
                      $compile(pageElement)($scope); // Double compilation
                    }
                  ],
              };
              }
              /*var localTime  = moment.utc(value.updated_at).toDate();
              localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
              value.updated_at=localTime;*/
            }); //angular.forEach
        })

        $scope.submitNewDate = function(){
          $state.go($state.current, {}, { alerts: 'test' },{reload:true})
          let reschedule = API.service('reschedule', API.all('joborders'))
          reschedule.post({
            'newDateTime': $scope.selectedDateObj,
            'assocId': $scope.reschedule_association_id,
            'empId': $scope.employer_id,
            'candId': $scope.candidate_id,
            'joborderId': $scope.job_id
          }).then((response) => {
            let alert = { type: 'success', msg: 'Interview has been rescheduled successfully.'}
            $state.go($state.current, {alerts: alert})
            setTimeout(function(){ $(".alert-success").hide() }, 10000);

          }, function (response) {
            let alert = { type: 'error', msg: response.data.message }
            $state.go($state.current, { alerts: alert})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          });
        };

        $scope.getscheduleTime = function (data,selectedDateObj) {  
         $scope.selectedDateObj = selectedDateObj;
         $scope.reschedule_association_id=data.association_id;
          $scope.employer_id = data.employer_id;
          $scope.candidate_id = data.candidate_id;
          $scope.job_id = data.job_id;
         $scope.submitNewDate();
      }



        /* It fetches all the metric values It will return 16 different values like jobs pending, Profiles rejcted .. etc
            Joborders controller
            amametrics        
        */  

          let ammetrics = API.service('ammetricsall', API.all('joborders'))
          ammetrics.getList()
            .then((response) => { 
              let dataSet = response.plain()
              $scope.ammetrics =dataSet;
               /* $("#myModalData").modal('hide');*/

          })


        let amTopVendors = API.service('amtopvendors', API.all('dashboard'))

        amTopVendors.getList()
          .then((response) => {
            let dataSet = response.plain()
            $scope.vendortops=dataSet.length;
            $scope.labels1 = []
            $scope.data1 = []
            angular.forEach(dataSet, function(item){
               $scope.labels1.push(item.vendor.first_name+" "+item.vendor.last_name)
               $scope.data1.push(item.profiles)
               overrideRotation: 90
              
            });
            
            $scope.colors1 = ['#0266FF']
            $scope.options1 = {
              scales: {
                  xAxes: [{
                              gridLines: {
                                  display:false
                              },
                              ticks: {
                                    autoSkip: false
                              }
                          }],
                  yAxes: [{
                              gridLines: {
                                  display:false
                              },
                              ticks: {
                                 beginAtZero: true,
                                 userCallback: function(label, index, labels) {
                                     // when the floored value is the same as the value we have a whole number
                                     if (Math.floor(label) === label) {
                                         return label;
                                     }

                                 },
                             }   
                          }]
              }
            }
        })
           let amTopVendors_talent = API.service('amtopvendors', API.all('dashboard'))

        amTopVendors_talent.getList()
          .then((response) => {
            let dataSet = response.plain()
            $scope.vendortops=dataSet.length;
            $scope.labels11 = []
            $scope.data11 = []
            angular.forEach(dataSet, function(item){
               $scope.labels11.push(item.vendor.first_name+" "+item.vendor.last_name)
               $scope.data11.push(1);//item.profiles
               overrideRotation: 90
              
            });
            
            $scope.colors1 = ['#0266FF']
            $scope.options1 = {
              scales: {
                  xAxes: [{
                              gridLines: {
                                  display:false
                              },
                              ticks: {
                                    autoSkip: false
                              }
                          }],
                  yAxes: [{
                              gridLines: {
                                  display:false
                              },
                              ticks: {
                                 beginAtZero: true,
                                 userCallback: function(label, index, labels) {
                                     // when the floored value is the same as the value we have a whole number
                                     if (Math.floor(label) === label) {
                                         return label;
                                     }

                                 },
                             }   
                          }]
              }
            }
        })
          $http({
          method: "get",
          url: '/api/dashboard/empsorting',
          dataType: 'json',
          }).then(function successCallback(response){
              $scope.item1=response.data.data.reponceData;
               $('#' +$scope.item1.box_1[0].box_item).attr("data-order",$scope.item1.box_1[0].item_sort);
               $('#' +$scope.item1.box_1[1].box_item).attr("data-order",$scope.item1.box_1[1].item_sort);
               $('#' +$scope.item1.box_1[2].box_item).attr("data-order",$scope.item1.box_1[2].item_sort);
               $('#' +$scope.item1.box_1[3].box_item).attr("data-order",$scope.item1.box_1[3].item_sort);

               $('#' +$scope.item1.box_2[0].box_item).attr("data-order",$scope.item1.box_2[0].item_sort);
               $('#' +$scope.item1.box_2[1].box_item).attr("data-order",$scope.item1.box_2[1].item_sort);

               $('#' +$scope.item1.box_3[0].box_item).attr("data-order",$scope.item1.box_3[0].item_sort);
               $('#' +$scope.item1.box_3[1].box_item).attr("data-order",$scope.item1.box_3[1].item_sort);
               var $sorted_items,
                  getSorted = function(selector, attrName) {
                      return $(
                        $(selector).toArray().sort(function(a, b){
                            var aVal = parseInt(a.getAttribute(attrName)),
                                bVal = parseInt(b.getAttribute(attrName));
                            return aVal - bVal;
                        })
                      );
                  };
                $sorted_items = getSorted('#sortable-wrapper .cal_am', 'data-order');
                var $sorted_charts;
                $sorted_charts = getSorted('#sortable_charts .cal_am1', 'data-order');
                var $sorted_coments;
                $sorted_coments = getSorted('#sotable_recentcoments .cal_am2', 'data-order');


            $('#sortable-wrapper').html( $sorted_items );
            $('#sortable_charts').html( $sorted_charts );
            $('#sotable_recentcoments').html( $sorted_coments );
          });
      $("#sortable-wrapper,#sortable_charts,#sotable_recentcoments").sortable({
        revert: true,
        receive: function(event, ui) {
        },
        update: function(event, ui) {
          var item_sort1 = $("#sortable-wrapper > div").index($("#sortable-wrapper #posted_by_clients"));
          var item_sort2 = $("#sortable-wrapper > div").index($("#sortable-wrapper #employers_am"));
          var item_sort3 = $("#sortable-wrapper > div").index($("#sortable-wrapper #vendors_am"));
          var item_sort4 = $("#sortable-wrapper > div").index($("#sortable-wrapper #arofiles_am"));
          var chart1 = $("#sortable_charts > div").index($("#sortable_charts #chart1"));
          var chart2 = $("#sortable_charts > div").index($("#sortable_charts #chart2"));
          var chart3 = $("#sortable_charts > div").index($("#sortable_charts #chart3"));
          var chart4 = $("#sortable_charts > div").index($("#sortable_charts #chart4"));
          var comments1 = $("#sotable_recentcoments > div").index($("#sotable_recentcoments #performing_vendors"));
          var comments2 = $("#sotable_recentcoments > div").index($("#sotable_recentcoments #recent_coments_am"));
          
             $http({
                method : "POST",
                url : "/api/dashboard/empsortingp",
                data: {sortData: {
                    box1: [
                        {box_no: 1, box_item: 'posted_by_clients', item_sort: item_sort1+1},
                        {box_no: 1, box_item: 'employers_am', item_sort: item_sort2+1},
                        {box_no: 1, box_item: 'vendors_am', item_sort: item_sort3+1},
                        {box_no: 1, box_item: 'arofiles_am', item_sort: item_sort4+1}
                    ],
                    box2: [
                        {box_no: 2, box_item: 'chart1', item_sort: chart1+1},
                        {box_no: 2, box_item: 'chart2', item_sort: chart2+1},
                        {box_no: 2, box_item: 'chart3', item_sort: chart3+1},
                        {box_no: 2, box_item: 'chart4', item_sort: chart4+1}
                    ],
                    box3: [
                        {box_no: 3, box_item: 'performing_vendors', item_sort: comments1+1},
                        {box_no: 3, box_item: 'recent_coments_am', item_sort: comments2+1}
                    ]
                }}


            }).then((response) => {
               
            });
        }
      });
        
      }

      $onInit () { 
        
        $(".main-content").mouseup(function(e)
        {
            var subject = $("#newpost"); 

            if(e.target.id != subject.attr('id') && !subject.has(e.target).length)
            {
                subject.hide();
            }
        });

       
    }

}

export const AmDashboardComponent = {
    templateUrl: './views/app/components/am-dashboard/am-dashboard.component.html',
    controller: AmDashboardController,
    controllerAs: 'vm',
    bindings: {}
};
