class AmProfilesController{
    constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    
    this.$uibModal = $uibModal 
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);
   
    this.alerts = []
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
  
   let Joborders = API.service('amprofiles', API.all('joborders'));
     Joborders.getList()
      .then((response) => {
        console.log(response);  
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
        /*DTColumnBuilder.newColumn('id').withTitle('ID'),*/
           DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(job_profile),
           DTColumnBuilder.newColumn(null).withTitle('Job Title').renderWith(job_name_profile),
        /*  DTColumnBuilder.newColumn('total_experience_in_year').withTitle('Experience (Yr)'),*/
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(returnSkill),
          DTColumnBuilder.newColumn(null).withTitle('Vendor Name').renderWith(vendor),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().withClass('text-center')
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
     
    let job_profile = (data) => {
      if(data.candidate !== null) {
        return `<a ui-sref="app.empcandidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}', candidateStatus: '${data.numbers.encrypted_canStatus}' })" >${data.candidate.full_name}</a>`;
      } else {
        return ` `;
      }
    } 
       let job_name_profile = (data) => {
      if(data.candidate !== null) {
        let a = data.job.name.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
      return `<a ui-sref="app.amjobview({joborderId: '${data.numbers.encrypted_jobId}'})">${a}</a>`
      } else {
        return ` `;
      }
    } 
     let vendor = (data) => {
      return `${data.vendor.first_name}`;
    } 
    let returnSkill = (data) => {
       if (data.candidate != null) {
            if(data.candidate.edit_summary !=null){
          let string = data.candidate.edit_summary;
          let length = 300;
          let trimmedString = string.substring(0, length);
          if(string.length  >300){
                var clickmore ='readmore' ;
            }else{
                  var clickmore ='' ;
            }
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer;">${clickmore}</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
      } else{
          if (data.candidate != null) {
            if (data.candidate.executive_summary != null) {
              var string=data.candidate.executive_summary;
              let length = 300;
              let trimmedString = string.substring(0, length);
              if(string.length  >300){
                var clickmore ='readmore' ;
            }else{
                  var clickmore ='' ;
            }
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer;">${clickmore}</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            } else {
              var string=data.candidate.summary;
              let length = 300;
             let trimmedString = string.substring(0, length);
             if(string.length  >300){
                var clickmore ='readmore' ;
            }else{
                  var clickmore ='' ;
            }
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            }
          } 
      }
            }
            else {
            return `NA`
          }
    }    

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
  return `
                <a class="btn btn-xs" title="View Candidate" ui-sref="app.empcandidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}', candidateStatus: '${data.numbers.encrypted_canStatus}' })">
                    <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>`
    }

    }
  
    $onInit(){
       $(document).on('click', '.readmoreclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
      $(document).on('click', '.readlessclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
    }
}

export const AmProfilesComponent = {
    templateUrl: './views/app/components/am-profiles/am-profiles.component.html',
    controller: AmProfilesController,
    controllerAs: 'vm',
    bindings: {}
};
