class AmRejectedprofilesController{
    constructor ($scope, $stateParams, $state, API, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, AclService, ContextService, $filter, $rootScope, $interval) {
    'ngInject'
    this.$state = $state
    this.API = API
    this.$scope = $scope
    this.$uibModal = $uibModal
    this.$log = $log
    this.animationsEnabled = true
    this.formSubmitted = false
    this.alerts = []

    $scope.items = [ { name: "Accept", id: 31 }, { name: "Duplicate", id: 1 }, { name: "Reject", id: 2 } ]
    $scope.changeStatus = [ { name: "Change status", id: 'changeStatus' }, { name: "Reject", id: 'rejectShorlisted' } ]

    let jobView = this
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    $scope.spanClass = function(name) {
      let statusClass=name.replace(/\s+/g, '-').toLowerCase();
      return statusClass;
    };

   function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
        
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    if ($stateParams.alerts1) {
      this.alerts1.push($stateParams.alerts1)
    }

    ContextService.me(function (data) {
      jobView.loggedInUserData = data
    })
    
    let joborderId = $stateParams.JoborderId;
    $scope.joborderId = $stateParams.JoborderId;

let Decript = API.service('decryption', API.all('joborders'))
  Decript.one(joborderId).get()
  .then((response) => {
    let jobid_split = response.data.decryption;
    let split_arr = jobid_split.split('-');
    joborderId = split_arr[1];

    let rejectedCandidates = API.service('amrejectedcandidates', API.all('jobsorders'))
      rejectedCandidates.one(joborderId).getList()
      .then((response) => {
        let dataSet = {}
        dataSet = response.plain()
        $scope.rejectedProfiles=dataSet
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(job_profile),
          DTColumnBuilder.newColumn(null).withTitle('Vendor').renderWith(vendor_name),
          DTColumnBuilder.newColumn(null).withTitle('Experience in years').renderWith(exp_years),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(summary),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status).withClass('text-center'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').renderWith(actionsHtml)
        ]
        this.displayTable = true
      })

        let job_profile = (data) => {
          return `<a a ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${$scope.joborderId}' })" >${data.candidate.full_name}</a>`;
        } 

        let vendor_name = (data) => {
          return `${data.vendor.first_name} ${data.vendor.last_name}`
        }

        let exp_years = (data) => {
            if(data.candidate.total_experience_in_year) {
              return `${data.candidate.total_experience_in_year}`
            } else {
              return `Fresher` 
            }
        } 
        let status = (data) => {
          let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
          if(data.note && $scope.Jobstat != 6) {
            return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id},${$scope.jobstatusId})" ng-mouseover="openTooltip()" title="${data.note}" data-toggle="tooltip">${data.status.name} <i class="fa fa-sticky-note"></i></span>`
          } else if( $scope.Jobstat != 6 ){
            return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id},${$scope.jobstatusId})">${data.status.name}</span>`
          } else if($scope.Jobstat == 6) {
            return `<span class="status-cell status-${statusClass}">${data.status.name}</span>`            
          }
        } 
        let summary = (data) => {
             if(data.candidate.edit_summary !=null){
          let string = data.candidate.edit_summary;
          let length = 300;
          let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer; display:none;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
       } else{
          if (data.candidate != null) {
            if (data.candidate.executive_summary != null) {
              var string=data.candidate.executive_summary;
              let length = 300;
              let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer; display:none;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            } else {
              var string=data.candidate.summary;
              let length = 300;
             let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor:pointer; display:none;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            }
          } else {
            return `NA`
          }
      }
        }
        let actionsHtml = (data) => {
            return `N/A`
        }
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }

  })

    $scope.openTooltip = function() {
      $('[data-toggle="tooltip"]').tooltip()
    }

    $scope.toggle = true;
    
    $scope.$watch('toggle', function(){
        $scope.toggleText = $scope.toggle ? '(+)' : '(-)';
    })


} //constructor

activityModal (a_id,am_id,e_id,v_id,j_id,c_id,status_id) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
          $scope.admin_id=a_id;
          $scope.accountmanager_id=am_id;
          $scope.employer_id=e_id;
          $scope.vendor_id=v_id;
          $scope.job_id=j_id;
          $scope.candidate_id=c_id;
          $scope.status_id=status_id;
       
    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'activityComments.html',
      controller: this.activityModalcontroller,
      controllerAs: 'activity',
      resolve: {
         items: () => {
          return items
        },
         adminId: function () {
            return $scope.admin_id;
        },
        accountmanagerId: function () {
            return $scope.accountmanager_id;
        },
        employerId: function () {
            return $scope.employer_id;
        },
        vendorId: function () {
            return $scope.vendor_id;
        },
        candidateId: function() {
          return $scope.candidate_id;
        },
        jobId: function() {
          return $scope.job_id;
        },
        statusId: function() {
          return $scope.status_id;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }

   activityModalcontroller ($scope, $uibModalInstance, $state,items, API,adminId,accountmanagerId,employerId,vendorId,candidateId,jobId,statusId,$http) {
    'ngInject'
    this.items = items
    $scope.adminId = adminId
    console.log($scope.adminId);
    let ActivityData = API.service('activitydataam', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':adminId,
            'accountmanager_id':accountmanagerId,
            'employer_id':employerId,
            'vendor_id':vendorId,
            'job_id':jobId,
            'candidate_id':candidateId
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydataam;
          angular.forEach($scope.notes, function (value) {
                var localTime  = moment.utc(value.created_at).toDate();
                localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
                value.created_at=localTime;
              });//angular.forEach
          
          });
    this.updateStatus=function(){
        $state.go($state.current, {}, { alerts: 'test' })
        let ActivityComment = API.service('activitycommentam', API.all('jobsorders'))
        ActivityComment.post({
            'name':this.description,
            'admin_id':adminId,
            'accountmanager_id':accountmanagerId,
            'employer_id':employerId,
            'vendor_id':vendorId,
            'job_id':jobId,
            'candidate_id':candidateId
          }).then(function () {
              document.getElementById('mainInput').value = '';
        let ActivityData = API.service('activitydataam', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':adminId,
            'accountmanager_id':accountmanagerId,
            'employer_id':employerId,
            'vendor_id':vendorId,
            'job_id':jobId,
            'candidate_id':candidateId
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydataam;
          angular.forEach($scope.notes, function (value) {
                var localTime  = moment.utc(value.created_at).toDate();
                localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
                value.created_at=localTime;
              });//angular.forEach
             });

          }, function (response) {
            let alert = { type: 'error', msg: 'Data not sent' }
            $state.go($state.current, { alerts: alert})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
          })
    }//updateStatus
    $(document).ready(function(){
            //dummy random output. You can use api
            $http({
                method: "POST",
                url: '/api/jobsManager/predectivetxet',
                dataType: 'json',
                 data: {'candidate_id':candidateId,'jobid': jobId},
                ignoreLoadingBar: true
              }).then((response) => {
                    $scope.example_new=response.data.data.predectInfo;
                    var example=$scope.example_new;
        function randomobj(obj) {
            var objkeys = Object.keys(obj)
            var str = document.getElementById("mainInput").value;
            var pieces = str.split(" ");
            if(pieces.length >1){
            var laststr =pieces[pieces.length-2];
              if(laststr ==''){
                  laststr =pieces[pieces.length-3];
                  if(laststr ==''){
                  laststr =pieces[pieces.length-4];
                  }
                  if(laststr ==''){
                  laststr =pieces[pieces.length-5];
                  }
                  if(laststr ==''){
                  laststr =pieces[pieces.length-6];
                  }
                  if(laststr ==''){
                  laststr =pieces[pieces.length-7];
                  }
              }

            }else{
              var laststr =pieces[0];
            }
            $scope.laststr=laststr;
            for( var i=0; i < obj.length; i++){
              var str = obj[i];
              var n = str.startsWith(laststr);
              console.log(n,"nnnn");
              // var filterValue = laststr;
              // $scope.result_new = obj[i].filter((obj) => obj.startsWith(laststr));
              if(n){
                return i
                break;
              }
           }
            

        }

        var autocomplete = document.querySelectorAll("#banner-message");
        var mainInput = document.querySelectorAll("#mainInput");
        var foundName = '';
        var predicted = '';
        var apibusy= false;
        var mlresponsebusy = false;

        $('#mainInput').keyup(function(e) {
        //check if null value send
            if (mainInput[0].value == '') {
                autocomplete[0].textContent = '';
                return;
        }
        //check if space key press
            if (e.keyCode == 32) {
                CallMLDataSetAPI(e);
                scrolltobototm();
                return;
        }
        //check if Backspace key press
            if (e.key == 'Backspace'){
                autocomplete[0].textContent = '';
                predicted = '';
                apibusy = true;
                return;
        }
        //check if ArrowRight or Tab key press
            if(e.key != 'ArrowRight'){
                if (autocomplete[0].textContent != '' && predicted){
                    var first_character = predicted.charAt(0);
                    if(e.key == first_character){
                        var s1 = predicted;
                        var s2 = s1.substr(1);
                        predicted = s2;
                        apibusy = true;
                    }else{
                        autocomplete[0].textContent = '';
                        apibusy= false;
                    }
                }else{
                    autocomplete[0].textContent = '';
                    apibusy= false;
                }
                return;
                }else{
                    if(predicted){
                        if (apibusy == true){
                            apibusy= false;
                        }
                        if (apibusy== false){
                            mainInput[0].value = foundName;
                            autocomplete[0].textContent = '';
                        }
                    }else{
                    return;
                }
            }

            function CallMLDataSetAPI(event) {
                var response = {
                "predicted": example[randomobj($scope.example_new)]
                };
                if(response.predicted != ''){
                    predicted = response.predicted;
                    predicted = predicted.replace($scope.laststr,'');
                    
                    var new_text = event.target.value + predicted;
                    autocomplete[0].textContent = new_text;
                    foundName = new_text
                }else{
                    predicted = '';
                    var new_text1 = event.target.value + predicted;
                    autocomplete[0].textContent = new_text1;
                    foundName = new_text1
                }
            };
              });

        });
        $('#mainInput').keypress(function(e) {
            var sc = 0;
            $('#mainInput').each(function () {
                this.setAttribute('style', 'height:' + (0) + 'px;overflow-y:hidden;');
                this.setAttribute('style', 'height:' + (this.scrollHeight+3) + 'px;overflow-y:hidden;');
                sc = this.scrollHeight;
            });
            $('#banner-message').each(function () {
                if (sc <=400){
                    this.setAttribute('style', 'height:' + (0) + 'px;overflow-y:hidden;');
                    this.setAttribute('style', 'height:' + (sc+2) + 'px;overflow-y:hidden;');
                }
            }).on('input', function () {
                this.style.height = 0;
                this.style.height = (sc+2) + 'px';
            });
        });
            function scrolltobototm() {
                var target = document.getElementById('banner-message');
                var target1 = document.getElementById('mainInput');
                setInterval(function(){
                    target.scrollTop = target1.scrollHeight;
                }, 1000);
            };
            $( "#mainInput" ).keydown(function(e) {
                if (e.keyCode === 9) {
                    e.preventDefault();
                    presstabkey();
                }
            });
            function presstabkey() {
                if(predicted){
                    if (apibusy == true){
                        apibusy= false;
                    }
                    if (apibusy== false){
                        mainInput[0].value = foundName;
                        autocomplete[0].textContent = '';
                    }
                }else{
                return;
                }
            };
        });
    this.cancel = () => {
      $uibModalInstance.close()
    }
    this.close = () => {
      $uibModalInstance.dismiss('cancel')
    }
  } 

modalOpen (CandidateId, selectedOption, candidateStatusId) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
    $scope.CandidateId = CandidateId
    $scope.selectedOption = selectedOption
    $scope.candidateStatusId = candidateStatusId
    $scope.reasonsSelected = 0
    $scope.reasonsSelectedAs = 0

    if($scope.selectedOption.id == 1) {$scope.modalTitle = 'Duplicate profile'}
    else if ($scope.selectedOption.id == 2) {$scope.modalTitle = 'Reasons to reject'}
    else if ($scope.selectedOption.id == 31) {$scope.modalTitle = 'Accepted'}
    else if ($scope.selectedOption.id == 'changeStatus') {$scope.modalTitle = 'Change Status'}
    else if ($scope.selectedOption.id == 'rejectShorlisted') {$scope.modalTitle = 'Reasons to reject'}
      

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        items: () => {
          return items
        },
        jobCandidateForm: function () {
            return $scope.jobCandidateForm;
        },
        canId: function () {
            return $scope.CandidateId;
        },
        selectedOption: function () {
            return $scope.selectedOption;
        },
        JobOrderId: function () {
            return $scope.joborderId;
        },
        modalTitle: function () {
            return $scope.modalTitle;
        },
        candidateStatusId: function() {
          return $scope.candidateStatusId;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }

  modalcontroller ($scope, $uibModalInstance, items, $state, API, jobCandidateForm, selectedOption, canId, JobOrderId, $filter, modalTitle, candidateStatusId) {
    'ngInject'

    this.items = items
    $scope.jobCandidateForm = jobCandidateForm
    $scope.canId = canId
    $scope.selectedOption = selectedOption
    $scope.modalTitle = modalTitle
    $scope.JobOrderId = JobOrderId
    $scope.candidateStatusId = candidateStatusId
    $scope.masterReasons = null
    $scope.masterrejectAS = null
    $scope.reasonsSelected = 0
    $scope.reasonIdStrings = null
    $scope.reasonsSelectedAs = 0
    $scope.reasonIdAsStrings = null
    $scope.f2fIds  = null
    $scope.phoneIds = null
    $scope.selected = null
    this.selectedshortlistedround = candidateStatusId

      //Get all the reasons to reject if employer wants to reject.
    
      if($scope.selectedOption.id == 2) { // rejected
        let rejectReasons = API.service('reasontoreject', API.all('joborders'))
        rejectReasons.getList()
          .then((response) => {
              $scope.masterReasons = response.plain()
          })
      } else if ($scope.selectedOption.id == 31 || $scope.selectedOption.id == 'changeStatus') {

        
      } else if($scope.selectedOption.id == 'rejectShorlisted') { // rejected after shortlisted
        let reasontorejectAs = API.service('reasontorejectas', API.all('joborders'))
        reasontorejectAs.getList()
          .then((response) => {
              $scope.masterrejectAS = response.plain()
          })
      }
    
    this.selectedReasons = function () {
        $scope.reasonsSelected = $filter('filter')($scope.masterReasons, {checked: true});
        $scope.reasonIdStrings = String($scope.reasonsSelected.map(function(a) {return a.id;}));
    }

    this.selectedReasonsAs = function () { 
        $scope.reasonsSelectedAs = $filter('filter')($scope.masterrejectAS, {checked: true});
        $scope.reasonsSelectedAsFalse = $filter('filter')($scope.masterrejectAS, {checked: false});

        $scope.reasonIdAsStrings = String($scope.reasonsSelectedAs.map(function(a) {
          if(a.id == 35){$scope.showTA = true;}
          return a.id;
        }));

        $scope.reasonIdAsStringsFalse = String($scope.reasonsSelectedAsFalse.map(function(a) {
          if(a.id == 35){$scope.showTA = false;}
        }));

    }

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item, $scope.selectedOption)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }

    this.save = (isValid) => {
      $state.go($state.current, {}, { alerts: 'test' }, {reload: true})

      if (isValid) {

      if($scope.selectedOption.id == 1){ // Duplicate
       
        let duplicateJob = API.service('amduplicatejob', API.all('joborders'))
        duplicateJob.post({
          'joborderId': $scope.JobOrderId,
          'note': this.duplicateTA,
          'dupcandId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Profile marked as duplicate.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })
      }
      else if($scope.selectedOption.id == 31){ // Accepted
       
        let duplicateJob = API.service('acceptedprofile', API.all('joborders'))
        duplicateJob.post({
          'joborderId': $scope.JobOrderId,
          'note': this.acceptedTA,
          'dupcandId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Sent profile to employer.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }
      else if($scope.selectedOption.id == 2) { // rejected

        let reasonstoReject = API.service('amreasonstoreject', API.all('joborders'))
        reasonstoReject.post({
          'joborderId': $scope.JobOrderId,
          'reasonIds': $scope.reasonIdStrings,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Profile has been rejected.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }
      else if($scope.selectedOption.id == 31 || $scope.selectedOption.id == 'changeStatus') { // Shortlisted
         
        let amShortlistedIds = API.service('amshortlistedids', API.all('joborders'))
        amShortlistedIds.post({
          'joborderId': $scope.JobOrderId,
          'shortlistIds': this.selectedshortlistedround,
          'shrtListNote': this.shrtListNote,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Candiadate has been shortlisted.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })
      }  

      else if($scope.selectedOption.id == 'rejectShorlisted') { // rejected

        let amReasonstoReject = API.service('amreasonstorejectas', API.all('joborders'))
        amReasonstoReject.post({
          'joborderId': $scope.JobOrderId,
          'reasonIdsAs': $scope.reasonIdAsStrings,
          'note': this.rejectAsNote,
          'candId': $scope.canId
        }).then(function () {
          let alert = { type: 'success', msg: 'Sent reasons to reject candidate.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
          $uibModalInstance.dismiss('cancel')
        })

      }

      } else {
        this.formSubmitted = true
      }
    } //this.save
  }

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  }

    $onInit(){
    //   $(document).on('click', '.readmoreclick', function (e) {    
    //   e.preventDefault(); 
    //   $(this).parent().hide();
    //   $(this).parent().siblings().show();
    //   e.stopImmediatePropagation();   
    // });
    //   $(document).on('click', '.readlessclick', function (e) {    
    //   e.preventDefault(); 
    //   $(this).parent().hide();
    //   $(this).parent().siblings().show();
    //   e.stopImmediatePropagation();   
    // });
    }
}

export const AmRejectedprofilesComponent = {
    templateUrl: './views/app/components/am-rejectedprofiles/am-rejectedprofiles.component.html',
    controller: AmRejectedprofilesController,
    controllerAs: 'vm',
    bindings: {}
};
