class AmVendorWorkingController{
    constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal 
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    $rootScope.$broadcast('pageurl', this.$state.current.url);
   
    this.alerts = []
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
  
   let Joborders = API.service('amvendorworking', API.all('joborders'));
     Joborders.getList()
      .then((response) => {
        console.log(response);  
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
        DTColumnBuilder.newColumn('job_id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Experience').renderWith(actionExp),
        /*  DTColumnBuilder.newColumn('created_at').withTitle('Created Date'),*/
         /* DTColumnBuilder.newColumn(null).withTitle('Job Type').renderWith(actionJobtype).withClass('text-center'),*/
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(actionStatus).withClass('text-center'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().withClass('text-center')
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionName = (data) => {
      return `
                <a ui-sref="app.amjobview({joborderId: '${data.numbers.encrypted_jobId}'})">
                   ${data.job.name}
                </a>`
    }
    let actionJobtype = (data) => {
       if(data.job_type != null)
        {return `${data.job_type.name}`}
      else
        {return "";}
    }
    let industryName = (data) => {
       if(data.industry != null)
        {return `${data.industry.name}`}
      else
        {return "";}
     // return `${data.industry.name}`
    }
    let actionExp = (data) => {
       return `${data.job.experience} Yrs of ${data.job.name} `
    }
    let actionStatus = (data) => {
       let statusClass = data.job.status.name.replace(/\s+/g, '-').toLowerCase();
       return `<span class="status-cell status-${statusClass}">${data.job.status.name}</span>`
    }
    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" title="View This Job" ui-sref="app.amjobview({joborderId: '${data.numbers.encrypted_jobId}'})">
                     <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>
                <!--<button class="btn btn-xs" title="Assign to" ng-click="vm.modalOpen(${data.job_id})">
                   <img src="/user_assets/assets/emp_dashboard/plus.svg" width="18" class="img-q">
                </button>-->`
    }
  }
    $onInit(){
    }

}

export const AmVendorWorkingComponent = {
    templateUrl: './views/app/components/am-vendor-working/am-vendor-working.component.html',
    controller: AmVendorWorkingController,
    controllerAs: 'vm',
    bindings: {}
};
