class AmVendorsController{
    constructor($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, $rootScope){
        'ngInject';
        'ngInject'
        this.API = API
        this.$state = $state
        $rootScope.$broadcast('pageurl', this.$state.current.url);

        function renderer(api, rowIdx, columns) {
          var data = $.map( columns, function ( col, i ) {
         return col.hidden ?
             '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                  '<span class="dtr-title">'+
                      col.title+
                '</span> '+
                '<span class="dtr-data">'+
                    col.data+
               '</span>'+
           '</li>' : 
           '';
         }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

        }

        let Users = API.service('amvendors', API.all('users'))
    
        Users.getList()
          .then((response) => {
            let dataSet = response.plain()
            this.dtInstance = {};
            $scope.dtInstance = this.dtInstance
          
            this.dtOptions = DTOptionsBuilder.newOptions()
              .withOption('data', dataSet)
              .withOption('createdRow', createdRow)
              .withOption('responsive', {details: {renderer: renderer}})
              .withOption('order', [0, 'desc'])
              .withDisplayLength(50)
              .withBootstrap()

            this.dtColumns = [
              //DTColumnBuilder.newColumn(null).withTitle('').withOption('className', 'details-control').notSortable().renderWith(expandRow),
              DTColumnBuilder.newColumn('vendor_id').withTitle('ID'),
              DTColumnBuilder.newColumn(null).withOption('width','14%').withTitle('Full Name').renderWith(fullName),
              DTColumnBuilder.newColumn(null).withTitle('Company').renderWith(empCompany),
              /*DTColumnBuilder.newColumn(null).withTitle('Mobile').renderWith(empMobile),
              DTColumnBuilder.newColumn(null).withTitle('Email').renderWith(empEmail),*/
              DTColumnBuilder.newColumn(null).withOption('width','70%').withTitle('Actions').renderWith(viewIcons),
              /*DTColumnBuilder.newColumn(null).withTitle('Jobs').renderWith(JobsIcons),*/
            ]

            this.displayTable = true
          })

        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }

        /*let fullName = (data) => {
          return `${data.vendor.first_name} ${data.vendor.last_name}`
        }
*/       
       let fullName = (data) => {
          if(data.vendor != null){
            return `<span class="expandrow" style="color:#ee0b7d;cursor:pointer;">${data.vendor.first_name} ${data.vendor.last_name}</span>
                <div class="expandedcontent" style="display:none;">
               <div class="col-md-12" style="border-color: coral;">
               <div class="col-md-6"><b>Mobile Number :</b> &nbsp;&nbsp;<i class="fa fa-phone" aria-hidden="true"></i>&nbsp;&nbsp; ${data.vendor.mobile}</div>
               <div class="col-md-6"><b>Email Id : </b> &nbsp;&nbsp;<i class="fa fa-envelope" aria-hidden="true"></i>&nbsp;&nbsp;${data.vendor.email}</div>
               </div>`
          } else {
            return ` `
          }
        }
        let empCompany = (data) => {
           if(data.vendor != null){
          return `${data.vendor.company.name}`
          } else {
            return ` `
          }
        }
 let viewIcons = (data) => {
    if(data.vendor != null){
          return `
<div class="col-md-12  custom-row">
     <div class="block col-xs-12">
        <i class="hovicon small icon8 effect-7 sub-b" ng-mouseover="openTooltip()" title="Selected">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'selected' })" href="#/candidates-selected">
            <img src="img/profile_icons/selected1.svg" >
          </a>
          <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empselectedcandidates}</span>
          </div>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon8 effect-7 sub-b" ng-mouseover="openTooltip()" title="Request Direct Join">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'directjoin' })" href="#/candidates-requestdirectjoin">
            <img src="img/profile_icons/direct-join2.svg" >
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empdirectjoincandidates}</span>
            </div>
          </a>
        </i>
    </div>
    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Telephonic Interview">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'phoneinterview' })" href="#/shortlisted-for-phone">
            <img src="img/profile_icons/phone-interview3.svg" >
             <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empphoneinterviewcandidates}</span>
            </div>
          </a>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Face to Face Interview">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'shortlistftwof' })" href="#/shortlisted-for-f2f">
            <img src="img/profile_icons/face-to-face-interview4.svg">
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empshrtlistcandidates}</span>
            </div>
          </a>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Final Interview">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'finterview' })" href="#/shortlisted-for-final">
            <img src="img/profile_icons/final-interview5.svg">
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empfinalinterviewcandidates}</span>
            </div>
          </a>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Walk In">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'walkin' })" href="#/shortlisted-for-walkin">
            <img src="img/profile_icons/walkin6.svg">
             <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empwailkincandidates}</span>
            </div>
          </a>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Skype Interview">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'skypeinterview' })" href="#/shortlisted-for-skype">
            <img src="img/profile_icons/skype-interview7.svg">
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empskypeinterviewcandidates}</span>
            </div>
          </a>
        </i>
    </div>

    <div class="block col-xs-12">
        <i class="hovicon small icon10 effect-7 sub-b" ng-mouseover="openTooltip()" title="Direct Interview">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'directinterview' })" href="#/shortlisted-for-direct-interview">
            <img src="img/profile_icons/direct-interview8.svg">
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empdirectinterviewcandidates}</span>
            </div>
          </a>
        </i>
    </div>
    <div class="block col-xs-12">
        <i class="hovicon small icon7 effect-7 sub-b" ng-mouseover="openTooltip()" title="Hold">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'hold' })" href="#/candidates-held">
            <img src="img/profile_icons/hold9.svg">
            <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.empholdcandidates}</span>
              </div>
          </a>
        </i>
    </div>

   
    <div class="block col-xs-12">
        <i class="hovicon small icon7 effect-7 sub-b" ng-mouseover="openTooltip()" title="Rejected After Shortlisted">
          <a ui-sref="app.vendorcandidatedetails({vendorId: ${data.vendor.id}, statusname: 'rejectaftshortlist' })" href="#/candidates-rejectedaftershortlisted">
            <img src="img/profile_icons/reject10.svg">
             <div class="mini-stats1" style="padding:0px !important">
                    <span class="pink-skin1">${data.numbers.emprejectaftershortistcandidates}</span>
            </div>
          </a>
        </i>
    </div>

  </div>`
  } else {
            return ` `
          }
        }
        /*let empMobile = (data) => {
          return `${data.vendor.mobile}`
        }

        let empEmail = (data) => {
          return `${data.vendor.email}`
        }*/
        /*let JobsIcons = (data) => {;
          if(data.vendor!=null){
           return `
                <div class="block" >
                     <i class="hovicon small icon7 effect-7 sub-b" ng-mouseover="openTooltip()" title="Jobs">
                       <a ui-sref="app.vendorcandidatedetails({employerId: ${data.vendor.id}, statusname: 'Jobspage' })" href="#/candidates-rejectedaftershortlisted">
                        <img src="img/profile_icons/jobslogo.png" style="width: 26px;">
                        <div class="mini-stats1" style="padding:0px !important;">
                    <span class="pink-skin1" style="width: 29px !important;font-size: 10px !important;">${data.numbers.jobs}</span>
              </div>
                       </a>
                      </i>
                  </div>
           `
          } else {
            return ``
          }
        }
*/

        let expandRow = (data) => {
          return `
                    <a class="btn btn-xs btn-success">
                        <i class="fa fa-plus"></i>
                    </a>`
        }
        
    }

    $onInit(){
       $(document).on('click', '.expandrow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr');
          var content = $(this).parent().parent().find('.expandedcontent').html();
          $('<tr><td colspan="5" style="background-color: #e8c1c1;">'+content+'</td></tr>').insertAfter(tr);
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });

        $(document).on('click', '.deleterow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr').next().remove();;
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });
          
    }
}

export const AmVendorsComponent = {
    templateUrl: './views/app/components/am-vendors/am-vendors.component.html',
    controller: AmVendorsController,
    controllerAs: 'vm',
    bindings: {}
};
