class CandidatelistprofileviewController{
      constructor($scope, $stateParams, $state, API, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, AclService, ContextService, $filter, $rootScope){
        'ngInject';

    this.$state = $state
    this.API = API
    this.$scope = $scope
    this.$uibModal = $uibModal
    this.$log = $log
    this.animationsEnabled = true
    this.formSubmitted = false
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    $scope.myVar = false;
    $scope.myVar1 = true;
    $scope.toggle = function() {
        $scope.myVar = !$scope.myVar;
         $scope.myVar1 = !$scope.myVar1;

    };
    
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    let candidateId = $stateParams.candidateId;
    let jobId = $stateParams.JoborderId;
    let candidateStatus = $stateParams.candidateStatus;
    $scope.candidateId = $stateParams.candidateId;
    $scope.jobId = $stateParams.JoborderId;
    $scope.candidateStatus = $stateParams.candidateStatus;
    console.log($scope.candidateStatus, "200");


    let Candidateshow = API.service('candidatelist-show', API.all('joborders'))
    $state.go($state.current, {}, { alerts: 'test' })
    Candidateshow.one(candidateId).get()
    .then((response) => {
       
        if( (response.data || []).length === 0 ) {
            let alert = { type: 'error', msg: 'Please make sure the candidate is correct or no candidate exists!' }
            $state.go($state.current, { alerts: alert})
            setTimeout(function(){ $(".alert-error").hide() }, 10000);
        } else {
            this.alerts = []
            this.candidate = API.copy(response)
            this.candidate.data.created_at = this.candidate.data.created_at.split(" ")[0]  
            this.filepath = this.candidate.data.asset.url + '/' + this.candidate.data.asset.file_name
            this.filename = this.candidate.data.asset.file_name
        }
      })
    }

    modalOpen (canId, joborderId) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let candidateId = canId
    let jobId = joborderId
    let API = this.API

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: { 
        candidateId: function () {return candidateId;},
        jobId: function () {return jobId;}
       }
    })

    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } // modalopen


modalcontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, candidateId, jobId) {
    'ngInject'
   
    this.$state=$state
    $scope.candidateId = candidateId
    $scope.jobId = jobId
    $scope.assetId = null
    this.alerts = []

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let allCandidateactivity = API.service('allcandidateactivity', API.all('dashboard'))
    allCandidateactivity.post({
      'jobId': $scope.jobId,
      'candidateId': $scope.candidateId
    }).then(function (response) {
          let plainResponse = response.plain();
          let Dbtimeline = plainResponse.data;
            angular.forEach(Dbtimeline, function(value, key) {
              let time = new Date(value.created_at).getTime();
              Dbtimeline[key]['formatted_date'] = time ;
            });
          $scope.timeline = Dbtimeline;
    }, function (data) {
      $uibModalInstance.dismiss('cancel')//Close modal
      let alert = { type: 'error', msg: data.errors.message };
      $state.go($state.current, { alerts: alert});
      setTimeout(function(){ $(".alert-error").hide() }, 10000);
    });

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }
  }//modal controller

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  } 

    swalConfirm () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false
    }, () => {
      swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
    })
  }

  swalBasic () {
    swal("Here's a message!", "It's pretty, isn't it?")
  }

  swalSuccess () {
    swal('Good job!', 'You clicked the button!', 'success')
  }

  swalDecide () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, cancel plx!',
      closeOnConfirm: false,
      closeOnCancel: false
    }, (isConfirm) => {
      if (isConfirm) {
        swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
      } else {
        swal('Cancelled', 'Your imaginary file is safe :)', 'error')
      }
    })
  }

  swalImage () {
    swal({
      title: 'Sweet!',
      text: "Here's a custom image.",
      imageUrl: '/img/avatar5.png'
    })
  }

  swalHtmlMessage () {
    swal({
      title: 'HTML <small>Title</small>!',
      text: 'A custom <span style="color:#F8BB86">html<span> message.',
      html: true
    })
  }

  swalAutoClose () {
    swal({
      title: 'Auto close alert!',
      text: 'I will close in 2 seconds.',
      timer: 2000,
      showConfirmButton: false
    })
  }

  swalPrompt () {
    swal({
      title: 'An input!',
      text: 'Write something interesting:',
      type: 'input',
      showCancelButton: true,
      closeOnConfirm: false,
      animation: 'slide-from-top',
      inputPlaceholder: 'Write something'
    }, (inputValue) => {
      if (inputValue === false)
        return false
      if (inputValue === '') {
        swal.showInputError('You need to write something!')
        return false
      }
      swal('Nice!', 'You wrote: ' + inputValue, 'success')
    })
  }

  swalAjax () {
    let API = this.API

    swal({
      title: 'Ajax request example',
      text: 'Submit to run ajax request',
      type: 'info',
      showCancelButton: true,
      closeOnConfirm: false,
      showLoaderOnConfirm: true
    }, () => {
      let UserData = API.service('me', API.all('users'))

      UserData.one().get()
        .then((response) => {
          let userdata = response.plain()
          swal('Your Name is: ' + userdata.data.name)
        })
    })
  }

    $onInit(){
    }
}
export const CandidatelistprofileviewComponent = {
    templateUrl: './views/app/components/candidatelistprofileview/candidatelistprofileview.component.html',
    controller: CandidatelistprofileviewController,
    controllerAs: 'vm',
    bindings: {}
};
