class CitiesController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

     let Cities = API.service('cities', API.all('locations'))
         Cities.getList()
      .then((response) => {
        let dataSet = response.plain()
        console.log(Cities);
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('ID').renderWith(id),
          DTColumnBuilder.newColumn(null).withTitle('CityName').renderWith(cityName),
          DTColumnBuilder.newColumn(null).withTitle('CityState').renderWith(cityState),
          DTColumnBuilder.newColumn(null).withTitle('Country').renderWith(actionCountry),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    
    
    let id = (data) => {
      return `${data.id}`
    }
    let cityName = (data) => {
      return `${data.cityname}`
    }
    let cityState = (data) => {
      return `${data.citystate}`
    }
    let actionCountry = (data) => {
      return `${data.countryname}`
    }
    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" ui-sref="app.citiedit({cityId: ${data.id}})">
                    <img width="13" src="/user_assets/assets/am-dashboard/edit.svg">
                </a>
                &nbsp
                <!--<button class="btn btn-xs btn-danger" ng-click="vm.delete(${data.id})">
                    <i class="fa fa-trash-o"></i>
                </button>-->`
    }
  }



  delete (countrieId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('locations').one('countries', countrieId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'Countrie has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

    $onInit(){
    }
}

export const CitiesComponent = {
    templateUrl: './views/app/components/cities/cities.component.html',
    controller: CitiesController,
    controllerAs: 'vm',
    bindings: {}
}
