class CountriesController{
   constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    let Countries = this.API.service('locations')

    Countries.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn('name').withTitle('Name'),
          DTColumnBuilder.newColumn('ISD_code').withTitle('ISD Code'),
          DTColumnBuilder.newColumn('currency').withTitle('Currency'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs" ui-sref="app.countriesedit({countrieId: ${data.id}})">
                    <img src="/user_assets/assets/emp_dashboard/edit.svg" width="18" class="img-q">
                </a>
                &nbsp
                <!--<button class="btn btn-xs" ng-click="vm.delete(${data.id})">
                    <img src="/user_assets/assets/emp_dashboard/delete.svg" width="18" class="img-q">
                </button>-->`
    }
  }

  delete (countrieId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('locations').one('countries', countrieId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'Countrie has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

    $onInit(){
    }
}

export const CountriesComponent = {
    templateUrl: './views/app/components/countries/countries.component.html',
    controller: CountriesController,
    controllerAs: 'vm',
    bindings: {}
}
