class CountrieseditController{
    constructor ($stateParams, $state, API, $rootScope) {
    'ngInject'

    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let countryId = $stateParams.countrieId
    let Country = API.service('countries-show', API.all('locations'))
    Country.one(countryId).get()
      .then((response) => {
        this.country = API.copy(response)
      })
  }

  save (isValid) {
    if (isValid) {
      let $state = this.$state
      this.country.put()
        .then(() => {
          let alert = { type: 'success', msg: 'Country has been updated.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 6000);
           setTimeout(function(){ $state.go('app.countries'); }, 7000);
        }, 
        (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

    $onInit(){
    }
}

export const CountrieseditComponent = {
    templateUrl: './views/app/components/countriesedit/countriesedit.component.html',
    controller: CountrieseditController,
    controllerAs: 'vm',
    bindings: {}
}
