class CvsSubmittedController{
    constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
      
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
    let datacvs = API.service('cvssubmited', API.all('dashboard'))
    datacvs.getList()
      .then((response) => {
        let dataSets = response.plain()
        let uniqueIds = new Set();

// Use filter() to remove duplicates based on the 'id' property
   let  dataSet = dataSets.filter((obj) => {
  if (!uniqueIds.has(obj.candidate.email)) {
    uniqueIds.add(obj.candidate.email);
    return true;
  }
  return false;
});
        console.log(dataSet[0]);
        console.log(dataSet[1]);
        console.log(dataSet,'dataset');
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
           DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(actionName), 
           DTColumnBuilder.newColumn(null).withTitle('Job Name').renderWith(actionJobName),
           DTColumnBuilder.newColumn(null).withTitle('Email').renderWith(actionEmail),
           DTColumnBuilder.newColumn(null).withTitle('Description').renderWith(description),
           DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().withClass('text-center')
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
      let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
        }
        let actionName = (data) => {
          if(data !== null) {
           return `<a ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}' })" >${data.candidate.full_name}</a>`
          } else {
            return ` `
          }
        }
        let actionJobName = (data) => {
          let jobname = data.job;
          console.log(jobname,'78-------------')
          if(jobname !=null){
           return `<a ui-sref="app.joborderview({joborderId: '${data.numbers.encrypted_jobId}'})">${jobname.name}</a>`
          }else {
             return `NA`
            }
        }
        let description = (data) => {
          if(data.description != null){
          let string = data.description;
          let length = 300;
          let trimmedString = string.substring(0, length);
            return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor: pointer;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor: pointer;">Read less</span></p>`
        } else { 
          return ` `;
        }
        }
        let actionEmail = (data) => {
          if(data != null){
            return `${data.candidate.email}`
          }else{
           return ` `;
          }
          
       }
        let actionsHtml = (data) => {
          if(data != null){
            return `<a class="btn btn-xs"  title="View This Candidate" ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}' })">
            <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
       </a>       
       `
          }
          else{
            return '';
          }
     
    }
      }


  $onInit () {
    $(document).on('click', '.readmoreclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
      $(document).on('click', '.readlessclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
      $("select").val("50");
  }

}

export const CvsSubmittedComponent = {
    templateUrl: './views/app/components/cvs-submitted/cvs-submitted.component.html',
    controller: CvsSubmittedController,
    controllerAs: 'vm',
    bindings: {}
};
