class EducationQualificationsEditController{
constructor ($stateParams, $state, API, $rootScope) {
    'ngInject'

    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let education_qualificationsId = $stateParams.education_qualificationsId;
    let education_qualifications = API.service('educationqualifications-show', API.all('education_qualifications'))
    education_qualifications.one(education_qualificationsId).get()
      .then((response) => {
        this.education_qualifications = API.copy(response)
      })
  }

  save (isValid) {
  
    if (isValid) {
      let $state = this.$state
      this.education_qualifications.put()
        .then(() => {
          let alert = { type: 'success', msg: 'Education_qualifications has been updated.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

    $onInit(){
    }
}
export const EducationQualificationsEditComponent = {
    templateUrl: './views/app/components/education_qualifications-edit/education_qualifications-edit.component.html',
    controller: EducationQualificationsEditController,
    controllerAs: 'vm',
    bindings: {}
};