class EmpProfilesRejectedController{
    constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal 
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    $rootScope.$broadcast('pageurl', this.$state.current.url);
   
    this.alerts = []
 if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }
  
   let Joborders = API.service('empprofilesrejected', API.all('joborders'));
     Joborders.getList()
      .then((response) => { 
        let dataSet = response.plain()
        console.log(dataSet);
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          /*DTColumnBuilder.newColumn('id').withTitle('ID'),*/
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Experience in Years').renderWith(actionExp),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(actionSummary),
          DTColumnBuilder.newColumn(null).withTitle('Position').renderWith(jobposition),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(statusName),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().withClass('text-center')
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
     
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionName = (data) => {
      if(data.candidate != null){
          return `<a ui-sref="app.empcandidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}', candidateStatus: '${data.numbers.encrypted_canStatus}' })" >${data.candidate.full_name}</a>`;
      } else {
          return ` `
      }
    }
    let actionSummary = (data) => {
      if (data.candidate != null) {
        if (data.candidate.executive_summary != null) {
          return `${data.candidate.executive_summary}`
        } else {
          return `${data.candidate.summary}`
        }
      } else {
        return `NA`
      }
    }

    let jobposition = (data) => {
      if(data.job !== null) {
        if(data.numbers !== null) {
          return `<a ui-sref="app.empjoborderview({joborderId: '${data.numbers.encrypted_jobId}' })" >${data.job.name}</a>`;
        } else {
          return ` `
        }
        
      } else {
        return ` `
      }
    }
    
    let statusName = (data) => {
      if(data.status !=null){
        let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
        if(data.status.description){ return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})">${data.status.description}</span>` }
        else { return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})">${data.status.name}</span>`  }
      } else {
          return `NA`
      }
    } 

    let actionExp = (data) => {
      if(data.candidate != null){
          if(data.candidate.total_experience_in_year != ""){
             return `${data.candidate.total_experience_in_year}`
          }
          else{
             return `0`
          }
      } else {
          return ` `
      }
    }

    let actionsHtml = (data) => {
      if(data.numbers != null){
          return `<a class="btn btn-xs btn-success"  title="View This Candidate" ui-sref="app.empcandidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}', candidateStatus: '${data.numbers.encrypted_canStatus}' })">
                  <i class="fa fa-eye"></i>
                </a>`
      } else {
          return ` `
      }
    }
   
    }

    activityModal (a_id,am_id,e_id,v_id,j_id,c_id) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
          $scope.admin_id=a_id;
          $scope.accountmanager_id=am_id;
          $scope.employer_id=e_id;
          $scope.vendor_id=v_id;
          $scope.job_id=j_id;
          $scope.candidate_id=c_id;

       
    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'activityComments.html',
      controller: this.activityModalcontroller,
      controllerAs: 'activity',
      resolve: {
         items: () => {
          return items
        },
         adminId: function () {
            return $scope.admin_id;
        },
        accountmanagerId: function () {
            return $scope.accountmanager_id;
        },
        employerId: function () {
            return $scope.employer_id;
        },
        vendorId: function () {
            return $scope.vendor_id;
        },
        candidateId: function() {
          return $scope.candidate_id;
        },
        jobId: function() {
          return $scope.job_id;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } //activitymodal

   activityModalcontroller ($scope, $uibModalInstance, $state,items, API,adminId,accountmanagerId,employerId,vendorId,candidateId,jobId) {
    'ngInject'
    this.items = items
    $scope.adminId = adminId
    console.log($scope.adminId);
    let ActivityData = API.service('activitydataam', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':adminId,
            'accountmanager_id':accountmanagerId,
            'employer_id':employerId,
            'vendor_id':vendorId,
            'job_id':jobId,
            'candidate_id':candidateId
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydataam;
          angular.forEach($scope.notes, function (value) {
            var localTime  = moment.utc(value.created_at).toDate();
            localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
            value.created_at=localTime;
          });//angular.forEach
          
          });
      this.updateStatus=function(){
           $state.go($state.current, {}, { alerts: 'test' })
            let ActivityComment = API.service('activitycommentemployer', API.all('jobsorders'))
            ActivityComment.post({
                'name': this.description,
                'admin_id':adminId,
                'accountmanager_id':accountmanagerId,
                'employer_id':employerId,
                'vendor_id':vendorId,
                'job_id':jobId,
                'candidate_id':candidateId
              }).then(function () {
                  document.getElementById('description').value = '';
                  let ActivityData = API.service('activitydataam', API.all('jobsorders'))
                  ActivityData.post({
                      'admin_id':adminId,
                      'accountmanager_id':accountmanagerId,
                      'employer_id':employerId,
                      'vendor_id':vendorId,
                      'job_id':jobId,
                      'candidate_id':candidateId
                    }).then((response) => {
                        let Notes = response.plain()
                        $scope.notes=Notes.data.activitydataam;
                        angular.forEach($scope.notes, function (value) {
                          var localTime  = moment.utc(value.created_at).toDate();
                          localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
                          value.created_at=localTime;
                        });//angular.forEach
                    });
              }, function (response) {
                    let alert = { type: 'error', msg: 'Data not sent' }
                    $state.go($state.current, { alerts: alert},{reload:true})
                    setTimeout(function(){ $(".alert-error").hide() }, 10000);
                  })
    }//updateStatus
    this.cancel = () => {
      $uibModalInstance.close()
    }
    this.close = () => {
      $uibModalInstance.dismiss('cancel')
    }
  } //activity comments Controllercontroller
  
    $onInit(){
    }
}

export const EmpProfilesRejectedComponent = {
    templateUrl: './views/app/components/emp-profiles-rejected/emp-profiles-rejected.component.html',
    controller: EmpProfilesRejectedController,
    controllerAs: 'vm',
    bindings: {}
};
