class EmpSelectedProfilesController{
     constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, API, $stateParams, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    this.animationsEnabled = true
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

   let filterProfilesSelected = API.service('filterprofilesselected', API.all('joborders'))

    filterProfilesSelected.getList()
      .then((response) => {
        console.log(response);
        let filterselectedprofiles = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('stateSave', false)
          .withOption('data', filterselectedprofiles)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          /*DTColumnBuilder.newColumn('id').withTitle('ID'),*/
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Experience in Years').renderWith(actionExp),
          DTColumnBuilder.newColumn(null).withTitle('Summary').renderWith(actionSummary),
          DTColumnBuilder.newColumn(null).withTitle('Position').renderWith(jobposition),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(statusName),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
          .renderWith(actionsHtml)
        ]
        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionName = (data) => {
        if(data.candidate != null){
          return `<a ui-sref="app.empcandidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}', candidateStatus: '${data.numbers.encrypted_canStatus}' })" >${data.candidate.full_name}</a>`;
      } else {
          return ` `
      }
    }
    let actionSummary = (data) => {
        if (data.candidate != null) {
          if (data.candidate.executive_summary != null) {
            return `${data.candidate.executive_summary}`
          } else {
            return `${data.candidate.summary}`
          }
        } else {
          return `NA`
        }
    }

    let jobposition = (data) => {
        if(data.job !== null) {
          if(data.numbers !== null) {
            return `<a ui-sref="app.empjoborderview({joborderId: '${data.numbers.encrypted_jobId}' })" >${data.job.name}</a>`;
          } else {
            return ` `
          }
          
        } else {
          return ` `
        }
    }
    
    let statusName = (data) => {
      if(data.status !=null){
        let statusClass = data.status.name.replace(/\s+/g, '-').toLowerCase();
        if(data.status.description){ return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})">${data.status.description}</span>` }
        else { return `<span class="status-cell status-${statusClass}" ng-click="vm.activityModal(${data.admin_id},${data.accountmanager_id},${data.employer_id},${data.vendor_id},${data.job_id},${data.candidate_id})">${data.status.name}</span>`  }
      } else {
          return `NA`
      }
    } 

    let actionExp = (data) => {
       if(data.candidate != null){
          if(data.candidate.total_experience_in_year != ""){
             return `${data.candidate.total_experience_in_year}`
          }
          else{
             return `0`
          }
      } else {
          return ` `
      }
    }

    let actionsHtml = (data) => {
      if(data.candidate != null){
          return `<a class="btn btn-xs btn-success modalClick" title="See the activity" ng-click="vm.modalOpen(${data.candidate.id}, ${data.job.id})">
                    <i class="fa fa-eye"></i>
                </a>`
      } else {
          return ` `
      }
    }
  } // constructor

  activityModal (a_id,am_id,e_id,v_id,j_id,c_id) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
          $scope.admin_id=a_id;
          $scope.accountmanager_id=am_id;
          $scope.employer_id=e_id;
          $scope.vendor_id=v_id;
          $scope.job_id=j_id;
          $scope.candidate_id=c_id;

       
    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'activityComments.html',
      controller: this.activityModalcontroller,
      controllerAs: 'activity',
      resolve: {
         items: () => {
          return items
        },
         adminId: function () {
            return $scope.admin_id;
        },
        accountmanagerId: function () {
            return $scope.accountmanager_id;
        },
        employerId: function () {
            return $scope.employer_id;
        },
        vendorId: function () {
            return $scope.vendor_id;
        },
        candidateId: function() {
          return $scope.candidate_id;
        },
        jobId: function() {
          return $scope.job_id;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } //activitymodal

   activityModalcontroller ($scope, $uibModalInstance, $state,items, API,adminId,accountmanagerId,employerId,vendorId,candidateId,jobId) {
    'ngInject'
    this.items = items
    $scope.adminId = adminId
    console.log($scope.adminId);
    let ActivityData = API.service('activitydataam', API.all('jobsorders'))
        ActivityData.post({
            'admin_id':adminId,
            'accountmanager_id':accountmanagerId,
            'employer_id':employerId,
            'vendor_id':vendorId,
            'job_id':jobId,
            'candidate_id':candidateId
          }).then((response) => {
          let Notes = response.plain()
          $scope.notes=Notes.data.activitydataam;
          angular.forEach($scope.notes, function (value) {
            var localTime  = moment.utc(value.created_at).toDate();
            localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
            value.created_at=localTime;
          });//angular.forEach
          
          });
      this.updateStatus=function(){
           $state.go($state.current, {}, { alerts: 'test' })
            let ActivityComment = API.service('activitycommentemployer', API.all('jobsorders'))
            ActivityComment.post({
                'name': this.description,
                'admin_id':adminId,
                'accountmanager_id':accountmanagerId,
                'employer_id':employerId,
                'vendor_id':vendorId,
                'job_id':jobId,
                'candidate_id':candidateId
              }).then(function () {
                  document.getElementById('description').value = '';
                  let ActivityData = API.service('activitydataam', API.all('jobsorders'))
                  ActivityData.post({
                      'admin_id':adminId,
                      'accountmanager_id':accountmanagerId,
                      'employer_id':employerId,
                      'vendor_id':vendorId,
                      'job_id':jobId,
                      'candidate_id':candidateId
                    }).then((response) => {
                        let Notes = response.plain()
                        $scope.notes=Notes.data.activitydataam;
                        angular.forEach($scope.notes, function (value) {
                          var localTime  = moment.utc(value.created_at).toDate();
                          localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
                          value.created_at=localTime;
                        });//angular.forEach
                    });
              }, function (response) {
                    let alert = { type: 'error', msg: 'Data not sent' }
                    $state.go($state.current, { alerts: alert},{reload:true})
                    setTimeout(function(){ $(".alert-error").hide() }, 10000);
                  })
    }//updateStatus
    this.cancel = () => {
      $uibModalInstance.close()
    }
    this.close = () => {
      $uibModalInstance.dismiss('cancel')
    }
  } //activity comments Controllercontroller


  modalOpen (canId, joborderId) {

  let $uibModal = this.$uibModal
  let $scope = this.$scope
  let $log = this.$log
  let candidateId = canId
  let jobId = joborderId
  let API = this.API

  var modalInstance = $uibModal.open({
    animation: this.animationsEnabled,
    templateUrl: 'myModalContent.html',
    controller: this.modalcontroller,
    controllerAs: 'mvm',
    resolve: { 
      candidateId: function () {return candidateId;},
      jobId: function () {return jobId;}
     }
  })

  modalInstance.result.then((selectedItem) => {
    $scope.selected = selectedItem
  }, () => {
    $log.info('Modal dismissed at: ' + new Date())
    if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
  })
} // modalopen

modalcontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, candidateId, jobId) {
    'ngInject'
   
    this.$state=$state
    $scope.candidateId = candidateId
    $scope.jobId = jobId
    $scope.assetId = null
    this.alerts = []

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let empCandidateActivity = API.service('empcandidateactivity', API.all('dashboard'))
    empCandidateActivity.post({
      'jobId': $scope.jobId,
      'candidateId': $scope.candidateId
    }).then(function (response) {
          let plainResponse = response.plain();
          let Dbtimeline = plainResponse.data;
            angular.forEach(Dbtimeline, function(value, key) {
              let time = new Date(value.created_at).getTime();
              Dbtimeline[key]['formatted_date'] = time ;
            });
          $scope.timeline = Dbtimeline;
    }, function (data) {
      $uibModalInstance.dismiss('cancel')//Close modal
      let alert = { type: 'error', msg: data.errors.message };
      $state.go($state.current, { alerts: alert});
      setTimeout(function(){ $(".alert-error").hide() }, 10000);
    });

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }
  }//modal controller

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  } 

    swalConfirm () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false
    }, () => {
      swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
    })
  }

  swalBasic () {
    swal("Here's a message!", "It's pretty, isn't it?")
  }

  swalSuccess () {
    swal('Good job!', 'You clicked the button!', 'success')
  }

  swalDecide () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, cancel plx!',
      closeOnConfirm: false,
      closeOnCancel: false
    }, (isConfirm) => {
      if (isConfirm) {
        swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
      } else {
        swal('Cancelled', 'Your imaginary file is safe :)', 'error')
      }
    })
  }

  swalImage () {
    swal({
      title: 'Sweet!',
      text: "Here's a custom image.",
      imageUrl: '/img/avatar5.png'
    })
  }

  swalHtmlMessage () {
    swal({
      title: 'HTML <small>Title</small>!',
      text: 'A custom <span style="color:#F8BB86">html<span> message.',
      html: true
    })
  }

  swalAutoClose () {
    swal({
      title: 'Auto close alert!',
      text: 'I will close in 2 seconds.',
      timer: 2000,
      showConfirmButton: false
    })
  }

  swalPrompt () {
    swal({
      title: 'An input!',
      text: 'Write something interesting:',
      type: 'input',
      showCancelButton: true,
      closeOnConfirm: false,
      animation: 'slide-from-top',
      inputPlaceholder: 'Write something'
    }, (inputValue) => {
      if (inputValue === false)
        return false
      if (inputValue === '') {
        swal.showInputError('You need to write something!')
        return false
      }
      swal('Nice!', 'You wrote: ' + inputValue, 'success')
    })
  }

  swalAjax () {
    let API = this.API

    swal({
      title: 'Ajax request example',
      text: 'Submit to run ajax request',
      type: 'info',
      showCancelButton: true,
      closeOnConfirm: false,
      showLoaderOnConfirm: true
    }, () => {
      let UserData = API.service('me', API.all('users'))

      UserData.one().get()
        .then((response) => {
          let userdata = response.plain()
          swal('Your Name is: ' + userdata.data.name)
        })
    })
  }

    $onInit(){ }
}

export const EmpSelectedProfilesComponent = {
    templateUrl: './views/app/components/emp-selected-profiles/emp-selected-profiles.component.html',
    controller: EmpSelectedProfilesController,
    controllerAs: 'vm',
    bindings: {}
};
