class EmpTalentpoolDashboardController{
    constructor ($scope, $state, AclService, ContextService, API, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, $rootScope) {

    'ngInject'
     
    let dashboard = this
    this.API = API
    this.can = AclService.can
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    $scope.eventSource = null

    $scope.onEventSelected = function (event) {
          swal({
            title: event.swal_title,
            text: event.popup_message,
            html: true
          })
    };

    let empinterschedule = API.service('empinterschedule', API.all('talentpools'))
    empinterschedule.getList()
      .then((response) => {
        let dataSet = response.plain()
        angular.forEach(dataSet, function(value, key) {
          if(value.interview_schedule_date) {
            let date_time=value.interview_schedule_date,
            slices = date_time.split(' '),
            date_from_string = slices[0],
            time_from_string = slices[1],
            apm = slices[2],
            date_string_split = date_from_string.split('-'),
            ds = date_string_split[0].replace(/\b0+/g, ''),
            ms = date_string_split[1].replace(/\b0+/g, ''),
            ys = date_string_split[2].replace(/\b0+/g, ''),
            time_string_split=time_from_string.split(':'),
            hs = time_string_split[0].replace(/\b0+/g, ''),
            mins = time_string_split[1].replace(/\b0+/g, '');
            ms = ms-1;
            ds = ds-1;
            if(apm == "PM"){hs = 12+parseInt(hs);}
            let startTime = new Date(ys, ms, ds, hs, mins),
            endDate = new Date(ys, ms, ds, hs, 59);
            dataSet[key]['startTime']=startTime;
            dataSet[key]['endTime']=endDate;
          }
        });

        $scope.eventSource = dataSet;
         setTimeout(function(){ 
          document.querySelectorAll('.calendar-event-inner').forEach(function (element, index) {
              element.title = element.innerHTML;
              let str = element.innerHTML;
              element.innerHTML = str.substr(0, 20) + "...";
          });
        }, 1000);
        
    });

    $rootScope.$broadcast('pageurl', this.$state.current.url);
    
    ContextService.me(function (data) {
      dashboard.userData = data
    })
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    let empMetrics = API.service('empmetricsno', API.all('talentpools'))
    empMetrics.getList()
      .then((response) => { 
        let dataSet = response.plain()
        $scope.empmetrics =dataSet[0];
        $("#myModalData").modal('show');
    })
    let inActiveJobAlerts = API.service('inprogresstalentpooljobs', API.all('joborders'))
    inActiveJobAlerts.getList()
      .then((response) => { 
        let dataSet = response.plain()
        dashboard.inActiveJobAlerts=dataSet;
        $scope.job_notifications = dashboard.inActiveJobAlerts[0]['numbers']['job_notifications'];
    })
    let team = API.service('employerusers', API.all('users'))
    team.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.team=dataSet;
    })
    let empDashboard = API.service('emptalentpoolnumbers', API.all('dashboard'))
    empDashboard.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.empDashboard=dataSet[0]
        $scope.pieLabels1 = ['Total No. of Jobs,Ordered','No. of Closed,Jobs']
        $scope.pieData1 =   [dashboard.empDashboard.jobs,dashboard.empDashboard.jobsclosed]
        $scope.pieColors1 = ['#dddddd','#ff8b31']
        $scope.pieLabels2 = ['No. of Profiles,Interviewed','No. of Profiles,Rejected']
        $scope.pieData2 =   [dashboard.empDashboard.candidates,dashboard.empDashboard.candidatesinvalid]
        $scope.pieColors2 = ['#407fc5','#dddddd']
    })
    let empRatios = API.service('emptalenpoolratios', API.all('dashboard'))
    empRatios.getList()
      .then((response) => {
        $scope.ratioResponse = response.plain()
        $scope.pieLabels3 = ['No. of Job Orders,Posted','No. of Profiles,Received']
        $scope.pieData3 =   [$scope.ratioResponse[0].totalJobsCount,$scope.ratioResponse[0].submittedProfiles]
        $scope.pieColors3 = ['#dddddd','#ff6b6b']
        $scope.pieLabels4 = ['No. of Jobs,Closed','No. of Job Orders,Posted']
        $scope.pieData4 =   [$scope.ratioResponse[0].jobsclosed,$scope.ratioResponse[0].totalJobsCount]
        $scope.pieColors4 = ['#6bffca','#dddddd']
        $scope.pieLabels5 = ['No. of Profiles,Promised in 3:1,ratio','No. of Profiles,Submitted']
        $scope.pieData5 =   [$scope.ratioResponse[0].jobmaxprofiles,$scope.ratioResponse[0].noofprofiles]
        $scope.pieColors5 = ['#dddddd','#9c27b0']
        $scope.pieLabels6 = ['No. of Profiles,Interviewed ','No. of Profiles,Submitted']
        $scope.pieData6 =   [$scope.ratioResponse[0].interviwedProfiles,$scope.ratioResponse[0].noofprofiles]
        $scope.pieColors6 = ['#fbff57','#dddddd']  
        $scope.optionsDought = { 
            tooltips: {
              enabled: true,
              displayColors: false,
              showAllTooltips: true,
              mode: 'single',
              bodyFontColor: '#fff',
              backgroundColor: 'rgba(0,0,0,0.4)',
              bodyFontStyle: 'Bold',
              fullWidth: true,
                callbacks: {
                  label: function(tooltipItem, data) {
                    var arrayy = [];
                    var label = data.labels[tooltipItem.index];
                    arrayy = label.split(',');
                    var datasetLabel = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                    if(arrayy[2]) { return [arrayy[0], arrayy[1], arrayy[2]+':'+datasetLabel];}
                     else {return [arrayy[0], arrayy[1]+':'+datasetLabel];  }
                    
                  }
                } //callbacks              
            }
        };

        $scope.options = { 
            tooltips: {
              enabled: true,
              displayColors: false,
              showAllTooltips: true,
              mode: 'single',
              bodyFontColor: '#fff',
              bodyFontSize: 13,
              backgroundColor: 'rgba(0,0,0,0.4)',
              bodyFontStyle: 'Bold',
              fullWidth: true,
                callbacks: {
                  label: function(tooltipItem, data) {
                    var arrayy = [];
                    var label = data.labels[tooltipItem.index];
                    arrayy = label.split(',');
                    var datasetLabel = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                    if(arrayy[2]) { return [arrayy[0], arrayy[1], arrayy[2]+':'+datasetLabel];}
                     else {return [arrayy[0], arrayy[1]+':'+datasetLabel];  }
                    
                  }
                } //callbacks
            }
        };
    });

    let empNotes = API.service('activitytalentpooldata', API.all('dashboard'))
    empNotes.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.empNotes = dataSet
        $("#myModalData").modal('hide');
    })

      var toggled;
      $scope.expandtoggle = function(e) {
          if($(e.currentTarget).hasClass('showing')) {
            toggled = true;
          } else {
            toggled = false;
          }
          $scope[toggled ? "deleterow" : "expandrow"](e);
      };

      $scope.expandrow = function (e) {
        var clientinfo = $(e.currentTarget).closest('.client-info');
        $(e.currentTarget).addClass('showing');
        var content = $(e.currentTarget).parent().parent().find('.fade-in').html();
        $('<div>'+content+'</div>').insertAfter(clientinfo);
      };

      $scope.deleterow = function (e) {
        $(e.currentTarget).removeClass('showing');
         var clientinfo = $(e.currentTarget).closest('.client-info').next().remove();;
      };

    $scope.openTooltip = function() {
      $('[data-toggle="tooltip"]').tooltip()
    }
  }
 modalOpen (accepted, pending, closedjobs ) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let jobsaccepted = accepted
    let jobspending = pending
    let closedJobs = closedjobs
    let API = this.API

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: { 
        jobsaccepted: function () {return jobsaccepted;},
        jobspending: function () {return jobspending;},
        closedJobs: function () {return closedJobs;}
       }
    })

    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } // modalopen


modalcontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, jobsaccepted, jobspending, closedJobs) {
    'ngInject'
   
    this.$state=$state
    $scope.jobsaccepted = jobsaccepted;
    $scope.jobspending = jobspending;
    $scope.closedJobs = closedJobs;
    $scope.assetId = null
    this.alerts = []

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }


    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }
  }//modal controller

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  } 
  $onInit () {}
}
export const EmpTalentpoolDashboardComponent = {
    templateUrl: './views/app/components/emp-talentpool-dashboard/emp-talentpool-dashboard.component.html',
    controller: EmpTalentpoolDashboardController,
    controllerAs: 'vm',
    bindings: {}
};
