class EmpTeamDashboardController{
    constructor ($scope, $state, AclService, ContextService, API, $compile, DTOptionsBuilder, DTColumnBuilder, $log, $rootScope) {
    'ngInject'
  
    let dashboard = this
    this.API = API
    this.can = AclService.can
    this.$state = $state
    this.$log = $log
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    
    ContextService.me(function (data) {
      dashboard.userData = data
    })

    let inActiveJobAlerts = API.service('inprogressjobs', API.all('joborders'))
        inActiveJobAlerts.getList()
          .then((response) => { 
            let dataSet = response.plain()
            dashboard.inActiveJobAlerts=dataSet;
        })

    let empDashboard = API.service('empnumbers', API.all('dashboard'))
    empDashboard.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.empDashboard=dataSet[0]
        $scope.pieLabels1 = ['Total Jobs','Closed Jobs']
        $scope.pieData1 =   [dashboard.empDashboard.jobs,dashboard.empDashboard.jobsclosed]
        $scope.pieColors1 = ['#dddddd','#ff8b31']
        $scope.pieLabels2 = ['Interviewed','Rejected']        
        $scope.pieData2 =   [dashboard.empDashboard.candidates,dashboard.empDashboard.candidatesinvalid]
        $scope.pieColors2 = ['#407fc5','#dddddd']
    })

    let empRatios = API.service('empratios', API.all('dashboard'))
    empRatios.getList()
      .then((response) => {
        $scope.ratioResponse = response.plain()

        $scope.pieLabels3 = ['No. of Job Orders,Posted','No. of Profiles,Received']
        $scope.pieData3 =   [$scope.ratioResponse[0].totalJobsCount,$scope.ratioResponse[0].submittedProfiles]
        $scope.pieColors3 = ['#dddddd','#ff6b6b']
        $scope.pieLabels4 = ['No. of Jobs,Closed','No. of Job Orders,Posted']
        $scope.pieData4 =   [$scope.ratioResponse[0].jobsclosed,$scope.ratioResponse[0].totalJobsCount]
        $scope.pieColors4 = ['#6bffca','#dddddd']
        $scope.pieLabels5 = ['No. of Profiles,Promised in 3:1,ratio','No. of Profiles,Submitted']
        $scope.pieData5 =   [$scope.ratioResponse[0].jobmaxprofiles,$scope.ratioResponse[0].noofprofiles]
        $scope.pieColors5 = ['#dddddd','#9c27b0']
        $scope.pieLabels6 = ['No. of Profiles,Interviewed ','No. of Profiles,Submitted']
        $scope.pieData6 =   [$scope.ratioResponse[0].interviwedProfiles,$scope.ratioResponse[0].noofprofiles]
        $scope.pieColors6 = ['#fbff57','#dddddd']  

         
        $scope.optionsDought = { 
            tooltips: {
              enabled: true,
              displayColors: false,
              showAllTooltips: true,
              mode: 'single',
              bodyFontColor: '#fff',
              backgroundColor: 'rgba(0,0,0,0.4)',
              bodyFontStyle: 'Bold',
              fullWidth: true,
                callbacks: {
                  label: function(tooltipItem, data) {
                    var arrayy = [];
                    var label = data.labels[tooltipItem.index];
                    arrayy = label.split(',');
                    var datasetLabel = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                    if(arrayy[2]) { return [arrayy[0], arrayy[1], arrayy[2]+':'+datasetLabel];}
                     else {return [arrayy[0], arrayy[1]+':'+datasetLabel];  }
                    
                  }
                } //callbacks              
            }
        };

        $scope.options = { 
            tooltips: {
              enabled: true,
              displayColors: false,
              showAllTooltips: true,
              mode: 'single',
              bodyFontColor: '#fff',
              bodyFontSize: 13,
              backgroundColor: 'rgba(0,0,0,0.4)',
              bodyFontStyle: 'Bold',
              fullWidth: true,
                callbacks: {
                  label: function(tooltipItem, data) {
                    var arrayy = [];
                    var label = data.labels[tooltipItem.index];
                    arrayy = label.split(',');
                    var datasetLabel = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
                    if(arrayy[2]) { return [arrayy[0], arrayy[1], arrayy[2]+':'+datasetLabel];}
                     else {return [arrayy[0], arrayy[1]+':'+datasetLabel];  }
                    
                  }
                } //callbacks
            }
        };


    });

    let empNotes = API.service('activitydata', API.all('dashboard'))
    empNotes.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.empNotes = dataSet
    })
  }
  $onInit () {}
}

export const EmpTeamDashboardComponent = {
    templateUrl: './views/app/components/emp-team-dashboard/emp-team-dashboard.component.html',
    controller: EmpTeamDashboardController,
    controllerAs: 'vm',
    bindings: {}
};
