class EmpgdprdetailsController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder,$timeout, API,$rootScope,$stateParams,ContextService ) {
    'ngInject'
    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    let loggedinUser = this
    ContextService.me(function (data) {
      loggedinUser.userData = data;
      //console.log(data.user.first_name,"6");
      $scope.employer_name=data.user.first_name;
    })
    
    function renderer(api, rowIdx, columns) {
      var data = $.map( columns, function ( col, i ) {
      return col.hidden ?
              '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                  '<span class="dtr-title">'+
                    col.title+
                  '</span> '+
                  '<span class="dtr-data">'+
                    col.data+
                  '</span>'+
              '</li>' : '';
      }).join('');
      var retVal =  data ?
      $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) : false;
      $scope.$digest();
      return retVal;
    }

    $scope.dateOpts = {
        defaultDate: $scope.selectedDateObj,
        enableTime: true,
        dateFormat: "d-m-Y h:i K",
        minDate: "today",
        defaultHour: "00:00",
        defaultMinute: "00",
        position: "below",
        animate: true,
        static: true,
        time_24hr: false,
        onChange: function(selectedDates, dateStr, instance){
          $scope.selectedDateObj = dateStr;

          var slices = dateStr.split(' ');
          $scope.scheduleDate=slices[0];
          $scope.scheduleTime = slices[1];
          $scope.candidateInterviewDate = dateStr;
        }
    };
    this.callMe=function(id){
      $state.go($state.current, {}, { alerts: 'test' })
      let resendEmail = API.service('resendemail', API.all('joborders')) 
      resendEmail.one(id).put()
      .then((response) => {
         let alert = { type: 'success', msg: 'Email Sent successfully.' }
        $state.go($state.current, { alerts: alert},{reload:true})
        setTimeout(function(){ $(".alert-success").hide() }, 10000);
        //$state.go('app.vassignedjobs');
      }, (response) => {
        let alert = { type: 'error', msg: response.data.message }
        $state.go($state.current, { alerts: alert},{reload:true})
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      })
    }
    let Gdpr_Data = API.service('empgdprdata', API.all('joborders'))
    Gdpr_Data.getList()
    .then((response) => {
      let dataSet = response.plain()
      //console.log(dataSet.numbers.empgdprdata.length, 'DivyaNagendra')
      $scope.gdpr_form_data=API.copy(response);
      this.dtOptions = DTOptionsBuilder.newOptions()
        .withOption('data', dataSet)
        .withOption('createdRow', createdRow)
        .withOption('responsive', {details: {renderer: renderer}})
        .withBootstrap()
      this.dtColumns = [
        DTColumnBuilder.newColumn(null).withOption('width','18%').withTitle('Position').renderWith(job_name),
        DTColumnBuilder.newColumn(null).withOption('width','18%').withTitle('Candidate Name').renderWith(candidate_name),
        //DTColumnBuilder.newColumn(null).withOption('width','18%').withTitle('Vendor').renderWith(vendor_name),
        DTColumnBuilder.newColumn(null).withOption('width','18%').withTitle('Candidate Mobile').renderWith(candidate_mobile),
        DTColumnBuilder.newColumn(null).withOption('width','18%').withTitle('Candidate Email').renderWith(candidate_email),
        DTColumnBuilder.newColumn(null).withOption('width','15%').withTitle('Consent status').renderWith(cons_status),
        DTColumnBuilder.newColumn(null).withTitle('Retention Period').renderWith(retention_period),
        DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().renderWith(actionsHtml)
      ]
      this.displayTable = true
    })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let job_name = (data) => {
      if(data.numbers.empgdprdata.length == 0) {
        return `NA`
      } else {
        return `${data.numbers.empgdprdata[0].job.name}`
      }
    }
    let candidate_name = (data) => {
      if (data.numbers.empgdprdata.length >0) {
        if((data.candidate_status >= 9 && data.candidate_status <=18) || (data.candidate_status >= 20 && data.candidate_status <= 23) || data.candidate_status ==27 ){
          return `${data.numbers.empgdprdata[0].name}`
        } else{
          var name = data.numbers.empgdprdata[0].name;
            var hiddenname = "";
            var i=0;
            var name_len=name.length-2;
            for (i = 0; i < name.length; i++) {
              if (i > 1 && i < name_len) {
                hiddenname += "*";
              } else {
                hiddenname += name[i];
              }
            }
            return `${hiddenname}`
        }
      } else {
        return `NA`
      }
        //return `${data.candidate.full_name}`
    }
    let candidate_mobile = (data) => {
      if (data.numbers.empgdprdata.length >0) {
        var mobile = data.numbers.empgdprdata[0].candidate_no;
        var hiddenmobile = "";
        var i=0;
        for (i = 0; i < mobile.length; i++) {
          if (i > 2) {
            hiddenmobile += "*";
          } else {
            hiddenmobile += mobile[i];
          }
        }
        return `${hiddenmobile}`
      } else {
        return `NA`
      }
       // return `${data.candidate.phone}`
    }
    let candidate_email = (data) => {
      if (data.numbers.empgdprdata.length >0) {
        var candi_email=data.numbers.empgdprdata[0].candidate_email;
        var email = data.numbers.empgdprdata[0].candidate_email;
        var hiddenEmail = "";
        var i=0;
        for (i = 0; i < email.length; i++) {
          if (i > 2) {
            hiddenEmail += "*";
          } else {
            hiddenEmail += email[i];
          }
        }
        return `${hiddenEmail}`
      } else {
        return `NA`
      }
    }
    /* let vendor_name = (data) => {
        return `${data.vendor.first_name} ${data.vendor.last_name}`
    }*/
    let cons_status = (data) => {
        return `<span class="btn btn-xs btn-success" style="padding-right: 10px;padding-left: 10px;padding-top: 5px;padding-bottom: 5px;cursor: initial;">Success</span>`
    }

     let retention_period = (data) => {
      if(data.numbers.empgdprdata.length == 0) {
        return `NA`
      } else {
        if(data.numbers.empgdprdata[0].status == "0" || data.numbers.empgdprdata[0].status == "2"){
          return `N/A`}
        else{
          return `${data.numbers.empgdprdata[0].agreed_period}`
        }
      }
    }
    let actionsHtml = (data) => {
      if(data.numbers.empgdprdata.length == 0) {
        return `NA`
      } else {
        if(data.candidate_status >=9 && data.candidate_status <=28){
            return `<a class="btn btn-xs w_p" style="float: left; width: 50%;" title="View This GDPR/ROR" ui-sref="app.vendorgdprresultview({gdprId: ${data.numbers.empgdprdata[0].id}, flag: 1 })">
                  <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>
                <span ng-if="${data.candidate_status } >= 9 && ${data.candidate_status } <= 28"><a ng-show="${data.numbers.empgdprdata[0].status } == 1 || ${data.numbers.empgdprdata[0].status } == 2" class="btn btn-xs w_p" style="float: left; width: 50%;" title="Download GDPR/ROR Result" ng-click='getDta(${data.numbers.empgdprdata[0].id})' data-jobId="${data.numbers.empgdprdata[0].id}" type="button" id="printotcartd" class="btn"><img src="/user_assets/assets/emp_dashboard/download.svg" width="18" class="img-q"></a></span>`
        }else{
        return `<a class="btn btn-xs w_p" style="float: left; width: 50%;" title="View This GDPR/ROR" ui-sref="app.vendorgdprresultview({gdprId: ${data.numbers.empgdprdata[0].id}, flag: 0 })">
                  <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>`
        }
      }
    }
    $scope.getDta=function(id){
      let form_data =  API.service('gdpriddata', API.all('guests'))
      form_data.one(id).get()
      .then((response) => {
        $scope.a = API.copy(response);
        //console.log($scope.a.data[0].updated_at,"15");
        var localTime  = moment.utc($scope.a.data[0].updated_at).toDate();
        localTime = moment(localTime).format('YYYY-MM-DD HH:mm:ss');
        $scope.a.data[0].updated_at=localTime;
        $scope.name_can=$scope.a.data[0].name;
        /*var name = $scope.name_can;
        var hiddenname = "";
        var i=0;
        var name_len=name.length-2;
        for (i = 0; i < name.length; i++) {
          if (i > 2 && i < name_len) {
            hiddenname += "*";
          } else {
            hiddenname += name[i];
          }
        }
        $scope.name_can=hiddenname;*/
        $scope.email_can=$scope.a.data[0].candidate_email;
        var email = $scope.email_can;
        var hiddenEmail = "";
        var i=0;
        for (i = 0; i < email.length; i++) {
          if (i > 2) {
            hiddenEmail += "*";
          } else {
            hiddenEmail += email[i];
          }
        }
        $scope.email_can=hiddenEmail;
        $scope.mobile_can=$scope.a.data[0].candidate_no;
        var mobile = $scope.mobile_can;
        var hiddenmobile = "";
        var i=0;
        for (i = 0; i < mobile.length; i++) {
          if (i > 2) {
            hiddenmobile += "*";
          } else {
            hiddenmobile += mobile[i];
          }
        }
        $scope.mobile_can=hiddenmobile;
        setTimeout(function () {
          $scope.printToCartD()
        },50);
      })
    }
   $scope.printToCartD = function(name) {
      document.body.classList.add("htmltocanvas");
      var element = document.getElementById('detailedcandidates');
      html2pdf(element, {
        margin:       [2.5,2.5],
        filename:     name,
        image:        { type: 'jpeg', quality: 1 },
        html2canvas:  { dpi: 200, letterRendering: true, allowTaint: true},
        jsPDF:        { unit: 'pt', format: 'letter', orientation: 'portrait'},
        pdfCallback: myCallback
      });
      
      document.body.className = document.body.className.replace("htmltocanvas","");
      function myCallback(pdfObject) {
          var number_of_pages = pdfObject.internal.getNumberOfPages()
          var pdf_pages = pdfObject.internal.pages
          //var myFooter = " All rights reserved By Hirextra.com."
          for (var i = 1; i < pdf_pages.length; i++) {
              // We are telling our pdfObject that we are now working on this page
              pdfObject.setPage(i)
              pdfObject.setFont("helvetica");
              pdfObject.setFontSize(10);
              pdfObject.setFontType("normal");
              pdfObject.setTextColor(30,30,30);
              // The 10,200 value is only for A4 landscape. You need to define your own for other page sizes
              pdfObject.text("Page "+i+" of "+number_of_pages, 25, pdfObject.internal.pageSize.height-10)
              pdfObject.setFontType("bold");
              pdfObject.setFontSize(10);
              pdfObject.setTextColor(179,34,27);
              //pdfObject.text(myFooter, pdfObject.internal.pageSize.width-200, pdfObject.internal.pageSize.height-8)
          }
          var today = new Date();
          var dd = today.getDate();
          var mm = today.getMonth()+1; //January is 0!
          var yyyy = today.getFullYear();
          if(dd<10){
              dd='0'+dd;
          } 
          if(mm<10){
              mm='0'+mm;
          } 
          pdfObject.save($scope.name_can+"_"+"HireXtra_"+$scope.employer_name+"_GDPR_Result_"+dd+mm+yyyy+".pdf");
      }
    }
  }

  save (isValid) {
    if (isValid) {
      let $state = this.$state
      this.permission.put()
        .then(() => {
          let alert = { type: 'success', msg: 'Permission has been updated.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 6000);
           setTimeout(function(){ $state.go('app.userpermissions'); }, 7000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

  $onInit () {}
}

export const EmpgdprdetailsComponent = {
    templateUrl: './views/app/components/empgdprdetails/empgdprdetails.component.html',
    controller: EmpgdprdetailsController,
    controllerAs: 'vm',
    bindings: {}
};
