class EmployerTalentpoolViewController{
     constructor ($scope, $state,$stateParams, $compile,$timeout, DTOptionsBuilder, DTColumnBuilder, API,$rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $scope.requiredTags = []
    $scope.requiredTagsArr = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    this.searchTalentpool=function(){
        let Talentpoolssearch = this.API.service('talentpoolssearch', this.API.all('talentpools'))
        Talentpoolssearch.post({
              'minRate': this.rateSlider.minValue,
              'maxRate': this.rateSlider.maxValue,
              'rateType':$scope.rate_type,
              'requiredTags':$scope.requiredTags,
              'locations':this.city,
        }).then((response) => {
           let dataSet = response.plain()
        $scope.count=dataSet.data.talentpoolssearch.length;
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet.data.talentpoolssearch)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [[1, 'desc']])
         // .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
        this.dtColumns = [
         /* DTColumnBuilder.newColumn('id').withTitle('ID'),*/
          DTColumnBuilder.newColumn(null).withTitle('Name').withOption('width', '10%').renderWith(fullName), 
          DTColumnBuilder.newColumn(null).withTitle('No. of Skills Matched').withOption('width', '30%').renderWith(skillsMatched), 
        // DTColumnBuilder.newColumn('count_numbers').withTitle(''),
          DTColumnBuilder.newColumn('skills').withOption('width', '50%').withTitle('Skills'),
          DTColumnBuilder.newColumn(null).withTitle('Status').withOption('width', '10%').renderWith(status),
         
        ]
        this.displayTable = true 
        })
    }
   let job_id = $stateParams.id;
   this.rateSlider = {
              minValue:0,
              maxValue: 1200000,
           options: {
              floor: 0,
              ceil: 1200000,
              step: 1000,
              //readOnly: true,
          }
         };
   if(job_id != 0){
    let joborder = API.service('jobordertalentpool-show', API.all('joborders'))
    joborder.one(job_id).get()
      .then((response) => {
        this.jobdata=response;
        if(this.jobdata.data.skills_required.length){
          $scope.requiredTagsArr = this.jobdata.data.skills_required.split(',');  
        } else {
          $scope.requiredTags = null;  
        }
         angular.forEach($scope.requiredTagsArr, function (value) {
         $scope.requiredTags.push({text: value})
        })
        $scope.rate_type=this.jobdata.data.salaryType;
         this.rateSlider = {
              minValue:this.jobdata.data.salary_min,
              maxValue: this.jobdata.data.salary,
           options: {
              floor: 0,
              ceil: 1200000,
              step: 1000,
              //readOnly: true,
          }
        };
          let allCountries = API.service('locations')
          allCountries.getList()
          .then((response) => {
            $scope.countries = response.plain();
            angular.forEach($scope.countries, function (value,index) {
            if (value.is_enabled == 1) $scope.country = value.id
            }); 
            $scope.getcities($scope.country);
            var cityDummy = []
            angular.forEach(this.jobdata.data.job_citys, function (value) {
            cityDummy.push(value.city_id);
            });
            this.city = cityDummy;
          });
      })
   } else{
          let allCountries = API.service('locations')
          allCountries.getList()
          .then((response) => {
            $scope.countries = response.plain();
            angular.forEach($scope.countries, function (value,index) {
            if (value.is_enabled == 1) $scope.country = value.id
            }); 
            $scope.getcities($scope.country);        
      })
   }

    $scope.getcities=function(countryId) {
          let allCities = API.service('citiesof', API.all('locations'))
          allCities.one(countryId).getList()
        .then((response) => {
          $scope.masterlocations = null
          $scope.masterlocations = response.plain()
          
          $timeout(function() { 
            angular.element("#cityPin button").triggerHandler('click');
            angular.element("#cityPin button").triggerHandler('click');        
          }, 1000);
        });
      };

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</.0000000000000span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }
    let Talentpoolslist = API.service('alltalentpools', API.all('talentpools'))
    Talentpoolslist.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.count=dataSet.length;
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(fullName), 
         // DTColumnBuilder.newColumn('description').withTitle('Description'),
          DTColumnBuilder.newColumn(null).withTitle('Skills').notSortable()
            .renderWith(skills_data),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status),
         
        ]
        this.displayTable = true
      })

    let fullName = (data) => {
      return `<a title="View This Pool Details" ui-sref="app.emptalentpoolview({id: '${data.id}', jobid: '${job_id}'})">${data.name} </a>`;
    }
    let skillsMatched = (data) =>{
    return `${data.count_numbers} - ${data.matched_skills}`}
    let status = (data) => {

        if(data.status ==1){
            return `Active`
        }else{
            return `In-Active`
        }
      }
      let skills_data = (data) => {
      return `
      ${data.requests.skills}`}
    let createdRow = (row) => {$compile(angular.element(row).contents())($scope)}
    }
  $onInit () {}
}
export const EmployerTalentpoolViewComponent = {
    templateUrl: './views/app/components/employer-talentpool-view/employer-talentpool-view.component.html',
    controller: EmployerTalentpoolViewController,
    controllerAs: 'vm',
    bindings: {}
};
