class EmployerUsersListController{
 constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, $rootScope,ContextService) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    $("#myModalData").modal('show');
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

}
    ContextService.me(function (data) {
     $scope.employer_name=data.user.first_name;
    });

    let Users = API.service('employerusers', API.all('users'))

    Users.getList()
      .then((response) => {
        let dataSet = response.plain()


        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()
          
        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID').withOption('width', '5%'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').withOption('width', '15%').renderWith(fullName),
          DTColumnBuilder.newColumn(null).withOption('width', '15%').withTitle('Mobile').renderWith(mobile),
          DTColumnBuilder.newColumn('email').withTitle('Email').withOption('width', '25%'),
          DTColumnBuilder.newColumn(null).withOption('width', '5%').withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
         $("#myModalData").modal('hide');

      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `
                <a class="btn btn-xs btn-warning bt_n" style="background-color:#f1f0f0; border:none; padding:4px;" ui-sref="app.employerusersedit({vendorUserId: ${data.id}})">
                  <img src="/user_assets/assets/emp_dashboard/edit.svg" width="22" class="img-q">
                </a>
                <a ui-sref="app.editpricing({employerId: ${data.id} })" class="btn btn-xs cust_success_btn" title="Edit Pricing"><i class=""><img src="/user_assets/assets/emp_dashboard/edit-price.svg" width="18" class="img-q"></i></a>
                `
    }

    let mobile = (data) => {
      return `<span>${data.country_code}</span>&nbsp;<span>${data.mobile}</span>`

    }

    let fullName = (data) => {
          return `
<span class="expandrow" style="color:#ee0b7d;cursor:pointer;">${data.first_name} ${data.last_name}</span>
  <div class="expandedcontent" style="display:none;">
 <div class="col-md-12" style="border-color: coral;">
 <div class="col-md-2"><b>Total Jobs: </b> &nbsp;&nbsp;${data.empuserNumber.totalJobs}</div>
 <div class="col-md-2"><b>Closed Jobs :</b> &nbsp;&nbsp; ${data.empuserNumber.closedJobs}</div>
 <div class="col-md-2"><b>Inactive Jobs :</b> &nbsp;&nbsp; ${data.empuserNumber.inactiveJobs}</div>
 <div class="col-md-2"><b>Accepted Jobs :</b> &nbsp;&nbsp; ${data.empuserNumber.jobsaccepted}</div>
 <div class="col-md-2"><b>Pending Jobs :</b> &nbsp;&nbsp; ${data.empuserNumber.jobspending}</div>
 <div class="col-md-2"><b>Rejected Jobs :</b> &nbsp;&nbsp; ${data.empuserNumber.rejectedJobs}</div>
 </div>
          `
        }

  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  $onInit () {
    $(document).on('click', '.expandrow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr');
          var content = $(this).parent().parent().find('.expandedcontent').html();
          $('<tr><td colspan="5" style="background-color: #e8c1c1;">'+content+'</td></tr>').insertAfter(tr);
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });

        $(document).on('click', '.deleterow', function (e) {
          e.preventDefault();
          var tr = $(this).closest('tr').next().remove();;
          $(this).toggleClass('expandrow');
          $(this).toggleClass('deleterow');
          e.stopImmediatePropagation();
        });
  }
}


export const EmployerUsersListComponent = {
    templateUrl: './views/app/components/employer-users-list/employer-users-list.component.html',
    controller: EmployerUsersListController,
    controllerAs: 'vm',
    bindings: {}
}
