class EmployersListController{
 constructor ($scope, $state, $compile, DTOptionsBuilder,$stateParams, DTColumnBuilder, API, ContextService, $rootScope, $uibModal, $log, AclService, $timeout, $auth) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    //this.alerts = []
    this.animationsEnabled = true
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }
   let getCountry = API.service('country', API.all('users'))
    getCountry.getList()

      .then((response) => {
        let dataSet = response.plain()
        $scope.country = dataSet
      });
    let Users = API.service('employers', API.all('users'))
    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
		  DTColumnBuilder.newColumn(null).withTitle('Employer Type').renderWith(employerType),
          //DTColumnBuilder.newColumn('company.country_code').withTitle('Country Code'),
          DTColumnBuilder.newColumn('company.name').withTitle('Company Name'),
          //DTColumnBuilder.('company.country_code'),
          DTColumnBuilder.newColumn(null).withTitle('Mobile').renderWith(mobilenumber),
          DTColumnBuilder.newColumn(null).withTitle('Email').renderWith(emailid),
          //DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let mobilenumber = (data) => {
      return `
      <a class="mobile_font_color" href="tel:${data.mobile}">
        ${data.company.country_code} ${data.mobile}
      </a>
      `;
    }
    let emailid = (data) => {
      return `
      <a class="mobile_font_color" href="mailto:${data.email}">
      ${data.email}
      </a>
      `;
    }
    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `
                <a class="btn btn-xs" ui-sref="app.employersedit({userId: ${data.id}})" title="Edit">
                    <img src="/user_assets/assets/emp_dashboard/edit.svg" width="18" class="img-q">
                </a>
                <a ui-sref="app.editpricing({employerId: ${data.id} })" class="btn btn-xs cust_success_btn" title="Edit Pricing"><i class=""><img src="/user_assets/assets/emp_dashboard/edit-price.svg" width="18" class="img-q"></i></a>
                <a class="btn btn-xs cust_danger_btn" ng-click="changejobtype(${data.id})" ng-if="${data.job_type}==1" title="Enabled for Permanent Jobs Type Only"><img src="/user_assets/assets/emp_dashboard/enable_perminent.svg" width="18" class="img-q"></a>
                <a class="btn btn-xs btn-success" ng-click="changejobtype(${data.id})" ng-if="${data.job_type}==2" title="Enabled for Permanent & Contract to Hire Job Types"><img src="/user_assets/assets/emp_dashboard/enable_perminent.svg" width="18" class="img-q"></a>
                <a ui-sref="app.editam({employerId: ${data.id} })" class="btn btn-xs cust_success_bottom_btn" title="Update Accountmanager"><img src="/user_assets/assets/emp_dashboard/Account-manager.svg" width="18" class="img-q"></a>`;
    }
    let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`
    }
	let employerType = (data) => {
		if(data.user_type==1) {
		   data.user_type = 'ATS User';
		 } else if(data.user_type==2) {
		   data.user_type = 'Normal User';
		 } else  if(data.user_type==3) {
			 data.user_type = 'Normal User';
		 } else if(data.user_type==null || data.user_type==""){data.user_type = 'Normal User';}
			
      return `${data.user_type}`
    }
    $scope.changejobtype = function(id){
      let UserData = API.service('changejobtype', API.all('users'))
      UserData.one(id).get()
        .then((response) => {
       $state.reload()
      });
    }
  }

  delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  modalAssigntouser (job_id) {
  let $uibModal = this.$uibModal
  let $scope = this.$scope
  let $log = this.$log
  let API = this.API
  let jobId = job_id
  var modalInstance = $uibModal.open({
    animation: this.animationsEnabled,
    templateUrl: 'myModalContentavu.html',
    windowClass : "assign-to-vendor-user",
    controller: this.modalcontrolleravu,
    controllerAs: 'mvm',
    resolve: { jobId: function () {return jobId;}}
  });
    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => { 
      $log.info('Modal dismissed at: ' + new Date()) 
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
} // modalAssigntouser
modalcontrolleravu ($scope, $filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, jobId) {
    'ngInject'
    this.$state=$state
    this.API=API
    
    //let alerts = this.alerts
    $scope.jobId=jobId
    $scope.masterAm = null
     
      let Accountmanagers = API.service('accountmanagers', API.all('users'))
    Accountmanagers.getList()
      .then((response) => {
        let systemVendors = []
        $scope.masterAm = response.plain()
    })
      this.assign=() => { 
        let $state = this.$state;
        if ($stateParams.alerts) {this.alerts.push($stateParams.alerts)}
        $state.go($state.current, {}, { alerts: 'test' })
         let Employer = this.API.service('registervendordashboard', this.API.all('users'))
       
            Employer.post({
                'personId': $scope.jobId,
                'aManager': this.Ams[0]['id']
        }).then(function (data) {
          $uibModalInstance.dismiss('cancel');
            let alert = { type: 'success', msg: 'Accountmanager Assigned Successfully.' }
            $state.go($state.current, { alerts: alert},{reload:true});
           
           setTimeout(function(){ $(".alert-success").hide() }, 10000); 
           $uibModalInstance.dismiss('cancel');
        })
      }
    this.ok = () => {$uibModalInstance.close($scope.selected.item)}
    this.cancel = () => {$uibModalInstance.dismiss('cancel')}
  }//modalcontrollervs
  $onInit () {}
}
export const EmployersListComponent = {
    templateUrl: './views/app/components/employers-list/employers-list.component.html',
    controller: EmployersListController,
    controllerAs: 'vm',
    bindings: {}
}
