class FarmingController {
	constructor($scope, $state, $stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope, $http, $sce,) {
		'ngInject'
		this.API = API
		this.$state = $state
		this.$uibModal = $uibModal
		this.$log = $log
		this.$scope = $scope
		this.animationsEnabled = true
		$scope.job_title = '';
		$scope.data = '';
		$scope.location = '';
		$scope.skil = '';
		$scope.jobid = $stateParams.JoborderId;
		$scope.isLoading = false;
		$scope.candidatedata = false;
		$rootScope.$broadcast('pageurl', this.$state.current.url);

		function renderer(api, rowIdx, columns) {
			var data = $.map(columns, function (col, i) {
				return col.hidden ?
					'<li data-dtr-index="' + col.columnIndex + '" data-dt-row="' + col.rowIndex + '" data-dt-column="' + col.columnIndex + '">' +
					'<span class="dtr-title">' +
					col.title +
					'</span> ' +
					'<span class="dtr-data">' +
					col.data +
					'</span>' +
					'</li>' :
					'';
			})
				.join('');
			var retVal = data ?
				$compile(angular.element($('<ul data-dtr-index="' + rowIdx + '"/>').append(data)))($scope) :
				false;
			$scope.$digest();
			return retVal;
		}
		let Users = API.service('jobtitle', API.all('jobsorders'))
		Users.one($scope.jobid)
			.get()
			.then((response) => {
				let dataSet = response;
				console.log(dataSet, 'dataset');
				$scope.job_title = dataSet.data.getJobtile.title;
				$scope.location = dataSet.data.getJobtile.name;
				$scope.skil = dataSet.data.getJobtile.skillsrequired;
				console.log($scope.job_title, 'shiva');
			})
		$scope.getCandidatesdata = function () {
			$scope.isLoading = true;
			let GoogleSearch = API.service('customsearchprofile', API.all('jobsorders'));
			GoogleSearch.one($scope.jobid).get().then((response) => {
				$scope.data = response.data.tableData;
				$scope.candidatedata = true;
				$scope.isLoading = false;
				initializeDataTable($scope.data);
			}).catch(error => {
				console.error('Error fetching data:', error);
				$scope.isLoading = false;

			});
		};

		function initializeDataTable(data) {
			$scope.dtOptions = DTOptionsBuilder.newOptions()
				.withOption('data', data)
				.withOption('createdRow', createdRow)
				.withOption('responsive', true)
				.withOption('order', [0, 'desc'])
				.withDisplayLength(50)
				.withBootstrap();
			$scope.dtColumns = [
				DTColumnBuilder.newColumn(null).withTitle('<input type="checkbox"  id="myCheckbox" style="margin: 0px 63px -1px -30px" onclick="checkAll(this)">').withOption('width', '3%').renderWith(imageicon).notSortable(),
				DTColumnBuilder.newColumn(null).withTitle('NAME').withOption('width', '5%').renderWith(fullName).notSortable().withClass('text-center'),
				DTColumnBuilder.newColumn(null).withTitle('JOB POSITION').withOption('width', '5%').renderWith(jobposition).notSortable().withClass('text-center'),
				DTColumnBuilder.newColumn(null).withTitle('<img src="/farmingicons/linkedin.png" style="width: 29px;height: 28px;">').withOption('width', '5%').renderWith(linkedin).notSortable(),
				DTColumnBuilder.newColumn(null).withTitle('COMPANY NAME').withOption('width', '8%').renderWith(companyname).notSortable().withClass('text-center'),
				DTColumnBuilder.newColumn(null).withTitle('SUMMARY').withOption('width', '48%').renderWith(summary).notSortable().withClass('text-center'),
				DTColumnBuilder.newColumn(null).withTitle('SKILLS').withOption('width', '10%').renderWith(skills).notSortable().withClass('text-center'),
				DTColumnBuilder.newColumn(null).withTitle('ACTION').withOption('width', '13%').renderWith(action).notSortable().withClass('text-center'),
			]
			$scope.displayTable = true
		}
		let createdRow = (row, data, dataIndex) => {
			$compile(angular.element(row).contents())($scope);
		}
		let companyname = (data) => {
			if (data.company_name == "" || data.company_name == undefined) {
				return `
                <span style="text-align:center">Get Data<span>
                      `
			} else {
				return `
                <span style="text-align:center">${data.company_name}<span>
                     `
			}
		}
		let summary = (data) => {
			let string = data.summary;
			console.log(string);
			if (string == "" || string == undefined) {
				return `Get Data`
			} else {
				let length = 70;
				let trimmedString = string.substring(0, length);
				$scope.string_d = trimmedString;
				$scope.string_c = string;
				//angular.forEach
				return `<span class="trimmed">${$scope.string_d}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor: pointer;">Read more</span></span>
                <span class="trimmednot" style="display:none;">${$scope.string_c} <span class="readlessclick" style="color: #e3323e;cursor: pointer;">Read less</span></span>`
			}
		}
		let skills = (data) => {
			if (data.skills != '' || data.skills != undefined) {
				return `
                <span style="text-align:center">Get Data<span>
                      `
			} else {
				return `Get Data`
			}
		}
		let jobposition = (data) => {
			let title = $scope.job_title;
			return `
            <span style="text-align:center">${title}</span>
                   `
		}
		let imageicon = (data, type, full, meta) => {
			if (data.icon_value == null || data.icon_value == '' || data.icon_value == undefined) {
				data.icon_value = "/farmingicons/transgender_icon.png";
			}
			return `   
            <input type="checkbox" ng-click="updateSelection($event,${data.id})" class="checkall" name=""style="margin: 0px -18px -18px;">
            <img src="${data.icon_value}" style="margin:  0px 28px;" > 
                 `
		}
		let linkedin = (data) => {
			let linked = data.linkedin_url;

			function truncateString(str) {
				const maxLength = 60;
				const appendStr = '.....'; // Characters to append if the string is longer than maxLength  
				if (str.length > maxLength) {
					return str.substring(0, maxLength) + appendStr;
				}
				return str;
			}
			var url = linked;
			var modifiedUrl = truncateString(url);
			return `
             <a href="${linked}" style="color:black" target="_blank">${modifiedUrl}</a>
            `
		}
		let action = (data, type, full, metata) => {
			if (data.summary == null || data.summary == "") {
				return `
                <button style=" padding: 8px 16px;background-color: #ec107e;border-radius: 10px;color: white !important; border:none" title="Get Data" ng-click="getCandidatedata(${data.id})"><img src="/farmingicons/geticon.png" width="18" class="img-q"></button>
                       `
			} else {
				return `
                <div style="display: flex;margin: 18px 22px;">
                <a class="btn btn-xs btn-success" target="_blank" title="View Cv" style="background-color: black;" ui-sref="app.profileview({JoborderId: ${data.id}})" href="#/profileview/231">
                <img src="/farmingicons/View.png" width="18" class="img-q" style="width: 30px;height: 26px;padding: 5px;">
                </a>
                 
                <button class="btn btn-xs" title="Enrich" style="background-color: green;margin: 0px 12px;" ng-click="getEmail(${data.id})">
                <img src="/farmingicons/Enrich.png" width="18" class="img-q" style="width: 26px;height: 16px;padding: -17px 2px;">
                </button>
                </div> `
			}
		}
		let fullName = (data) => {
			return `<span style="text-align:center">${data.full_name}</span>`
		}
		// }
		$scope.getCandidatedata = function (id) {
			$scope.isLoading = true;
			let VendorCandidateNums = API.service('linkedinscrabber', API.all('jobsorders'))
			VendorCandidateNums.one(id)
				.get()
				.then((response) => {
					$scope.data = response.plain().data
					$scope.isLoading = false;
					$state.reload();
				})
		}
		$scope.selectedData = [];
		$scope.updateSelection = function ($event, id) {
			var checkbox = $event.target;
			// Ensure $scope.data is an array
			if (!Array.isArray($scope.data)) {
				console.error('Error: $scope.data is not an array');
				return;
			}
			if (checkbox.checked && !$scope.selectedData.some(item => item.id === id)) {
				let selected = $scope.data.find(record => record.id === id);
				if (selected) {
					$scope.selectedData.push(selected);
				}
			} else {
				var index = $scope.selectedData.findIndex(item => item.id === id);
				if (index > -1) {
					$scope.selectedData.splice(index, 1);
				}
			}
		};
		$scope.exportToExcel = function () {
			console.log($scope.selectedData);
			var worksheet = XLSX.utils.json_to_sheet($scope.selectedData, {
				header: ['id', 'full_name', 'icon_value', 'linkedin_url', 'job_title', 'company_name', 'summary', 'skills', 'mobile_phone', 'work_email'], // Specify the headers you want
				skipHeader: false // Include headers in the worksheet
			});

			var workbook = XLSX.utils.book_new();
			XLSX.utils.book_append_sheet(workbook, worksheet, "SelectedData");

			// Define export options
			var exportOptions = {
				bookType: 'xlsx', // Can be 'xlsx', 'csv', 'txt', etc.
				type: 'binary'
			};

			// Exporting the file
			XLSX.writeFile(workbook, "candidatesData.xlsx", exportOptions);
		};
		$scope.getEmail = function (id) {
			let getdata = API.service('email', API.all('jobsorders'))
			getdata.one(id)
				.get()
				.then((response) => {
					$scope.data = response.plain().data

				})
		}
		$(function () {
			$('#myCheckbox').change(function () {
				if (this.checked) {
					checkboxChecked();
				} else {
					checkboxUnchecked();
				}
			});

			function checkboxChecked() {
				alert('Checkbox is checked.');
				// Add your logic for a checked checkbox here
			}

			function checkboxUnchecked() {
				alert('Checkbox is unchecked.');
				// Add your logic for an unchecked checkbox here
			}
		});
	};
	delete(userId) {
		let API = this.API
		let $state = this.$state
		swal({
			title: 'Are you sure?',
			text: 'You will not be able to recover this data!',
			type: 'warning',
			showCancelButton: true,
			confirmButtonColor: '#DD6B55',
			confirmButtonText: 'Yes, delete it!',
			closeOnConfirm: false,
			showLoaderOnConfirm: true,
			html: false
		}, function () {
			API.one('users')
				.one('user', userId)
				.remove()
				.then(() => {
					swal({
						title: 'Deleted!',
						text: 'User Permission has been deleted.',
						type: 'success',
						confirmButtonText: 'OK',
						closeOnConfirm: true
					}, function () {
						$state.reload()
					})
				})
		})
	}
	modalAssigntouser(job_id) {
		let $uibModal = this.$uibModal
		let $scope = this.$scope
		let $log = this.$log
		let API = this.API
		let jobId = job_id
		var modalInstance = $uibModal.open({
			animation: this.animationsEnabled,
			templateUrl: 'myModalContentavu.html',
			windowClass: "assign-to-vendor-user",
			controller: this.modalcontrolleravu,
			controllerAs: 'mvm',
			resolve: {
				jobId: function () {
					return jobId;
				}
			}
		});
		modalInstance.result.then((selectedItem) => {
			$scope.selected = selectedItem
		}, () => {
			$log.info('Modal dismissed at: ' + new Date())
		})
	}
	modalcontrolleravu($scope, $filter, $uibModalInstance, $state, $stateParams, API, $http, $auth, jobId) {
		'ngInject'
		this.$state = $state
		this.API = API
		$scope.jobId = jobId
		$scope.masterAm = null
		this.alerts = []
		if ($stateParams.alerts) {
			this.alerts.push($stateParams.alerts)
		}
		let Accountmanagers = API.service('accountmanagers', API.all('users'))
		Accountmanagers.getList()
			.then((response) => {
				let systemVendors = []
				$scope.masterAm = response.plain()
			})
		this.assign = () => {
			let $state = this.$state;
			$state.go($state.current, {}, {
				alerts: 'test'
			})
			let Employer = this.API.service('registervendordashboard', this.API.all('users'))
			Employer.post({
				'personId': $scope.jobId,
				'aManager': this.Ams[0]['id']
			})
				.then((response) => {
					let alert = {
						type: 'success',
						msg: 'Accountmanager has been updated.'
					}
					$state.go($state.current, {
						alerts: alert
					}, {
						reload: true
					})
					setTimeout(function () {
						$(".alert-success")
							.hide()
					}, 10000);
				})
		}
		this.ok = () => {
			$uibModalInstance.close($scope.selected.item)
		}
		this.cancel = () => {
			$uibModalInstance.dismiss('cancel')
		}
	}
	$onInit() {
		$(document)
			.on('click', '.readlessclick', function (e) {
				e.preventDefault();
				$(this).parent().hide();
				$(this).parent().siblings().show();
				e.stopImmediatePropagation();
			});
		$(function () {
			$('#myCheckbox').change(function () {
				if (this.checked) {
					checkboxChecked();
				} else {
					checkboxUnchecked();
				}
			});

			function checkboxChecked() {
				alert('Checkbox is checked.');
				// Add your logic for a checked checkbox here
			}

			function checkboxUnchecked() {
				alert('Checkbox is unchecked.');
				// Add your logic for an unchecked checkbox here
			}
		});
	}
}
export const FarmingComponent = {
	templateUrl: './views/app/components/farming/farming.component.html',
	controller: FarmingController,
	controllerAs: 'vm',
	bindings: {}
};