class LanguagesEditController{
   constructor ($stateParams, $state, API,$rootScope) {
    'ngInject'

    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
$rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let languagesId = $stateParams.languagesId;
    let languages = API.service('languages-show', API.all('languages'))
    languages.one(languagesId).get()
      .then((response) => {
        this.languages = API.copy(response)
      })
  }

  save (isValid) {
   
    if (isValid) {
      let $state = this.$state
      console.log(this.languages);
      this.languages.put()
        .then(() => {
          let alert = { type: 'success', msg: 'Languages has been updated.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

    $onInit(){
    }
}
export const LanguagesEditComponent = {
    templateUrl: './views/app/components/languages-edit/languages-edit.component.html',
    controller: LanguagesEditController,
    controllerAs: 'vm',
    bindings: {}
};
