class LoginResetPasswordController{
    constructor (API, $state, $location,$rootScope, $stateParams, $scope) {
    'ngInject'

    this.API = API
    this.$state = $state
    this.$location = $location
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
     $scope.email = $stateParams.email;
       this.API.all('auth/password/validateemail_p').post({
         email: $scope.email,
       }).then((res) => {
        $scope.days=res.data.interval.days;
        $scope.recreate=res.data.email_verified;
       });
  } 

  $onInit () {
    this.password = ''
    this.password_confirmation = ''
    this.isValidToken = false
    this.formSubmitted = false
    this.verifyToken()
  }


  verifyToken () {

    let email = this.$state.params.email
    let token = this.$state.params.token
    this.API.all('auth/password').get('verifyps', {
    email, token}).then(() => {
      this.isValidToken = true 
    }, () => {
      this.$state.go('app.landing')
    })
  }

  submit (isValid) {
    let $state = this.$state
    if (isValid) {
      this.alerts = []
      let data = {
        email: this.$state.params.email,
        email_verification_code: this.$state.params.token,
        password: this.password,
        password_confirmation: this.password_confirmation
      }

      this.API.all('auth/password/reset').post(data).then(() => {
        let alrtArr = []
        alrtArr = {type: 'success', msg: 'Your password has been changed, You may now login.'}
        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-success").hide() }, 10000);
      }, (res) => {
        let alrtArr = []

        angular.forEach(res.data.errors, function (value) {
          alrtArr = {type: 'error', msg: value[0]}
        })

        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      })
    } else {
      this.formSubmitted = true
    }
    //$location.path("/login");
    setTimeout(function(){
      console.log($state);
      $state.go('login');
      //this.$location.path('/login'); 
    }, 3000);
  }
}

export const LoginResetPasswordComponent = {
    templateUrl: './views/app/components/login-reset-password/login-reset-password.component.html',
    controller: LoginResetPasswordController,
    controllerAs: 'vm',
    bindings: {}
};
