class ManageProcessLeadController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    ContextService.me(function (data) {
      $scope.loggedInUserData = data
    })

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    
    let getCountry = API.service('country', API.all('users'))
    getCountry.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.country = dataSet
      });

    let Users = API.service('processleads', API.all('users'))

    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
          DTColumnBuilder.newColumn('mobile').withTitle('Mobile'),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `
                <a class="btn btn-xs btn-warning" ui-sref="app.employersedit({userId: ${data.id}})" title="Edit">
                    <i class="fa fa-edit"></i>
                </a>
                <a ui-sref="app.editpricing({employerId: ${data.id} })" class="btn btn-xs btn-success" title="Edit Pricing"><i class="fa ${userdata[0].fa_icon_class}"></i></a>
                <a class="btn btn-xs btn-danger" ng-click="changejobtype(${data.id})" ng-if="${data.job_type}==1" title="Enabled for Permanent Jobs Type Only"><i class="fa fa-lock"></i></a>
                <a class="btn btn-xs btn-success" ng-click="changejobtype(${data.id})" ng-if="${data.job_type}==2" title="Enabled for Permanent & Contract to Hire Job Types"><i class="fa fa-lock"></i></a>
                `
                
    }

    let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`
    }
    $scope.changejobtype = function(id){
      let UserData = API.service('changejobtype', API.all('users'))
      UserData.one(id).get()
        .then((response) => {
       $state.reload()
      });

    }
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  $onInit () {}
}

export const ManageProcessLeadComponent = {
    templateUrl: './views/app/components/manage-process-lead/manage-process-lead.component.html',
    controller: ManageProcessLeadController,
    controllerAs: 'vm',
    bindings: {}
};
