class ManageProcessController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    ContextService.me(function (data) {
      $scope.loggedInUserData = data
    })

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    
    let getCountry = API.service('country', API.all('users'))
    getCountry.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.country = dataSet
      });

    let Users = API.service('processusers', API.all('users'))

    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(fullName),
          DTColumnBuilder.newColumn('mobile').withTitle('Mobile'),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn(null).withTitle('Role').renderWith(role),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `
                <a class="btn btn-xs" ui-sref="app.puseredit({userId: ${data.id}})" title="Edit">
                    <img width="13" src="/user_assets/assets/am-dashboard/edit.svg">
                </a>`
                
    }

    let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`
    }
    let role = (data) => {
      if(data.role_id == 11) {
        return `Process Lead`
      } else if(data.role_id == 12) {
        return `Process Executive`
      }
      
    }
    $scope.changejobtype = function(id){
      let UserData = API.service('changejobtype', API.all('users'))
      UserData.one(id).get()
        .then((response) => {
       $state.reload()
      });

    }
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  $onInit () {}
}

export const ManageProcessComponent = {
    templateUrl: './views/app/components/manage-process/manage-process.component.html',
    controller: ManageProcessController,
    controllerAs: 'vm',
    bindings: {}
};
