class ManageSurveyController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    ContextService.me(function (data) {
      $scope.loggedInUserData = data
    })

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    let QustionsData = API.service('managequestionsdata', API.all('processsurvey'))
    QustionsData.getList()
    .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
         /* DTColumnBuilder.newColumn('prid').withTitle('ID'),*/
          DTColumnBuilder.newColumn('question').withTitle('Question'),
          DTColumnBuilder.newColumn('answertype').withTitle('AnswerType'),
          DTColumnBuilder.newColumn(null).withTitle('Role').renderWith(role),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let role = (data) => {
      if(data.role_id == 11) {
        return `Process Lead`
      } else if(data.role_id == 12) {
        return `Process Executive`
      }
    }

    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `<!--<a class="btn btn-xs btn-warning" ui-sref="app.manageQuestionsedit({questionId: ${data.id}})" style="float: left;"><i class="fa fa-edit"></i></a>
              &nbsp;&nbsp;-->
              <a class="btn btn-xs btn-danger" ng-if="${data.is_alive}==0" ng-click="approve(${data.id})">Approve</a>
              <a class="btn btn-xs btn-success" ng-if="${data.is_alive}==1">Approved</a>
              `
                
    }

    $scope.approve = function(id){
      swal({
        title: 'Are you sure?',
        text: 'You want to Approve this Question!',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes, Approve it!',
        closeOnConfirm: false,
        showLoaderOnConfirm: true,
        html: false
      }, function () {
        let Approve = API.service('qstnapprove', API.all('processsurvey'))
        Approve.post({
          'qstnID' : id
        }).then(() => {
            swal({
              title: 'Approved!',
              text: 'Question has been Approved.',
              type: 'success',
              confirmButtonText: 'OK',
              closeOnConfirm: true
            }, function () {
              $state.reload()
            })
          })
      })

      /*let Approve = API.service('qstnapprove', API.all('processsurvey'))
      Approve.post({
        'qstnID' : id
      }).then(() => {
          let alert = { type: 'success', msg: 'Question Approved Successfully.' }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-success").hide() }, 4000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert},{reload:true})
          setTimeout(function(){ $(".alert-error").hide() }, 4000);
        })*/
    };
  }


  saveQuestion (isValid) { 
    // console.log('i am here');
    this.$state.go(this.$state.current, {}, { alerts: 'test' })
    if (isValid) {
      let Jobtypes = this.API.service('updatequestion', this.API.all('processsurvey'))
      let $state = this.$state
      console.log($state.current)

      Jobtypes.post({
        'name': this.name
      }).then(() => {
          let alert = { type: 'success', msg: 'Updated Question Successfully.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }


  $onInit () {
    
  }

}

export const ManageSurveyComponent = {
    templateUrl: './views/app/components/manage-survey/manage-survey.component.html',
    controller: ManageSurveyController,
    controllerAs: 'vm',
    bindings: {}
};
