class NewProfileAccessController{
    constructor ($scope, $stateParams, $state, API, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, $log, AclService, ContextService, $filter, $rootScope, $timeout,$http,$location) {
    'ngInject'

    this.API = API
    this.$state = $state
    this.$location = $location
    this.alerts = []
    this.$scope = $scope
    this.$uibModal = $uibModal
    this.$log = $log
    $scope.items = [ { name: "Shortlist", id: 5 }, { name: "Duplicate", id: 1 }, { name: "Reject", id: 2 } ]
    $scope.changeStatus = [ { name: "Change Status", id: 'changeStatus' }, { name: "Reject", id: 'rejectShorlisted' } ]
    $rootScope.$broadcast('pageurl', this.$state.current.url);
  } 

  $onInit () {
    this.mobile = ''
    this.formSubmitted = false
    this.profile = ''
  }

  submit (isValid) {
    let $state = this.$state
    if (isValid) {
      this.alerts = []
      let data = {
        mobile: this.mobile,
        token: this.$state.params.token
      }

      this.API.service('employerprofileaccess', this.API.all('publicprofile')).post(data).then((response) => {
        let dataSet={}
        dataSet = response.plain()
        this.profile = dataSet.data.employerprofileaccess[0];
      }, (res) => {
        let alrtArr = []
        alrtArr = {type: 'error', msg: 'The link is expired. Please login to your account to access this.'}
        this.alerts.push(alrtArr)
        setTimeout(function(){ 
            $(".alert-error").hide() 
            $state.go('login')
        }, 10000);
      })
    } else {
      this.formSubmitted = true
    }
    
  }

  modalOpen (interview_date, candidateName, CandidateId, selectedOption, candidateStatusId, job_id, employer_id, vendor_id , accountmanager_id) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.vendors
    let API = this.API
    let $state = this.$state
    $scope.CandidateId = CandidateId
    $scope.selectedOption = selectedOption
    $scope.candidateStatusId = candidateStatusId
    $scope.jobid = job_id
    $scope.employer_id = employer_id
    $scope.vendor_id = vendor_id
    $scope.accountmanager_id = accountmanager_id
    $scope.reasonsSelected = 0
    $scope.reasonsSelectedAs = 0
    if($scope.selectedOption == 1) {$scope.modalTitle = 'Duplicate profile'}
    else if ($scope.selectedOption == 2) {$scope.modalTitle = 'Reasons to reject'}
    else if ($scope.selectedOption == 5) {$scope.modalTitle = 'Shortlisted'}
    else if ($scope.selectedOption == 'changeStatus') {$scope.modalTitle = 'Change Status'}
    else if ($scope.selectedOption == 'rejectShorlisted') {$scope.modalTitle = 'Reasons to reject'}
      

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      size: 'lg',
      resolve: {
        items: () => {
          return items
        },
        jobCandidateForm: function () {
            return $scope.jobCandidateForm;
        },
        canId: function () {
            return $scope.CandidateId;
        },
        selectedOption: function () {
            return $scope.selectedOption;
        },
        JobOrderId: function () {
            return $scope.joborderId;
        },
        modalTitle: function () {
            return $scope.modalTitle;
        },
        candidateStatusId: function() {
          return $scope.candidateStatusId;
        },
        candidateName: function() {
          return candidateName;
        },
        interviewDate: function() {
          return interview_date;
        },
        jobid: function() {
          return $scope.jobid;
        },
        employer_id: function() {
          return $scope.employer_id;
        },
        vendor_id: function() {
          return $scope.vendor_id;
        },
        accountmanager_id: function() {
          return $scope.accountmanager_id;
        },
        
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      // if ($rootScope.previousState.name == '') {
      //   // No previous state to go? Go to list page
      //   $state.go('app.logout');
      // } else {
      //   // Back to previous state if any
      //   $window.history.back();
      // }
    })
  }

  modalcontroller ($scope, $uibModalInstance, items, $state, API, jobCandidateForm, selectedOption, canId, JobOrderId, $filter, modalTitle, candidateStatusId, candidateName, interviewDate, jobid, employer_id, vendor_id, accountmanager_id ) {
    'ngInject'

    this.items = items
    this.loader_show =0;
    $scope.jobCandidateForm = jobCandidateForm
    $scope.canId = canId
    $scope.selectedOption = selectedOption
    $scope.modalTitle = modalTitle
    $scope.JobOrderId = JobOrderId
    $scope.candidateStatusId = candidateStatusId
    $scope.jobid = jobid
    $scope.employer_id = employer_id
    $scope.vendor_id = vendor_id
    $scope.accountmanager_id = accountmanager_id
    $scope.masterReasons = null
    $scope.masterrejectAS = null
    $scope.reasonsSelected = 0
    $scope.reasonIdStrings = null
    $scope.reasonsSelectedAs = 0
    $scope.reasonIdAsStrings = null
    $scope.reasonsSelectedSrt = null
    $scope.f2fIds  = null
    $scope.phoneIds = null
    $scope.selected = null
    $scope.candidateName = candidateName
    console.log($scope.selectedOption,"fdfkjdskfdsk")
    if(interviewDate != "null"){ $scope.selectedDateObj = interviewDate; }
      
      else { $scope.selectedDateObj=""; }
    $scope.roundText = "Shortlisted for Telephonic Interview"
    $scope.radioClick = function(id){
      if(parseInt(id) == 17) {$scope.roundText = "Shortlisted for Telephonic Interview";}
      else if(parseInt(id) == 18) {$scope.roundText = "Shortlisted for face to face Interview";}
        else if(parseInt(id) == 20) {$scope.roundText = "Shortlisted for Final Interview";}
          else if(parseInt(id) == 21) {$scope.roundText = "Shortlisted for Walk-in Interview";}
            else if(parseInt(id) == 22) {$scope.roundText = "Shortlisted for Skype call Interview";}
            else if(parseInt(id) == 23) {$scope.roundText = "Shortlisted for Direct Interview";}
    }


    if(interviewDate) {
      var slices = interviewDate.split(' ');
      $scope.scheduleDate=slices[0];
      $scope.scheduleTime = slices[1];
    } else { $scope.selectedDateObj = ""; }

    $scope.dateOpts = {
        defaultDate: $scope.selectedDateObj,
        enableTime: true,
        dateFormat: "d-m-Y h:i K",
        minDate: "today",
        defaultHour: "00:00",
        defaultMinute: "00",
        position: "below",
        animate: true,
        static: true,
        time_24hr: false,
        onChange: function(selectedDates, dateStr, instance){
          $scope.selectedDateObj = dateStr;
          var slices = dateStr.split(' ');
           $scope.scheduleDate=slices[0];
           $scope.scheduleTime = slices[1];
        }
    };
    this.selectedshortlistedround = candidateStatusId
      if($scope.selectedOption== 2) { 
        let rejectReasons = API.service('reasontoreject', API.all('publicprofile'))
        rejectReasons.getList()
          .then((response) => {
              $scope.masterReasons = response.plain()
          })
      } else if ($scope.selectedOption == 5 || $scope.selectedOption == 'changeStatus') {
        let shortlistedPhone = API.service('shorlistedstatus', API.all('publicprofile'))
        shortlistedPhone.getList()
          .then((response) => {
              $scope.masterStatus = response.plain()
          })
      
      } else if($scope.selectedOption== 'rejectShorlisted') { 
        let reasontorejectAs = API.service('reasontorejectas', API.all('publicprofile'))
        reasontorejectAs.getList()
          .then((response) => {
              $scope.masterrejectAS = response.plain()
          })
      }
    
    this.selectedReasons = function () {
        $scope.reasonsSelected = $filter('filter')($scope.masterReasons, {checked: true});
        $scope.reasonIdStrings = String($scope.reasonsSelected.map(function(a) {return a.id;}));
    }

    this.selectedReasonsSrt = function () {
        $scope.reasonsSelectedSrt = $filter('filter')($scope.masterStatus, {checked: true});
       
    }

    this.selectedReasonsAs = function () { 
        $scope.reasonsSelectedAs = $filter('filter')($scope.masterrejectAS, {checked: true});
        $scope.reasonsSelectedAsFalse = $filter('filter')($scope.masterrejectAS, {checked: false});

        $scope.reasonIdAsStrings = String($scope.reasonsSelectedAs.map(function(a) {
          if(a.id == 35){$scope.showTA = true;}
          return a.id;
        }));

        $scope.reasonIdAsStringsFalse = String($scope.reasonsSelectedAsFalse.map(function(a) {
          if(a.id == 35){$scope.showTA = false;}
        }));

    }

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item, $scope.selectedOption)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }

    this.save = (isValid) => {
      this.loader_show =1;
      if (isValid) {
        

      $('.saveBtn').attr('disabled',true);
        
      if($scope.selectedOption == 1){ 
       
        let duplicateJob = API.service('duplicatejob', API.all('publicprofile'))
        duplicateJob.post({
          'joborderId': $scope.JobOrderId,
          'note': this.duplicateTA,
          'dupcandId': $scope.canId,
          'jobid': $scope.jobid,
          'employer_id': $scope.employer_id,
          'vendor_id': $scope.vendor_id, 
          'accountmanager_id': $scope.accountmanager_id 
        }).then(function () {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'success', msg: 'Sent duplicate candidate message.' }
          $(".alert_duplicate").show();
          setTimeout(function(){ $state.go('app.landing'), 150000});
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'error', msg: response.data.message }
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })

      } 
      else if($scope.selectedOption == 2) { 

        let reasonstoReject = API.service('reasonstoreject', API.all('publicprofile'))
        reasonstoReject.post({          
          'reasonIds': $scope.reasonIdStrings,
          'candId': $scope.canId,
          'note':this.rejectAsNote,
          'joborderId': $scope.JobOrderId,
          'jobid': $scope.jobid,
          'employer_id': $scope.employer_id,
          'vendor_id': $scope.vendor_id, 
          'accountmanager_id': $scope.accountmanager_id 

        }).then(function () {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'success', msg: 'Sent reasons to reject candidate.' }
           $(".alert_reject").show();
           setTimeout(function(){ $state.go('app.landing'), 150000});
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'error', msg: response.data.message }
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      } 
      else if($scope.selectedOption == 5 || $scope.selectedOption== 'changeStatus') { // Shortlisted
        
        
        if(this.selectedshortlistedround == 27 || this.selectedshortlistedround == 28) {
          if(!(this.selectedshortlistedround==17 || this.selectedshortlistedround==18 || (this.selectedshortlistedround>=20 && this.selectedshortlistedround<=23) )){
            $scope.selectedDateObj = null;
          }
            let selectedIds = API.service('selectedids', API.all('publicprofile'))
            selectedIds.post({
              'joborderId': $scope.JobOrderId,
              'shortlistIds': this.selectedshortlistedround,
              'shrtListNote': this.shrtListNote,
              'addressAsNote': this.addressAsNote,
              'candId': $scope.canId,
              'interview_schedule_date': $scope.selectedDateObj,
              'jobid': $scope.jobid,
              'employer_id': $scope.employer_id,
              'vendor_id': $scope.vendor_id, 
              'accountmanager_id': $scope.accountmanager_id 
            }).then(function () {
              $uibModalInstance.dismiss('cancel')
              let alert = { type: 'success', msg: 'Candiadate has been selected by employer.' }
               $(".alert_shortlist").show();
              setTimeout(function(){ $state.go('app.landing'), 150000});
              setTimeout(function(){ $(".alert-success").hide() }, 10000);
            }, function (response) {
              $uibModalInstance.dismiss('cancel')
              let alert = { type: 'error', msg: response.data.message }
              setTimeout(function(){ $(".alert-error").hide() }, 10000);})
           
        } else { 
            if(!(this.selectedshortlistedround==17 || this.selectedshortlistedround==18 || (this.selectedshortlistedround>=20 && this.selectedshortlistedround<=23) )){
              $scope.selectedDateObj = null;
            }
           let shortlistedIds = API.service('shortlistedids', API.all('publicprofile'))
            shortlistedIds.post({
              'joborderId': $scope.JobOrderId,
              'shortlistIds': this.selectedshortlistedround,
              'shrtListNote': this.shrtListNote,
              'addressAsNote': this.addressAsNote,
              'candId': $scope.canId,
              'interview_schedule_date': $scope.selectedDateObj,
              'jobid': $scope.jobid,
              'employer_id': $scope.employer_id,
              'vendor_id': $scope.vendor_id, 
              'accountmanager_id': $scope.accountmanager_id 
            }).then(function () {
              $uibModalInstance.dismiss('cancel')
              let alert = { type: 'success', msg: 'Candiadate has been shortlisted.' }
               $(".alert_shortlist").show();
              setTimeout(function(){ $state.go('app.landing'), 150000});
              setTimeout(function(){ $(".alert-success").hide() }, 10000);
            }, function (response) {
              $uibModalInstance.dismiss('cancel')
              let alert = { type: 'error', msg: response.data.message }
              setTimeout(function(){ $(".alert-error").hide() }, 10000);
            })
        } 
      }  
      else if($scope.selectedOption == 'rejectShorlisted') { 

        let reasonstoReject = API.service('reasonstorejectas', API.all('publicprofile'))
        reasonstoReject.post({
          'joborderId': $scope.JobOrderId,
          'reasonIdsAs': $scope.reasonIdAsStrings,
          'note': this.rejectAsNote,
          'candId': $scope.canId
        }).then(function () {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'success', msg: 'Sent reasons to reject candidate.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          $uibModalInstance.dismiss('cancel')
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      }
      } else {
        this.formSubmitted = true
      }
    } 
  }

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  }
}

export const NewProfileAccessComponent = {
    templateUrl: './views/app/components/new-profile-access/new-profile-access.component.html',
    controller: NewProfileAccessController,
    controllerAs: 'vm',
    bindings: {}
};
