class PredefinedListController {
  constructor($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, $timeout, API, $rootScope, $stateParams, ContextService) {
    'ngInject'
    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    let loggedinUser = this
    

    function renderer(api, rowIdx, columns) {
      var data = $.map(columns, function(col, i) {
        return col.hidden ?
          '<li data-dtr-index="' + col.columnIndex + '" data-dt-row="' + col.rowIndex + '" data-dt-column="' + col.columnIndex + '">' +
          '<span class="dtr-title">' +
          col.title +
          '</span> ' +
          '<span class="dtr-data">' +
          col.data +
          '</span>' +
          '</li>' : '';
      }).join('');
      var retVal = data ?
        $compile(angular.element($('<ul data-dtr-index="' + rowIdx + '"/>').append(data)))($scope) : false;
      $scope.$digest();
      return retVal;
    }

    $scope.dateOpts = {
      defaultDate: $scope.selectedDateObj,
      enableTime: true,
      dateFormat: "d-m-Y h:i K",
      minDate: "today",
      defaultHour: "00:00",
      defaultMinute: "00",
      position: "below",
      animate: true,
      static: true,
      time_24hr: false,
      onChange: function(selectedDates, dateStr, instance) {
        $scope.selectedDateObj = dateStr;

        var slices = dateStr.split(' ');
        $scope.scheduleDate = slices[0];
        $scope.scheduleTime = slices[1];
        $scope.candidateInterviewDate = dateStr;
      }
    };
    this.callMe = function(id) {
      $state.go($state.current, {}, {
        alerts: 'test'
      })
      let resendEmail = API.service('resendemail', API.all('joborders'))
      resendEmail.one(id).put()
        .then((response) => {
          let alert = {
            type: 'success',
            msg: 'Email Sent successfully.'
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function() {
            $(".alert-success").hide()
          }, 10000);
          //$state.go('app.vassignedjobs');
        }, (response) => {
          let alert = {
            type: 'error',
            msg: response.data.message
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function() {
            $(".alert-error").hide()
          }, 10000);
        })
    }
    this.callMee = function(gdprId) {
      var element = "Are you sure want to send mail?"
      if(confirm(element) == true){
        $state.go($state.current, {}, {
          alerts: 'test'
        })
        let resendemailpredifine = API.service('resendemailpredifine', API.all('joborders'))
        resendemailpredifine.one(gdprId).put()
          .then((response) => {
            let alert = {
              type: 'success',
              msg: 'Email Sent successfully.'
            }
            $state.go($state.current, {
              alerts: alert
            }, {
              reload: true
            })
            setTimeout(function() {
              $(".alert-success").hide()
            }, 10000);
            //$state.go('app.vassignedjobs');
          }, (response) => {
            let alert = {
              type: 'error',
              msg: response.data.message
            }
            $state.go($state.current, {
              alerts: alert
            }, {
              reload: true
            })
            setTimeout(function() {
              $(".alert-error").hide()
            }, 10000);
          }) 
      }else {
        text = "You canceled!";
      }
      }
     let userData = API.service('me', API.all('users'))
         userData.one().get()
          .then((response) => {
            let dataSet = response.plain()
            $scope.userda = dataSet;
            $scope.userda = $scope.userda.data;
            $scope.userid_prede = $scope.userda.user.role_id;
       
    if($scope.userid_prede == 5 ){
    let Emppredefinedata = API.service('emppredefineddata', API.all('dashboard'))
    Emppredefinedata.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {
            details: {
              renderer: renderer
            }
          })
          .withBootstrap()
        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Position').renderWith(job_name),
          DTColumnBuilder.newColumn(null).withTitle('Candidate Name').renderWith(candidate_name),
          DTColumnBuilder.newColumn(null).withTitle('Candidate Mobile').renderWith(candidate_mobile),
          DTColumnBuilder.newColumn(null).withTitle('Candidate Email').renderWith(candidate_email),
          DTColumnBuilder.newColumn(null).withOption('width', '18%').withTitle('Status').renderWith(cons_status),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().renderWith(actionsHtml)
        ]
        this.displayTable = true
      })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let job_name = (data) => {
        return `${data.job.name}`
     
    }
    let candidate_name = (data) => {
      if (data.numbers.GdprData.length > 0) {
        if ((data.candidate_status >= 9 && data.candidate_status <= 18) || (data.candidate_status >= 20 && data.candidate_status <= 23) || data.candidate_status == 27) {
          return `${data.numbers.GdprData[0].name}`
        } else {
          var name = data.numbers.GdprData[0].name;
          var hiddenname = "";
          var i = 0;
          var name_len = name.length - 2;
          for (i = 0; i < name.length; i++) {
            if (i > 1 && i < name_len) {
              hiddenname += "*";
            } else {
              hiddenname += name[i];
            }
          }
          return `${hiddenname}`
        }
      } else {
        return `NA`
      }
      //return `${data.candidate.full_name}`
    }
    let candidate_mobile = (data) => {
      if (data.numbers.GdprData.length > 0) {
        var mobile = data.numbers.GdprData[0].candidate_no;
        var hiddenmobile = "";
        var i = 0;
        for (i = 0; i < mobile.length; i++) {
          if (i > 2) {
            hiddenmobile += "*";
          } else {
            hiddenmobile += mobile[i];
          }
        }
        return `${hiddenmobile}`
      } else {
        return `NA`
      }
      // return `${data.candidate.phone}`
    }
    let candidate_email = (data) => {
      if (data.numbers.GdprData.length > 0) {
        var candi_email = data.numbers.GdprData[0].candidate_email;
        var email = data.numbers.GdprData[0].candidate_email;
        var hiddenEmail = "";
        var i = 0;
        for (i = 0; i < email.length; i++) {
          if (i > 2) {
            hiddenEmail += "*";
          } else {
            hiddenEmail += email[i];
          }
        }
        return `${hiddenEmail}`
      } else {
        return `NA`
      }
    }

    let cons_status = (data) => {
      if (data.numbers.emppredefineddata.length > 0) {
        return `<button class="btn btn-primary btn-xs edit_sum normalangular">Submitted</button>`
      } else {
        return `<button class="btn btn-primary btn-xs edit_sum normalangular">Pending</button>`
      }
    }

    let actionsHtml = (data) => {
      if (data.numbers.emppredefineddata.length > 0 ) {
        return `<a class="btn btn-xs" title="View This Predefined Questions Answers" ui-sref="app.predefined_question_show({jobId: '${data.job.id}', candidateId: '${data.candidate_id}'})">
                  <img width="16" src="/user_assets/assets/am-dashboard/eye.svg">
              </a>`
      } else {
        return `N/A`
      }
    }
}
else if($scope.userid_prede == 10) {

    let Ampredefineddata = API.service('ampredefineddata', API.all('dashboard'))
    Ampredefineddata.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow1)
          .withOption('responsive', {
            details: {
              renderer: renderer
            }
          })
          .withBootstrap()
        this.dtColumns = [
          DTColumnBuilder.newColumn(null).withTitle('Position').renderWith(job_namee),
          DTColumnBuilder.newColumn(null).withOption('width', '18%').withTitle('Candidate Name').renderWith(candidate_namee),
          DTColumnBuilder.newColumn(null).withTitle('Candidate Mobile').renderWith(candidate_mobilee),
          DTColumnBuilder.newColumn(null).withTitle('Candidate Email').renderWith(candidate_emaill),
          DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(cons_statuss),
          DTColumnBuilder.newColumn(null).withTitle('Resend Link').renderWith(actionsLink),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable().renderWith(actionsHtmll)
        ]
        this.displayTable = true
      })
    let createdRow1 = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let job_namee = (data) => {
      return `${data.job.name}`
    }
    let candidate_namee = (data) => {
      if(data.candidate){
      if (data.candidate.full_name !='' || data.candidate.full_name !=''){ 
      return `${data.candidate.full_name}`
      } else {
        return `NA`
      }
    }else {
      return `N/A`
    }
  }

    let candidate_mobilee = (data) => {
      if (data.candidate){
      if (data.candidate.country_code != null && (data.candidate.mobile != null || data.candidate.mobile != '')) {
        return `<span class="" style="padding-right: 10px;padding-left: 10px;padding-top: 5px;padding-bottom: 5px;">${data.candidate.country_code}&nbsp;${data.candidate.mobile} </span>`
      } else if (data.candidate.country_code == null && (data.candidate.mobile == null || data.candidate.mobile == '')) {
        return `<span class="" style="padding-right: 10px;padding-left: 10px;padding-top: 5px;padding-bottom: 5px;">${data.numbers.GdprData[0].candidate_no} </span>`

      } else {
        return `NA`
      }
    } else {
      return `N/A`
    }
  }
    let candidate_emaill = (data) => {
      if(data.candidate){
        return `${data.candidate.email}`
      } else {
        return `NA`
      }
     
    }

    let cons_statuss = (data) => {
      if (data.numbers.statuspredefined.length > 0) {
        return `<button class="btn btn-primary btn-xs edit_sum normalangular">Submitted</button>`
      } else {
        return `<button class="btn btn-primary btn-xs edit_sum normalangular">Pending</button>`
      }
    }
    let actionsLink = (data) => {
      if (data.numbers.statuspredefined.length > 0) {
        return `N/A`
      } else {
        if(data.numbers.GdprData[0]){
        return `Not Yet done &nbsp;&nbsp;<a class="btn btn-xs btn-warning" ng-click="vm.callMee('${data.numbers.GdprData[0].id}')">
                    Resend Link
                </a>`
      } else {
        return `N/A`
      }
    }
    }

    let actionsHtmll = (data) => {
         if (data.numbers.ampredefineddata.length > 0 ) {
        return `<a class="btn btn-xs" title="View This Predefined Questions Answers" ui-sref="app.predefined_question_show({jobId: '${data.job.id}', candidateId: '${data.candidate_id}'})">
                  <img width="16" src="/user_assets/assets/am-dashboard/eye.svg">
              </a>`
      } else {
        return `N/A`
      }
    }
}
 });


  }

  save(isValid) {
    if (isValid) {
      let $state = this.$state
      this.permission.put()
        .then(() => {
          let alert = {
            type: 'success',
            msg: 'Permission has been updated.'
          }
          $state.go($state.current, {
            alerts: alert
          })
          setTimeout(function() {
            $(".alert-success").hide()
          }, 6000);
          setTimeout(function() {
            $state.go('app.userpermissions');
          }, 7000);
        }, (response) => {
          let alert = {
            type: 'error',
            msg: response.data.message
          }
          $state.go($state.current, {
            alerts: alert
          })
          setTimeout(function() {
            $(".alert-error").hide()
          }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }

  $onInit() {}
}

export const PredefinedListComponent = {
  templateUrl: './views/app/components/predefined_list/predefined_list.component.html',
  controller: PredefinedListController,
  controllerAs: 'vm',
  bindings: {}
};