class PricingViewController{
   constructor($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API,$rootScope){
        'ngInject';
        'ngInject'
        this.API = API
        this.$state = $state
        $rootScope.$broadcast('pageurl', this.$state.current.url);
        function renderer(api, rowIdx, columns) {
          var data = $.map( columns, function ( col, i ) {
         return col.hidden ?
             '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                  '<span class="dtr-title">'+
                      col.title+
                '</span> '+
                '<span class="dtr-data">'+
                    col.data+
               '</span>'+
           '</li>' : 
           '';
         }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

        }

        let empPricing = API.service('emppricing', API.all('pricing'))
        empPricing.getList()
          .then((response) => {
             let dataSet = response.plain()
            this.dtInstance = {};
            $scope.dtInstance = this.dtInstance
          
            this.dtOptions = DTOptionsBuilder.newOptions()
              .withOption('data', dataSet)
              .withOption('createdRow', createdRow)
              .withOption('responsive', {details: {renderer: renderer}})
              .withOption('order', [0, 'asc'])
              .withDisplayLength(50)
              .withBootstrap()

            this.dtColumns = [
              DTColumnBuilder.newColumn('type_of_emp').withTitle('Employement Type'),
              DTColumnBuilder.newColumn(null).withTitle('Salary Starting Range').renderWith(starting_range),
              DTColumnBuilder.newColumn(null).withTitle('Salary Ending Range').renderWith(ending_range),
              DTColumnBuilder.newColumn(null).withTitle('Price').renderWith(customprice),
              DTColumnBuilder.newColumn('price_type').withTitle('Price Type')
            ]

            this.displayTable = true
          })
        let createdRow = (row) => {
          $compile(angular.element(row).contents())($scope)
        }
        let customprice = (data) => {
            if(data.revised_price) {return `${data.revised_price}`}
            else if (data.price) {return `${data.price}`}
            else  {return ``}
        }
        let starting_range = (data) => {
            if(data.starting_range) {return `<i class="fa fa-inr"></i> ${data.starting_range}`}
            else  {return `0`}
        }
        let ending_range = (data) => {
            if(data.ending_range) {return `<i class="fa fa-inr"></i> ${data.ending_range}`}
            else  {return `0`}
        }
    }

    $onInit(){
          
    }
}

export const PricingViewComponent = {
    templateUrl: './views/app/components/pricing-view/pricing-view.component.html',
    controller: PricingViewController,
    controllerAs: 'vm',
    bindings: {}
};
