class ProfileViewController{
    constructor($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope,$http, $window){
        'ngInject';
        this.API = API
        this.$state = $state
        $scope.requiredTags = []
        $scope.requiredTagsArr = []
        $scope.child=0;
        $scope.parent=1;
        $rootScope.$broadcast('pageurl', this.$state.current.url);
        $scope.candidateId = $stateParams.JoborderId;
        //

        let Users = API.service('candidatedatapdfdownload', API.all('jobsorders'))
        Users.one($scope.candidateId).get()
          .then((response) => {
            console.log(response)
            this.candidatedata = response.data.candidateDataPDF[0];      
          })

          $scope.printToCart = function() {
            document.body.classList.add("htmltocanvas");
            $('#downoload').text('Downloading ...');
            $('#downoload').hide();
            $("#all-profiles").removeClass('dataTable');
            $('#all-profiles tr:even').not(':first').after('<div class="html2pdf__page-break"></div>');
      
            $('#all-profiles tr').each(function(){
              var tr = this;
              var content = $(this).find('.expandedcontent').html();
              var content1 = $(this).find('.expandednotecontent').html();
              if(content) {
                $('<tr class="ai-row" style="display:none;"><td colspan="8"  style="border-top: 1px solid #0f0;border-bottom: 1px solid #0f0; ">'+content+'</td><td></td></tr>').insertAfter(tr);
              }
              if(content1) {
                $('<tr class="ai-row" style="display:none;"><td colspan="8"  style="border-top: 1px solid #0f0;border-bottom: 1px solid #0f0; ">'+content1+'</td><td></td></tr>').insertAfter(tr);
              }
            });
      
            $('#all-profiles tr:even').not(':first').after('<div class="html2pdf__page-break"></div>');
      
            var svgElements = $("#all-profiles").find('svg');
      
            //replace all svgs with a temp canvas
            svgElements.each(function() {
              var canvas, xml;
      
              // canvg doesn't cope very well with em font sizes so find the calculated size in pixels and replace it in the element.
              $.each($(this).find('[style*=em]'), function(index, el) {
                $(this).css('font-size', getStyle(el, 'font-size'));
              });
      
              canvas = document.createElement("canvas");
              canvas.className = "screenShotTempCanvas";
              //convert SVG into a XML string
              xml = (new XMLSerializer()).serializeToString(this);
      
              // Removing the name space as IE throws an error
              xml = xml.replace(/xmlns=\"http:\/\/www\.w3\.org\/2000\/svg\"/, '');
      
              //draw the SVG onto a canvas
              canvg(canvas, xml);
              $(canvas).insertAfter(this);
              //hide the SVG element
              $(this).attr('class', 'tempHide');
              $(this).hide();
            });
            $('#downoload').hide();
            var element = document.getElementById('detailed_info');
            html2pdf(element, {
              margin:       [30,5],
              filename:     'HireXtra_Profiles_Summary.pdf',
              image:        { type: 'jpeg', quality: 1 },
              html2canvas:  { dpi: 192, letterRendering: true, allowTaint: true},
              jsPDF:        { unit: 'pt', format: 'letter', orientation: 'landscape' },
              pdfCallback: myCallback
            });
            
            $("#all-profiles").find('.screenShotTempCanvas').remove();
            $("#all-profiles").find('.tempHide').show().removeClass('tempHide');
            document.body.className = document.body.className.replace("htmltocanvas","");
            $("#all-profiles").addClass('dataTable');
            function myCallback(pdfObject) {
                var number_of_pages = pdfObject.internal.getNumberOfPages()
                var pdf_pages = pdfObject.internal.pages
                var myFooter = "Intellectual property of HireXtra. All rights reserved."
                for (var i = 1; i < pdf_pages.length; i++) {
                    // We are telling our pdfObject that we are now working on this page
                    pdfObject.setPage(i)
                    pdfObject.setFont("helvetica");
                    pdfObject.setFontSize(10);
                    pdfObject.setFontType("normal");
                    pdfObject.setTextColor(30,30,30);
                    // The 10,200 value is only for A4 landscape. You need to define your own for other page sizes
                    pdfObject.text("Page "+i+" of "+number_of_pages, 25, pdfObject.internal.pageSize.height-10)
                    pdfObject.setFontType("bold");
                    pdfObject.setFontSize(10);
                    pdfObject.setTextColor(179,34,27);
                    pdfObject.text(myFooter, pdfObject.internal.pageSize.width-270, pdfObject.internal.pageSize.height-10)
                }
      
                var today = new Date();
                var dd = today.getDate();
                var mm = today.getMonth()+1; //January is 0!
      
                var yyyy = today.getFullYear();
                if(dd<10){
                    dd='0'+dd;
                } 
                if(mm<10){
                    mm='0'+mm;
                } 
                var jobId = $('#printotcart').data('jobid');
                pdfObject.save("HireXtra_Profiles_Summary"+jobId+"_"+dd+mm+yyyy+".pdf");
                $('#downoload').show();
                $('#downoload').text('Download Complete');
            }
          }
    }

    $onInit(){
    }
}

export const ProfileViewComponent = {
    templateUrl: './views/app/components/profileview/profileview.component.html',
    controller: ProfileViewController,
    controllerAs: 'vm',
    bindings: {}
};
