class ResetPasswordController {
  constructor ($scope, API, $state, $location,$rootScope, $stateParams, $http) {
    'ngInject'

    this.API = API
    this.$state = $state
    this.$location = $location
    this.$scope=$scope
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    $scope.email = $stateParams.email;
    let email1 = $stateParams.email;
     this.API.all('auth/password/validateemail_pcreate').post({
       email: $scope.email,
     }).then((res) => {
      $scope.days=res.data.interval.days;
      $scope.recreate=res.data.email_verified;
     });
  }

  $onInit () {
    this.password = ''
    this.password_confirmation = ''
    this.isValidToken = false
    this.formSubmitted = false
    this.verifyToken()
  }

  verifyToken () {

    let email = this.$state.params.email
    let token = this.$state.params.token
    this.API.all('auth/password').get('verify', {
    email, token}).then(() => {
      this.isValidToken = true
    }, () => {
      this.$state.go('app.landing')
    })
  }
  submitread () {
    this.alerts = []
    let $scope=this.$scope
    this.API.all('auth/password/fpemail').post({
      email: $scope.email,
    }).then(() => {
      let alrtArr = []
        alrtArr = {type: 'success', 'title': 'Success!', msg: 'An email sent with password reset instructions.'}
        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-success").hide(); document.getElementById('clear_input').value=''; }, 6000);
        }, (res) => {
        let alrtArr = []
        angular.forEach(res.data.errors, function (value) {
        alrtArr = {type: 'error', 'title': 'Error!', msg: value[0]}
        setTimeout(function(){ $(".alert-success").hide() }, 6000);
        })

      })
    this.formSubmitted = true
  }
  submit (isValid) {
    let $state = this.$state
    if (isValid) {
      this.alerts = []
      let data = {
        email: this.$state.params.email,
        email_verification_code: this.$state.params.token,
        password: this.password,
        password_confirmation: this.password_confirmation
      }

      this.API.all('auth/password/reset').post(data).then(() => {
        let alrtArr = []
        alrtArr = {type: 'success', msg: 'Your account has been created, You may now login.'}
        this.alerts.push(alrtArr)
        setTimeout(function(){ 
          $(".alert-success").hide()
          $state.go('login');
        }, 3000);
      }, (res) => {
        let alrtArr = []

        angular.forEach(res.data.errors, function (value) {
          alrtArr = {type: 'error', msg: value[0]}
        })

        this.alerts.push(alrtArr)
        setTimeout(function(){ $(".alert-error").hide() }, 10000);
      })
    } else {
      this.formSubmitted = true
    }
  }
}

export const ResetPasswordComponent = {
  templateUrl: './views/app/components/reset-password/reset-password.component.html',
  controller: ResetPasswordController,
  controllerAs: 'vm',
  bindings: {}
}
