class SelectFirstCallController{
    constructor ($scope, $state, $compile, DTOptionsBuilder, DTColumnBuilder, $uibModal, API, ContextService, $rootScope,$log) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$scope=$scope
    this.$log=$log

    $rootScope.$broadcast('pageurl', this.$state.current.url);

    ContextService.me(function (data) {
      $scope.loggedInUserData = data
    })

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }

    
    let getCountry = API.service('country', API.all('users'))
    getCountry.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.country = dataSet
      });
    let Users = API.service('guestusers', API.all('guests'))

    Users.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('company').withTitle('Company Name'),
          DTColumnBuilder.newColumn('name').withTitle('Full Name'),
          DTColumnBuilder.newColumn('type').withTitle('Role Name'),
          DTColumnBuilder.newColumn('phone_number').withTitle('Mobile'),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn('created_at').withTitle('Requested On'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `
          <a class="btn btn-xs btn-success" ui-sref="app.calldetails({ employerId: ${data.id} })" title="View the caller details"><i class="fa fa-eye"></i></a>
          <a ui-sref="app.completedCallsData({ employerId: ${data.id} })" ng-if="${data.processSurveyApprove} == 1" class="btn btn-xs btn-success" title="Process Survey Completed"><i class="fa fa-phone"></i></a>
          <a ui-sref="app.firstCall({ employerId: ${data.id}, roleName: type })" ng-if="${data.processSurveyApprove} == 0" class="btn btn-xs btn-danger" title="Take First call on process support"><i class="fa fa-phone"></i></a>
          <button class="btn btn-xs btn-danger" ng-if="${data.id} != 6 && ${data.id} != 4 && ${data.id} != 2" title="Assign to Executive" ng-click="vm.modalOpen(${data.id})">
            <i class="fa fa-plus"></i></button>
        `
    }

    let filter = (data) => {
        $scope.filterItems = $scope.Users;
        console.log($scope.filterItems)
    }

    $scope.changejobtype = function(id){
      let UserData = API.service('changejobtype', API.all('users'))
      UserData.one(id).get()
        .then((response) => {
       $state.reload()
      });

    }
  }

delete (userId) {
    let API = this.API
    let $state = this.$state
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
}

modalOpen (id) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let jobOrderId = id
    let API = this.API
    let $state = this.$state

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        jobOrderId: jobOrderId,
        vendorForm: function () {return $scope.vendorForm;} }
    })
    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => { 
      $log.info('Modal dismissed at: ' + new Date()) 
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    });
}

modalcontroller ($scope, $uibModalInstance, $state, API, vendorForm, jobOrderId) {
    'ngInject'
    this.jobOrderId = jobOrderId
    $scope.vendorForm = vendorForm
    let vendors = API.service('processexedata', API.all('users'))
    vendors.one(jobOrderId).getList()
       .then((response) => {this.items = response.plain()})
    this.ok = () => {$uibModalInstance.close($scope.selected.item) }
    this.cancel = () => {$uibModalInstance.dismiss('cancel')}
    this.save = (isValid) => {
      $state.go($state.current, {}, { alerts: 'test' })
      if (isValid) {
        let assignJobs = API.service('assignvendors', API.all('joborders'))        
        assignJobs.post({
          'vendors': this.vendors,
          'jobOrderId': this.jobOrderId,
        }).then((response) =>  {
         $uibModalInstance.dismiss('cancel')
          let alert = { type: 'success', msg: 'Job assigned to vendors successfully.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, function (response) {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
      } else {this.formSubmitted = true}
    }
  }


  $onInit () {}
}

export const SelectFirstCallComponent = {
    templateUrl: './views/app/components/select-first-call/select-first-call.component.html',
    controller: SelectFirstCallController,
    controllerAs: 'vm',
    bindings: {}
};
