class SkillsController{
  constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService, $rootScope,$http) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    this.$compile = $compile
    this.DTOptionsBuilder = DTOptionsBuilder
    this.DTColumnBuilder = DTColumnBuilder
    this.animationsEnabled = true
    this.alerts = []
    $rootScope.$broadcast('pageurl', this.$state.current.url); 
    $("#myModalData").modal('show');
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
        return col.hidden ?
            '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
              '</span>'+
          '</li>' : 
          '';
        }).join('');
        var retVal =  data ?
            $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;
    }
    let candidates = this
    let jobsclosedData = API.service('vendorassignedjobsclosed', API.all('joborders'))
    
    jobsclosedData.getList()
      .then((response) => {
        let dataSet = response.plain()
        candidates.jobsclosed=dataSet;
    })
    let joborderId = $stateParams.JoborderId;
    $scope.skillType = $stateParams.skillType;
    $scope.privateAreaCheck = $stateParams.isPrivateareaChecked;
    if($scope.privateAreaCheck=='false'){
      $scope.privateAreaCheck = false;
    }
    else{
      $scope.privateAreaCheck = true;
    }
  
    if ($scope.skillType == 'preferredSkills') {
      $scope.pageHeader = "Preferred Skills";
    } else {
      $scope.pageHeader = "Required Skills";
    }

    let Decript = API.service('decryption', API.all('joborders'))
    Decript.one(joborderId).get()
    .then((response) => {
      let jobid_split = response.data.decryption;
      let split_arr = jobid_split.split('-');
      joborderId = split_arr[1];

        let skilltypefiledata = API.service('skilltypefiledata', API.all('rchilliResume'))
        skilltypefiledata.post({
          'job_id': joborderId,
          'skillType': $scope.skillType,
          'privateAreaCheck': $scope.privateAreaCheck
        }).then((response) => {
          let dataSet = response.plain();
          $scope.skills = dataSet.data.candidates;
          this.dtOptions = DTOptionsBuilder.newOptions()
            .withOption('data', $scope.skills)
            .withOption('createdRow', createdRow)
            .withOption('responsive', {details: {renderer: renderer}})
            .withOption('aaSorting', [[3, 'desc']])
            .withOption('order', [0, 'desc'])
            .withDisplayLength(10)
            .withBootstrap()
                this.dtOptions.withButtons([
          {
              text:  '<div class="flip-box-inner tooltip-hx" ng-mouseover="openTooltip()" title="Average Stay" data-toggle="tooltip" data-placement="auto"  data-original-title="Average Stay"><img src="/profileicons/averagestay.png"/><div class="overlay"><img src="/profileicons/averagestay_P.png"/></div></div>',
              key: '1',
              action: function (e, dt, node, config) {
                  $(".matchiconsspan").show();
                  $(".matchiconsspangap").hide();
                  $(".matchiconsspanlong").hide();
                  $(".matchiconsspanexp").hide();
                  $(".matchiconsspanagen").hide();
              },
              className: '',
              //-----------------------------------
              init: function(dt, node, config) {
                  node.attr('access', "ROLE_ADMIN")
              }
          },
          {
              text: '<div class="flip-box-inner tooltip-hx" ng-mouseover="openTooltip()" title="Gaps" data-toggle="tooltip" data-placement="auto"  data-original-title="Gaps"><img src="/profileicons/gaps.png"/><div class="overlay"><img src="/profileicons/gap_P.png"></div></div>',
              key: '2',
              action: function (e, dt, node, config) {
                  $(".matchiconsspan").hide();
                  $(".matchiconsspangap").show();
                  $(".matchiconsspanlong").hide();
                  $(".matchiconsspanexp").hide();
                  $(".matchiconsspanagen").hide();
              },
              className: '',
              //-----------------------------------
              init: function(dt, node, config) {
                  node.attr('access', "ROLE_ADMIN")
              }
          },
          {
              text: '<div class="flip-box-inner tooltip-hx" ng-mouseover="openTooltip()" title="Longest Stay" data-toggle="tooltip" data-placement="auto"  data-original-title="Longest Stay"><img src="/profileicons/longeststay.png"/><div class="overlay"><img src="/profileicons/longstay_P.png"></div></div>',
              key: '3',
              action: function (e, dt, node, config) {
                  $(".matchiconsspan").hide();
                  $(".matchiconsspangap").hide();
                  $(".matchiconsspanlong").show();
                  $(".matchiconsspanexp").hide();
                  $(".matchiconsspanagen").hide();
              },
              className: '',
              //-----------------------------------
              init: function(dt, node, config) {
                  node.attr('access', "ROLE_ADMIN")
              }
          },
          {
              text:  '<div class="flip-box-inner tooltip-hx" ng-mouseover="openTooltip()" title="Experience" data-toggle="tooltip" data-placement="auto"  data-original-title="Experience"><img src="/profileicons/experience.png"/><div class="overlay"><img src="/profileicons/Experience_P.png"></div></div>',
              key: '4',
              action: function (e, dt, node, config) {
                  $(".matchiconsspan").hide();
                  $(".matchiconsspangap").hide();
                  $(".matchiconsspanlong").hide();
                  $(".matchiconsspanexp").show();
                  $(".matchiconsspanagen").hide();
              },
              className: '',
              //-----------------------------------
              init: function(dt, node, config) {
                  node.attr('access', "ROLE_ADMIN")
              }
          }         
        ])
      
          this.dtColumns = [ 
            DTColumnBuilder.newColumn(null).withTitle('ID').withOption('width', '10%').renderWith(job_id),
            DTColumnBuilder.newColumn(null).withTitle('Full Name').withOption('width', '10%').renderWith(job_profile),
            DTColumnBuilder.newColumn('total_experience_in_year').withTitle('Experience (Yr)').withClass('text-center').withOption('width', '8%'),
            DTColumnBuilder.newColumn('job_profile').withTitle('Job Applied').withClass('text-center').withOption('width', '10%'),
            DTColumnBuilder.newColumn(null).withTitle('Location').withClass('text-center').renderWith(location),
            DTColumnBuilder.newColumn(null).withTitle( 'HireXtra AI Job Match').withOption('width', '26%').withClass('dynamicSort').renderWith(overall_match),
            DTColumnBuilder.newColumn(null).withTitle('Skills').withOption('width', '30%').renderWith(returnSkill),       
            DTColumnBuilder.newColumn(null).withTitle('Candidate Rating').withClass('text-center').withOption('width', '10%').renderWith(profile_rating),
            DTColumnBuilder.newColumn(null).withTitle('History').withOption('width', '15%').renderWith(history),
            DTColumnBuilder.newColumn(null).withTitle('Actions').withOption('width', '10%').withClass('text-center').notSortable()
              .renderWith(actionsHtml)
          ]
          this.displayTable = true
          $("#myModalData").modal('hide');
        })
    })
    let job_id = (data) => {
      return `${data.id} <span class="private-area-icon" ng-if="${data.is_privatearea} == '0'"><svg xmlns="http://www.w3.org/2000/svg" width="10.547" height="17.191" viewBox="0 0 10.547 17.191">
      <g id="Group_5377" data-name="Group 5377" transform="translate(7643 -10204)">
        <circle id="Ellipse_581" data-name="Ellipse 581" cx="4" cy="4" r="4" transform="translate(-7642 10205)" fill="#fff"/>
        <g id="Group_5364" data-name="Group 5364" transform="translate(-7643 10204)">
          <path id="Path_12297" data-name="Path 12297" d="M501.283-28.026c-.256-.423-.5-.821-.734-1.214a54.852,54.852,0,0,1-3.218-6.146,22.247,22.247,0,0,1-.849-2.193,7.893,7.893,0,0,1-.469-2.521,5.275,5.275,0,0,1,1.819-3.829,5.275,5.275,0,0,1,4.049-1.254,5.268,5.268,0,0,1,4.676,5.42,8.636,8.636,0,0,1-.57,2.507,36.6,36.6,0,0,1-2.274,5.011q-1.1,2.076-2.339,4.072Zm-4.1-11.982a4.044,4.044,0,0,0,4.035,4.051A4.05,4.05,0,0,0,505.265-40a4.049,4.049,0,0,0-1.189-2.87A4.049,4.049,0,0,0,501.2-44.05a4.042,4.042,0,0,0-4.018,4.042Z" transform="translate(-496.014 45.217)" fill=""/>
          <path id="Path_12298" data-name="Path 12298" d="M505.792-34.9h-1.41a.483.483,0,0,1-.367-.135.482.482,0,0,1-.147-.363q-.008-1.112,0-2.224a.47.47,0,0,1,.142-.352.47.47,0,0,1,.356-.133c.116,0,.147-.028.146-.146a3.152,3.152,0,0,1,.046-.855,1.3,1.3,0,0,1,1.352-.927,1.289,1.289,0,0,1,1.153,1.11,5.775,5.775,0,0,1,.019.71c0,.078.02.114.1.106a.5.5,0,0,1,.4.148.5.5,0,0,1,.141.4c0,.7,0,1.406,0,2.11a.5.5,0,0,1-.143.4.5.5,0,0,1-.4.144Zm0-3.21h.768c.061,0,.091-.014.09-.082,0-.206,0-.413,0-.619a.852.852,0,0,0-.722-.785.844.844,0,0,0-.953.624,3.944,3.944,0,0,0-.027.811c0,.067.052.054.091.054ZM505.58-36.2h0v.206a.218.218,0,0,0,.055.158.218.218,0,0,0,.152.072.221.221,0,0,0,.16-.067.221.221,0,0,0,.062-.162c0-.111,0-.222,0-.332a.243.243,0,0,1,.082-.21.415.415,0,0,0,.13-.3.415.415,0,0,0-.13-.3.427.427,0,0,0-.582-.008.415.415,0,0,0-.14.3.415.415,0,0,0,.121.306.264.264,0,0,1,.091.24.933.933,0,0,0,0,.107Z" transform="translate(-500.525 42.491)" fill=""/>
        </g></g></svg></span>`;
    }
    let job_profile = (data) => {
      return `<a ui-sref="app.candidateprofileview({candidateId: '${data.numbers.encrypted_canId}'})">${data.full_name}</a>`;
    }
    let history = (data) => {
      return `
      <ul class="candidate-history">
        <li ng-mouseover="openTooltip()" title="Shotlisted" ><img src="/user_assets/assets/emp_dashboard/shorlist.svg" width="22" class="img-q"><span>${data.shotlisted}</span></li>
        <li ng-mouseover="openTooltip()" title="Interviewed"><img src="/user_assets/assets/emp_dashboard/intervied.svg" width="22" class="img-q"><span>${data.interviewed}</span></li>
        <li ng-mouseover="openTooltip()" title="Final Interview"><img src="/user_assets/assets/emp_dashboard/final-round.svg" width="22" class="img-q"><span>${data.final_interview}</span></li>
        <li ng-mouseover="openTooltip()" title="Selected"><img src="/user_assets/assets/emp_dashboard/select.svg" width="22" class="img-q"><span>${data.selected}</span></li>
      </ul>`;
    }
    let returnSkill = (data) => {
        if(data.skill != null){
          let string = data.skill.skill_set;
          let length = 300;
          let trimmedString = string.substring(0, length);
            if(string.length  >300){
                var clickmore ='Read more' ;
            }else{
                  var clickmore ='' ;
            }
            return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">${clickmore}</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`

        }else { return ` `; }
    }
    
    let location = (data) => {
      if(data.city){
        return `${data.city}`
      }
      if(data.state){
        return `${data.state}`
      }
      if(data.country){
        return `${data.country}`
      }
      if(data.current_location){
        return `${data.current_location}`
      } 
    }

    let overall_match = (data) => {
     // return  '<span  ng-mouseover="openTooltip()"   title="HireXtra AI Matching Algorithm Says This Profile Is Moderate"  data-toggle="tooltip" data-placement="auto"><img src="/user_assets/Moderate.gif" style="height:100px;width:240px;"></span>'
            if(data.candidate_details !=null ){
              if( data.candidate_details.gapperiod){
                  var pathbino='/user_assets/assets/am-dashboard/binoclusred.svg';
                  var gapperiod=data.candidate_details.gapperiod+' Months';
              }else{
                var pathbino='/user_assets/assets/am-dashboard/binoclus.svg';
                var gapperiod='No Gaps';
              }
              if(data.candidate_details.averageStay.length >0){
                var averageStay=data.candidate_details.averageStay+' Months';
              }else{var averageStay="Not Extracted"}
              if(data.total_experience_in_year.length >0){
                var total_experience_in_year=data.total_experience_in_year+' Yrs';
              }else{var total_experience_in_year="Not Extracted"}
              if(data.candidate_details.LongestStay.length >0){
                var LongestStay=data.candidate_details.LongestStay+' Months';
              }else{var LongestStay="Not Extracted"}
            }else{
              var pathbino='/user_assets/assets/am-dashboard/binoclus.svg';
              var gapperiod='No Gaps';
              var averageStay="Not Extracted"
              var total_experience_in_year="Not Extracted"
              var LongestStay="Not Extracted"
            }
     if(data.candidate_points  == null){     
       return `<p style="float:right;"> <img src="/user_assets/assets/am-dashboard/smile-2.svg" style="color: #000000;" title="Profile Quality is Poor" > </p>
                 <span  ng-mouseover="openTooltip()"   title="HireXtra AI Matching Algorithm Says This Profile Is Poor" data-toggle="tooltip"  data-placement="auto">
                <img src="/user_assets/Poor.gif" style="height:100px;width:240px;"></span>
                <span class="matchiconsspan">Average stay: `+averageStay+` </span>
                <span class="matchiconsspangap">Gaps: `+gapperiod+`</span>
                <span class="matchiconsspanlong">Longest Stay: `+LongestStay+`</span>
                <span class="matchiconsspanexp">Experience: `+total_experience_in_year+`</span>
                `
              }

              else{
            if( data.candidate_points.over_all_status == "Excellent Match"){
                return `<p style="float:right;">
              <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Excellent" ng-show="'${data.candidate_points.over_all_status}' == 'Excellent Match'" class="fa fa-smile-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-1.svg"  title="Profile Quality is Moderate" ng-show="'${data.candidate_points.over_all_status}' == 'Moderate Match'">
                <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Detailed" ng-show="'${data.candidate_points.over_all_status}' == 'Good Match'" class="fa fa-smile-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Average"     ng-show="'${data.candidate_points.over_all_status}' == 'Average Match'" class="fa fa-frown-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-2.svg" style="color: #000000;" title="Profile Quality is Poor" ng-show="'${data.candidate_points.over_all_status}' == 'Poor Match'" class="fa fa-frown-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/eye-g.svg" style="color: #000000;cursor:pointer;" data-toggle="modal" data-target="#view_guage_loops" title="Read More" class=" expandrow">
                </p>
                <span  ng-mouseover="openTooltip()" title="HireXtra AI Matching Algorithm Says This Profile Is Excellent" data-toggle="tooltip" data-placement="auto">
                <img src="/user_assets/Excellent.gif" style="height:100px;width:240px;"></span>
                <span class="matchiconsspan">Average stay: `+averageStay+` </span>
                <span class="matchiconsspangap">Gaps: `+gapperiod+`</span>
                <span class="matchiconsspanlong">Longest Stay: `+LongestStay+`</span>
                <span class="matchiconsspanexp">Experience: `+total_experience_in_year+`</span>
                `
            }

            if( data.candidate_points.over_all_status == "Good Match"){
              return `<p style="float:right;">
               <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Excellent" ng-show="'${data.candidate_points.over_all_status}' == 'Excellent Match'" class="fa fa-smile-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-1.svg"  title="Profile Quality is Moderate" ng-show="'${data.candidate_points.over_all_status}' == 'Moderate Match'">
                <img src="/user_assets/assets/am-dashboard/smile.svg" title="Profile Quality is Good" ng-show="'${data.candidate_points.over_all_status}' == 'Good Match'" />
                <img src="/user_assets/assets/am-dashboard/smile-1.svg" style="color: #000000;" title="Profile Quality is Average"     ng-show="'${data.candidate_points.over_all_status}' == 'Average Match'" class="fa fa-frown-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-2.svg" style="color: #000000;" title="Profile Quality is Poor" ng-show="'${data.candidate_points.over_all_status}' == 'Poor Match'" class="fa fa-frown-o fa-2x"></i>
                </p>
                <span  ng-mouseover="openTooltip()" title="HireXtra AI Matching Algorithm Says This Profile Is Good" data-toggle="tooltip" data-placement="auto">
                <img src="/user_assets/Good.gif"  style="height:100px;width:240px;"></span>
                <span class="matchiconsspan">Average stay: `+averageStay+` </span>
                <span class="matchiconsspangap">Gaps: `+gapperiod+`</span>
                <span class="matchiconsspanlong">Longest Stay: `+LongestStay+`</span>
                <span class="matchiconsspanexp">Experience: `+total_experience_in_year+`</span>
                `
            }
            if( data.candidate_points.over_all_status == "Moderate Match"){              
              return `<p style="float:right;">
              <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Excellent" ng-show="'${data.candidate_points.over_all_status}' == 'Excellent Match'" class="fa fa-smile-o fa-2x"></i>
              <img src="/user_assets/assets/am-dashboard/smile-1.svg"  title="Profile Quality is Moderate" ng-show="'${data.candidate_points.over_all_status}' == 'Moderate Match'">              <img src="/user_assets/assets/am-dashboard/smile.svg" title="Profile Quality is Detailed" ng-show="'${data.candidate_points.over_all_status}' == 'Good Match'" class="fa fa-smile-o fa-2x"></i>
              <img src="/user_assets/assets/am-dashboard/smile-1.svg" style="color: #000000;" title="Profile Quality is Average"     ng-show="'${data.candidate_points.over_all_status}' == 'Average Match'" class="fa fa-frown-o fa-2x"></i>
              <img src="/user_assets/assets/am-dashboard/smile-2.svg" style="color: #000000;" title="Profile Quality is Poor" ng-show="'${data.candidate_points.over_all_status}' == 'Poor Match'" class="fa fa-frown-o fa-2x"></i>
             </p>
              <span  ng-mouseover="openTooltip()"   title="HireXtra AI Matching Algorithm Says This Profile Is Moderate"  data-toggle="tooltip" data-placement="auto">
           <img src="/user_assets/Moderate.gif" style="height:100px;width:240px;"></span>
           <span class="matchiconsspan">Average stay: `+averageStay+` </span>
           <span class="matchiconsspangap">Gaps: `+gapperiod+`</span>
           <span class="matchiconsspanlong">Longest Stay: `+LongestStay+`</span>
           <span class="matchiconsspanexp">Experience: `+total_experience_in_year+`</span>
           `
              }
              if( data.candidate_points.over_all_status == "Average Match"){    
                return `<p style="float:right;">
                <img src="/user_assets/assets/am-dashboard/smile.svg" style="color: #000000;" title="Profile Quality is Excellent" ng-show="'${data.candidate_points.over_all_status}' == 'Excellent Match'" class="fa fa-smile-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-1.svg"  title="Profile Quality is Moderate" ng-show="'${data.candidate_points.over_all_status}' == 'Moderate Match'">    <img src="/user_assets/assets/am-dashboard/smile.svg" title="Profile Quality is Detailed" ng-show="'${data.candidate_points.over_all_status}' == 'Good Match'" class="fa fa-smile-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-1.svg" style="color: #000000;" title="Profile Quality is Average"     ng-show="'${data.candidate_points.over_all_status}' == 'Average Match'" class="fa fa-frown-o fa-2x"></i>
                <img src="/user_assets/assets/am-dashboard/smile-2.svg" style="color: #000000;" title="Profile Quality is Poor" ng-show="'${data.candidate_points.over_all_status}' == 'Poor Match'" class="fa fa-frown-o fa-2x"></i>
                </p>
                <span  ng-mouseover="openTooltip()"  title="HireXtra AI Matching Algorithm Says This Profile Is Average" data-toggle="tooltip" data-placement="auto">
                <img src="/user_assets/Average.gif" style="height:100px;width:240px;"></span>
                <span class="matchiconsspan">Average stay: `+averageStay+` </span>
                <span class="matchiconsspangap">Gaps: `+gapperiod+`</span>
                <span class="matchiconsspanlong">Longest Stay: `+LongestStay+`</span>
                <span class="matchiconsspanexp">Experience: `+total_experience_in_year+`</span>
                `
              }
             
              } 
            }
              
            
    let profile_rating = (data) => {
      if(data.rating != null) {
        var rating = Math.round(data.rating);
        if(rating == 1) {
          return `<span ng-hide='true'>1</span> <i class="fa fa-star" aria-hidden="true"></i>`
        } else if(rating == 2) {
          return `<span ng-hide='true'>2</span> <i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i>`
        } else if(rating == 3) {
          return `<span ng-hide='true'>3</span> <i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i>`
        } else if(rating == 4) {
          return `<span ng-hide='true'>4</span> <i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i>`
        } else if(rating == 5) {
          return `<span ng-hide='true'>5</span> <i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i><i class="fa fa-star" aria-hidden="true"></i>`
        } else {
          return '-'
        }
      } else {return `-` }
    } //profile_rating  
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
    let actionsHtml = (data) => {
      console.log('skills file 151',data)
      if(data.notes != null)
      {
  
        var notese = data.notes.note_description;
      }
      else {
        var notese = data.note;
      }
      return `  <button class="btn btn-xs w_ca" style="background: none;" title="Submit profile to Jobs" ng-click="vm.modalOpen(${data.id},'${data.full_name}')">
                             <img src="/user_assets/assets/emp_dashboard/plus.svg" width="18" class="img-q">
               </button>
                &nbsp;
                <button class="btn btn-xs w_ca" style="background: none;" title="Profile Activity" ng-click="vm.profileactivity(${data.id})">
                    <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                &nbsp;
                <button class="btn btn-xs w_ca" style="background: none;" title="Note" ng-click="vm.modalNote(${data.id},'${data.note}', '${data.full_name}', '${data.updated_at}')">
                    <img src="/user_assets/assets/emp_dashboard/note.svg" width="18" class="img-q">
                </button>
                `
    }
  }


    delete (userId) {
      let API = this.API
      let $state = this.$state
      swal({
        title: 'Are you sure?',
        text: 'You will not be able to recover this data!',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: 'Yes, delete it!',
        closeOnConfirm: false,
        showLoaderOnConfirm: true,
        html: false
      }, function () {
        API.one('candidates').one('user', userId).remove()
          .then(() => {
            swal({
              title: 'Deleted!',
              text: 'Candidates Profile has been deleted.',
              type: 'success',
              confirmButtonText: 'OK',
              closeOnConfirm: true
            }, function () {
              $state.reload()
            })
          })
      })
    }
    modalNote (id,note ,full_name,updated_at ) {
      let candidate_id=id
      let $uibModal = this.$uibModal
      let $scope = this.$scope
      let $log = this.$log
      let API = this.API
      let Note = note
      let Full_name = full_name
      let Updated_at = updated_at
      var modalInstance = $uibModal.open({
        animation: this.animationsEnabled,
        templateUrl: 'myModalContent1.html',
        controller: this.modalnotecontroller,
        controllerAs: 'mvm',
        resolve: { 
          Candidate_id: function() { return candidate_id;},
          Note: function() { return Note;},
          Full_name: function() { return Full_name;},
          Updated_at: function() { return Updated_at;}
        }
      })
      modalInstance.result.then((selectedItem) => { 
        $scope.selected = selectedItem
      }, () => {
        $log.info('Modal dismissed at: ' + new Date())
        if ($rootScope.previousState.name == '') {
          // No previous state to go? Go to list page
          $state.go('app.logout');
        } else {
          // Back to previous state if any
          $window.history.back();
        }
      })
    }
    modalnotecontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth,Candidate_id, Note,Full_name,Updated_at) {
      'ngInject'
      this.$state=$state
      $scope.note = Note;
      if($scope.note == null){
          $scope.note ="";
        }
      $scope.full_name = Full_name;
      $scope.updated_at = "";
      $scope.candidate_id=Candidate_id;
          let Candidates_note = API.service('candidatesnotec', API.all('candidates'))
              Candidates_note.post({ 'candidate_id':$scope.candidate_id })
              .then((response) => {
                  $scope.candidates_note = API.copy(response)
                  if($scope.candidates_note.data.candidateNotes.length > 0){
                    $scope.notes=$scope.candidates_note.data.candidateNotes;
                    if($scope.candidates_note.data.candidateNotes.length != 0){
                      if($scope.candidates_note.data.candidateNotes[0].note !=null || $scope.candidates_note.data.candidateNotes[0].note !=""){
                        $scope.notes_latest=$scope.candidates_note.data.candidateNotes[0].note;
                        $scope.notes_latest2=$scope.candidates_note.data.candidateNotes[0].note;
                        $scope.updated_at = Date.parse($scope.candidates_note.data.candidateNotes[0].updated_at);
                        if($scope.notes_latest == 'null'){
                          $scope.notes_latest ="";
                          $scope.notes_latest2 ="";
                        }
                      }
                    }
                  }else{
                      $scope.notes_latest=$scope.note;
                      if($scope.notes_latest == 'null'){
                          $scope.notes_latest ="";
                          $scope.notes_latest2 ="";
                          $scope.updated_at ="";
                        }
                    }
              })
              if( $scope.notes_latest== $scope.notes_latest2){
                  $scope.updated_but=1;
              }else{
                $scope.updated_but=0;
              }
              $scope.checking_blurr=function(){
                if( $scope.notes_latest== $scope.notes_latest2){
                  $scope.updated_but=1;
                }else{
                  $scope.updated_but=0;
                }
              }
      // $.get("https://api.ipdata.co/?api-key=4f92c2cfe0a5361b930aead1a1150b4da89f8997b17612eeb0b7ce10", function (response) {
      //   $scope.time_zone_name = response.time_zone.name;
      //   let Timezone = API.service('timezone', API.all('rchilliResume'))
      //        Timezone.post({
      //           'timezone': $scope.updated_at,
      //           'timezone_name': $scope.time_zone_name,
      //         }).then(function (response) {
      //           $scope.zone_updated_at=response.data.datetime.date;
      //           $scope.zone_updated_at= $scope.zone_updated_at.split(".");
      //           $scope.zone_updated_at= $scope.zone_updated_at[0];
      //         });
      // });
      this.alerts = []
      this.ok = () => { $uibModalInstance.close($scope.selected.item, $scope.selectedOption)}
      this.cancel = () => { $uibModalInstance.dismiss('cancel') }
      $("input[name='buyout']").click(function(){
          var buyout = $("input[name=buyout]:checked").val();
          if(buyout == "YES"){
                $("#buyout").show();
        }else{
             $("#buyout").hide();
      }
      });
      $("input[name='currentnotice']").click(function(){
        var currentnotice = $("input[name=currentnotice]:checked").val();
        if(currentnotice == "YES"){
                $("#currentnotice").show();
        }else{
             $("#currentnotice").hide();
      }
      });
      this.update=() =>{
         this.$state.go(this.$state.current, {}, { alerts: 'test' })
         let note=document.getElementById('profile_note').value;
              let CandidateNote2 = API.service('candidatenotes', API.all('candidates'))
              CandidateNote2.post({ 'note': note, 'candidate_id':Candidate_id })
              .then(function () {
                $uibModalInstance.dismiss('cancel')
                let alert = { type: 'success', msg: 'Profile (' +$scope.full_name+ ') Note is Updated.' }
                $state.go($state.current, { alerts: alert},{reload:true})
                setTimeout(function(){ $(".alert-success").hide() }, 10000);
              }, function (response) {
                let alert = { type: 'error', msg: response.data.message }
                $state.go($state.current, { alerts: alert})
                setTimeout(function(){ $(".alert-error").hide() }, 10000);
              })
      }
    }
    profileactivity (jobId) { 
      let $uibModal = this.$uibModal
      let $scope = this.$scope
      let $log = this.$log
      let items = this.jobsclosed
      let API = this.API
      let $state = this.$state
      let DTOptionsBuilder = this.DTOptionsBuilder
      let dtOptions = this.dtOptions
      let dtColumns = this.dtColumns
      let DTColumnBuilder = this.DTColumnBuilder
      let $compile = this.$compile
      var modalInstance = $uibModal.open({
        animation: this.animationsEnabled,
        templateUrl: 'profileactivity.html',
        controller: this.profileactivitycontroller,
        windowClass: 'pa_modal',
        controllerAs: 'pa',
        resolve: {
          items: () => {return items },
          candidate_activity: function () {return $scope.candidate_activity;},
          jobOrderId: function () {return jobId;},
          DTColumnBuilder: function () {return DTColumnBuilder;},
          dtColumns: function () {return dtColumns;},
          dtOptions: function () {return dtOptions;},
          DTOptionsBuilder: function () {return DTOptionsBuilder;}
        }
      })
      modalInstance.result.then((selectedItem) => { 
        $scope.selected = selectedItem
      }, () => { 
        $log.info('Modal dismissed at: ' + new Date())
        if ($rootScope.previousState.name == '') {
          $state.go('app.logout');
        } else {
          $window.history.back();
        }
      })
    } //profileactivity
  
    profileactivitycontroller ($scope, $uibModalInstance, $state, API, candidate_activity, jobOrderId, DTOptionsBuilder, dtOptions, dtColumns, DTColumnBuilder, $compile) {
      'ngInject'
      this.jobOrderId = jobOrderId
      this.DTOptionsBuilder = DTOptionsBuilder
      this.dtOptions = dtOptions
      this.dtColumns = dtColumns
      this.DTColumnBuilder = DTColumnBuilder
      this.$compile = $compile
      $scope.candidate_activity = candidate_activity
      let candidatejobwiserating = API.service('candidatejobwiserating', API.all('dashboard'))
      candidatejobwiserating.one(jobOrderId).getList()
      .then((response) => {
          $scope.jobwise_rating = response.plain()
          this.dtOptions = this.DTOptionsBuilder.newOptions()
            .withOption('data', $scope.jobwise_rating)
            .withOption('createdRow', createdRow)
            .withOption('responsive', true)
            .withOption('order', [0, 'asc'])
            .withDisplayLength(50)
            .withBootstrap()
          this.dtColumns = [ 
            this.DTColumnBuilder.newColumn(null).withTitle('ID').renderWith(jobId),
            this.DTColumnBuilder.newColumn(null).withTitle('Job Name').renderWith(job_name),
            this.DTColumnBuilder.newColumn(null).withTitle('Status').renderWith(status)
           ]
          this.displayTable = true
      })
        let jobId=(data) => {return `${data.job_id}`;}
        let job_name = (data) => {return `${data.job.name}`;} 
        let status = (data) => {return `${data.status.name}`}
        let createdRow = (row) => {this.$compile(angular.element(row).contents())($scope)}
        let candidateallactivities = API.service('candidateallactivities', API.all('dashboard'))
        candidateallactivities.one(jobOrderId).getList()
        .then((response) => {
             let Dbtimeline = response.plain()
                angular.forEach(Dbtimeline, function(value, key) {
                  let time = new Date(value.created_at).getTime()
                  Dbtimeline[key]['formatted_date'] = time
                });
              this.timeline = Dbtimeline
        });
        this.ok = () => {
        $uibModalInstance.close($scope.selected.item)
      }
  
      this.cancel = () => {
        $uibModalInstance.dismiss('cancel')
      }
  
    } //profileactivitycontroller
  
    modalOpen (jobId) { 
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.jobsclosed
    let API = this.API
    let $state = this.$state

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      backdrop: 'static',
      resolve: {
        items: () => {
          return items
          
        },
        vendorForm: function () {
            return $scope.vendorForm;
        },
        jobId: function () {
            return jobId;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }
  
  modalcontroller ($scope,$stateParams,$filter, $uibModalInstance, items, $state, API, vendorForm, jobId) {
    'ngInject'
    this.$state = $state
    this.items = items.reverse();
    console.log(this.items,'this.jobsclosed123');
    $scope.vendorForm = vendorForm
    this.jobId = jobId
    $scope.errormessage=null;
    $scope.errormessagecheck=null;
    $scope.buyout = 'No';
    $scope.currentnotice = 'No';
    $("input[name='buyout']").click(function(){
      $scope.buyout = 'YES';
    });
    $("input[name='currentnotice']").click(function(){
      $scope.currentnotice = 'YES';
    });
    $scope.selected = {
      item: items[0]
    }
 
    let vendors_checklist = API.service('vendorchecklist', API.all('joborders'))
    
    vendors_checklist.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.checklist=dataSet;
    })
    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel') 
    }
    $scope.clearError=function(){$scope.errormessagecheck='';}

    this.save_test = (isValid,candidateListForm,description) => { 
      $scope.canId=this.candidateId;
      $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
      if($scope.checklistyesdata.length >= 5){
      $state.go($state.current, {}, { alerts: 'test' }) 
      if (isValid) {
      $uibModalInstance.dismiss('cancel'); 
      let checkProfile = API.service('checkprofilevalidity', API.all('jobsorders'))
          checkProfile.post({
            'jobs': $scope.selected.item,
            'positions': $scope.vacancy,
            'candidateId': this.candidateId,
            'vendorchecklist':$scope.checklistyesdata,
          }).then(function (data) {
              $uibModalInstance.dismiss('cancel');
              if(data.data.assignedJob == 0 ){
                 let assignJobs = API.service('submitcandidatesassign', API.all('joborders'))
                  assignJobs.post({
                    'jobs': $scope.selected.item,
                    'positions': $scope.vacancy,
                    'candidateId': $scope.canId,
                    'vendorchecklist':$scope.checklistyesdata,
                  }).then(function () {
                    $uibModalInstance.dismiss('cancel')//Close modal
                    let alert = { type: 'success', 'title': 'Success!', msg: 'Profile submitted successfully.' }
                    $state.go($state.current, { alerts: alert})
                    setTimeout(function(){ $(".alert-success").hide() }, 10000);
                  }, function (data) {
                    let alert = { type: 'error', 'title': 'Error!', msg: data.data.errors.message[0] };
                    $state.go($state.current, { alerts: alert});
                    setTimeout(function(){ $(".alert-error").hide() }, 10000);
                  });
                  $uibModalInstance.dismiss('cancel')//Close modal
              } else {
                  let alert = { type: 'error', 'title': 'Error!', msg: 'This Profile Already Submitted to Employer ,Please Try With different profile' };
                  $state.go($state.current, { alerts: alert});
                  setTimeout(function(){ $(".alert-error").hide() }, 10000);
                }
          }).error(function(data) {
              $uibModalInstance.dismiss('cancel')//Close modal
              let alert = { type: 'error', 'title': 'Error!', msg: data.errors.message[0] };
              $state.go($state.current, { alerts: alert});
              setTimeout(function(){ $(".alert-error").hide() }, 10000);
          });
        } else { this.formSubmitted = true }

      }else{
         $scope.errormessagecheck="Candidate profile must satisfy at least 5 of the requirement checks";
      }
    }
    this.shownext=()=>{
      if($scope.test != undefined){
      document.getElementById('welcomeDiv').style.display = "block";
       document.getElementById('aa').style.display = "none";
        document.getElementById('welcomeDiv1').style.display = "none";
       }
       else{
        $scope.errormessage="Please choose the job to go next step";
       }
    }
    this.shownext2=(id)=>{
      $scope.operationalTags = [];
      $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
      if($scope.test != undefined && $scope.checklistyesdata.length >= 5){
        let CandidateData = API.service('candidatedata', API.all('candidates'))
            CandidateData.one(id).get()
              .then((response) => {
                console.log('------------',response.data[0])
                $scope.canId=response.data[0].id;
                $scope.nationality=response.data[0].nationality;  
                $scope.buyout=response.data[0].buyout;               ;
                $scope.full_name=response.data[0].full_name;
                $scope.total_experience_in_year=response.data[0].total_experience_in_year;
                $scope.email=response.data[0].email;
                $scope.phone=response.data[0].phone;
                $scope.preferred_location=response.data[0].preferred_location;
                $scope.qualification=response.data[0].qualification;
                $scope.operational_skills=response.data[0].candidate_operational_skill[0].operational_skills
                $scope.country_code=response.data[0].country_code_id;
                if($scope.operational_skills.length){
                  $scope.operationalTagsArr = $scope.operational_skills.split(',');
                } else {
                  $scope.operationalTags = null;
                }
                angular.forEach($scope.operationalTagsArr, function (value) {
                  if(value != 'undefined' && value != undefined && value != ""){
                  $scope.operationalTags.push({text: value})
                }
                })
                var short_country_code = $scope.country_code;
                var countryCode = document.querySelector("#phone1");
                 window.intlTelInput(countryCode, {
                  hiddenInput: "full_number",
                  initialCountry: short_country_code,
                    onlyCountries: ['GB', 'IN', 'US', 'DE', 'IT','FR','ES','NL','SE','PL','MT','GR','AT','PT','DK','CZ','HR','FI','BE','CY','HU','RO','IE','BG','LT','EE','SI','SK','LV','CHE'],
                    separateDialCode: true,
                  utilsScript: "/user_assets/css/utils.js?1562189064761",
                });
                /*let allCities = API.service('citiesofind', API.all('locations'))
                allCities.one(2).getList()
                .then((response) => {
                  $scope.masterlocations = null
                  $scope.masterlocations = response.plain()
                });*/
                let allCountries = API.service('locations')
                allCountries.getList()
                .then((response) => {
                  $scope.countries = response.plain();
                });

                let allCountries1 = API.service('locations')
                allCountries1.getList()
                .then((response) => {
                  $scope.countries1 = response.plain();
                });

                let country = API.service('currencycountry', API.all('locations'))
                country.getList()
                  .then((response) => {
                    $scope.Countrys = response.plain();
                  })

                $scope.getcities=function(countryId) {
                  let allCities = API.service('citiesof', API.all('locations'))
                  allCities.one(countryId).getList()
                  .then((response) => {
                    $scope.masterlocations2 = null
                    $scope.masterlocations2 = response.plain()
                  })
                }

                $scope.getcities1=function(countryId) {
                  let allCities1 = API.service('citiesof', API.all('locations'))
                  allCities1.one(countryId).getList()
                  .then((response) => {
                    $scope.masterlocations1 = null
                    $scope.masterlocations1 = response.plain()
                  })
                }
                $scope.noticePeriods = [ '3 Months', '2 Months','30 Days','15 days', '1 Week', 'Immediate']
                let allEducations = API.service('educations', API.all('joborders'))
                allEducations.getList()
                .then((response) => {
                  let dataSet = response.plain()
                  $scope.masterEdu=dataSet;
                });
                  document.getElementById('welcomeDiv').style.display = "none";
                 document.getElementById('aa').style.display = "none";
                 document.getElementById('welcomeDiv1').style.display = "block";

              });
       }
       else{
        $scope.errormessagecheck="Candidate profile must satisfy at least 5 of the requirement checks";
       }
    }
    this.save=(isValid,vendorForm) => {
      var country_code = $(".iti__selected-dial-code").html();
      var country_mobile = $('#phone1').val();
      let Desc=document.getElementById('note_description').innerText;
      $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
      $scope.operationalTagsArr = [];
      angular.forEach($scope.operationalTags, function (value) {
        $scope.operationalTagsArr.push(value.text)
      });
      console.log(this.city,"5");
      $scope.operationalSkills = $scope.operationalTagsArr.join(",");
      let updateCandidate = API.service('vendorcandidateupdate', API.all('candidates'))
        updateCandidate.post({
            'preferred_location': this.city,
            'preferred_country': this.prefferCountry,
            'present_country' : this.presentCountry,
            'present_location' : this.present_location,
            'nationality' : $scope.nationality,
            'currency' : $scope.currency,
            'work_autherization' : this.workautherization,
            'email': $scope.email,
            'phone': country_mobile,
            'mobile': country_mobile,
            'qualification': this.educationLevel,
            'candidateId': $scope.canId,
            'operational_skills':$scope.operationalSkills,
            'experience':$scope.total_experience_in_year,
            'aadharno':this.identityno,
            'full_name':$scope.full_name,
            'present_salary' : $scope.present_salary,
            'expected_salary': $scope.expected_salary,
            //'present_location' :$scope.cityPin,
            'relocate_locations' :this.city, //this.relocate_locations,
            'notice_period' : this.noticePeriods,
            'buyout' : $('input[name=buyout]:checked').val(),
            'currentnotice' : $('input[name=currentnotice]:checked').val(),
            'note_description' : Desc,
            'country_code':country_code,
            'jobID' : $scope.selected.item
        }).then(function (data) {
          console.log($scope.checklistyesdata);
          //alert("called");
             let checkProfile = API.service('checkprofilevalidity', API.all('jobsorders'))
              checkProfile.post({
                'jobs': $scope.selected.item,
                'positions': $scope.vacancy,
                'candidateId': $scope.canId,
                'vendorchecklist':$scope.checklistyesdata,
              }).then(function (data) {
              $uibModalInstance.dismiss('cancel');
              if(data.data.assignedJob == 0 ){
                 let assignJobs = API.service('submitcandidatesassign', API.all('joborders'))
                  assignJobs.post({
                    'jobs': $scope.selected.item,
                    'positions': $scope.vacancy,
                    'candidateId': $scope.canId,
                    'vendorchecklist':$scope.checklistyesdata,
                  }).then(function () {
                    $uibModalInstance.dismiss('cancel')//Close modal
                    let alert = { type: 'success', 'title': 'Success!', msg: 'Profile submitted successfully.' }
                    $state.go($state.current, { alerts: alert},{reload:true})
                    setTimeout(function(){ $(".alert-success").hide() }, 10000);
                  }, function (data) {
                    let alert = { type: 'error', 'title': 'Error!', msg: data.data.errors.message[0] };
                    $state.go($state.current, { alerts: alert},{reload:true});
                    setTimeout(function(){ $(".alert-error").hide() }, 10000);
                  });
                  $uibModalInstance.dismiss('cancel')//Close modal
              } else {
                  let alert = { type: 'error', 'title': 'Error!', msg: 'This Profile Already Submitted to Employer ,Please Try With different profile' };
                  $state.go($state.current, { alerts: alert},{reload:true});
                  setTimeout(function(){ $(".alert-error").hide() }, 10000);
                }
          });
        }, function (data) {
              let alert = { type: 'error', 'title': 'Error!', msg: 'Candidate Data Not Yet Updated Please Contact Admin.' };
              //this.cancel();
              $uibModalInstance.close();
              $state.go($state.current, { alerts: alert},{reload:true});
              setTimeout(function(){ $(".alert-error").hide() }, 10000);
          });
    }
    this.showback=()=>{
     document.getElementById('welcomeDiv').style.display = "none";
     document.getElementById('welcomeDiv1').style.display = "none";
       document.getElementById('aa').style.display = "block";
    }
    this.showback1=()=>{
     document.getElementById('welcomeDiv').style.display = "block";
     document.getElementById('welcomeDiv1').style.display = "none";
       document.getElementById('aa').style.display = "none";
    }
    this.savevalue=(id,vacancy,jobname)=>{
      $scope.errormessage=null;
      $scope.vacancy=vacancy;
      $scope.test=id;
      $scope.jobsname=jobname;
    }

    this.calculatevalue=()=>{
      $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
          if($scope.checklistyesdata.length == 5){
          if($scope.checklistyesdata.length >= 5){$scope.errormessagecheck=null;}
          else{
            $scope.errormessagecheck=null;
            $scope.errormessagecheck="Candidate profile must satisfy at least 5 of the requirement checks"; 
          }
        }
    }
    this.calculatevalue1 = function(a){
      if(a){
        $scope.relocate_disc ="Is willing to relocate."
      }else{
        $scope.relocate_disc ="Isn't willing to relocate."
      }
    }
  }
    toggleModalAnimation () {
      this.animationsEnabled = !this.animationsEnabled
    }
    $onInit () {
      $(document).on('click', '.readmoreclick', function (e) {    
        e.preventDefault(); 
        $(this).parent().hide();
        $(this).parent().siblings().show();
        e.stopImmediatePropagation();   
      });
       $(document).on('click', '.readlessclick', function (e) {    
        e.preventDefault(); 
        $(this).parent().hide();
        $(this).parent().siblings().show();
        e.stopImmediatePropagation();   
      });
      $(document).on('click', '.editing', function (e) {
          e.preventDefault();
           $('textarea').attr("disabled", false);
      });
      $(document).on('click', '.disabling', function (e) {
          e.preventDefault();
           $('textarea').attr("disabled", true);
      });
    }
  }
  export const SkillsComponent = {
      templateUrl: './views/app/components/skills/skills.component.html',
      controller: SkillsController,
      controllerAs: 'vm',
      bindings: {}
  };
  