class SubscribeemaildataController{
   constructor ($scope, $state, $compile, $stateParams, DTOptionsBuilder, DTColumnBuilder, API,$rootScope, $uibModal, $log, AclService, $timeout, $auth) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    this.animationsEnabled = true

    let subscribedatas = API.service('subscribedatas', API.all('users'))
$rootScope.$broadcast('pageurl', this.$state.current.url);

function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

}
    subscribedatas.getList()
      .then((response) => {
        let dataSet = response.plain()

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
          DTColumnBuilder.newColumn('id').withTitle('ID'),
          DTColumnBuilder.newColumn('user_location').withTitle('Location'),
          DTColumnBuilder.newColumn('email').withTitle('Email'),
          DTColumnBuilder.newColumn('ip_address').withTitle('IP Address'),
          DTColumnBuilder.newColumn('latitude').withTitle('Latitude'),
          DTColumnBuilder.newColumn('longitude').withTitle('Longitude'),
          DTColumnBuilder.newColumn('postal').withTitle('Postal'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `<a class="btn btn-xs"  ng-click="vm.accept(${data.id})"  title="Unsubscribe this email id"><img src="/user_assets/assets/emp_dashboard/delete.svg" width="18" class="img-q"></button></a>`
             
                
    }
    
    let fullName = (data) => {
      return `${data.first_name} ${data.last_name}`
    }
  }

    delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }


  $onInit () {}
}

export const SubscribeemaildataComponent = {
    templateUrl: './views/app/components/subscribeemaildata/subscribeemaildata.component.html',
    controller: SubscribeemaildataController,
    controllerAs: 'vm',
    bindings: {}
};
