class SurveyReportDataController{
    constructor ($scope, $stateParams, $state, $compile, DTOptionsBuilder, DTColumnBuilder, API, ContextService, $rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    ContextService.me(function (data) {
      $scope.loggedInUserData = data
    })

    $scope.employerId = $stateParams.employerId;

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    let QustionsData = API.service('processsurveyreport', API.all('processsurvey'))
    QustionsData.one($scope.employerId).get()
    .then((response) => {
        let dataSet = response.plain().data.processsurveyreport
        console.log(dataSet);

        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [
         /* DTColumnBuilder.newColumn('prid').withTitle('ID'),*/
          DTColumnBuilder.newColumn(null).withTitle('Caller Role').renderWith(role),
          DTColumnBuilder.newColumn(null).withTitle('Employer Name').renderWith(empName),
          DTColumnBuilder.newColumn('question.question').withTitle('Question'),
          DTColumnBuilder.newColumn('questionAnswerRadio').withTitle('Answer Type'),
          DTColumnBuilder.newColumn('processQuestionAnswerText').withTitle('Answer Text'),
          DTColumnBuilder.newColumn('created_at').withTitle('Call Date'),
          DTColumnBuilder.newColumn('employer.startTime').withTitle('Start Time'),
          DTColumnBuilder.newColumn('employer.endTime').withTitle('End Time'),
          DTColumnBuilder.newColumn(null).withTitle('Call Duration'),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let empName = (data) => {
      return `${data.employer.first_name} ${data.employer.last_name}`
    }

    let role = (data) => {
      if(data.processRole == 5) {
        return `Employer`
      } else if(data.processRole == 6) {
        return `Vendor`
      }
    }

    let actionsHtml = (data) => {
      let userdata = $scope.country;
      return `
                <a class="btn btn-xs btn-warning" ui-sref="app.manageQuestionsedit({questionId: ${data.prid}})">
                    <i class="fa fa-edit"></i>
                </a>

                &nbsp
                `
                
    }
  }


  saveQuestion (isValid) { 
    this.$state.go(this.$state.current, {}, { alerts: 'test' })
    if (isValid) {
      let Jobtypes = this.API.service('updatequestion', this.API.all('processsurvey'))
      let $state = this.$state

      Jobtypes.post({
        'name': this.name
      }).then(() => {
          let alert = { type: 'success', msg: 'Updated Question Successfully.' }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
    } else {
      this.formSubmitted = true
    }
  }


  $onInit () {
    
  }

}

export const SurveyReportDataComponent = {
    templateUrl: './views/app/components/survey-report-data/survey-report-data.component.html',
    controller: SurveyReportDataController,
    controllerAs: 'vm',
    bindings: {}
};
