class UsercandidatelistController{
   constructor ($scope, $state,$stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService,$rootScope) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.$scope = $scope
    this.animationsEnabled = true
    this.alerts = []
    if ($stateParams.alerts) {
     this.alerts.push($stateParams.alerts)
    }
    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    $rootScope.$broadcast('pageurl', this.$state.current.url);
    let candidates = this
    let jobs = API.service('vendoruserassignedjobs', API.all('joborders'))
    
    jobs.getList()
      .then((response) => {
        let dataSet = response.plain()
        candidates.jobs=dataSet;
    })

    let Users = this.API.service('candidates')
    
    Users.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withOption('order', [0, 'desc'])
          .withDisplayLength(50)
          .withBootstrap()

        this.dtColumns = [ 
          DTColumnBuilder.newColumn('id').withTitle('ID'),
           DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(job_profile),
         /* DTColumnBuilder.newColumn('full_name').withTitle('Full Name'),*/
          DTColumnBuilder.newColumn('total_experience_in_year').withTitle('Experience (Yr)'),
          DTColumnBuilder.newColumn(null).withTitle('Skills').renderWith(returnSkill),
          DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
 let job_profile = (data) => {
      return `<a a ui-sref="app.candidateprofile({candidateId: ${data.id} })" >${data.full_name}</a>`;
    } 
    let returnSkill = (data) => {
        return `${data.skill.skill_set}`
    }    

    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }

    let actionsHtml = (data) => {
      return `
                <button class="btn btn-xs btn-success" title="Submit profile to Jobs" ng-click="vm.modalOpen(${data.id})">
                    <i class="fa fa-plus"></i>
                </button>`
    }
  }

  delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }

  modalOpen (jobId) { 
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let items = this.jobs
    let API = this.API
    let $state = this.$state

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        items: () => {
          return items
        },
        vendorForm: function () {
            return $scope.vendorForm;
        },
        jobId: function () {
            return jobId;
        }
      }
    })

    modalInstance.result.then((selectedItem) => { 
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  }

  modalcontroller ($scope,$stateParams,$filter, $uibModalInstance, items, $state, API, vendorForm, jobId) {
    'ngInject'
 this.$state = $state
    this.items = items
    $scope.vendorForm = vendorForm
    this.jobId = jobId
$scope.errormessage=null;
$scope.errormessagecheck=null;
    $scope.selected = {
      item: items[0]
    }
 
     let vendors_checklist = API.service('vendorchecklist', API.all('joborders'))
    
    vendors_checklist.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.checklist=dataSet;
        
    })
    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel') 
    }

    this.save = (isValid,candidateListForm) => { 
     
       $scope.canId=this.candidateId;
      $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
      if($scope.checklistyesdata.length >= 5){
      $state.go($state.current, {}, { alerts: 'test' })
      if (isValid) {
            let checkProfile = API.service('checkuserprofilevalidity', API.all('joborders'))
                checkProfile.post({
                  'jobs': $scope.selected.item,
                  'positions': $scope.vacancy,
                  'candidateId': $scope.canId,
                  'vendorchecklist':$scope.checklistyesdata,
                }).then(function (data) {
                  $uibModalInstance.dismiss('cancel');
                  if(data.data.assignedJob == 0 ){
                    if(data.data.number == 2 ){
                                 swal({
                              title: 'Are you sure?',
                              text: 'HireXtra Matching Algorithm Found that there is Mis-Match.Please review Profile you like to submit.',
                              type: 'warning',
                              showCancelButton: true,
                              confirmButtonColor: '#DD6B55',
                              confirmButtonText: 'Yes, Submit!',
                              closeOnConfirm: false,
                              showLoaderOnConfirm: true,
                              html: false
                              }, function () {
                                    let assignJobs = API.service('submitcandidatesuserlist', API.all('jobsorders'))
                                    assignJobs.post({
                                      'jobs': $scope.selected.item,
                                       'positions': $scope.vacancy,
                                       'candidateId':  $scope.canId,
                                       'vendorchecklist':$scope.checklistyesdata,
                                   }) .then(() => {
                                                swal({
                                                  title: 'Submitted!',
                                                  text: 'Profile has been Submitted.',
                                                  type: 'success',
                                                  confirmButtonText: 'OK',
                                                  closeOnConfirm: true
                                                }, function () {
                                                  $state.reload()
                                                })
                                              })
                                     })
                              }
                            if(data.data.number == 1 ){
                               let assignJobs = API.service('submitcandidatesuserlist', API.all('jobsorders'))
                                assignJobs.post({
                                  'jobs': $scope.selected.item,
                                       'positions': $scope.vacancies,
                                       'candidateId':  $scope.canId,
                                       'vendorchecklist':$scope.checklistyesdata,
                                }).then(function () {
                                  $uibModalInstance.dismiss('cancel')//Close modal
                                  let alert = { type: 'success', 'title': 'Success!', msg: 'Profile submitted successfully.' }
                                  $state.go($state.current, { alerts: alert})
                                }, function (data) {
                                  let alert = { type: 'error', 'title': 'Error!', msg: data.data.errors.message[0] };
                                  $state.go($state.current, { alerts: alert});
                                });
                                $uibModalInstance.dismiss('cancel')//Close modal
                                }
                            if(data.data.number == 3 ){
                                        swal({
                                                  title: 'warning!',
                                                  text: 'HireXtra Matching Algorithm Found that there is Mis-Match.Please review Profile you like to submit..',
                                                  type: 'warning',
                                                  confirmButtonText: 'OK',
                                                  closeOnConfirm: true
                                                }, function () {
                                                  $state.reload()
                                                })
                              }
           }else{
                               let alert = { type: 'error', 'title': 'Error!', msg: 'This Profile Already Submitted to Employer ,Please Try With different profile' };
              $state.go($state.current, { alerts: alert});
                            }

                               }).error(function(data) {
              $uibModalInstance.dismiss('cancel')//Close modal
              let alert = { type: 'error', 'title': 'Error!', msg: data.errors.message[0] };
              $state.go($state.current, { alerts: alert});
            });
      } else {
        this.formSubmitted = true
      }
    }else{
       $scope.errormessagecheck="Candidate profile must satisfy at least 5 of the requirement checks";
    }
    }
this.shownext=()=>{
  if($scope.test != undefined){
  document.getElementById('welcomeDiv').style.display = "block";
   document.getElementById('aa').style.display = "none";
   }
   else{
    $scope.errormessage="Please choose the job to go next step";
   }
}
this.showback=()=>{
 document.getElementById('welcomeDiv').style.display = "none";
   document.getElementById('aa').style.display = "block";
}

this.savevalue=(id,vacancy)=>{
  $scope.errormessage=null;
  $scope.vacancy=vacancy;
  $scope.test=id;
}

this.calculatevalue=()=>{
  $scope.checklistyesdata = $filter("filter")($scope.checklist, {is_must:'YES'});
      if($scope.checklistyesdata.length == 5){
      if($scope.checklistyesdata.length >= 5){
        $scope.errormessagecheck=null;
      }else{
         $scope.errormessagecheck=null;
       $scope.errormessagecheck="Candidate profile must satisfy at least 5 of the requirement checks"; 
      }
    }
}

  }
  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  }

  $onInit () {
    this.selectedJob = ''
    this.candidateId = ''
  }

}

export const UsercandidatelistComponent = {
    templateUrl: './views/app/components/usercandidatelist/usercandidatelist.component.html',
    controller: UsercandidatelistController,
    controllerAs: 'vm',
    bindings: {}
};
