class VendorDashboardController {
  constructor($scope, $state, $rootScope, AclService, ContextService, API, $compile, DTOptionsBuilder, DTColumnBuilder, $http, $uibModal, $log, $stateParams) {
    'ngInject'
    this.$state = $state
    this.$scope = $scope
    this.$uibModal = $uibModal
    this.$log = $log
    this.alerts = []
    let dashboard = this
    this.API = API
    this.can = AclService.can
    this.$state = $state
    this.$log = $log
    $scope.tab_value = 5000;
    $scope.calender_show = false;
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    $scope.isChildVendor = false;
    $scope.zone_name = new Date().toLocaleTimeString('en-us', {
      timeZoneName: 'short'
    }).split(' ')[2];
    $scope.reschedule_association_id = null;
    $scope.labels = ['Skills Required Match', 'Qualification Match', 'Location Match', 'Experience Match', 'Position Match', 'Skills Prefered Match']
    $scope.series = ['Series A']
    $scope.data = [
      [65, 59, 80, 81, 56, 55, 40],
      [28, 48, 40, 19, 86, 27, 90]
    ]
    $scope.value = 1.5;
    $scope.upperLimit = 6;
    $scope.lowerLimit = 0;
    $scope.unit = "kW";
    $scope.precision = 2;
    $scope.eventSource = null;
    $scope.successMessage = null;
    $scope.ranges = [{
        min: 0,
        max: 1.5,
        color: '#DEDEDE'
      },
      {
        min: 1.5,
        max: 2.5,
        color: '#8DCA2F'
      },
      {
        min: 2.5,
        max: 3.5,
        color: '#FDC702'
      },
      {
        min: 3.5,
        max: 4.5,
        color: '#FF7700'
      },
      {
        min: 4.5,
        max: 6.0,
        color: '#C50200'
      }
    ];
    // ContextService.me(function (data) {
    //   dashboard.userData = data;
    //   $scope.userda = data;
    //   $scope.roleid = data.user.role_id;
    //   if (data) {
    //     $scope.isChildVendor = data.user.parent_id;
    //   }
    // });
    let userData = API.service('me', API.all('users'))
         userData.one().get()
          .then((response) => {
            let dataSet = response.plain()
            $scope.userda = dataSet;
            $scope.userda = $scope.userda.data;
            dashboard.userData =  $scope.userda;
            $scope.roleid = $scope.userda.user.role_id;
            if ($scope.userda) {
              $scope.isChildVendor = $scope.userda.user.parent_id;
            }
          })
    $scope.onEventSelected = function (event) {
      swal({
        title: event.swal_title,
        text: event.popup_message,
        html: true
      })
    };
    $scope.eventcal = function (event) {
      $( "#event-calendar" ).slideToggle( "slow" );
                   $("#event-calendar").toggleClass('active');
                   if($("#event-calendar").hasClass('active')){
                      $('html, body').animate({
                              'scrollTop' : $("#event-calendar").position().top
                          });
                   }else{
                       $('body').animate({scrollTop: 0},'slow');
                       return false;
                   }
    }
    let allCandidates = API.service('skillblockinformations', API.all('rchilliResume'))
      allCandidates.post({
            'candidate_id':29808,
          }).then(function (response) {
              let dataSet = {}
       
      });
    
    $scope.chagnestatusnotificationuser = function (id) {
      let vendorJobAlerts1 = API.service('chagnestatusnotificationusers', API.all('joborders'))
      vendorJobAlerts1.one(id).put()
        .then((response) => {

        }, (response) => {

        })
    };

    $http({
          method: "get",
          url: '/api/dashboard/lastloginven',
          dataType: 'json',
          ignoreLoadingBar: true
          }).then(function successCallback(response){
            $scope.lastlogin = response.data.data.lastlogin[0].time[1].updated_at;
            $scope.timezone = response.data.data.lastlogin[0].timezone[0].GMT_offset;
    })

    function renderer(api, rowIdx, columns) {
      var data = $.map(columns, function (col, i) {
        return col.hidden ?
          '<li data-dtr-index="' + col.columnIndex + '" data-dt-row="' + col.rowIndex + '" data-dt-column="' + col.columnIndex + '">' +
          '<span class="dtr-title">' +
          col.title +
          '</span> ' +
          '<span class="dtr-data">' +
          col.data +
          '</span>' +
          '</li>' :
          '';
      }).join('');
      var retVal = data ?
        $compile(angular.element($('<ul data-dtr-index="' + rowIdx + '"/>').append(data)))($scope) :
        false;
      $scope.$digest();
      return retVal;
    }
    this.myFunction1 = function () {
      let talentpools_data = API.service('vendortalentpoolsdata', API.all('dashboard'))
      talentpools_data.getList()
        .then((response) => {
          dashboard.vendorDashboardTalentpools = response.plain();
          let dataSet = response.plain()

          this.dtOptions = DTOptionsBuilder.newOptions()
            .withOption('data', dataSet)
            .withOption('createdRow', createdRow)
            .withOption('responsive', {
              details: {
                renderer: renderer
              }
            })
            .withOption('order', [0, 'desc'])
            .withDisplayLength(50)
            .withBootstrap()

          this.dtColumns = [
            DTColumnBuilder.newColumn(null).withTitle('Talentpool Code').notSortable()
            .renderWith(talentpool_code),
            DTColumnBuilder.newColumn(null).withTitle('Talentpool Name').notSortable()
            .renderWith(talentpool_name),
            DTColumnBuilder.newColumn(null).withTitle('Profile Name').notSortable()
            .renderWith(profile_name),
            DTColumnBuilder.newColumn(null).withTitle('For Job').notSortable()
            .renderWith(job_name),
            DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
          ]

          this.displayTable = true

        })
      let talentpool_name = (data) => {
        return `${data.talentpools.name}</a>`
      }
      let talentpool_code = (data) => {
        return `${data.talentpools.talentpool_code}</a>`
      }

      let profile_name = (data) => {
        return `${data.talentpools.resume_name}`
      }
      let job_name = (data) => {
        return `${data.job.name}`
      }
      let createdRow = (row) => {
        $compile(angular.element(row).contents())($scope)
      }

      let actionsHtml = (data) => {
        return `<a class="btn btn-xs btn-success">
                    <i class="fa fa-check" title="Submit This Request to Vendor"></i>
                </a>
                <a class="btn btn-xs btn-warning">
                    <i class="fa fa-pause" title="Hold This Request to Vendor"></i>
                </a>
                <a class="btn btn-xs btn-danger">
                    <i class="fa fa-remove" aria-hidden="true" title="Cancel This Request"></i>
                </a>
                `
      }
      var p = document.getElementById("talentpoolsmetrics");
      var y = document.getElementsByClassName("talentpool");
      var z = document.getElementsByClassName("jobs-panel-content");
      if (p.style.display === "block") {
        p.style.display = "none";
        y[0].innerHTML = "Talentpool Requests (" + this.vendorDashboard.talentpool_request + ")";
        z[0].style.display = "block";

      } else {
        p.style.display = "block";
        y[0].innerHTML = "Hide Talentpool Dashboard";
        z[0].style.display = "none";
      }
      let amDashboardTlntpoolnumbers = API.service('vendortplnumbers', API.all('dashboard'))
      amDashboardTlntpoolnumbers.getList()
        .then((response) => {
          let dataSet = response.plain()
          dashboard.amTlntpoolnumbers = dataSet[0];
        })
    }
    let vendorinterschedule = API.service('vendorinterschedule', API.all('joborders'))
    vendorinterschedule.getList()
      .then((response) => {
        let dataSet = response.plain()
        angular.forEach(dataSet, function (value, key) {
          if (value.interview_schedule_date) {

            var mmmmm = new Date(value.interview_schedule_date);
            var pppp = mmmmm.toLocaleString();
            let date_time = value.interview_schedule_date,
              slices = pppp.split(' '),
              date_from_string = slices[0],
              time_from_string = slices[1],
              apm = slices[2],
              date_string_split = date_from_string.split('/'),
              ms = date_string_split[0],
              ds = date_string_split[1],
              ys = date_string_split[2].replace(",", ''),
              time_string_split = time_from_string.split(':'),
              hs = time_string_split[0].replace(/\b0+/g, ''),
              mins = time_string_split[1].replace(/\b0+/g, '');
            ms = ms - 1;
            ds = ds;
            if (apm == "PM") {
              hs = 12 + parseInt(hs);
              if (hs == 12) {
                hs = 24
              } else if (hs == 24) {
                hs = 12
              }
            } else if (apm == "AM") {
              if (hs == 12) {
                hs = 0
              } else if (hs == 24) {
                hs = 12
              }
            } else if (hs == 12 && apm == "AM") {
              hs = 0;
            }
            let startTime = new Date(ys, ms, ds, hs, mins),
              endDate = new Date(ys, ms, ds, hs, mins, 59);
            dataSet[key]['startTime'] = startTime;
            dataSet[key]['endTime'] = endDate;
          }
        });
        $scope.eventSource = dataSet;

        setTimeout(function () {
          document.querySelectorAll('.calendar-event-inner').forEach(function (element, index) {
            element.title = element.innerHTML;
            let str = element.innerHTML;
            element.innerHTML = str.substr(0, 20) + "...";
          });
        }, 1000);
      })

    $scope.changeDate = function (assocId) {
      $scope.reschedule_association_id = assocId;
    }
    $scope.dateOpts = {
      enableTime: true,
      dateFormat: "d-m-Y h:i K",
      position: "below",
      animate: true,
      closeOnSelect: true,
      static: true,
      time_24hr: false,
      onChange: function (selectedDates, dateStr, instance) {
        $scope.selectedDateObj = dateStr;
      },
      onOpen: [
        function (selectedDates, dateStr, instance) {
          instance.setDate(instance.element.attributes[6].nodeValue);
          instance.redraw();
          var existingElem = angular.element(document.getElementsByClassName('flatpickr-button'));
          existingElem.remove();
          var newEl = angular.element('<div class="flatpickr-button"><button class="btn btn-default dateSubmit" ng-click="submitNewDate()" type="submit">Submit</button></div>');
          var pageElement = angular.element(document.getElementsByClassName('flatpickr-calendar open'));
          pageElement.append(newEl);
          $compile(pageElement)($scope); // Double compilation
        }
      ],
    };
    $scope.getscheduleTime = function (data,selectedDateObj) {  
     $scope.selectedDateObj = selectedDateObj;
     $scope.reschedule_association_id=data.association_id;
      $scope.employer_id = data.employer_id;
      $scope.candidate_id = data.candidate_id;
      $scope.job_id = data.job_id;
     $scope.submitNewDate();
  }
  $scope.show_calendar = function(){
    $scope.calender_show = true;
  }
    $scope.submitNewDate = function () {
      $state.go($state.current, {}, {
        alerts: 'test'
      })
      let reschedule = API.service('reschedulevendor', API.all('joborders'))
      reschedule.post({
        'newDateTime': $scope.selectedDateObj,
        'assocId': $scope.reschedule_association_id,
      }).then((response) => {
        let alert = {
          type: 'success',
          msg: "Interview has been rescheduled successfully."
        }
        $state.go($state.current, {
          alerts: alert
        }, {
          reload: true
        })
        setTimeout(function () {
          $(".alert-success").hide()
        }, 10000);
      }, function (response) {
        let alert = {
          type: 'error',
          msg: response.data.message
        }
        $state.go($state.current, {
          alerts: alert
        }, {
          reload: true
        })
        setTimeout(function () {
          $(".alert-error").hide()
        }, 10000);
      });
    };

    let vendorNotes = API.service('vendoractivitydata', API.all('dashboard'))
    vendorNotes.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorNotes = dataSet
        angular.forEach(dashboard.vendorNotes, function (value) {
          value.created_at = Date.parse(value.created_at);
          value.interview_schedule_date = Date.parse(value.interview_schedule_date);
        });
        $scope.nocomments = dashboard.vendorNotes.length

      })

    let vendorDashboardRev = API.service('vendorjobrevenues', API.all('dashboard'))
    vendorDashboardRev.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.vendorpos_nodata = dataSet.length;
        $scope.labelstv = []
        $scope.datatv = []
        angular.forEach(dataSet, function (value, key) {
          $scope.labelstv.push(value.name+'('+value.currency+')');
          $scope.datatv.push(value.vendor_price);
        });
        var ctx = document.getElementById('myChart');
        var myChart = new Chart(ctx, {
          type: 'bar',
          data: {
            labels: $scope.labelstv,
            datasets: [{
              label: '',
              data: $scope.datatv,
              backgroundColor: [
                '#3cb44b', '#da5959', '#0082c8', '#f58231', '#911eb4', '#46f0f0', '#f032e6', '#809620', '#fabebe', '#008080', '#e6beff', '#aa6e28', '#800000', '#aaffc3', '#808000', '#ffd8b1', '#000080', '#000000'
              ],
              borderColor: [
                '#3cb44b', '#da5959', '#0082c8', '#f58231', '#911eb4', '#46f0f0', '#f032e6', '#809620', '#fabebe', '#008080', '#e6beff', '#aa6e28', '#800000', '#aaffc3', '#808000', '#ffd8b1', '#000080', '#000000'
              ],
              borderWidth: 1
            }]
          },
          options: {
            scales: {
              yAxes: [{
                ticks: {
                  beginAtZero: true
                }
              }]
            }
          }
        });
      })
    let vendormetrics = API.service('vendormetricsall', API.all('joborders'))
    vendormetrics.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.vendormetrics = dataSet;
      })
    let vendorDashboard = API.service('vendornumbers', API.all('dashboard'))
    vendorDashboard.getList()
      .then((response) => {
        let dataSet = response.plain()
        dashboard.vendorDashboard = dataSet[0];
        $scope.pieLabels1 = ['CVs Submitted', 'Selected Profiles']
        $scope.pieData1 = [dashboard.vendorDashboard.candidates, dashboard.vendorDashboard.selectedprofiles]
        $scope.pieColors1 = ['#dddddd', '#ff8b31']
        $scope.pieLabels2 = ['Jobs Assigned', 'Jobs Closed']
        $scope.pieData2 = [dashboard.vendorDashboard.jobs, dashboard.vendorDashboard.jobsclosed]
        $scope.pieColors2 = ['#dddddd', '#407fc5']
        $scope.dashboard_em = dashboard.vendorDashboard.candidates
        $scope.dashboard_ema = dashboard.vendorDashboard.selectedprofiles
        $scope.dashboard_amand = dashboard.vendorDashboard.jobs
        $scope.dashboard_amanda = dashboard.vendorDashboard.jobsclosed
        var options = {
          chart: {
            width: 200,

            type: "donut"
          },
          colors: ["#49577a", "#8d41ff"],
          dataLabels: {
            enabled: false
          },
          series: [dashboard.vendorDashboard.jobs, dashboard.vendorDashboard.jobsclosed],
          chartOptions: {
            labels: ['Jobs Assigned', 'Jobs Closed']
          },
          tooltip: {
            enabled: true,
            y: {
              formatter: function (val) {
                return val
              },
              title: {
                formatter: function (seriesName) {
                                if(seriesName=='series-1'){
                                  return 'Jobs Assigned'
                                }
                                else{
                                  return 'Jobs Closed'
                                }
                              }
              }
            }
          },
          legend: {
            show: false
          }
        };

        var chart = new ApexCharts(document.querySelector("#chart"), options);

        chart.render();
        google.charts.load('current', {
          'packages': ['corechart']
        });
        google.charts.setOnLoadCallback(drawChart);

        function drawChart() {
          var data = google.visualization.arrayToDataTable([
            ['Profiles ', ' Profiles'],
            ['Submitted', dashboard.vendorDashboard.candidates],
            ['Selected', dashboard.vendorDashboard.selectedprofiles]
          ]);

          var options = {
            title: '',
            //vAxis: {title: 'Acceptance Ratio'},
            colors: ['#30D2D6', '#0266FF', '#ec8f6e', '#f3b49f', '#f6c7b6'],
            isStacked: true
          };

          var chart = new google.visualization.SteppedAreaChart(document.getElementById('chart_div'));

          chart.draw(data, options);
        }

      })

    let team = API.service('vendorusernumber', API.all('dashboard'))
    team.getList()
      .then((response) => {
        let dataSet = response.plain()
        $scope.team = dataSet;
      })
    $http({
      method: "get",
      url: '/api/dashboard/empsorting',
      dataType: 'json',
    }).then(function successCallback(response) {
      $scope.item1 = response.data.data.reponceData;
      $('#' +$scope.item1.box_1[0].box_item).attr("data-order", $scope.item1.box_1[0].item_sort);
      $('#' +$scope.item1.box_1[1].box_item).attr("data-order", $scope.item1.box_1[1].item_sort);
      $('#' +$scope.item1.box_1[2].box_item).attr("data-order", $scope.item1.box_1[2].item_sort);
      $('#' +$scope.item1.box_1[3].box_item).attr("data-order", $scope.item1.box_1[3].item_sort);
      $('#' +$scope.item1.box_1[4].box_item).attr("data-order", $scope.item1.box_1[4].item_sort);
      $('#' +$scope.item1.box_1[5].box_item).attr("data-order", $scope.item1.box_1[5].item_sort);
      $('#' +$scope.item1.box_2[0].box_item).attr("data-order", $scope.item1.box_2[0].item_sort);
      $('#' +$scope.item1.box_2[1].box_item).attr("data-order", $scope.item1.box_2[1].item_sort);
      $('#' +$scope.item1.box_3[0].box_item).attr("data-order", $scope.item1.box_3[0].item_sort);
      $('#' +$scope.item1.box_3[1].box_item).attr("data-order", $scope.item1.box_3[1].item_sort);
      var $sorted_items,
        getSorted = function (selector, attrName) {
          return $(
            $(selector).toArray().sort(function (a, b) {
              var aVal = parseInt(a.getAttribute(attrName)),
                bVal = parseInt(b.getAttribute(attrName));
              return aVal - bVal;
            })
          );
        };
      $sorted_items = getSorted('#sortable-wrapper .cal_ven1', 'data-order');
      var $sorted_charts;
      $sorted_charts = getSorted('#sortable_charts .cal_ven2', 'data-order');
      var $sorted_coments;
      $sorted_coments = getSorted('#sotable_recentcoments .cal_ven3', 'data-order');


      $('#sortable-wrapper').html($sorted_items);
      $('#sortable_charts').html($sorted_charts);
      $('#sotable_recentcoments').html($sorted_coments);
    });
    $("#sortable-wrapper,#sortable_charts,#sotable_recentcoments").sortable({
      revert: true,
      receive: function (event, ui) {},
      update: function (event, ui) {
        var item_sort1 = $("#sortable-wrapper > div").index($("#sortable-wrapper #jvendorobs_accepted"));
        var item_sort2 = $("#sortable-wrapper > div").index($("#sortable-wrapper #profiles_submitted"));
        var item_sort3 = $("#sortable-wrapper > div").index($("#sortable-wrapper #employers"));
        var item_sort4 = $("#sortable-wrapper > div").index($("#sortable-wrapper #possible_revenue"));
        var item_sort5 = $("#sortable-wrapper > div").index($("#sortable-wrapper #jobs_closed"));
        var item_sort6 = $("#sortable-wrapper > div").index($("#sortable-wrapper #selected_profiles"));
        var chart1 = $("#sortable_charts > div").index($("#sortable_charts #acceptance_ratio"));
        var chart2 = $("#sortable_charts > div").index($("#sortable_charts #job_closure_ration"));
        var comments1 = $("#sotable_recentcoments > div").index($("#sotable_recentcoments #possible_revenue_chart"));
        var comments2 = $("#sotable_recentcoments > div").index($("#sotable_recentcoments #recent_comments"));

        $http({
                method : "POST",
                url : "/api/dashboard/empsortingp",
                data: {sortData: {
            box1: [{
                box_no: 1,
                box_item: 'jvendorobs_accepted',
                item_sort: item_sort1 + 1
              },
              {
                box_no: 1,
                box_item: 'profiles_submitted',
                item_sort: item_sort2 + 1
              },
              {
                box_no: 1,
                box_item: 'employers',
                item_sort: item_sort3 + 1
              },
              {
                box_no: 1,
                box_item: 'possible_revenue',
                item_sort: item_sort4 + 1
              },
              {
                box_no: 1,
                box_item: 'jobs_closed',
                item_sort: item_sort5 + 1
              },
              {
                box_no: 1,
                box_item: 'selected_profiles',
                item_sort: item_sort6 + 1
              }
            ],
            box2: [{
                box_no: 2,
                box_item: 'acceptance_ratio',
                item_sort: chart1 + 1
              },
              {
                box_no: 2,
                box_item: 'job_closure_ration',
                item_sort: chart2 + 1
              }
            ],
            box3: [{
                box_no: 3,
                box_item: 'possible_revenue_chart',
                item_sort: comments1 + 1
              },
              {
                box_no: 3,
                box_item: 'recent_comments',
                item_sort: comments2 + 1
              }
            ]
          }}


        }).then((response) => {

        });
      }
    });
    $scope.acceptJob = function (id) {
      $state.go($state.current, {}, {
        alerts: 'test'
      })
      let vendorJobAlerts1 = API.service('jobacceptuser-show', API.all('joborders'))
      vendorJobAlerts1.one(id).put()
        .then((response) => {
          let alert = {
            type: 'success',
            msg: 'Job has been Accepted successfully.'
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function () {
            $(".alert-success").hide()
          }, 10000);
          $state.go('app.vassignedjobs');
        }, (response) => {
          let alert = {
            type: 'error',
            msg: response.data.message
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function () {
            $(".alert-error").hide()
          }, 10000);
        })
    }
    $scope.rejectJob = function (id) {
      $state.go($state.current, {}, {
        alerts: 'test'
      })
      let vendorJobAlerts1 = API.service('jobrejectuser-show', API.all('joborders'))
      vendorJobAlerts1.one(id).put()
        .then((response) => {
          let dataSet = response.plain()
          dashboard.vendorJobAlerts = dataSet;
          let alert = {
            type: 'success',
            msg: 'Job has been Rejected successfully.'
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function () {
            $(".alert-success").hide()
          }, 10000);
        }, (response) => {
          let alert = {
            type: 'error',
            msg: response.data.message
          }
          $state.go($state.current, {
            alerts: alert
          }, {
            reload: true
          })
          setTimeout(function () {
            $(".alert-error").hide()
          }, 10000);
        })
    }
    var toggled;
    $scope.expandtoggle = function (e) {
      if ($(e.currentTarget).hasClass('showing')) {
        toggled = true;
      } else {
        toggled = false;
      }
      $scope[toggled ? "deleterow" : "expandrow"](e);
    };
    $scope.expandrow = function (e) {
      var clientinfo = $(e.currentTarget).closest('.client-info');
      $(e.currentTarget).addClass('showing');
      var content = $(e.currentTarget).parent().parent().find('.fade-in').html();
      $('<div>' + content + '</div>').insertAfter(clientinfo);
    };
    $scope.deleterow = function (e) {
      $(e.currentTarget).removeClass('showing');
      var clientinfo = $(e.currentTarget).closest('.client-info').next().remove();;
    };
  } //constructor
  modalOpen(assignedjobs, closedjobs, profilesselected, numberofemployers) {
    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let jobs = assignedjobs
    let jobsclosed = closedjobs
    let selectedprofiles = profilesselected
    let employersnumber = numberofemployers
    let API = this.API
    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: {
        jobs: function () {
          return jobs;
        },
        jobsclosed: function () {
          return jobsclosed;
        },
        selectedprofiles: function () {
          return selectedprofiles;
        },
        employersnumber: function () {
          return employersnumber;
        }
      }
    })
    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } // modalopen
  modalcontroller($scope, $filter, $uibModalInstance, $state, $stateParams, API, $http, $auth, jobs, jobsclosed, selectedprofiles, employersnumber) {
    'ngInject'
    this.$state = $state
    $scope.jobs = jobs;
    $scope.jobsclosed = jobsclosed;
    $scope.selectedprofiles = selectedprofiles;
    $scope.employersnumber = employersnumber;
    $scope.assetId = null
    this.alerts = []
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }
    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }
  } //modal controller
  toggleModalAnimation() {
    this.animationsEnabled = !this.animationsEnabled
  }
  $onInit() {

  }
}
export const VendorDashboardComponent = {
  templateUrl: './views/app/components/vendor-dashboard/vendor-dashboard.component.html',
  controller: VendorDashboardController,
  controllerAs: 'vm',
  bindings: {}
};