class VendorDescriptionController{
   constructor ($stateParams,$scope, $state, $compile,DTOptionsBuilder, DTColumnBuilder, API,$rootScope) {
    'ngInject'
    this.$state = $state
    this.formSubmitted = false
    this.alerts = []
    this.vendorSummaryDesc='';
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    $rootScope.$broadcast('pageurl', this.$state.current.url);
     let vendorId = $stateParams.vendorId;
    let Jobtype = API.service('vendorsummarydesc', API.all('joborders'))
    Jobtype.one(vendorId).get()
      .then((response) => {
        this.vendorSummaryDesc = API.copy(response)
        this.summdata=this.vendorSummaryDesc.data.vendorsummarydesc[0]
        let dataa = response.plain()
        let dbdt=dataa.data.vendorsummarydesc[0]
        let dataSet = dbdt.jobs_worked;
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()
        this.dtColumns = [
          DTColumnBuilder.newColumn(null).renderWith(actionId),
          DTColumnBuilder.newColumn(null).withTitle('Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Experience').renderWith(actionExp),
          DTColumnBuilder.newColumn(null).withTitle('Created Date').renderWith(actionCreated),
        ]
        this.displayTable = true
      })
    let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
     let actionId = (data) => {
      return `${data.job.id}`
    }
    let actionName = (data) => {
      return `${data.job.name}`
    }
    let actionCreated = (data) => {
      return `${data.job.created_at }`
    }
    let actionExp = (data) => {
       return `${data.job.experience} Yrs of ${data.job.experienceType} `
    }
  }
    $onInit(){
    }
}

export const VendorDescriptionComponent = {
    templateUrl: './views/app/components/vendor-description/vendor-description.component.html',
    controller: VendorDescriptionController,
    controllerAs: 'vm',
    bindings: {}
};
