class VendorRevenueRuleController{
   constructor ($scope, $stateParams, $state, API, $timeout,$rootScope) {
    'ngInject'

    this.$state = $state
    this.$scope = $scope
    this.formSubmitted = false
    this.alerts = []
    this.API = API
    this.language = null
    $scope.preferredTags = []
    $scope.preferredTagsArr = []
    $scope.requiredTags = []
    $scope.requiredTagsArr = []
    $scope.prefQualArr = []
    $rootScope.$broadcast('pageurl', this.$state.current.url);
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    this.employerId = $stateParams.employerId;
    let editVendorRule = API.service('editvendorrule', API.all('pricing'))
        editVendorRule.getList()
          .then((response) => {
             this.vendorRule = API.copy(response);
          
          })

}
 
 save (isValid) {
    if (isValid) {
      let $state = this.$state
      let $scope = this.$scope

      let vendorRevenue = this.API.service('vendorrevenue', this.API.all('pricing'))
       vendorRevenue.post({
            'data': this.vendorRule,
        }).then(() => {
          let alert = { type: 'success', msg: 'Vendor Pricing rules have been updated.' }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-success").hide() }, 10000);
        }, (response) => {
          let alert = { type: 'error', msg: response.data.message }
          $state.go($state.current, { alerts: alert}, {reload: true})
          setTimeout(function(){ $(".alert-error").hide() }, 10000);
        })
 
    } else {
      this.formSubmitted = true
    }
  }
    $onInit(){}
}

export const VendorRevenueRuleComponent = {
    templateUrl: './views/app/components/vendor-revenue-rule/vendor-revenue-rule.component.html',
    controller: VendorRevenueRuleController,
    controllerAs: 'vm',
    bindings: {}
};
