class VendorSelectedProfilesController{
    constructor ($scope, $state, $stateParams, $compile, DTOptionsBuilder, DTColumnBuilder, API, $uibModal, $log, AclService, ContextService,$rootScope ) {
    'ngInject'
    this.API = API
    this.$state = $state
    this.$uibModal = $uibModal
    this.$log = $log
    this.API = API
    this.$scope = $scope
    this.animationsEnabled = true
    this.alerts = []
    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }
    $rootScope.$broadcast('pageurl', this.$state.current.url);

    function renderer(api, rowIdx, columns) {
        var data = $.map( columns, function ( col, i ) {
       return col.hidden ?
           '<li data-dtr-index="'+col.columnIndex+'" data-dt-row="'+col.rowIndex+'" data-dt-column="'+col.columnIndex+'">'+
                '<span class="dtr-title">'+
                    col.title+
              '</span> '+
              '<span class="dtr-data">'+
                  col.data+
             '</span>'+
         '</li>' : 
         '';
       }).join('');
        var retVal =  data ?
           $compile(angular.element($('<ul data-dtr-index="'+rowIdx+'"/>').append( data )))($scope) :  
            false;
            $scope.$digest();
        return retVal;

    }

    let jobsClosed = API.service('vendorselectedprofiles', API.all('jobsorders'))

    jobsClosed.getList()
      .then((response) => {
        let dataSet = response.plain()
        this.dtOptions = DTOptionsBuilder.newOptions()
          .withOption('data', dataSet)
          .withOption('createdRow', createdRow)
          .withOption('responsive', {details: {renderer: renderer}})
          .withDisplayLength(50)
          .withOption('order', [0, 'desc'])
          .withBootstrap()

        this.dtColumns = [
          /*DTColumnBuilder.newColumn(null).withTitle('Id').renderWith(actionId),*/
          DTColumnBuilder.newColumn(null).withTitle('Full Name').renderWith(actionName),
          DTColumnBuilder.newColumn(null).withTitle('Job Name').renderWith(actionJobName),
          DTColumnBuilder.newColumn(null).withTitle('Email').renderWith(actionEmail),
          DTColumnBuilder.newColumn(null).withTitle('Skills').renderWith(actionSkills),
           DTColumnBuilder.newColumn(null).withTitle('Actions').notSortable()
            .renderWith(actionsHtml)
        ]

        this.displayTable = true
      })
      let createdRow = (row) => {
      $compile(angular.element(row).contents())($scope)
    }
     /*let actionId = (data) => {
      return `${data.candidate.id}`
    }*/
    let actionName = (data) => {
       return `<a a ui-sref="app.candidateprofile({candidateId: '${data.numbers.encrypted_canId}', JoborderId: '${data.numbers.encrypted_jobId}' })" >${data.candidate.full_name}</a>`
    }
    let actionJobName = (data) => {
       return `<a ui-sref="app.joborderview({joborderId: '${data.numbers.encrypted_jobId}'})">${data.job.name}</a>`
    }
    let actionSkills = (data) => {
      if (data.candidate != null) {
            if(data.candidate.edit_summary !=null){
          let string = data.candidate.edit_summary;
          let length = 300;
          let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
      } else{
          if (data.candidate != null) {
            if (data.candidate.executive_summary != null) {
              var string=data.candidate.executive_summary;
              let length = 300;
              let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick"  style="color: #e3323e;cursor:pointer;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            } else {
              var string=data.candidate.summary;
              let length = 300;
             let trimmedString = string.substring(0, length);
         return `<p class="trimmed">${trimmedString}${'...'} <span class="readmoreclick" style="color: #e3323e;cursor:pointer;">Read more</span></p>
                    <p class="trimmednot" style="display:none;">${string} <span class="readlessclick" style="color: #e3323e;cursor:pointer;">Read less</span></p>`
            }
          } 
      }
            }
            else {
            return `NA`
          }
    }
    let actionEmail = (data) => {
       return `${data.candidate.email} `
    }
    let actionsHtml = (data) => {
      return `
       <a class="btn btn-xs modalClick" title="See the activity" ng-click="vm.modalOpen(${data.candidate.id}, ${data.job.id})">
                    <img src="/user_assets/assets/emp_dashboard/eye.svg" width="18" class="img-q">
                </a>
             `
    }
  }

  delete (userId) {
    let API = this.API
    let $state = this.$state

    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this data!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false,
      showLoaderOnConfirm: true,
      html: false
    }, function () {
      API.one('users').one('user', userId).remove()
        .then(() => {
          swal({
            title: 'Deleted!',
            text: 'User Permission has been deleted.',
            type: 'success',
            confirmButtonText: 'OK',
            closeOnConfirm: true
          }, function () {
            $state.reload()
          })
        })
    })
  }//delete

  modalOpen (canId, joborderId) {

    let $uibModal = this.$uibModal
    let $scope = this.$scope
    let $log = this.$log
    let candidateId = canId
    let jobId = joborderId
    let API = this.API

    var modalInstance = $uibModal.open({
      animation: this.animationsEnabled,
      templateUrl: 'myModalContent.html',
      controller: this.modalcontroller,
      controllerAs: 'mvm',
      resolve: { 
        candidateId: function () {return candidateId;},
        jobId: function () {return jobId;}
       }
    })

    modalInstance.result.then((selectedItem) => {
      $scope.selected = selectedItem
    }, () => {
      $log.info('Modal dismissed at: ' + new Date())
      if ($rootScope.previousState.name == '') {
        // No previous state to go? Go to list page
        $state.go('app.logout');
      } else {
        // Back to previous state if any
        $window.history.back();
      }
    })
  } // modalopen


modalcontroller ($scope,$filter, $uibModalInstance, $state,$stateParams, API, $http, $auth, candidateId, jobId) {
    'ngInject'
   
    this.$state=$state
    $scope.candidateId = candidateId
    $scope.jobId = jobId
    $scope.assetId = null
    this.alerts = []

    if ($stateParams.alerts) {
      this.alerts.push($stateParams.alerts)
    }

    let CandidateActivity = API.service('candidateactivity', API.all('dashboard'))
    CandidateActivity.post({
      'jobId': $scope.jobId,
      'candidateId': $scope.candidateId
    }).then(function (response) {
          let plainResponse = response.plain();
          let Dbtimeline = plainResponse.data;
            angular.forEach(Dbtimeline, function(value, key) {
              let time = new Date(value.created_at).getTime();
              Dbtimeline[key]['formatted_date'] = time ;
            });
          $scope.timeline = Dbtimeline;
    }, function (data) {
      $uibModalInstance.dismiss('cancel')//Close modal
      let alert = { type: 'error', msg: data.errors.message };
      $state.go($state.current, { alerts: alert});
      setTimeout(function(){ $(".alert-error").hide() }, 10000);
    });
  
    // let CandidateActivity = API.service('candidateactivity', API.all('dashboard'))
    // CandidateActivity.one($scope.candidateId).get()
    //   .then((response) => {
    //     let plainResponse = response.plain()
    //     let Dbtimeline = plainResponse.data
    //     angular.forEach(Dbtimeline, function(value, key) {
    //       let time = new Date(value.created_at).getTime()
    //       Dbtimeline[key]['formatted_date'] = time  
    //     });
    //     this.timeline = Dbtimeline
    //   })

    this.ok = () => {
      $uibModalInstance.close($scope.selected.item)
    }

    this.cancel = () => {
      $uibModalInstance.dismiss('cancel')
    }
  }//modal controller

  toggleModalAnimation () {
    this.animationsEnabled = !this.animationsEnabled
  } 

    swalConfirm () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      closeOnConfirm: false
    }, () => {
      swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
    })
  }

  swalBasic () {
    swal("Here's a message!", "It's pretty, isn't it?")
  }

  swalSuccess () {
    swal('Good job!', 'You clicked the button!', 'success')
  }

  swalDecide () {
    swal({
      title: 'Are you sure?',
      text: 'You will not be able to recover this imaginary file!',
      type: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#DD6B55',
      confirmButtonText: 'Yes, delete it!',
      cancelButtonText: 'No, cancel plx!',
      closeOnConfirm: false,
      closeOnCancel: false
    }, (isConfirm) => {
      if (isConfirm) {
        swal('Deleted!', 'Your imaginary file has been deleted.', 'success')
      } else {
        swal('Cancelled', 'Your imaginary file is safe :)', 'error')
      }
    })
  }

  swalImage () {
    swal({
      title: 'Sweet!',
      text: "Here's a custom image.",
      imageUrl: '/img/avatar5.png'
    })
  }

  swalHtmlMessage () {
    swal({
      title: 'HTML <small>Title</small>!',
      text: 'A custom <span style="color:#F8BB86">html<span> message.',
      html: true
    })
  }

  swalAutoClose () {
    swal({
      title: 'Auto close alert!',
      text: 'I will close in 2 seconds.',
      timer: 2000,
      showConfirmButton: false
    })
  }

  swalPrompt () {
    swal({
      title: 'An input!',
      text: 'Write something interesting:',
      type: 'input',
      showCancelButton: true,
      closeOnConfirm: false,
      animation: 'slide-from-top',
      inputPlaceholder: 'Write something'
    }, (inputValue) => {
      if (inputValue === false)
        return false
      if (inputValue === '') {
        swal.showInputError('You need to write something!')
        return false
      }
      swal('Nice!', 'You wrote: ' + inputValue, 'success')
    })
  }

  swalAjax () {
    let API = this.API

    swal({
      title: 'Ajax request example',
      text: 'Submit to run ajax request',
      type: 'info',
      showCancelButton: true,
      closeOnConfirm: false,
      showLoaderOnConfirm: true
    }, () => {
      let UserData = API.service('me', API.all('users'))

      UserData.one().get()
        .then((response) => {
          let userdata = response.plain()
          swal('Your Name is: ' + userdata.data.name)
        })
    })
  }

    $onInit(){ 
     $(document).on('click', '.readmoreclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
      $(document).on('click', '.readlessclick', function (e) {    
      e.preventDefault(); 
      $(this).parent().hide();
      $(this).parent().siblings().show();
      e.stopImmediatePropagation();   
    });
    }
}

export const VendorSelectedProfilesComponent = {
    templateUrl: './views/app/components/vendor-selected-profiles/vendor-selected-profiles.component.html',
    controller: VendorSelectedProfilesController,
    controllerAs: 'vm',
    bindings: {}
};
